/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;

public final class VanDerWaals
implements Searchable {
    public final double power = 0.25;
    public final double b = 0.2;
    public final double beta = 12.0;
    public final double darad = 0.8;
    public final double daeps = 0.5;
    private final Object[][] table;

    public VanDerWaals(Tables tables, String string) {
        this.table = Csv.readFile(string);
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public double alpha_i(int n) {
        return ((Number)this.table[this.index(n)][1]).doubleValue();
    }

    public double n_i(int n) {
        return ((Number)this.table[this.index(n)][2]).doubleValue();
    }

    public double a_i(int n) {
        return ((Number)this.table[this.index(n)][3]).doubleValue();
    }

    public double g_i(int n) {
        return ((Number)this.table[this.index(n)][4]).doubleValue();
    }

    public char da(int n) {
        return ((Character)this.table[this.index(n)][5]).charValue();
    }

    public double r_star(int n) {
        int n2 = this.index(n);
        return ((Number)this.table[n2][3]).doubleValue() * Math.pow(((Number)this.table[n2][1]).doubleValue(), 0.25);
    }

    private int index(int n) {
        return Search.binary(0, n, (Searchable)this);
    }
}

