/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.PeriodicTable;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;

public final class Torsion
implements Searchable {
    private final Object[][] table;
    private final Tables t;

    public Torsion(Tables tables, String string) {
        this.table = Csv.readFile(string);
        this.t = tables;
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    public static <T> T s(T t, T t2) {
        return t;
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public Kb get(int n) {
        return new Kb(n);
    }

    public int index(int n, int n2, int n3, int n4, int n5) {
        return Search.binary(new int[]{2, 3, 1, 4, 0}, new int[]{n2, n3, n, n4, n5}, (Searchable)this);
    }

    public Kb getForceConstants(MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = mMFFMolecule.getAtomType(n);
        int n7 = mMFFMolecule.getAtomType(n2);
        int n8 = mMFFMolecule.getAtomType(n3);
        int n9 = mMFFMolecule.getAtomType(n4);
        int n10 = com.actelion.research.chem.forcefield.mmff.type.Torsion.getType(this.t, mMFFMolecule, n, n2, n3, n4);
        int n11 = n10 > 10 ? n10 / 10 : n10;
        int n12 = n10 > 10 ? n10 - n11 * 10 : 0;
        int n13 = -1;
        int n14 = 0;
        int n15 = 0;
        int n16 = n11;
        int n17 = 5;
        for (int i = 0; i < n17 && (n13 == -1 || n17 == 4) || i == 4 && n11 == 5 && n12 > 0; ++i) {
            if (n17 == 5 && i == 4) {
                n17 = 4;
                i = 0;
                n16 = n12;
            }
            if (i == 1) {
                n14 = 1;
                n15 = 3;
            } else if (i == 2) {
                n14 = 3;
                n15 = 1;
            } else {
                n14 = i;
                n15 = i;
            }
            n5 = this.t.def.table[n6 - 1][Math.min(n14 + 1, 4)];
            int n18 = n7;
            int n19 = n8;
            int n20 = this.t.def.table[n9 - 1][Math.min(n15 + 1, 4)];
            if (n18 > n19) {
                Integer n21 = n18;
                n18 = n19;
                n19 = Torsion.s(n21, n18);
                Integer n22 = n5;
                n5 = n20;
                n20 = Torsion.s(n22, n5);
            } else if (n18 == n19 && n5 > n20) {
                Integer n23 = n5;
                n5 = n20;
                n20 = Torsion.s(n23, n5);
            }
            n13 = this.index(n5, n18, n19, n20, n16);
            if (n13 != -1 && n17 == 4) break;
        }
        if (n13 >= 0) {
            return new Kb(n13);
        }
        n5 = mMFFMolecule.getBond(n2, n3);
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0};
        int[] nArray = new int[]{mMFFMolecule.getAtomicNo(n2), mMFFMolecule.getAtomicNo(n3)};
        double d = (this.t.atom.crd(n7) - 1) * (this.t.atom.crd(n8) - 1);
        block9: for (int i = 0; i < 2; ++i) {
            switch (nArray[i]) {
                case 6: {
                    dArray[i] = 2.0;
                    dArray2[i] = 2.12;
                    continue block9;
                }
                case 7: {
                    dArray[i] = 2.0;
                    dArray2[i] = 1.5;
                    continue block9;
                }
                case 8: {
                    dArray[i] = 2.0;
                    dArray2[i] = 0.2;
                    dArray3[i] = 2.0;
                    continue block9;
                }
                case 14: {
                    dArray[i] = 1.25;
                    dArray2[i] = 1.22;
                    continue block9;
                }
                case 15: {
                    dArray[i] = 1.25;
                    dArray2[i] = 2.4;
                    continue block9;
                }
                case 16: {
                    dArray[i] = 1.25;
                    dArray2[i] = 0.49;
                    dArray3[i] = 8.0;
                }
            }
        }
        if (this.t.atom.linear(n7) || this.t.atom.linear(n8)) {
            return new Kb(0.0, 0.0, 0.0);
        }
        if (this.t.atom.arom(n7) && this.t.atom.arom(n8) && mMFFMolecule.isAromaticBond(n5)) {
            double d2 = this.t.atom.val(n7) == 3 && this.t.atom.val(n8) == 4 || this.t.atom.val(n7) == 4 && this.t.atom.val(n8) == 3 ? 3.0 : 6.0;
            double d3 = this.t.atom.pilp(n7) == 0 && this.t.atom.pilp(n8) == 0 ? 0.5 : 0.3;
            return new Kb(0.0, d2 * d3 * Math.sqrt(dArray[0] * dArray[1]), 0.0);
        }
        if (mMFFMolecule.getBondOrder(n5) == 2) {
            double d4 = 6.0;
            double d5 = this.t.atom.mltb(n7) == 2 && this.t.atom.mltb(n8) == 2 ? 1.0 : 0.4;
            return new Kb(0.0, d4 * d5 * Math.sqrt(dArray[0] * dArray[1]), 0.0);
        }
        if (this.t.atom.crd(n7) == 4 && this.t.atom.crd(n8) == 4) {
            return new Kb(0.0, 0.0, Math.sqrt(dArray2[0] * dArray2[1]) / d);
        }
        if (this.t.atom.crd(n7) == 4 && this.t.atom.crd(n8) != 4) {
            if (this.t.atom.crd(n8) == 3 && (this.t.atom.val(n8) == 4 || this.t.atom.val(n8) == 34 || this.t.atom.mltb(n8) > 0) || this.t.atom.crd(n8) == 2 && (this.t.atom.val(n8) == 3 || this.t.atom.mltb(n8) > 0)) {
                return new Kb();
            }
            return new Kb(0.0, 0.0, Math.sqrt(dArray2[0] * dArray2[1]) / d);
        }
        if (this.t.atom.crd(n8) == 4 && this.t.atom.crd(n7) != 4) {
            if (this.t.atom.crd(n7) == 3 && (this.t.atom.val(n7) == 4 || this.t.atom.val(n7) == 34 || this.t.atom.mltb(n7) > 0) || this.t.atom.crd(n7) == 2 && (this.t.atom.val(n7) == 3 || this.t.atom.mltb(n7) > 0)) {
                return new Kb();
            }
            return new Kb(0.0, 0.0, Math.sqrt(dArray2[0] * dArray2[1]) / d);
        }
        if (mMFFMolecule.getBondOrder(n5) == 1 && this.t.atom.mltb(n7) > 0 && this.t.atom.mltb(n8) > 0 || this.t.atom.mltb(n7) > 0 && this.t.atom.pilp(n8) > 0 || this.t.atom.pilp(n7) > 0 && this.t.atom.mltb(n8) > 0) {
            if (this.t.atom.pilp(n7) > 0 && this.t.atom.pilp(n8) > 0) {
                return new Kb();
            }
            if (this.t.atom.pilp(n7) > 0 && this.t.atom.mltb(n8) > 0) {
                double d6 = 6.0;
                double d7 = 0.0;
                if (this.t.atom.mltb(n7) == 1) {
                    d7 = 0.5;
                } else if (PeriodicTable.row(nArray[0]) == 2 && PeriodicTable.row(nArray[1]) == 2) {
                    d7 = 0.3;
                } else if (PeriodicTable.row(nArray[0]) != 2 || PeriodicTable.row(nArray[1]) != 2) {
                    d7 = 0.15;
                }
                return new Kb(0.0, d6 * d7 * Math.sqrt(dArray[0] * dArray[1]), 0.0);
            }
            if (this.t.atom.pilp(n8) > 0 && this.t.atom.mltb(n7) > 0) {
                double d8 = 6.0;
                double d9 = 0.0;
                if (this.t.atom.mltb(n8) == 1) {
                    d9 = 0.5;
                } else if (PeriodicTable.row(nArray[0]) == 2 && PeriodicTable.row(nArray[1]) == 2) {
                    d9 = 0.3;
                } else if (PeriodicTable.row(nArray[0]) != 2 || PeriodicTable.row(nArray[1]) != 2) {
                    d9 = 0.15;
                }
                return new Kb(0.0, d8 * d9 * Math.sqrt(dArray[0] * dArray[1]), 0.0);
            }
            if (!(this.t.atom.mltb(n7) != 1 && this.t.atom.mltb(n8) != 1 || nArray[0] == 6 && nArray[1] == 6)) {
                return new Kb(0.0, 2.4000000000000004 * Math.sqrt(dArray[0] * dArray[1]), 0.0);
            }
            return new Kb(0.0, 0.8999999999999999 * Math.sqrt(dArray[0] * dArray[1]), 0.0);
        }
        if (!(nArray[0] != 8 && nArray[0] != 16 || nArray[1] != 8 && nArray[1] != 16)) {
            return new Kb(0.0, -Math.sqrt(dArray3[0] * dArray3[1]), 0.0);
        }
        return new Kb(0.0, 0.0, Math.sqrt(dArray2[0] * dArray2[1]) / d);
    }

    public final class Kb {
        public double v1;
        public double v2;
        public double v3;

        public Kb(int n) {
            this.v1 = ((Number)Torsion.this.table[n][5]).doubleValue();
            this.v2 = ((Number)Torsion.this.table[n][6]).doubleValue();
            this.v3 = ((Number)Torsion.this.table[n][7]).doubleValue();
        }

        public Kb() {
            this.v1 = 0.0;
            this.v2 = 0.0;
            this.v3 = 0.0;
        }

        public Kb(double d, double d2, double d3) {
            this.v1 = d;
            this.v2 = d2;
            this.v3 = d3;
        }

        public String toString() {
            return this.v1 + "," + this.v2 + "," + this.v3;
        }
    }
}

