/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;
import java.util.Arrays;

public class OutOfPlane
implements Searchable {
    private final Object[][] table;
    private final Tables t;

    public OutOfPlane(Tables tables, String string) {
        this.table = Csv.readFile(string);
        this.t = tables;
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public double getKoop(MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        int n5 = mMFFMolecule.getAtomType(n);
        int[] nArray = new int[]{mMFFMolecule.getAtomType(n2), mMFFMolecule.getAtomType(n3), mMFFMolecule.getAtomType(n4)};
        for (int i = 0; i < 4; ++i) {
            int n6;
            int[] nArray2 = new int[3];
            for (n6 = 0; n6 < 3; ++n6) {
                nArray2[n6] = this.t.def.table[nArray[n6] - 1][i + 1];
            }
            Arrays.sort(nArray2);
            n6 = Search.binary(new int[]{1, 0, 2, 3}, new int[]{n5, nArray2[0], nArray2[1], nArray2[2]}, (Searchable)this);
            if (n6 < 0) continue;
            return ((Number)this.table[n6][4]).doubleValue();
        }
        return 0.0;
    }

    public double getKoop(int n) {
        return ((Number)this.table[n][4]).doubleValue();
    }
}

