/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.PeriodicTable;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;

public final class Dfsb
implements Searchable {
    private final Object[][] table;

    public Dfsb(Tables tables, String string) {
        this.table = Csv.readFile(string);
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public int index(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = PeriodicTable.row(mMFFMolecule.getAtomicNo(n));
        int n5 = PeriodicTable.row(mMFFMolecule.getAtomicNo(n2));
        int n6 = PeriodicTable.row(mMFFMolecule.getAtomicNo(n3));
        if (n4 > n6) {
            Integer n7 = n6;
            n6 = n4;
            n4 = Search.s(n7, n6);
        }
        return Search.binary(new int[]{1, 0, 2}, new int[]{n5, n4, n6}, (Searchable)this);
    }

    public double kb(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4;
        int n5 = PeriodicTable.row(mMFFMolecule.getAtomicNo(n));
        int n6 = n5 > (n4 = PeriodicTable.row(mMFFMolecule.getAtomicNo(n3))) ? 4 : 3;
        int n7 = this.index(mMFFMolecule, n, n2, n3);
        return n7 >= 0 ? ((Number)this.table[n7][n6]).doubleValue() : 0.0;
    }
}

