/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;

public final class Angle
implements Searchable {
    private final Object[][] table;
    private final Tables t;

    public Angle(Tables tables, String string) {
        this.table = Csv.readFile(string);
        this.t = tables;
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public double ka(int n) {
        return ((Number)this.table[n][4]).doubleValue();
    }

    public double theta(int n) {
        return ((Number)this.table[n][5]).doubleValue();
    }

    public int index(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = mMFFMolecule.getAtomType(n);
        int n5 = mMFFMolecule.getAtomType(n2);
        int n6 = mMFFMolecule.getAtomType(n3);
        int n7 = com.actelion.research.chem.forcefield.mmff.type.Angle.getType(this.t, mMFFMolecule, n, n2, n3);
        int n8 = -1;
        for (int i = 0; i < 5 && n8 < 0; ++i) {
            int n9 = this.t.def.table[n4 - 1][i];
            int n10 = this.t.def.table[n6 - 1][i];
            if (n9 > n10) {
                Integer n11 = n10;
                n10 = n9;
                n9 = Search.s(n11, n10);
            }
            n8 = Search.binary(new int[]{2, 1, 3, 0}, new int[]{n5, n9, n10, n7}, (Searchable)this);
        }
        return n8;
    }

    public double theta(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = this.index(mMFFMolecule, n, n2, n3);
        if (n4 < 0) {
            return this.getEmpiricalTheta0(mMFFMolecule, n, n2, n3);
        }
        return this.theta(n4);
    }

    public double ka(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = this.index(mMFFMolecule, n, n2, n3);
        if (n4 < 0) {
            return this.getEmpiricalKa(mMFFMolecule, n, n2, n3, this.getEmpiricalTheta0(mMFFMolecule, n, n2, n3));
        }
        if (Math.abs(this.ka(n4)) < 0.001) {
            return this.getEmpiricalKa(mMFFMolecule, n, n2, n3, this.theta(n4));
        }
        return this.ka(n4);
    }

    private double getEmpiricalTheta0(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        if (com.actelion.research.chem.forcefield.mmff.type.Angle.inRingOfSize(mMFFMolecule, n, n2, n3, 3)) {
            return 60.0;
        }
        if (com.actelion.research.chem.forcefield.mmff.type.Angle.inRingOfSize(mMFFMolecule, n, n2, n3, 4)) {
            return 90.0;
        }
        int n4 = mMFFMolecule.getAtomType(n2);
        switch (this.t.atom.crd(n4)) {
            case 2: {
                if (mMFFMolecule.getAtomicNo(n2) == 8) {
                    return 105.0;
                }
                if (!this.t.atom.linear(n4)) break;
                return 180.0;
            }
            case 3: {
                if (this.t.atom.val(n4) != 3 || this.t.atom.mltb(n4) != 0) break;
                if (mMFFMolecule.getAtomicNo(n2) == 7) {
                    return 107.0;
                }
                return 92.0;
            }
            case 4: {
                return 109.45;
            }
        }
        return 120.0;
    }

    private double getEmpiricalKa(MMFFMolecule mMFFMolecule, int n, int n2, int n3, double d) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        int[] nArray = new int[]{mMFFMolecule.getAtomicNo(n), mMFFMolecule.getAtomicNo(n2), mMFFMolecule.getAtomicNo(n3)};
        double d2 = 1.75;
        block13: for (int i = 0; i < 3; ++i) {
            switch (nArray[i]) {
                case 1: {
                    dArray[i] = 1.395;
                    continue block13;
                }
                case 6: {
                    dArray[i] = 2.494;
                    dArray2[i] = 1.016;
                    continue block13;
                }
                case 7: {
                    dArray[i] = 2.711;
                    dArray2[i] = 1.113;
                    continue block13;
                }
                case 8: {
                    dArray[i] = 3.045;
                    dArray2[i] = 1.337;
                    continue block13;
                }
                case 9: {
                    dArray[i] = 2.847;
                    continue block13;
                }
                case 14: {
                    dArray[i] = 2.35;
                    dArray2[i] = 0.811;
                    continue block13;
                }
                case 15: {
                    dArray[i] = 2.35;
                    dArray2[i] = 1.068;
                    continue block13;
                }
                case 16: {
                    dArray[i] = 2.98;
                    dArray2[i] = 1.249;
                    continue block13;
                }
                case 17: {
                    dArray[i] = 2.909;
                    dArray2[i] = 1.078;
                    continue block13;
                }
                case 35: {
                    dArray[i] = 3.017;
                    continue block13;
                }
                case 53: {
                    dArray[i] = 3.086;
                }
            }
        }
        double d3 = this.t.bond.r0(mMFFMolecule, n, n2);
        double d4 = this.t.bond.r0(mMFFMolecule, n2, n3);
        double d5 = (d3 - d4) * (d3 - d4) / ((d3 + d4) * (d3 + d4));
        double d6 = Math.PI / 180 * d;
        if (com.actelion.research.chem.forcefield.mmff.type.Angle.inRingOfSize(mMFFMolecule, n, n2, n3, 4)) {
            d2 *= 0.85;
        } else if (com.actelion.research.chem.forcefield.mmff.type.Angle.inRingOfSize(mMFFMolecule, n, n2, n3, 3)) {
            d2 *= 0.05;
        }
        return d2 * dArray[0] * dArray2[1] * dArray[2] / ((d3 + d4) * d6 * d6 * Math.exp(2.0 * d5));
    }
}

