/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;

public class Vector3 {
    private static final double TOL = 0.01;
    public final double x;
    public final double y;
    public final double z;

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public Vector3(MMFFMolecule mMFFMolecule, int n) {
        this.x = mMFFMolecule.getAtomX(n);
        this.y = mMFFMolecule.getAtomY(n);
        this.z = mMFFMolecule.getAtomZ(n);
    }

    public Vector3(ExtendedMolecule extendedMolecule, int n) {
        this.x = extendedMolecule.getAtomX(n);
        this.y = extendedMolecule.getAtomY(n);
        this.z = extendedMolecule.getAtomZ(n);
    }

    public Vector3(double[] dArray, int n) {
        this.x = dArray[3 * n];
        this.y = dArray[3 * n + 1];
        this.z = dArray[3 * n + 2];
    }

    public Vector3(double[] dArray, int n, int n2) {
        this(new Vector3(dArray, n).to(new Vector3(dArray, n2)));
    }

    public Vector3(MMFFMolecule mMFFMolecule, int n, int n2) {
        this(new Vector3(mMFFMolecule, n).to(new Vector3(mMFFMolecule, n2)));
    }

    public Vector3(ExtendedMolecule extendedMolecule, int n, int n2) {
        this(new Vector3(extendedMolecule, n).to(new Vector3(extendedMolecule, n2)));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector3)) {
            return false;
        }
        Vector3 vector3 = (Vector3)object;
        return Math.abs(this.x - vector3.x) < 0.01 && Math.abs(this.y - vector3.y) < 0.01 && Math.abs(this.z - vector3.z) < 0.01;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() + new Double(this.y).hashCode() + new Double(this.z).hashCode();
    }

    public void write(double[] dArray, int n) {
        dArray[3 * n] = this.x;
        dArray[3 * n + 1] = this.y;
        dArray[3 * n + 2] = this.z;
    }

    public Vector3 negate() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 to(Vector3 vector3) {
        return new Vector3(vector3.x - this.x, vector3.y - this.y, vector3.z - this.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3 normalise() {
        if (this.length() > 0.0) {
            return new Vector3(this.x / this.length(), this.y / this.length(), this.z / this.length());
        }
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 add(Vector3 vector3) {
        return new Vector3(this.x + vector3.x, this.y + vector3.y, this.z + vector3.z);
    }

    public Vector3 sub(Vector3 vector3) {
        return new Vector3(this.x - vector3.x, this.y - vector3.y, this.z - vector3.z);
    }

    public double distance(Vector3 vector3) {
        return Math.sqrt((this.x - vector3.x) * (this.x - vector3.x) + (this.y - vector3.y) * (this.y - vector3.y) + (this.z - vector3.z) * (this.z - vector3.z));
    }

    public double dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public Vector3 cross(Vector3 vector3) {
        return new Vector3(this.y * vector3.z - this.z * vector3.y, this.z * vector3.x - this.x * vector3.z, this.x * vector3.y - this.y * vector3.x);
    }

    public double angle(Vector3 vector3) {
        return Math.acos(this.dot(vector3) / (this.length() * vector3.length()));
    }

    public double cosAngle(Vector3 vector3) {
        return this.dot(vector3) / (this.length() * vector3.length());
    }

    public String toString() {
        return "(" + String.format("%.3f", this.x) + "," + String.format("%.3f", this.y) + "," + String.format("%.3f", this.z) + ")";
    }
}

