/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import java.util.ArrayList;
import java.util.List;

public class OutOfPlane
implements EnergyTerm {
    int ac;
    int a1;
    int a2;
    int a3;
    double koop;

    public OutOfPlane(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3, int n4) {
        this.ac = n;
        this.a1 = n2;
        this.a2 = n3;
        this.a3 = n4;
        this.koop = tables.oop.getKoop(mMFFMolecule, n, n2, n3, n4);
    }

    public double getKoop() {
        return this.koop;
    }

    @Override
    public double getEnergy(double[] dArray) {
        Vector3 vector3 = new Vector3(dArray, this.ac, this.a1).normalise();
        Vector3 vector32 = new Vector3(dArray, this.ac, this.a2).normalise();
        Vector3 vector33 = new Vector3(dArray, this.ac, this.a3).normalise();
        Vector3 vector34 = vector3.cross(vector32).normalise();
        double d = 57.29577951308232 * Math.asin(vector34.dot(vector33));
        double d2 = 0.043844346773450435;
        return 0.5 * d2 * this.koop * d * d;
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        Vector3 vector3;
        Vector3 vector32 = new Vector3(dArray, this.ac, this.a1);
        Vector3 vector33 = new Vector3(dArray, this.ac, this.a2);
        Vector3 vector34 = new Vector3(dArray, this.ac, this.a3);
        double d = vector32.length();
        double d2 = vector33.length();
        double d3 = vector34.length();
        vector32 = vector32.normalise();
        vector33 = vector33.normalise();
        double d4 = (vector34 = vector34.normalise()).dot(vector3 = vector32.negate().cross(vector33).normalise());
        double d5 = 1.0 - d4 * d4;
        double d6 = Math.max(d5 > 0.0 ? Math.sqrt(d5) : 0.0, 1.0E-8);
        double d7 = 57.29577951308232 * Math.asin(d4);
        double d8 = vector32.dot(vector33);
        double d9 = Math.max(1.0 - d8 * d8, 1.0E-8);
        double d10 = Math.max(d9 > 0.0 ? Math.sqrt(d9) : 0.0, 1.0E-8);
        double d11 = 2.5120960256267386 * this.koop * d7;
        Vector3 vector35 = vector34.cross(vector33);
        Vector3 vector36 = vector32.cross(vector34);
        Vector3 vector37 = vector33.cross(vector32);
        double d12 = d6 * d10;
        double d13 = d4 / (d6 * d9);
        double[] dArray3 = new double[]{(vector35.x / d12 - (vector32.x - vector33.x * d8) * d13) / d, (vector35.y / d12 - (vector32.y - vector33.y * d8) * d13) / d, (vector35.z / d12 - (vector32.z - vector33.z * d8) * d13) / d};
        double[] dArray4 = new double[]{(vector36.x / d12 - (vector33.x - vector32.x * d8) * d13) / d2, (vector36.y / d12 - (vector33.y - vector32.y * d8) * d13) / d2, (vector36.z / d12 - (vector33.z - vector32.z * d8) * d13) / d2};
        double[] dArray5 = new double[]{(vector37.x / d12 - vector34.x * d4 / d6) / d3, (vector37.y / d12 - vector34.y * d4 / d6) / d3, (vector37.z / d12 - vector34.z * d4 / d6) / d3};
        for (int i = 0; i < 3; ++i) {
            int n = 3 * this.a1 + i;
            dArray2[n] = dArray2[n] + d11 * dArray3[i];
            int n2 = 3 * this.ac + i;
            dArray2[n2] = dArray2[n2] + -d11 * (dArray3[i] + dArray4[i] + dArray5[i]);
            int n3 = 3 * this.a2 + i;
            dArray2[n3] = dArray2[n3] + d11 * dArray4[i];
            int n4 = 3 * this.a3 + i;
            dArray2[n4] = dArray2[n4] + d11 * dArray5[i];
        }
    }

    public boolean equals(int n, int n2, int n3, int n4) {
        return this.ac == n && (this.a1 == n2 && this.a2 == n3 && this.a3 == n4 || this.a1 == n2 && this.a2 == n4 && this.a3 == n3 || this.a1 == n3 && this.a2 == n2 && this.a3 == n4 || this.a1 == n3 && this.a2 == n4 && this.a3 == n2 || this.a1 == n4 && this.a2 == n2 && this.a3 == n3 || this.a1 == n4 && this.a2 == n3 && this.a3 == n2);
    }

    public boolean exactly(int n, int n2, int n3, int n4) {
        return this.ac == n && this.a1 == n2 && this.a2 == n3 && this.a3 == n4;
    }

    public static List<OutOfPlane> findIn(Tables tables, MMFFMolecule mMFFMolecule) {
        ArrayList<OutOfPlane> arrayList = new ArrayList<OutOfPlane>();
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            if (mMFFMolecule.getAllConnAtoms(i) != 3) continue;
            int n = mMFFMolecule.getConnAtom(i, 0);
            int n2 = mMFFMolecule.getConnAtom(i, 1);
            int n3 = mMFFMolecule.getConnAtom(i, 2);
            arrayList.add(new OutOfPlane(tables, mMFFMolecule, i, n, n2, n3));
            arrayList.add(new OutOfPlane(tables, mMFFMolecule, i, n, n3, n2));
            arrayList.add(new OutOfPlane(tables, mMFFMolecule, i, n2, n3, n));
        }
        return arrayList;
    }

    public static List<OutOfPlane> findIn(MMFFMolecule mMFFMolecule) {
        return OutOfPlane.findIn(ForceFieldMMFF94.table("MMFF94"), mMFFMolecule);
    }
}

