/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;

public class MMFFExternalPositionConstraint
implements EnergyTerm {
    private double[] refPos;
    private int constrainedAtom;
    private double k;
    private double d;

    public MMFFExternalPositionConstraint(int n, double[] dArray, double d, double d2) {
        this.refPos = dArray;
        this.constrainedAtom = n;
        this.k = d;
        this.d = d2;
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = 0.0;
        double d2 = dArray[3 * this.constrainedAtom] - this.refPos[0];
        double d3 = dArray[3 * this.constrainedAtom + 1] - this.refPos[1];
        double d4 = dArray[3 * this.constrainedAtom + 2] - this.refPos[2];
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d6 = 0.0;
        d6 = d5 > this.d ? d5 - this.d : 0.0;
        return d += 0.5 * this.k * d6 * d6;
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        int n = this.constrainedAtom;
        double d = dArray[3 * n] - this.refPos[0];
        double d2 = dArray[3 * n + 1] - this.refPos[1];
        double d3 = dArray[3 * n + 2] - this.refPos[2];
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = 0.0;
        d5 = d4 > this.d ? d4 - this.d : 0.0;
        int n2 = n;
        dArray2[n2] = dArray2[n2] + d5 * d / Math.max(d4, 1.0E-8);
        int n3 = n + 1;
        dArray2[n3] = dArray2[n3] + d5 * d2 / Math.max(d4, 1.0E-8);
        int n4 = n + 2;
        dArray2[n4] = dArray2[n4] + d5 * d3 / Math.max(d4, 1.0E-8);
    }
}

