/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import java.util.ArrayList;
import java.util.List;

public class AngleBend
implements EnergyTerm {
    public final int a1;
    public final int a2;
    public final int a3;
    public final boolean isLinear;
    public final double ka;
    public final double theta0;

    public AngleBend(Tables tables, MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        this.a1 = n;
        this.a2 = n2;
        this.a3 = n3;
        this.isLinear = tables.atom.linear(mMFFMolecule.getAtomType(n2));
        this.theta0 = tables.angle.theta(mMFFMolecule, n, n2, n3);
        this.ka = tables.angle.ka(mMFFMolecule, n, n2, n3);
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = new Vector3(dArray, this.a2, this.a1).angle(new Vector3(dArray, this.a2, this.a3));
        double d2 = Math.toDegrees(d) - this.theta0;
        if (this.isLinear) {
            return 143.9325 * this.ka * (1.0 + Math.cos(d));
        }
        return 0.021922173386725217 * this.ka * d2 * d2 * (1.0 + -0.006981317 * d2);
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        Vector3 vector3 = new Vector3(dArray, this.a2, this.a1).normalise();
        Vector3 vector32 = new Vector3(dArray, this.a2, this.a3).normalise();
        double d = new Vector3(dArray, this.a2, this.a1).length();
        double d2 = new Vector3(dArray, this.a2, this.a3).length();
        double d3 = vector3.cosAngle(vector32);
        double d4 = 1.0 - d3 * d3;
        double d5 = 1.0E-8;
        if (d4 > 0.0) {
            d5 = Math.sqrt(d4);
        }
        double d6 = 57.29577951308232 * Math.acos(d3) - this.theta0;
        double d7 = -0.006981317;
        double d8 = 0.043844346773450435;
        double d9 = 57.29577951308232 * d8 * this.ka * d6 * (1.0 + 1.5 * d7 * d6);
        if (this.isLinear) {
            d9 = -143.9325 * this.ka * d5;
        }
        double[] dArray3 = new double[]{1.0 / d * (vector32.x - d3 * vector3.x), 1.0 / d * (vector32.y - d3 * vector3.y), 1.0 / d * (vector32.z - d3 * vector3.z), 1.0 / d2 * (vector3.x - d3 * vector32.x), 1.0 / d2 * (vector3.y - d3 * vector32.y), 1.0 / d2 * (vector3.z - d3 * vector32.z)};
        int n = 3 * this.a1;
        dArray2[n] = dArray2[n] + d9 * dArray3[0] / -d5;
        int n2 = 3 * this.a1 + 1;
        dArray2[n2] = dArray2[n2] + d9 * dArray3[1] / -d5;
        int n3 = 3 * this.a1 + 2;
        dArray2[n3] = dArray2[n3] + d9 * dArray3[2] / -d5;
        int n4 = 3 * this.a2;
        dArray2[n4] = dArray2[n4] + d9 * (-dArray3[0] - dArray3[3]) / -d5;
        int n5 = 3 * this.a2 + 1;
        dArray2[n5] = dArray2[n5] + d9 * (-dArray3[1] - dArray3[4]) / -d5;
        int n6 = 3 * this.a2 + 2;
        dArray2[n6] = dArray2[n6] + d9 * (-dArray3[2] - dArray3[5]) / -d5;
        int n7 = 3 * this.a3;
        dArray2[n7] = dArray2[n7] + d9 * dArray3[3] / -d5;
        int n8 = 3 * this.a3 + 1;
        dArray2[n8] = dArray2[n8] + d9 * dArray3[4] / -d5;
        int n9 = 3 * this.a3 + 2;
        dArray2[n9] = dArray2[n9] + d9 * dArray3[5] / -d5;
    }

    public static List<AngleBend> findIn(Tables tables, MMFFMolecule mMFFMolecule) {
        ArrayList<AngleBend> arrayList = new ArrayList<AngleBend>();
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            if (mMFFMolecule.getAllConnAtoms(i) <= 1) continue;
            for (int j = 0; j < mMFFMolecule.getAllConnAtoms(i); ++j) {
                int n = mMFFMolecule.getConnAtom(i, j);
                for (int k = j + 1; k < mMFFMolecule.getAllConnAtoms(i); ++k) {
                    int n2 = mMFFMolecule.getConnAtom(i, k);
                    arrayList.add(new AngleBend(tables, mMFFMolecule, n, i, n2));
                }
            }
        }
        return arrayList;
    }
}

