/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.forcefield.ForceField;
import com.actelion.research.chem.forcefield.ForceFieldChangeListener;
import java.util.ArrayList;

public abstract class AbstractForceField
implements ForceField {
    public static final double FUNCTOL = 1.0E-4;
    public static final double MOVETOL = 1.0E-7;
    public static final double EPS = 3.0E-8;
    public static final double TOLX = 1.2E-7;
    public static final double MAXSTEP = 100.0;
    protected ArrayList<ForceFieldChangeListener> listeners = new ArrayList();
    protected StereoMolecule mMol;
    protected final int mDim;
    protected double[] mPos;
    protected double[] mNewpos;
    protected double[] mGrad;
    protected int[] mFixedAtoms;
    protected double mTotalEnergy;
    protected long mTimeInterval;
    protected volatile boolean mIsInterrupted;

    public AbstractForceField(StereoMolecule stereoMolecule) {
        int n;
        int n2 = 0;
        for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
            n2 += stereoMolecule.getImplicitHydrogens(n);
        }
        if (n2 > 0) {
            throw new IllegalArgumentException("molecule needs explicit hydrogen atoms for force field calculations");
        }
        this.mMol = stereoMolecule;
        this.mDim = 3 * stereoMolecule.getAllAtoms();
        this.mGrad = new double[this.mDim];
        this.mPos = new double[this.mDim];
        this.mNewpos = new double[this.mDim];
        this.mIsInterrupted = false;
        this.mTimeInterval = 20L;
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            this.mPos[3 * n] = stereoMolecule.getAtomX(n);
            this.mPos[3 * n + 1] = stereoMolecule.getAtomY(n);
            this.mPos[3 * n + 2] = stereoMolecule.getAtomZ(n);
        }
    }

    @Override
    public void addListener(ForceFieldChangeListener forceFieldChangeListener) {
        this.listeners.add(forceFieldChangeListener);
    }

    public void addGradient(double[] dArray) {
        assert (dArray.length == this.mGrad.length);
        this.updateGradient();
        for (int i = 0; i < this.mGrad.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] + this.mGrad[i];
        }
    }

    public void getState(double[] dArray) {
        assert (dArray.length == this.mPos.length);
        for (int i = 0; i < this.mPos.length; ++i) {
            dArray[i] = this.mPos[i];
        }
    }

    public void setState(double[] dArray) {
        assert (dArray.length == this.mPos.length);
        for (int i = 0; i < this.mPos.length; ++i) {
            this.mPos[i] = dArray[i];
        }
    }

    public double coordVariance(int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 1;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            double d3;
            switch (n) {
                case 0: {
                    d3 = this.mMol.getAtomX(i);
                    break;
                }
                case 1: {
                    d3 = this.mMol.getAtomY(i);
                    break;
                }
                default: {
                    d3 = this.mMol.getAtomZ(i);
                }
            }
            double d4 = d;
            d2 += (d3 - d4) * (d3 - (d += (d3 - d4) / (double)n2));
            ++n2;
        }
        return n2 > 1 ? d2 / (double)(n2 - 1) : 0.0;
    }

    @Override
    public int minimise() {
        return this.minimise(4000, 1.0E-4, 1.0E-6);
    }

    @Override
    public void setFixedAtoms(int[] nArray) {
        this.mFixedAtoms = nArray;
    }

    @Override
    public void zeroGradient() {
        if (this.mFixedAtoms != null) {
            for (int n : this.mFixedAtoms) {
                this.mGrad[3 * n] = 0.0;
                this.mGrad[3 * n + 1] = 0.0;
                this.mGrad[3 * n + 2] = 0.0;
            }
        }
    }

    public int minimise(int n, double d, double d2) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            this.mPos[3 * n2] = this.mMol.getAtomX(n2);
            this.mPos[3 * n2 + 1] = this.mMol.getAtomY(n2);
            this.mPos[3 * n2 + 2] = this.mMol.getAtomZ(n2);
        }
        n3 = this.run_minimiser(n, d, d2);
        if (n3 == 0) {
            for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
                this.mMol.setAtomX(n2, this.mPos[3 * n2]);
                this.mMol.setAtomY(n2, this.mPos[3 * n2 + 1]);
                this.mMol.setAtomZ(n2, this.mPos[3 * n2 + 2]);
            }
        }
        for (ForceFieldChangeListener forceFieldChangeListener : this.listeners) {
            forceFieldChangeListener.stateChanged();
        }
        return n3;
    }

    public int run_minimiser(int n, double d, double d2) {
        int n2;
        this.mGrad = new double[this.mDim];
        double[] dArray = new double[this.mDim];
        double[] dArray2 = new double[this.mDim];
        double[] dArray3 = new double[this.mDim];
        double[] dArray4 = new double[this.mDim];
        double[] dArray5 = new double[this.mDim * this.mDim];
        for (n2 = 0; n2 < this.mDim; ++n2) {
            dArray3[n2] = this.mPos[n2];
        }
        double d3 = this.getTotalEnergy(this.mPos);
        this.updateGradient();
        this.zeroGradient();
        double d4 = 0.0;
        for (n2 = 0; n2 < this.mDim; ++n2) {
            dArray5[n2 * this.mDim + n2] = 1.0;
            dArray4[n2] = -this.mGrad[n2];
            d4 += this.mPos[n2] * this.mPos[n2];
        }
        double d5 = 100.0 * Math.max(Math.sqrt(d4), (double)this.mDim);
        long l = System.currentTimeMillis();
        for (int i = 1; i <= n && !this.mIsInterrupted; ++i) {
            int n3;
            int n4;
            int n5;
            int n6 = this.linearSearch(this.mPos, d3, dArray4, dArray3, d5);
            if (n6 < 0) {
                return 2;
            }
            d3 = this.mTotalEnergy;
            double d6 = 0.0;
            for (int j = 0; j < this.mDim; ++j) {
                dArray4[j] = dArray3[j] - this.mPos[j];
                this.mPos[j] = dArray3[j];
                double d7 = Math.abs(dArray4[j]) / Math.max(Math.abs(this.mPos[j]), 1.0);
                if (d7 > d6) {
                    d6 = d7;
                }
                dArray[j] = this.mGrad[j];
            }
            if (d6 < 1.2E-7) {
                return 0;
            }
            double d8 = this.updateGradient();
            this.zeroGradient();
            d6 = 0.0;
            double d9 = Math.max(this.mTotalEnergy * d8, 1.0);
            for (int j = 0; j < this.mDim; ++j) {
                double d10 = Math.abs(this.mGrad[j]) * Math.max(Math.abs(this.mPos[j]), 1.0);
                d6 = Math.max(d6, d10);
                dArray[j] = this.mGrad[j] - dArray[j];
            }
            if ((d6 /= d9) < d) {
                return 0;
            }
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            for (n5 = 0; n5 < this.mDim; ++n5) {
                n4 = n5 * this.mDim;
                dArray2[n5] = 0.0;
                for (n3 = 0; n3 < this.mDim; ++n3) {
                    int n7 = n5;
                    dArray2[n7] = dArray2[n7] + dArray5[n4 + n3] * dArray[n3];
                }
                d11 += dArray[n5] * dArray4[n5];
                d12 += dArray[n5] * dArray2[n5];
                d13 += dArray[n5] * dArray[n5];
                d14 += dArray4[n5] * dArray4[n5];
            }
            if (d11 > Math.sqrt(3.0E-8 * d13 * d14)) {
                d11 = 1.0 / d11;
                double d15 = 1.0 / d12;
                for (n3 = 0; n3 < this.mDim; ++n3) {
                    dArray[n3] = d11 * dArray4[n3] - d15 * dArray2[n3];
                }
                for (n3 = 0; n3 < this.mDim; ++n3) {
                    int n8 = n3 * this.mDim;
                    for (int j = n3; j < this.mDim; ++j) {
                        int n9 = n8 + j;
                        dArray5[n9] = dArray5[n9] + (d11 * dArray4[n3] * dArray4[j] - d15 * dArray2[n3] * dArray2[j] + d12 * dArray[n3] * dArray[j]);
                        dArray5[j * this.mDim + n3] = dArray5[n8 + j];
                    }
                }
            }
            for (n5 = 0; n5 < this.mDim; ++n5) {
                n4 = n5 * this.mDim;
                dArray4[n5] = 0.0;
                for (n3 = 0; n3 < this.mDim; ++n3) {
                    int n10 = n5;
                    dArray4[n10] = dArray4[n10] - dArray5[n4 + n3] * this.mGrad[n3];
                }
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 < this.mTimeInterval) continue;
            for (ForceFieldChangeListener forceFieldChangeListener : this.listeners) {
                forceFieldChangeListener.stateChanged();
            }
            l = l2;
        }
        return 1;
    }

    private int linearSearch(double[] dArray, double d, double[] dArray2, double[] dArray3, double d2) {
        int n;
        int n2 = -1;
        double[] dArray4 = new double[this.mDim];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        d3 = 0.0;
        for (n = 0; n < this.mDim; ++n) {
            d3 += dArray2[n] * dArray2[n];
        }
        if ((d3 = Math.sqrt(d3)) > d2) {
            n = 0;
            while (n < this.mDim) {
                int n3 = n++;
                dArray2[n3] = dArray2[n3] * (d2 / d3);
            }
        }
        d4 = 0.0;
        for (n = 0; n < this.mDim; ++n) {
            d4 += dArray2[n] * this.mGrad[n];
        }
        if (d4 >= 0.0) {
            return n2;
        }
        d5 = 0.0;
        for (n = 0; n < this.mDim; ++n) {
            double d11 = Math.abs(dArray2[n]) / Math.max(Math.abs(dArray[n]), 1.0);
            if (!(d11 > d5)) continue;
            d5 = d11;
        }
        d8 = 1.0E-7 / d5;
        d6 = 1.0;
        for (n = 0; n < 1000; ++n) {
            if (d6 < d8) {
                n2 = 1;
                break;
            }
            for (int i = 0; i < this.mDim; ++i) {
                dArray3[i] = dArray[i] + d6 * dArray2[i];
            }
            this.mTotalEnergy = this.getTotalEnergy(dArray3);
            if (this.mTotalEnergy - d <= 1.0E-4 * d6 * d4) {
                return 0;
            }
            if (n == 0) {
                d9 = -d4 / (2.0 * (this.mTotalEnergy - d - d4));
            } else {
                double d12;
                double d13 = this.mTotalEnergy - d - d6 * d4;
                double d14 = d10 - d - d7 * d4;
                double d15 = (d13 / (d6 * d6) - d14 / (d7 * d7)) / (d6 - d7);
                double d16 = (-d7 * d13 / (d6 * d6) + d6 * d14 / (d7 * d7)) / (d6 - d7);
                d9 = d15 == 0.0 ? -d4 / (2.0 * d16) : ((d12 = d16 * d16 - 3.0 * d15 * d4) < 0.0 ? 0.5 * d6 : (d16 <= 0.0 ? (-d16 + Math.sqrt(d12)) / (3.0 * d15) : -d4 / (d16 + Math.sqrt(d12))));
                if (d9 > 0.5 * d6) {
                    d9 = 0.5 * d6;
                }
            }
            d7 = d6;
            d10 = this.mTotalEnergy;
            d6 = Math.max(d9, 0.1 * d6);
        }
        for (int i = 0; i < this.mDim; ++i) {
            dArray3[i] = dArray[i];
        }
        return n2;
    }

    @Override
    public void interrupt() {
        this.mIsInterrupted = true;
    }
}

