/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring.idoscore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.interactionstatistics.InteractionDistanceStatistics;
import com.actelion.research.chem.interactionstatistics.SplineFunction;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class InteractionTerm
implements PotentialEnergyTerm {
    private static final double CUTOFF = 5.8;
    private static final double CUTOFF_SQ = 33.64;
    private double energy;
    private double factor;
    private Conformer ligand;
    private Conformer receptor;
    private int[] atoms;
    private final SplineFunction f;

    private InteractionTerm(Conformer conformer, Conformer conformer2, int[] nArray, SplineFunction splineFunction, double d) {
        this.receptor = conformer;
        this.ligand = conformer2;
        this.f = splineFunction;
        this.factor = d;
        this.atoms = nArray;
    }

    public static InteractionTerm create(Conformer conformer, Conformer conformer2, int n, int n2, int[] nArray, int[] nArray2) {
        SplineFunction splineFunction = InteractionDistanceStatistics.getInstance().getFunction(nArray[n], nArray2[n2]);
        if (splineFunction == null) {
            return null;
        }
        return new InteractionTerm(conformer, conformer2, new int[]{n, n2}, splineFunction, 1.0);
    }

    @Override
    public final double getFGValue(double[] dArray) {
        Coordinates coordinates = this.receptor.getCoordinates(this.atoms[0]);
        Coordinates coordinates2 = this.ligand.getCoordinates(this.atoms[1]);
        Coordinates coordinates3 = coordinates.subC(coordinates2);
        double d = coordinates3.distSq();
        double d2 = 0.0;
        if (d > 33.64) {
            this.energy = 0.0;
        } else {
            double d3 = 0.0;
            d2 = Math.sqrt(d);
            double[] dArray2 = this.f.getFGValue(d2);
            this.energy = this.factor * dArray2[0];
            if (dArray != null) {
                d3 = this.factor * dArray2[1];
            }
            if (dArray != null) {
                double d4 = (d2 <= 1.0 ? -10.0 : d3) / d2;
                coordinates3.scale(d4);
                int n = 3 * this.atoms[1];
                dArray[n] = dArray[n] - coordinates3.x;
                int n2 = 3 * this.atoms[1] + 1;
                dArray[n2] = dArray[n2] - coordinates3.y;
                int n3 = 3 * this.atoms[1] + 2;
                dArray[n3] = dArray[n3] - coordinates3.z;
            }
        }
        return this.energy;
    }
}

