/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring.chemscore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleMetalTerm
implements PotentialEnergyTerm {
    private static final double D1 = 2.6;
    private static final double D2 = 3.0;
    private static final double PHI0 = Math.PI;
    private static final double PHI1 = 1.3962634015954636;
    private static final double PHI2 = 1.5707963267948966;
    private static final double ENERGY = -6.0;
    private Conformer receptor;
    private Conformer ligand;
    private int acceptor;
    private int metal;
    private int[] acceptorNeighbours;
    private double scale;

    private SimpleMetalTerm(Conformer conformer, Conformer conformer2, int n, int n2, int[] nArray, double d) {
        this.receptor = conformer;
        this.ligand = conformer2;
        this.acceptor = n;
        this.metal = n2;
        this.acceptor = n;
        this.acceptorNeighbours = nArray;
        this.scale = d;
    }

    public static SimpleMetalTerm create(Conformer conformer, Conformer conformer2, int n, int n2, int[] nArray, double d) {
        return new SimpleMetalTerm(conformer, conformer2, n, n2, nArray, d);
    }

    private double getDistTerm(double[] dArray) {
        Coordinates coordinates;
        Coordinates coordinates2 = new Coordinates();
        double d = 0.0;
        Coordinates coordinates3 = this.ligand.getCoordinates(this.acceptor);
        Coordinates coordinates4 = coordinates3.subC(coordinates = this.receptor.getCoordinates(this.metal));
        double d2 = coordinates4.dist();
        if (d2 < 2.6) {
            d = 1.0;
        } else if (d2 > 3.0) {
            d = 0.0;
        } else {
            double d3 = -2.5000000000000004 * (1.0 / d2);
            coordinates2 = coordinates4.scaleC(d3);
            int n = 3 * this.acceptor;
            dArray[n] = dArray[n] + coordinates2.x;
            int n2 = 3 * this.acceptor + 1;
            dArray[n2] = dArray[n2] + coordinates2.y;
            int n3 = 3 * this.acceptor + 2;
            dArray[n3] = dArray[n3] + coordinates2.z;
            d = (3.0 - d2) / 0.3999999999999999;
        }
        return d;
    }

    private double getAngleTerm(double[] dArray, int n, int n2, int n3, double d, double d2, double d3) {
        double d4 = 0.0;
        Coordinates coordinates = this.ligand.getCoordinates(n);
        Coordinates coordinates2 = this.ligand.getCoordinates(n2);
        Coordinates coordinates3 = this.receptor.getCoordinates(n3);
        Coordinates coordinates4 = coordinates.subC(coordinates2).unit();
        Coordinates coordinates5 = coordinates3.subC(coordinates2).unit();
        double d5 = coordinates2.distance(coordinates);
        double d6 = coordinates3.distance(coordinates2);
        double d7 = coordinates4.cosAngle(coordinates5);
        double d8 = Math.acos(d7) - d;
        if (d8 < d2) {
            d4 = 1.0;
        } else if (d8 > d3) {
            d4 = 0.0;
        } else {
            double d9 = -1.0 / (d3 - d2);
            if (d8 < 0.0) {
                d9 = -d9;
                d8 = -d8;
            }
            d4 = (d3 - d8) / (d3 - d2);
            double d10 = 1.0 - d7 * d7;
            double d11 = 1.0E-8;
            if (d10 > 0.0) {
                d11 = Math.sqrt(d10);
            }
            double[] dArray2 = new double[]{1.0 / d5 * (coordinates5.x - d7 * coordinates4.x), 1.0 / d5 * (coordinates5.y - d7 * coordinates4.y), 1.0 / d5 * (coordinates5.z - d7 * coordinates4.z), 1.0 / d6 * (coordinates4.x - d7 * coordinates5.x), 1.0 / d6 * (coordinates4.y - d7 * coordinates5.y), 1.0 / d6 * (coordinates4.z - d7 * coordinates5.z)};
            int n4 = 3 * n;
            dArray[n4] = dArray[n4] + d9 * dArray2[0] / -d11;
            int n5 = 3 * n + 1;
            dArray[n5] = dArray[n5] + d9 * dArray2[1] / -d11;
            int n6 = 3 * n + 2;
            dArray[n6] = dArray[n6] + d9 * dArray2[2] / -d11;
            int n7 = 3 * n2;
            dArray[n7] = dArray[n7] + d9 * (-dArray2[0] - dArray2[3]) / -d11;
            int n8 = 3 * n2 + 1;
            dArray[n8] = dArray[n8] + d9 * (-dArray2[1] - dArray2[4]) / -d11;
            int n9 = 3 * n2 + 2;
            dArray[n9] = dArray[n9] + d9 * (-dArray2[2] - dArray2[5]) / -d11;
        }
        return d4;
    }

    @Override
    public double getFGValue(double[] dArray) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        double d = 0.0;
        double[] dArray2 = new double[dArray.length];
        d = this.getDistTerm(dArray2);
        if (d != 0.0) {
            arrayList.add(d);
            arrayList2.add(dArray2);
            for (int iterator : this.acceptorNeighbours) {
                dArray2 = new double[dArray.length];
                d = this.getAngleTerm(dArray, iterator, this.acceptor, this.metal, Math.PI, 1.3962634015954636, 1.5707963267948966);
                arrayList.add(d);
                arrayList2.add(dArray2);
            }
        } else {
            arrayList.add(d);
        }
        double[] dArray3 = new double[dArray.length];
        double d2 = this.scale * -6.0;
        Iterator n2 = arrayList.iterator();
        while (n2.hasNext()) {
            double dArray32 = (Double)n2.next();
            d2 *= dArray32;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            int n3;
            double[] dArray4 = (double[])arrayList2.get(n);
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                if (n == n3) continue;
                double d3 = (Double)arrayList.get(n3);
                double d4 = d3 * this.scale * -6.0;
                int n4 = 0;
                while (n4 < dArray4.length) {
                    int n5 = n4++;
                    dArray4[n5] = dArray4[n5] * d4;
                }
            }
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                int n6 = n3;
                dArray3[n6] = dArray3[n6] + dArray4[n3];
            }
        }
        for (n = 0; n < dArray3.length; ++n) {
            int n7 = n;
            dArray[n7] = dArray[n7] + dArray3[n];
        }
        return d2;
    }
}

