/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring;

import com.actelion.research.calc.combinatorics.CombinationGenerator;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.KabschAlignment;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.docking.LigandPose;
import com.actelion.research.chem.docking.scoring.AbstractScoringEngine;
import com.actelion.research.chem.docking.scoring.chemscore.HBTerm;
import com.actelion.research.chem.docking.scoring.chemscore.SimpleMetalTerm;
import com.actelion.research.chem.docking.scoring.plp.PLPTerm;
import com.actelion.research.chem.docking.scoring.plp.REPTerm;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.chem.phesa.pharmacophore.ChargedGroupDetector;
import com.actelion.research.chem.phesa.pharmacophore.PharmacophoreCalculator;
import com.actelion.research.chem.phesa.pharmacophore.pp.ChargePoint;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ChemPLP
extends AbstractScoringEngine {
    private static final double METAL_INTERACTION_CUTOFF = 2.6;
    private static final double STRAIN_CUTOFF = 20.0;
    private Set<Integer> receptorAcceptors = new HashSet<Integer>();
    private Set<Integer> receptorDonorHs = new HashSet<Integer>();
    private Set<Integer> receptorDonors;
    private Set<Integer> receptorDonorHPos = new HashSet<Integer>();
    private Set<Integer> receptorAcceptorNeg = new HashSet<Integer>();
    private Set<Integer> receptorMetals = new HashSet<Integer>();
    private Set<Integer> ligandAcceptors;
    private Set<Integer> ligandDonorHs;
    private Set<Integer> ligandDonors;
    private Set<Integer> ligandDonorHPos;
    private Set<Integer> ligandAcceptorNeg;
    private List<PotentialEnergyTerm> plp;
    private List<PotentialEnergyTerm> chemscoreHbond;
    private List<PotentialEnergyTerm> chemscoreMetal;
    private ForceFieldMMFF94 ff;
    private double e0;
    private Map<Integer, List<Coordinates>> metalInteractionSites;

    public ChemPLP(Molecule3D molecule3D, Set<Integer> set, MoleculeGrid moleculeGrid) {
        super(molecule3D, set, moleculeGrid);
        this.receptorDonors = new HashSet<Integer>();
        ChemPLP.identifyHBondFunctionality(molecule3D, this.receptorAcceptors, this.receptorDonorHs, this.receptorDonors, this.receptorMetals, this.receptorAcceptorNeg, this.receptorDonorHPos);
        this.metalInteractionSites = new HashMap<Integer, List<Coordinates>>();
        for (int n : this.receptorMetals) {
            this.metalInteractionSites.put(n, ChemPLP.processMetalCoordination(this.receptorConf, n, this.receptorAcceptors));
        }
    }

    @Override
    public double getFGValue(double[] dArray) {
        double d = this.getBumpTerm();
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreHbond) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreMetal) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.plp) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        this.ff.setState(this.candidatePose.getCartState());
        double d2 = this.ff.getTotalEnergy();
        if (d2 - this.e0 > 20.0) {
            d += d2 - this.e0;
            this.ff.addGradient(dArray);
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.constraints) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        return d;
    }

    @Override
    public void updateState() {
        this.ff.setState(this.candidatePose.getCartState());
    }

    @Override
    public double getScore() {
        double[] dArray = new double[3 * this.candidatePose.getLigConf().getMolecule().getAllAtoms()];
        double d = this.getBumpTerm();
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreHbond) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreMetal) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.plp) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        return d;
    }

    @Override
    public void init(LigandPose ligandPose, double d) {
        this.e0 = d;
        this.candidatePose = ligandPose;
        this.plp = new ArrayList<PotentialEnergyTerm>();
        this.chemscoreHbond = new ArrayList<PotentialEnergyTerm>();
        this.chemscoreMetal = new ArrayList<PotentialEnergyTerm>();
        this.ligandAcceptors = new HashSet<Integer>();
        this.ligandDonorHs = new HashSet<Integer>();
        this.ligandDonors = new HashSet<Integer>();
        this.ligandDonorHPos = new HashSet<Integer>();
        this.ligandAcceptorNeg = new HashSet<Integer>();
        this.constraints = new ArrayList();
        StereoMolecule stereoMolecule = ligandPose.getLigConf().getMolecule();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dielectric constant", 80.0);
        ForceFieldMMFF94.initialize("MMFF94s+");
        this.ff = new ForceFieldMMFF94(stereoMolecule, "MMFF94s+", hashMap);
        StereoMolecule stereoMolecule2 = this.receptorConf.getMolecule();
        ChemPLP.identifyHBondFunctionality(stereoMolecule, this.ligandAcceptors, this.ligandDonorHs, this.ligandDonors, new HashSet<Integer>(), this.ligandAcceptorNeg, this.ligandDonorHPos);
        Iterator iterator = this.bindingSiteAtoms.iterator();
        while (iterator.hasNext()) {
            int[] nArray;
            int n;
            boolean bl;
            int n3 = (Integer)iterator.next();
            if (stereoMolecule2.getAtomicNo(n3) == 1) {
                if (!this.receptorDonorHs.contains(n3)) continue;
                int n4 = stereoMolecule2.getConnAtom(n3, 0);
                bl = this.receptorDonorHPos.contains(n3);
                for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                    if (!this.ligandAcceptors.contains(n)) continue;
                    int n5 = n;
                    nArray = IntStream.range(0, stereoMolecule.getConnAtoms(n5)).map(n2 -> stereoMolecule.getConnAtom(n5, n2)).toArray();
                    boolean bl2 = this.ligandAcceptorNeg.contains(n);
                    double d2 = 1.0;
                    if (bl && bl2) {
                        d2 = 2.0;
                    }
                    HBTerm hBTerm = HBTerm.create(this.receptorConf, ligandPose.getLigConf(), n, n4, n3, true, false, nArray, d2);
                    this.chemscoreHbond.add(hBTerm);
                }
                continue;
            }
            if (this.receptorDonors.contains(n3)) {
                for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                    PotentialEnergyTerm potentialEnergyTerm;
                    if (this.ligandAcceptors.contains(i)) {
                        potentialEnergyTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.HBOND_TERM);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    if (this.ligandDonors.contains(i)) {
                        potentialEnergyTerm = REPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    potentialEnergyTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.BURIED_TERM);
                    this.plp.add(potentialEnergyTerm);
                }
                continue;
            }
            if (this.receptorAcceptors.contains(n3)) {
                int[] nArray2 = IntStream.range(0, stereoMolecule2.getConnAtoms(n3)).map(n2 -> stereoMolecule2.getConnAtom(n3, n2)).toArray();
                bl = this.receptorAcceptorNeg.contains(n3);
                for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
                    if (stereoMolecule.getAtomicNo(n) == 1) {
                        if (!this.ligandDonorHs.contains(n)) continue;
                        boolean bl3 = this.ligandDonorHPos.contains(n);
                        int n6 = stereoMolecule.getConnAtom(n, 0);
                        double d3 = 1.0;
                        if (bl && bl3) {
                            d3 = 2.0;
                        }
                        HBTerm hBTerm = HBTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, n6, n, false, true, nArray2, d3);
                        this.chemscoreHbond.add(hBTerm);
                        continue;
                    }
                    if (this.ligandDonors.contains(n)) {
                        PLPTerm pLPTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, n, PLPTerm.HBOND_TERM);
                        this.plp.add(pLPTerm);
                        continue;
                    }
                    if (this.ligandAcceptors.contains(n)) {
                        REPTerm rEPTerm = REPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, n);
                        this.plp.add(rEPTerm);
                        continue;
                    }
                    PLPTerm pLPTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, n, PLPTerm.BURIED_TERM);
                    this.plp.add(pLPTerm);
                }
                continue;
            }
            if (this.receptorMetals.contains(n3)) {
                for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                    PotentialEnergyTerm potentialEnergyTerm;
                    if (this.ligandDonors.contains(i)) {
                        potentialEnergyTerm = REPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    if (this.ligandAcceptors.contains(i)) {
                        potentialEnergyTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.METAL_TERM);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    potentialEnergyTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.BURIED_TERM);
                    this.plp.add(potentialEnergyTerm);
                }
                for (int n7 : this.ligandAcceptors) {
                    double d4 = 1.0;
                    if (this.ligandAcceptorNeg.contains(n7)) {
                        d4 = 2.0;
                    }
                    nArray = IntStream.range(0, stereoMolecule.getConnAtoms(n7)).map(n2 -> stereoMolecule.getConnAtom(n7, n2)).toArray();
                    SimpleMetalTerm simpleMetalTerm = SimpleMetalTerm.create(this.receptorConf, ligandPose.getLigConf(), n7, n3, nArray, d4);
                    this.chemscoreMetal.add(simpleMetalTerm);
                }
                continue;
            }
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                PLPTerm pLPTerm;
                if (this.ligandDonors.contains(i)) {
                    pLPTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.BURIED_TERM);
                    this.plp.add(pLPTerm);
                    continue;
                }
                if (this.ligandAcceptors.contains(i)) {
                    pLPTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.BURIED_TERM);
                    this.plp.add(pLPTerm);
                    continue;
                }
                pLPTerm = PLPTerm.create(this.receptorConf, ligandPose.getLigConf(), n3, i, PLPTerm.NONPOLAR_TERM);
                this.plp.add(pLPTerm);
            }
        }
    }

    private static List<Coordinates> processMetalCoordination(Conformer conformer, int n, Set<Integer> set) {
        Object object;
        Object object2;
        ArrayList<Coordinates> arrayList = new ArrayList<Coordinates>();
        Coordinates coordinates = conformer.getCoordinates(n);
        ArrayList<Coordinates> arrayList2 = new ArrayList<Coordinates>();
        Coordinates[] coordinatesArray = set.iterator();
        while (coordinatesArray.hasNext()) {
            int n2 = coordinatesArray.next();
            Coordinates coordinates2 = conformer.getCoordinates(n2);
            if (!(coordinates2.distance(coordinates) < 2.6)) continue;
            arrayList2.add(coordinates2);
        }
        coordinatesArray = arrayList2.toArray(new Coordinates[arrayList2.size()]);
        double d = Double.MAX_VALUE;
        Object object3 = null;
        int[][] nArray2 = null;
        if (coordinatesArray.length < 4) {
            object2 = ChemPLP.getTetrahedron();
            object = new int[coordinatesArray.length][2];
            d = ChemPLP.getBestMetalFit((Coordinates[])object2, coordinatesArray, (int[][])object);
            object3 = object2;
            nArray2 = object;
        } else if (coordinatesArray.length < 6 && ChemPLP.getBestMetalFit((Coordinates[])(object2 = ChemPLP.getOctahedron()), coordinatesArray, (int[][])(object = new int[coordinatesArray.length][2])) < d) {
            object3 = object2;
            nArray2 = object;
        }
        if (object3 != null) {
            object2 = new KabschAlignment(coordinatesArray, (Coordinates[])object3, nArray2);
            ((KabschAlignment)object2).align();
            object = Arrays.stream(nArray2).map(nArray -> nArray[1]).collect(Collectors.toList());
            for (int i = 0; i < ((Coordinates[])object3).length; ++i) {
                if (object.contains(i)) continue;
                arrayList.add(object3[i]);
            }
        }
        return arrayList;
    }

    private static double getBestMetalFit(Coordinates[] coordinatesArray, Coordinates[] coordinatesArray2, int[][] nArray) {
        double d = Double.MAX_VALUE;
        if (coordinatesArray2.length < 4) {
            List<int[]> list = ChemPLP.enumerateMetalPosAssignments(4, coordinatesArray2.length);
            for (int[] nArray2 : list) {
                Object object;
                int[][] nArray3 = new int[coordinatesArray2.length][2];
                int n = 0;
                for (int i = 0; i < coordinatesArray2.length; ++i) {
                    object = new int[]{n, nArray2[n]};
                    nArray3[i] = object;
                    ++n;
                }
                Coordinates[] coordinatesArray3 = (Coordinates[])Arrays.stream(coordinatesArray).map(coordinates -> new Coordinates((Coordinates)coordinates)).toArray(Coordinates[]::new);
                object = new KabschAlignment(coordinatesArray2, coordinatesArray3, nArray3);
                ((KabschAlignment)object).align();
                double d2 = ChemPLP.getRMSD(coordinatesArray2, coordinatesArray3, nArray3);
                if (!(d2 < d)) continue;
                d = d2;
                nArray = nArray3;
            }
        }
        return d;
    }

    private static double getRMSD(Coordinates[] coordinatesArray, Coordinates[] coordinatesArray2, int[][] nArray) {
        double d = 0.0;
        for (int[] nArray2 : nArray) {
            Coordinates coordinates = coordinatesArray[nArray2[0]];
            Coordinates coordinates2 = coordinatesArray2[nArray2[1]];
            double d2 = coordinates.x - coordinates2.x;
            double d3 = coordinates.y - coordinates2.y;
            double d4 = coordinates.z - coordinates2.z;
            d += d2 * d2 + d3 * d3 + d4 * d4;
        }
        return Math.sqrt(d /= (double)nArray.length);
    }

    private static List<int[]> enumerateMetalPosAssignments(int n2, int n3) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (n3 != 0) {
            if (n3 == 1) {
                int[] nArray = new int[]{0, 0};
                arrayList.add(nArray);
            } else {
                List<int[]> list = CombinationGenerator.getAllOutOf(n2 - 1, n3 - 1);
                for (int[] nArray : list) {
                    List<int[]> list2 = CombinationGenerator.getPermutations(nArray, nArray.length);
                    for (int[] nArray2 : list2) {
                        int[] nArray3 = new int[nArray2.length + 1];
                        nArray3[0] = 0;
                        IntStream.range(0, nArray2.length).forEach(n -> {
                            nArray[n + 1] = nArray2[n] + 1;
                        });
                        arrayList.add(nArray3);
                    }
                }
            }
        }
        return arrayList;
    }

    public static void identifyHBondFunctionality(StereoMolecule stereoMolecule, Set<Integer> set, Set<Integer> set2, Set<Integer> set3, Set<Integer> set4, Set<Integer> set5, Set<Integer> set6) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) == 7 || stereoMolecule.getAtomicNo(i) == 8) {
                if (!PharmacophoreCalculator.isAcceptor(stereoMolecule, i)) continue;
                set.add(i);
                continue;
            }
            if (PharmacophoreCalculator.isDonorHydrogen(stereoMolecule, i)) {
                set2.add(i);
                set3.add(stereoMolecule.getConnAtom(i, 0));
                continue;
            }
            if (!stereoMolecule.isMetalAtom(i)) continue;
            set4.add(i);
        }
        ChargedGroupDetector chargedGroupDetector = new ChargedGroupDetector(stereoMolecule);
        ArrayList<ChargePoint> arrayList = chargedGroupDetector.detect();
        ChemPLP.getChargedDonorsAcceptors(stereoMolecule, arrayList, set, set2, set5, set6);
    }

    private static void getChargedDonorsAcceptors(StereoMolecule stereoMolecule, List<ChargePoint> list, Set<Integer> set, Set<Integer> set2, Set<Integer> set3, Set<Integer> set4) {
        for (int n : set) {
            if (!ChemPLP.isPartOfChargedGroup(stereoMolecule, n, list)) continue;
            set3.add(n);
        }
        for (int n : set2) {
            int n2 = stereoMolecule.getConnAtom(n, 0);
            if (!ChemPLP.isPartOfChargedGroup(stereoMolecule, n2, list)) continue;
            set4.add(n);
        }
    }

    private static boolean isPartOfChargedGroup(StereoMolecule stereoMolecule, int n, List<ChargePoint> list) {
        boolean bl = false;
        for (ChargePoint chargePoint : list) {
            if (chargePoint.getChargeAtom() == n) {
                bl = true;
                break;
            }
            int n2 = chargePoint.getChargeAtom();
            for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
                if (n2 != stereoMolecule.getConnAtom(n, i)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private static Coordinates[] getTetrahedron() {
        return new Coordinates[]{new Coordinates(2.074, 0.0, -0.733), new Coordinates(-1.037, 1.796, -0.733), new Coordinates(-1.037, -1.796, -0.733), new Coordinates(0.0, 0.0, 2.2)};
    }

    private static Coordinates[] getOctahedron() {
        return new Coordinates[]{new Coordinates(0.0, 0.0, 2.2), new Coordinates(0.0, 0.0, -2.2), new Coordinates(1.555, 1.555, 0.0), new Coordinates(1.555, -1.555, 0.0), new Coordinates(-1.555, 1.555, 0.0), new Coordinates(-1.555, -1.555, 0.0)};
    }

    @Override
    public Map<String, Double> getContributions() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double[] dArray = new double[3 * this.candidatePose.getLigConf().getMolecule().getAllAtoms()];
        double d = 0.0;
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreHbond) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        hashMap.put("HBOND", d);
        double d2 = 0.0;
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreMetal) {
            d2 += potentialEnergyTerm.getFGValue(dArray);
        }
        hashMap.put("METAL", d2);
        double d3 = 0.0;
        for (PotentialEnergyTerm potentialEnergyTerm : this.plp) {
            d3 += potentialEnergyTerm.getFGValue(dArray);
        }
        hashMap.put("PLP", d3);
        double d4 = 0.0;
        this.ff.setState(this.candidatePose.getCartState());
        double d5 = this.ff.getTotalEnergy();
        if (d5 - this.e0 > 20.0) {
            d4 += d5;
            this.ff.addGradient(dArray);
        }
        hashMap.put("STRAIN", d4);
        return hashMap;
    }
}

