/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.receptorpharmacophore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.docking.receptorpharmacophore.NegativeReceptorImage;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.ShapeVolume;

public class NegativeReceptorImageCreator {
    public static ShapeVolume create(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, TransformationSequence transformationSequence) {
        Molecule3D molecule3D = new Molecule3D(stereoMolecule);
        molecule3D.ensureHelperArrays(31);
        Molecule3D molecule3D2 = new Molecule3D(stereoMolecule2);
        molecule3D2.ensureHelperArrays(31);
        MolecularVolume molecularVolume = new MolecularVolume(molecule3D);
        Coordinates coordinates = new Coordinates(molecularVolume.getCOM());
        Conformer conformer = new Conformer(molecule3D);
        Rotation rotation = molecularVolume.preProcess(conformer);
        NegativeReceptorImageCreator.rotateMols(molecule3D2, molecule3D, rotation, coordinates);
        NegativeReceptorImage negativeReceptorImage = new NegativeReceptorImage(molecule3D, molecule3D2, 0.4, new Coordinates(4.0, 4.0, 4.0));
        ShapeVolume shapeVolume = negativeReceptorImage.calculate();
        Rotation rotation2 = rotation.getInvert();
        Translation translation = new Translation(new double[]{coordinates.x, coordinates.y, coordinates.z});
        transformationSequence.addTransformation(rotation2);
        transformationSequence.addTransformation(translation);
        return shapeVolume;
    }

    private static void rotateMols(Molecule3D molecule3D, Molecule3D molecule3D2, Rotation rotation, Coordinates coordinates) {
        Coordinates coordinates2;
        int n;
        for (n = 0; n < molecule3D2.getAllAtoms(); ++n) {
            coordinates2 = molecule3D2.getCoordinates(n);
            coordinates2.sub(coordinates);
            rotation.apply(coordinates2);
        }
        for (n = 0; n < molecule3D.getAllAtoms(); ++n) {
            coordinates2 = molecule3D.getCoordinates(n);
            coordinates2.sub(coordinates);
            rotation.apply(coordinates2);
        }
    }
}

