/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.receptorpharmacophore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.docking.DockingUtils;
import com.actelion.research.chem.docking.scoring.ProbeScanning;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.chem.phesa.AtomicGaussian;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.ShapeVolume;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import com.actelion.research.chem.phesa.pharmacophore.pp.SimplePharmacophorePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import smile.clustering.KMeans;

public class NegativeReceptorImage
extends MoleculeGrid {
    private static final long SEED = 12345L;
    private static final int STARTING_POINTS_CAVITY_DETECTION = 10;
    private static final int RAYS = 120;
    private static final double RAY_LENGTH = 8.0;
    private static final double BURIEDNESS_RATIO_CUTOFF = 0.4;
    private static final int BUMP_RADIUS = 3;
    private static final double BUMP_RADIUS2 = 2.0;
    private static final double INTERACTION_CUTOFF = 0.0;
    private static final double INTERACTION_CUTOFF_CHARGE = -1.0;
    private static final double NONPOLAR_RADIUS = 2.5;
    private static final double GAUSSIAN_DISTANCE = 1.3;
    private static final int MAX_NR_INTERACTION_POINTS = 8;
    private static double MIN_INTERACTION_POINT_DIST = 1.5;
    private boolean[][][] bumpGrid;
    private Set<Integer> receptorAtoms;
    private StereoMolecule receptor;
    private Map<Integer, Map<Integer, List<Coordinates>>> receptorInteractionSites;
    private ProbeScanning probeScanning;
    private MoleculeGrid receptorGrid;

    public NegativeReceptorImage(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this(stereoMolecule, stereoMolecule2, 0.4, new Coordinates(5.0, 5.0, 5.0));
    }

    public NegativeReceptorImage(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, double d, Coordinates coordinates) {
        super(stereoMolecule, d, coordinates);
        this.receptorGrid = new MoleculeGrid(stereoMolecule2, d, new Coordinates(0.0, 0.0, 0.0));
        this.receptor = stereoMolecule2;
        this.receptorAtoms = new HashSet<Integer>();
        this.receptorInteractionSites = new HashMap<Integer, Map<Integer, List<Coordinates>>>();
        int[] nArray = this.receptorGrid.getGridSize();
        this.bumpGrid = new boolean[nArray[0]][nArray[1]][nArray[2]];
        for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
            int[] nArray2 = this.getGridCoordinates(stereoMolecule2.getCoordinates(i));
            int n = nArray2[0];
            int n2 = nArray2[1];
            int n3 = nArray2[2];
            if (n <= 0 || n >= this.grid.length || n2 <= 0 || n2 >= this.grid[0].length || n3 <= 0 || n3 >= this.grid[0][0].length) continue;
            this.receptorAtoms.add(i);
        }
        this.probeScanning = new ProbeScanning(stereoMolecule2, this.receptorAtoms, this);
    }

    public ShapeVolume calculate() {
        int n;
        ArrayList<PPGaussian> arrayList = new ArrayList<PPGaussian>();
        ArrayList<AtomicGaussian> arrayList2 = new ArrayList<AtomicGaussian>();
        this.analyzeBindingSiteAtoms();
        ShapeVolume shapeVolume = new ShapeVolume();
        this.analyzeBumps();
        this.createPolarInteractionSites(arrayList);
        this.createShapeAtoms(arrayList2);
        ArrayList<Coordinates> arrayList3 = new ArrayList<Coordinates>();
        for (n = 0; n < this.mol.getAtoms() && n < 10; ++n) {
            arrayList3.add(this.mol.getCoordinates(n));
        }
        this.prunePoints(arrayList3, arrayList, arrayList2, 2.0);
        for (n = 0; n < arrayList.size(); ++n) {
            ((PPGaussian)arrayList.get(n)).setAtomId(n);
        }
        shapeVolume.setAtomicGaussians(arrayList2);
        shapeVolume.setPPGaussians(arrayList);
        return shapeVolume;
    }

    private void createPolarInteractionSites(List<PPGaussian> list) {
        for (int n : this.receptorInteractionSites.keySet()) {
            for (int n2 : this.receptorInteractionSites.get(n).keySet()) {
                for (Coordinates coordinates : this.receptorInteractionSites.get(n).get(n2)) {
                    double[][] dArray;
                    IPharmacophorePoint.Functionality functionality = null;
                    double d = 0.0;
                    int n3 = 1;
                    switch (n2) {
                        case 2: {
                            functionality = IPharmacophorePoint.Functionality.POS_CHARGE;
                            d = -1.0;
                            n3 = 2;
                            break;
                        }
                        case 3: {
                            functionality = IPharmacophorePoint.Functionality.NEG_CHARGE;
                            d = -1.0;
                            n3 = 2;
                            break;
                        }
                        case 0: {
                            functionality = IPharmacophorePoint.Functionality.DONOR;
                            break;
                        }
                        case 1: {
                            functionality = IPharmacophorePoint.Functionality.ACCEPTOR;
                            break;
                        }
                        default: {
                            functionality = null;
                        }
                    }
                    if (functionality == null || (dArray = this.scanProbe(coordinates, functionality, n, d, n3)) == null) continue;
                    for (double[] dArray2 : dArray) {
                        SimplePharmacophorePoint simplePharmacophorePoint = new SimplePharmacophorePoint(-1, new Coordinates(dArray2[0], dArray2[1], dArray2[2]), functionality);
                        PPGaussian pPGaussian = new PPGaussian(6, simplePharmacophorePoint);
                        list.add(pPGaussian);
                    }
                }
            }
        }
    }

    private void createShapeAtoms(List<AtomicGaussian> list) {
        int n;
        ArrayList<AtomicGaussian> arrayList = new ArrayList<AtomicGaussian>();
        double d = 6.25;
        double d2 = 1.6900000000000002;
        for (int i = n = (int)(2.5 / this.gridWidth); i < this.gridSize[0]; ++i) {
            for (int j = n; j < this.gridSize[1]; ++j) {
                for (int k = n; k < this.gridSize[2]; ++k) {
                    AtomicGaussian atomicGaussian22;
                    boolean bl = false;
                    Coordinates coordinates = this.getCartCoordinates(new int[]{i, j, k});
                    for (AtomicGaussian atomicGaussian22 : arrayList) {
                        double d3;
                        double d4 = atomicGaussian22.getCenter().x - coordinates.x;
                        double d5 = atomicGaussian22.getCenter().y - coordinates.y;
                        double d6 = atomicGaussian22.getCenter().z - coordinates.z;
                        double d7 = d4 * d4 + d5 * d5 + d6 * d6;
                        if (d7 > d2 || !((d3 = Math.sqrt(d7)) < 1.3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        Iterator<Object> iterator = this.receptorAtoms.iterator();
                        while (iterator.hasNext()) {
                            double d8;
                            int n2 = (Integer)iterator.next();
                            Coordinates coordinates2 = this.receptor.getCoordinates(n2);
                            double d9 = coordinates2.x - coordinates.x;
                            double d10 = coordinates2.y - coordinates.y;
                            double d11 = coordinates2.z - coordinates.z;
                            double d12 = d9 * d9 + d10 * d10 + d11 * d11;
                            if (d12 > d || !((d8 = Math.sqrt(d12)) < 2.5)) continue;
                            bl = true;
                            break;
                        }
                    }
                    boolean bl2 = this.getBuriedness(new int[]{i, j, k});
                    if (bl || !bl2) continue;
                    atomicGaussian22 = new AtomicGaussian(-1, 6, coordinates);
                    arrayList.add(atomicGaussian22);
                }
            }
        }
        arrayList.stream().forEach(atomicGaussian -> list.add((AtomicGaussian)atomicGaussian));
    }

    private double[][] scanProbe(Coordinates coordinates, IPharmacophorePoint.Functionality functionality, int n2, double d, int n3) {
        Object object;
        boolean bl;
        int n4;
        int n5;
        ProbeScanning.Probe probe = new ProbeScanning.Probe(new Coordinates(), functionality);
        this.probeScanning.init(probe);
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n6 = n3;
        int[] nArray = this.getGridCoordinates(coordinates);
        int n7 = (int)(3.0 / this.gridWidth);
        for (int i = -n6; i < n6 + 1; ++i) {
            for (int j = -n6; j < n6 + 1; ++j) {
                for (int k = -n6; k < n6 + 1; ++k) {
                    int n8 = nArray[0] + i * n3;
                    n5 = nArray[1] + j * n3;
                    n4 = nArray[2] + k * n3;
                    if (n8 < n7 || n8 > this.gridSize[0] - n7 || n5 < n7 || n5 > this.gridSize[1] - n7 || n4 < n7 || n4 > this.gridSize[2] - n7 || !(bl = this.getBuriedness(new int[]{n8, n5, n4}))) continue;
                    Coordinates coordinates2 = this.getCartCoordinates(new int[]{n8, n5, n4});
                    probe.updateCoordinates(coordinates2);
                    double d2 = this.probeScanning.getScore();
                    if (!(d2 < d)) continue;
                    arrayList.add(new double[]{coordinates2.x, coordinates2.y, coordinates2.z});
                    arrayList2.add(d2);
                }
            }
        }
        if (arrayList.size() == 0) {
            object = null;
        } else {
            double[][] dArray = new double[arrayList.size()][3];
            IntStream.range(0, arrayList.size()).forEach(n -> {
                dArray[n] = (double[])arrayList.get(n);
            });
            double d3 = MIN_INTERACTION_POINT_DIST * MIN_INTERACTION_POINT_DIST;
            n4 = n5 = Math.min(dArray.length, 8);
            if (n5 == 1) {
                object = new double[][]{{dArray[0][0], dArray[0][1], dArray[0][2]}};
            } else {
                bl = false;
                for (int i = 2; i < n5 + 1 && !bl; ++i) {
                    KMeans kMeans = new KMeans(dArray, i);
                    double[][] dArray2 = kMeans.centroids();
                    for (int j = 0; j < dArray2.length && !bl; ++j) {
                        double[] dArray3 = dArray2[j];
                        for (int k = j + 1; k < dArray2.length && !bl; ++k) {
                            double[] dArray4 = dArray2[k];
                            double d4 = dArray3[0] - dArray4[0];
                            double d5 = dArray3[1] - dArray4[1];
                            double d6 = dArray3[2] - dArray4[2];
                            double d7 = d4 * d4 + d5 * d5 + d6 * d6;
                            if (!(d7 > 0.001) || !(d7 < d3)) continue;
                            n4 = i - 1;
                            bl = true;
                        }
                    }
                }
                if (n4 == 1) {
                    double[] dArray5 = new double[]{0.0, 0.0, 0.0};
                    int n9 = 0;
                    for (double[] dArray4 : dArray) {
                        dArray5[0] = dArray5[0] + dArray4[0];
                        dArray5[1] = dArray5[1] + dArray4[1];
                        dArray5[2] = dArray5[2] + dArray4[2];
                        ++n9;
                    }
                    dArray5[0] = dArray5[0] / (double)n9;
                    dArray5[1] = dArray5[1] / (double)n9;
                    dArray5[2] = dArray5[2] / (double)n9;
                    object = new double[][]{dArray5};
                } else {
                    KMeans kMeans = new KMeans(dArray, n4);
                    object = kMeans.centroids();
                }
            }
        }
        return object;
    }

    private void analyzeBumps() {
        double d = 4.0;
        int n = Math.min(this.gridSize[0], this.bumpGrid.length);
        int n2 = Math.min(this.gridSize[1], this.bumpGrid[0].length);
        int n3 = Math.min(this.gridSize[2], this.bumpGrid[0][0].length);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                block2: for (int k = 0; k < n3; ++k) {
                    Coordinates coordinates = this.getCartCoordinates(new int[]{i, j, k});
                    for (int i2 = 0; i2 < this.receptor.getAtoms(); ++i2) {
                        double d2;
                        Coordinates coordinates2 = this.receptor.getCoordinates(i2);
                        double d3 = coordinates2.x - coordinates.x;
                        double d4 = coordinates2.y - coordinates.y;
                        double d5 = coordinates2.z - coordinates.z;
                        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
                        if (d6 > d || !((d2 = Math.sqrt(d6)) < 2.0)) continue;
                        this.bumpGrid[i][j][k] = true;
                        continue block2;
                    }
                }
            }
        }
    }

    public boolean getBuriedness(int[] nArray) {
        int n;
        Random random = new Random(12345L);
        int n2 = (int)(8.0 / this.gridWidth);
        int n3 = 0;
        Coordinates coordinates = this.getCartCoordinates(nArray);
        block2: for (int i = 0; i < 120; ++i) {
            Coordinates coordinates2 = DockingUtils.randomVectorInSphere(random).scale(this.gridWidth);
            for (n = 1; n < n2 + 1; ++n) {
                Coordinates coordinates3 = coordinates.addC(coordinates2.scaleC(n));
                int[] nArray2 = this.getGridCoordinates(coordinates3);
                try {
                    boolean bl = this.bumpGrid[nArray2[0]][nArray2[1]][nArray2[2]];
                    if (!bl) continue;
                    ++n3;
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        double d = (double)n3 / 120.0;
        n = d > 0.4 ? 1 : 0;
        return n != 0;
    }

    private void analyzeBindingSiteAtoms() {
        MolecularVolume molecularVolume = new MolecularVolume(this.receptor);
        for (PPGaussian pPGaussian : molecularVolume.getPPGaussians()) {
            int n = pPGaussian.getAtomId();
            IPharmacophorePoint iPharmacophorePoint = pPGaussian.getPharmacophorePoint();
            int n2 = iPharmacophorePoint.getFunctionalityIndex();
            this.receptorInteractionSites.putIfAbsent(n, new HashMap());
            Map<Integer, List<Coordinates>> map = this.receptorInteractionSites.get(n);
            map.putIfAbsent(n2, new ArrayList());
            List<Coordinates> list = map.get(n2);
            if (pPGaussian.getPharmacophorePoint().getFunctionalityIndex() == IPharmacophorePoint.Functionality.ACCEPTOR.getIndex()) {
                Coordinates coordinates;
                if (this.receptor.getConnAtoms(n) == 1 && this.receptor.getBondOrder(this.receptor.getBond(n, this.receptor.getConnAtom(n, 0))) == 2 && list.size() == 0) {
                    coordinates = this.receptor.getCoordinates(n).subC(this.receptor.getCoordinates(this.receptor.getConnAtom(n, 0))).unitC();
                    Coordinates coordinates2 = this.receptor.getCoordinates(n).addC(coordinates.scaleC(2.8));
                    list.add(coordinates2);
                }
                coordinates = this.receptor.getCoordinates(n).addC(iPharmacophorePoint.getDirectionality().scaleC(2.8));
                list.add(coordinates);
                continue;
            }
            if (pPGaussian.getPharmacophorePoint().getFunctionalityIndex() == IPharmacophorePoint.Functionality.NEG_CHARGE.getIndex()) {
                if (this.receptor.getConnAtoms(n) == 1) {
                    Coordinates coordinates = this.receptor.getCoordinates(n).subC(this.receptor.getCoordinates(this.receptor.getConnAtom(n, 0))).unitC();
                    Coordinates coordinates3 = this.receptor.getCoordinates(n).addC(coordinates.scaleC(2.8));
                    list.add(coordinates3);
                    continue;
                }
                if (this.receptor.getConnAtoms(n) != 3) continue;
                int n3 = -1;
                for (int i = 0; i < this.receptor.getConnAtoms(n); ++i) {
                    if (this.receptor.getAtomicNo(this.receptor.getConnAtom(n, i)) != 6) continue;
                    n3 = this.receptor.getConnAtom(n, i);
                    break;
                }
                if (n3 == -1) continue;
                Coordinates coordinates = this.receptor.getCoordinates(n).subC(this.receptor.getCoordinates(n3)).unitC();
                Coordinates coordinates4 = this.receptor.getCoordinates(n).addC(coordinates.scaleC(4.0));
                list.add(coordinates4);
                continue;
            }
            if (pPGaussian.getPharmacophorePoint().getFunctionalityIndex() == IPharmacophorePoint.Functionality.POS_CHARGE.getIndex()) {
                if (this.receptor.getConnAtoms(n) == 1) {
                    Coordinates coordinates = this.receptor.getCoordinates(n).subC(this.receptor.getCoordinates(this.receptor.getConnAtom(n, 0))).unitC();
                    Coordinates coordinates5 = this.receptor.getCoordinates(n).addC(coordinates.scaleC(4.0));
                    list.add(coordinates5);
                    continue;
                }
                if (this.receptor.getConnAtoms(n) != 3) continue;
                int n4 = -1;
                for (int i = 0; i < this.receptor.getConnAtoms(n); ++i) {
                    int n5 = this.receptor.getConnAtom(n, i);
                    if (this.receptor.getConnAtoms(n5) != 2) continue;
                    n4 = n5;
                }
                if (n4 == -1) continue;
                Coordinates coordinates = this.receptor.getCoordinates(n).subC(this.receptor.getCoordinates(n4)).unitC();
                Coordinates coordinates6 = this.receptor.getCoordinates(n).addC(coordinates.scaleC(4.0));
                list.add(coordinates6);
                continue;
            }
            if (pPGaussian.getPharmacophorePoint().getFunctionalityIndex() != IPharmacophorePoint.Functionality.DONOR.getIndex()) continue;
            Coordinates coordinates = this.receptor.getCoordinates(n).addC(iPharmacophorePoint.getDirectionality().scaleC(1.7999999999999998));
            list.add(coordinates);
        }
    }

    private void prunePoints(List<Coordinates> list, List<PPGaussian> list2, List<AtomicGaussian> list3, double d) {
        Object object;
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList();
        HashSet hashSet2 = new HashSet();
        Set<Gaussian3D> set = new HashSet<Gaussian3D>();
        for (Coordinates arrayList2 : list) {
            set.addAll(this.getNeighbourPoints(arrayList2, list2, list3, d));
        }
        linkedList.addAll(set);
        hashSet.addAll(set);
        while (!linkedList.isEmpty()) {
            object = (Gaussian3D)linkedList.poll();
            if (hashSet2.contains(object)) continue;
            hashSet2.add(object);
            set = this.getNeighbourPoints(((Gaussian3D)object).getCenter(), list2, list3, d);
            linkedList.addAll(set);
            hashSet.addAll(set);
        }
        object = new ArrayList<PPGaussian>();
        for (PPGaussian pPGaussian : list2) {
            if (hashSet.contains(pPGaussian)) continue;
            object.add(pPGaussian);
        }
        list2.removeAll((Collection<?>)object);
        ArrayList<AtomicGaussian> arrayList = new ArrayList<AtomicGaussian>();
        for (AtomicGaussian atomicGaussian : list3) {
            if (hashSet.contains(atomicGaussian)) continue;
            arrayList.add(atomicGaussian);
        }
        list3.removeAll(arrayList);
    }

    private Set<Gaussian3D> getNeighbourPoints(Coordinates coordinates, List<PPGaussian> list, List<AtomicGaussian> list2, double d) {
        double d2 = d * d;
        HashSet<Gaussian3D> hashSet = new HashSet<Gaussian3D>();
        HashSet<Gaussian3D> hashSet2 = new HashSet<Gaussian3D>();
        hashSet2.addAll(list2);
        hashSet2.addAll(list);
        for (Gaussian3D gaussian3D : hashSet2) {
            double d3 = gaussian3D.getCenter().distSquareTo(coordinates);
            if (d3 > d2) continue;
            hashSet.add(gaussian3D);
        }
        return hashSet;
    }

    public static enum InteractionProbe {
        NEG_CHARGE,
        POS_CHARGE,
        HB_DONOR,
        HB_ACCEPTOR;

    }
}

