/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.generator;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.histogram.MatrixBasedHistogram;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.descriptor.flexophore.redgraph.SubGraphIndices;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.datamodel.DoubleArray;
import java.util.ArrayList;
import java.util.List;

public class MultCoordFragIndex {
    private int[] arrIndexFrag;
    private List<Coordinates> liCoord;

    public MultCoordFragIndex(int[] nArray) {
        this.arrIndexFrag = nArray;
        this.liCoord = new ArrayList<Coordinates>();
    }

    public MultCoordFragIndex getDeepClone() {
        int[] nArray = new int[this.arrIndexFrag.length];
        System.arraycopy(this.arrIndexFrag, 0, nArray, 0, nArray.length);
        MultCoordFragIndex multCoordFragIndex = new MultCoordFragIndex(nArray);
        for (Coordinates coordinates : this.liCoord) {
            multCoordFragIndex.liCoord.add(new Coordinates(coordinates));
        }
        return multCoordFragIndex;
    }

    public boolean isEqualIndices(SubGraphIndices subGraphIndices) {
        return subGraphIndices.equalIndices(this.arrIndexFrag);
    }

    public void addCoord(Coordinates coordinates) {
        this.liCoord.add(coordinates);
    }

    public List<Coordinates> getCoordinates() {
        return this.liCoord;
    }

    public int[] getArrIndexFrag() {
        return this.arrIndexFrag;
    }

    public static byte[] getDistHist(MultCoordFragIndex multCoordFragIndex, MultCoordFragIndex multCoordFragIndex2) {
        int n;
        int n2 = multCoordFragIndex.liCoord.size();
        if (n2 != (n = multCoordFragIndex2.liCoord.size())) {
            throw new RuntimeException("Number of distances differ for two fragments sets!");
        }
        DoubleArray doubleArray = new DoubleArray(n2);
        for (int i = 0; i < n2; ++i) {
            double d = multCoordFragIndex.liCoord.get(i).distance(multCoordFragIndex2.liCoord.get(i));
            if (d > 40.0) {
                throw new RuntimeException("Distance " + Formatter.format1(d) + " between two pharmacophore points exceeded maximum histogram range.");
            }
            doubleArray.add(d);
        }
        Matrix matrix = MatrixBasedHistogram.getHistogramBins(0.0, 40.0, 80);
        Matrix matrix2 = MatrixBasedHistogram.getHistogram(doubleArray.get(), matrix);
        double[] dArray = matrix2.getRow(2);
        int n3 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n3 = (int)((double)n3 + dArray[i]);
        }
        byte[] byArray = new byte[matrix2.getColDim()];
        for (int i = 0; i < dArray.length; ++i) {
            byArray[i] = (byte)(dArray[i] / (double)n3 * 100.0 + 0.5);
        }
        return byArray;
    }
}

