/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.example;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandlerFlexophore;
import com.actelion.research.chem.descriptor.flexophore.IMolDistHist;
import com.actelion.research.chem.descriptor.flexophore.ModelSolutionSimilarity;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import com.actelion.research.chem.descriptor.flexophore.completegraphmatcher.ObjectiveBlurFlexophoreHardMatchUncovered;
import com.actelion.research.util.ArrayUtils;
import com.actelion.research.util.Formatter;
import java.util.ArrayList;

public class MatchFlexophoreNodesMain {
    public static final String IDCODE_100 = "ffchb@DXXJWb`dLbbRbrrTTRRMNRUGL@QSPPQQ@@@";
    public static final String IDCODE_101 = "fi{iA@IJcdn`Xa@cHhhdmDeDdmDjfBM[MXHHZj`bJp@@@";

    public static void main(String[] stringArray) {
        String string = IDCODE_100;
        String string2 = IDCODE_101;
        MatchFlexophoreNodesMain.pairMatch(string, string2);
    }

    public static void pairMatch(String string, String string2) {
        Object object;
        Object object2;
        DescriptorHandlerFlexophore descriptorHandlerFlexophore = new DescriptorHandlerFlexophore();
        ObjectiveBlurFlexophoreHardMatchUncovered objectiveBlurFlexophoreHardMatchUncovered = descriptorHandlerFlexophore.getObjectiveCompleteGraph();
        IDCodeParser iDCodeParser = new IDCodeParser();
        MolDistHistViz molDistHistViz = MatchFlexophoreNodesMain.create(iDCodeParser, descriptorHandlerFlexophore, string);
        System.out.println("Num pp nodes base " + molDistHistViz.getNumPPNodes());
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < molDistHistViz.getNumPPNodes(); ++i) {
            object2 = molDistHistViz.getNode(i).getArrayIndexOriginalAtoms();
            arrayList.add((int[])object2);
        }
        MolDistHistViz molDistHistViz2 = MatchFlexophoreNodesMain.create(iDCodeParser, descriptorHandlerFlexophore, string2);
        System.out.println("Num pp nodes query " + molDistHistViz2.getNumPPNodes());
        object2 = new ArrayList();
        for (int i = 0; i < molDistHistViz2.getNumPPNodes(); ++i) {
            object = molDistHistViz2.getNode(i).getArrayIndexOriginalAtoms();
            object2.add(object);
        }
        System.out.println(molDistHistViz.toString());
        System.out.println(molDistHistViz2.toString());
        MolDistHist molDistHist = molDistHistViz.getMolDistHist();
        object = molDistHistViz2.getMolDistHist();
        ModelSolutionSimilarity modelSolutionSimilarity = descriptorHandlerFlexophore.getBestMatch(molDistHist, (MolDistHist)object);
        int n = modelSolutionSimilarity.getSizeHeap();
        objectiveBlurFlexophoreHardMatchUncovered.setBase(molDistHist);
        objectiveBlurFlexophoreHardMatchUncovered.setQuery((IMolDistHist)object);
        for (int i = 0; i < n; ++i) {
            byte by = modelSolutionSimilarity.getIndexQueryFromHeap(i);
            byte by2 = modelSolutionSimilarity.getIndexBaseFromHeap(i);
            PPNodeViz pPNodeViz = molDistHistViz.getNode(by2);
            int[] nArray = (int[])arrayList.get(by2);
            PPNodeViz pPNodeViz2 = molDistHistViz2.getNode(by);
            int[] nArray2 = (int[])object2.get(by);
            System.out.println(pPNodeViz.toString());
            System.out.println(ArrayUtils.toString(nArray));
            System.out.println(pPNodeViz2.toString());
            System.out.println(ArrayUtils.toString(nArray2));
            float f = objectiveBlurFlexophoreHardMatchUncovered.getSimilarityHistogramsForNode(modelSolutionSimilarity, i);
            System.out.println("Node similarity " + Formatter.format3(Double.valueOf(modelSolutionSimilarity.getSimilarityNode(by))) + ", histogram similarity " + Formatter.format3(Double.valueOf(f)) + ".");
            System.out.println();
        }
        System.out.println("Un-normalized similarity " + Formatter.format3(modelSolutionSimilarity.getSimilarity()));
    }

    public static MolDistHistViz create(IDCodeParser iDCodeParser, DescriptorHandlerFlexophore descriptorHandlerFlexophore, String string) {
        StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(string);
        stereoMolecule.ensureHelperArrays(7);
        return descriptorHandlerFlexophore.createVisualDescriptor(stereoMolecule);
    }
}

