/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.calculator;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.VDWRadii;
import com.actelion.research.chem.descriptor.flexophore.calculator.GeometryCalculator;
import com.actelion.research.chem.descriptor.flexophore.calculator.IntQueue;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class StructureCalculator {
    public static List<List<Integer>> getConnexComponents(Molecule3D molecule3D) {
        int n;
        int[] nArray = StructureCalculator.getAtomToGroups(molecule3D);
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(new ArrayList());
        }
        for (n = 0; n < nArray.length; ++n) {
            ((List)arrayList.get(nArray[n] - 1)).add(n);
        }
        return arrayList;
    }

    public static int[] getAtomToGroups(Molecule3D molecule3D) {
        return StructureCalculator.getAtomToGroups(molecule3D, null);
    }

    public static int[] getAtomToGroups(Molecule3D molecule3D, List<Integer> list) {
        int[] nArray = new int[molecule3D.getAtoms()];
        IntQueue intQueue = new IntQueue();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            if (list != null) {
                list.add(i);
            }
            intQueue.push(i);
            ++n;
            while (!intQueue.isEmpty()) {
                int n2 = intQueue.pop();
                nArray[n2] = n;
                for (int j = 0; j < molecule3D.getAllConnAtoms(n2); ++j) {
                    int n3 = molecule3D.getConnAtom(n2, j);
                    if (n3 >= molecule3D.getAtoms() || nArray[n3] != 0) continue;
                    intQueue.push(n3);
                    nArray[n3] = -1;
                }
            }
            intQueue.clear();
        }
        return nArray;
    }

    public static List<Integer> getLongestChain(Molecule3D molecule3D, int n) {
        LinkedList<Item> linkedList = new LinkedList<Item>();
        linkedList.add(new Item(n));
        boolean[] blArray = new boolean[molecule3D.getAllBonds() * 2];
        try {
            Item item;
            do {
                item = (Item)linkedList.removeFirst();
                int n2 = item.a;
                for (int i = 0; i < molecule3D.getAllConnAtoms(n2); ++i) {
                    int n3;
                    int n4 = molecule3D.getConnBond(n2, i);
                    int n5 = n4 * 2 + ((n3 = molecule3D.getConnAtom(n2, i)) > n2 ? 1 : 0);
                    if (blArray[n5]) continue;
                    blArray[n5] = true;
                    if (molecule3D.getAtomicNo(n3) <= 1) continue;
                    Item item2 = new Item(n3);
                    item2.a = n3;
                    item2.path = (ArrayList)item.path.clone();
                    item2.path.add(n3);
                    linkedList.add(item2);
                }
            } while (!linkedList.isEmpty());
            return item.path;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean[] getBackbones(Molecule3D molecule3D) {
        return StructureCalculator.getBackbones(molecule3D, 70);
    }

    public static boolean[] getBackbones(Molecule3D molecule3D, int n) {
        boolean[] blArray = new boolean[molecule3D.getAllAtoms()];
        List<List<Integer>> list = StructureCalculator.getConnexComponents(molecule3D);
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            boolean bl = false;
            List<Integer> list2 = list.get(i);
            List<Integer> list3 = null;
            int n3 = list2.get(0);
            if (bl) {
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    blArray[list2.get((int)n2).intValue()] = true;
                }
                continue;
            }
            list3 = StructureCalculator.getLongestChain(molecule3D, n3);
            n3 = list3.get(list3.size() - 1);
            if ((list3 = StructureCalculator.getLongestChain(molecule3D, n3)).size() < n && molecule3D.getAllAtoms() > 80) {
                bl = true;
            }
            for (n2 = 0; n2 < list3.size(); ++n2) {
                blArray[list3.get((int)n2).intValue()] = true;
            }
        }
        return blArray;
    }

    public static int[][] getNumberOfBondsBetweenAtoms(Molecule3D molecule3D, int n, int[][] nArray) {
        int n2;
        int n3;
        if (nArray == null) {
            nArray = new int[molecule3D.getAllAtoms()][molecule3D.getAllAtoms()];
        }
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3][n3] = 0;
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                nArray[n2][n3] = -1;
                nArray[n3][n2] = -1;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < molecule3D.getAllBonds(); ++n2) {
                int n5 = molecule3D.getBondAtom(0, n2);
                int n6 = molecule3D.getBondAtom(1, n2);
                if (n5 >= n4 || n6 >= n4) continue;
                for (int i = 0; i < n4; ++i) {
                    if (nArray[i][n5] >= 0 && (nArray[i][n6] == -1 || nArray[i][n5] + 1 < nArray[i][n6]) && nArray[i][n5] < n) {
                        int n7 = nArray[i][n5] + 1;
                        nArray[i][n6] = n7;
                        nArray[n6][i] = n7;
                    }
                    if (nArray[i][n6] < 0 || nArray[i][n5] != -1 && nArray[i][n6] + 1 >= nArray[i][n5] || nArray[i][n6] >= n) continue;
                    int n8 = nArray[i][n6] + 1;
                    nArray[i][n5] = n8;
                    nArray[n5][i] = n8;
                }
            }
        }
        return nArray;
    }

    public static int[][] getNumberOfAtomsBetweenBonds(Molecule3D molecule3D, int n, int[][] nArray) {
        int n2;
        int n3;
        if (nArray == null) {
            nArray = new int[molecule3D.getAllBonds()][molecule3D.getAllBonds()];
        }
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3][n3] = 0;
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                nArray[n2][n3] = -1;
                nArray[n3][n2] = -1;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < molecule3D.getAllAtoms(); ++n2) {
                for (int i = 0; i < molecule3D.getConnAtoms(n2); ++i) {
                    int n5 = molecule3D.getConnBond(n2, i);
                    for (int j = i + 1; j < molecule3D.getConnAtoms(n2); ++j) {
                        int n6 = molecule3D.getConnBond(n2, j);
                        if (n5 >= n4 || n6 >= n4) continue;
                        for (int k = 0; k < n4; ++k) {
                            if (nArray[k][n5] >= 0 && (nArray[k][n6] == -1 || nArray[k][n5] + 1 < nArray[k][n6]) && nArray[k][n5] < n) {
                                int n7 = nArray[k][n5] + 1;
                                nArray[k][n6] = n7;
                                nArray[n6][k] = n7;
                            }
                            if (nArray[k][n6] < 0 || nArray[k][n5] != -1 && nArray[k][n6] + 1 >= nArray[k][n5] || nArray[k][n6] >= n) continue;
                            int n8 = nArray[k][n6] + 1;
                            nArray[k][n5] = n8;
                            nArray[n5][k] = n8;
                        }
                    }
                }
            }
        }
        return nArray;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        StereoMolecule stereoMolecule = new StereoMolecule();
        new SmilesParser().parse(stereoMolecule, "C1CCC1OCCCC");
        Molecule3D molecule3D = new Molecule3D(stereoMolecule);
        int[][] nArray = StructureCalculator.getNumberOfAtomsBetweenBonds(molecule3D, molecule3D.getAllAtoms(), null);
        System.out.print("\t");
        for (n = 0; n < nArray.length; ++n) {
            System.out.print("_" + n + "_\t");
        }
        System.out.println();
        for (n = 0; n < nArray.length; ++n) {
            System.out.print("_" + n + "_\t");
            for (int i = 0; i < nArray[n].length; ++i) {
                System.out.print((nArray[n][i] >= 0 ? Integer.valueOf(nArray[n][i]) : "") + "\t");
            }
            System.out.println();
        }
    }

    public static int getMaxValence(int n) {
        if (n >= 171 && n <= 190) {
            return 2;
        }
        switch (n) {
            case 1: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 1;
            }
            case 13: {
                return 3;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 17: {
                return 1;
            }
            case 33: {
                return 3;
            }
            case 34: {
                return 2;
            }
            case 35: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 53: {
                return 1;
            }
        }
        return 0;
    }

    public static int getImplicitHydrogens(Molecule3D molecule3D, int n) {
        int n2 = molecule3D.getAtomicNo(n);
        int n3 = StructureCalculator.getMaxValence(n2);
        n3 = n2 == 6 ? (n3 -= Math.abs(molecule3D.getAtomCharge(n))) : (Molecule.isAtomicNoElectronegative(n2) ? (n3 += molecule3D.getAtomCharge(n)) : (n3 -= molecule3D.getAtomCharge(n)));
        for (int i = 0; i < molecule3D.getAllConnAtoms(n); ++i) {
            if (molecule3D.getAtomicNo(molecule3D.getConnAtom(n, i)) < 1) continue;
            n3 -= molecule3D.getConnBondOrder(n, i);
        }
        if (n2 == 15) {
            return 0;
        }
        if (n2 == 16 && n3 < 0) {
            n3 += Math.min(4, -n3);
        } else if (n2 == 8 && molecule3D.getAllConnAtoms(n) == 1 && molecule3D.getAtomicNo(molecule3D.getConnAtom(n, 0)) == 15) {
            return 0;
        }
        return n3;
    }

    public static int getMaxFreeValence(Molecule3D molecule3D, int n) {
        switch (molecule3D.getAtomicNo(n)) {
            case 15: {
                return 5 - StructureCalculator.getValence(molecule3D, n);
            }
            case 16: {
                return 6 - StructureCalculator.getValence(molecule3D, n);
            }
        }
        return StructureCalculator.getImplicitHydrogens(molecule3D, n) + StructureCalculator.getExplicitHydrogens(molecule3D, n);
    }

    public static List<Molecule3D> extractFragments(Molecule3D molecule3D) {
        return null;
    }

    public static List<Molecule3D> extractLigands(Molecule3D molecule3D) {
        List<List<Integer>> list = StructureCalculator.getConnexComponents(molecule3D);
        ArrayList<Molecule3D> arrayList = new ArrayList<Molecule3D>();
        for (List<Integer> list2 : list) {
            Molecule3D molecule3D2 = new Molecule3D();
            StructureCalculator.extractFragment(molecule3D, molecule3D2, ArrayUtils.toIntArray(list2));
            if (molecule3D2.getAllAtoms() <= 5 || !molecule3D2.isAtomFlag(0, 2)) continue;
            arrayList.add(molecule3D2);
        }
        return arrayList;
    }

    public static <T extends Molecule3D> T extractFragment(Molecule3D molecule3D, T t, List<Integer> list) {
        return StructureCalculator.extractFragment(molecule3D, t, ArrayUtils.toIntArray(list));
    }

    public static <T extends Molecule3D> T extractFragment(Molecule3D molecule3D, T t, int[] nArray) {
        t.clear();
        int[] nArray2 = new int[molecule3D.getAllAtoms()];
        Arrays.fill(nArray2, -1);
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = t.addAtom(molecule3D, nArray[i]);
            for (int j = 0; j < molecule3D.getAllConnAtoms(nArray[i]); ++j) {
                int n = molecule3D.getConnAtom(nArray[i], j);
                if (nArray2[n] < 0) continue;
                t.addBond(nArray2[nArray[i]], nArray2[n], molecule3D.getConnBondOrder(nArray[i], j));
            }
        }
        return t;
    }

    public static List<Integer>[] getRings(Molecule3D molecule3D, List<int[]> list) {
        if (molecule3D.getAllAtoms() < 100) {
            return StructureCalculator.getRingsAccurate(molecule3D, list);
        }
        return StructureCalculator.getRingsFast(molecule3D, list);
    }

    public static List<Integer>[] getRingsAccurate(Molecule3D molecule3D, List<int[]> list) {
        int n;
        Object object;
        int n2;
        ArrayList[] arrayListArray = new ArrayList[molecule3D.getAllAtoms()];
        int n3 = 0;
        for (n2 = 0; n2 < molecule3D.getAllAtoms(); ++n2) {
            if (molecule3D.getAtomicNo(n2) == 1) continue;
            ++n3;
            Node node = new Node(n2, null, 0);
            arrayListArray[n2] = new ArrayList();
            arrayListArray[n2].add(node);
        }
        if (n3 > 50) {
            n3 = 50;
        }
        n2 = molecule3D.getAllAtoms();
        int n4 = molecule3D.getAllBonds();
        boolean[] blArray = new boolean[n4];
        boolean[][] blArray2 = new boolean[n2][n4 * 2];
        int n5 = 0;
        while (n5 < n3) {
            ++n5;
            for (int i = 0; i < n2; ++i) {
                ArrayList arrayList = arrayListArray[i];
                if (arrayList == null) continue;
                object = new ArrayList();
                block3: for (Node node : arrayList) {
                    int n6 = node.atm;
                    for (int j = 0; j < molecule3D.getAllConnAtoms(n6); ++j) {
                        Node node2;
                        int n7 = molecule3D.getConnAtom(n6, j);
                        int n8 = molecule3D.getConnBond(n6, j);
                        int n9 = n8 + (n7 < n6 ? molecule3D.getAllBonds() : 0);
                        if (molecule3D.getAtomicNo(n7) == 1 || n5 == 1 && n7 < i || node.parent != null && node.parent.atm == n7 || blArray2[i][n9]) continue;
                        blArray2[i][n9] = true;
                        if (n7 == i) {
                            node2 = node;
                            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                            boolean bl = true;
                            while (node2 != null) {
                                arrayList2.add(0, node2.atm);
                                if (!blArray[node2.bond]) {
                                    bl = false;
                                    blArray[node2.bond] = true;
                                }
                                node2 = node2.parent;
                            }
                            if (bl) continue;
                            if (arrayList2.size() < 3) {
                                System.err.println("ring of size " + arrayList2.size() + "???");
                                continue;
                            }
                            int[] nArray = ArrayUtils.toIntArray(arrayList2);
                            if (StructureCalculator.contains(list, nArray)) continue;
                            list.add(nArray);
                            n3 -= (nArray.length - 1) / 2;
                            continue;
                        }
                        node2 = node.parent;
                        while (node2 != null) {
                            if (node2.atm == n7) continue block3;
                            node2 = node2.parent;
                        }
                        node2 = new Node(n7, node, n8);
                        object.add(node2);
                    }
                }
                arrayListArray[i] = object;
            }
        }
        ArrayList[] arrayListArray2 = new ArrayList[molecule3D.getAllAtoms()];
        for (n = 0; n < arrayListArray2.length; ++n) {
            arrayListArray2[n] = new ArrayList();
        }
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayListArray2[object[i]].add(n);
            }
        }
        return arrayListArray2;
    }

    public static List<Integer>[] getRingsFast(Molecule3D molecule3D, List<int[]> list) {
        int n;
        int n2;
        boolean[] blArray = new boolean[molecule3D.getAllBonds()];
        for (n2 = 0; n2 < molecule3D.getAllAtoms(); ++n2) {
            if (molecule3D.getAtomicNo(n2) <= 1) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n2);
            StructureCalculator.doRings(molecule3D, list, arrayList, blArray, 7);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            if (list.get(n2).length < 6) continue;
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (n2 == i || list.get(i).length >= 6) continue;
                int n4 = 0;
                block3: for (int n5 : list.get(i)) {
                    for (int n6 : list.get(n2)) {
                        if (n5 == n6) continue block3;
                    }
                    ++n4;
                }
                if (n4 > 1) continue;
                ++n3;
            }
            if (n3 < 2) continue;
            list.remove(n2--);
        }
        Collections.sort(list, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                return nArray.length - nArray2.length;
            }
        });
        ArrayList[] arrayListArray = new ArrayList[molecule3D.getAllAtoms()];
        for (n = 0; n < arrayListArray.length; ++n) {
            arrayListArray[n] = new ArrayList();
        }
        for (n = 0; n < list.size(); ++n) {
            for (int n7 : list.get(n)) {
                arrayListArray[n7].add(n);
            }
        }
        return arrayListArray;
    }

    private static void doRings(Molecule3D molecule3D, List<int[]> list, List<Integer> list2, boolean[] blArray, int n) {
        if (n <= 0) {
            return;
        }
        int n2 = list2.get(0);
        int n3 = list2.get(list2.size() - 1);
        for (int i = 0; i < molecule3D.getAllConnAtoms(n3); ++i) {
            int n4 = molecule3D.getConnBond(n3, i);
            int n5 = molecule3D.getConnAtom(n3, i);
            if (blArray[n4] || molecule3D.getAtomicNo(n5) <= 1 || n5 < n2) continue;
            if (n5 == n2 && list2.size() > 2) {
                if (list2.get(1) > list2.get(list2.size() - 1)) continue;
                int[] nArray = ArrayUtils.toIntArray(list2);
                list.add(nArray);
                continue;
            }
            blArray[n4] = true;
            list2.add(n5);
            StructureCalculator.doRings(molecule3D, list, list2, blArray, n - 1);
            list2.remove(list2.size() - 1);
            blArray[n4] = false;
        }
    }

    private static boolean contains(List<int[]> list, int[] nArray) {
        block0: for (int[] nArray2 : list) {
            if (nArray2.length != nArray.length) continue;
            for (int i = 0; i < nArray2.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j] != nArray2[i]) continue;
                    bl = true;
                }
                if (!bl) continue block0;
            }
            return true;
        }
        return false;
    }

    public static List<int[]> getInterMolecularInteractions(Molecule3D molecule3D) {
        return null;
    }

    public static int[] getAtomsOnPath(Molecule3D molecule3D, int n, int n2) {
        int n3;
        Object object;
        int n4;
        if (n >= molecule3D.getAllAtoms() || n2 >= molecule3D.getAllAtoms()) {
            throw new IllegalArgumentException("Invalid atom number");
        }
        boolean[] blArray = new boolean[molecule3D.getAllAtoms()];
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node = new Node(n, null, -1);
        arrayList.add(node);
        int n5 = -1;
        for (int i = 0; i < molecule3D.getAllBonds() && n5 != 0 && arrayList.size() > 0; ++i, --n5) {
            node = (Node)arrayList.remove(0);
            n4 = node.atm;
            if (n4 == n2) {
                object = node;
                while (((Node)object).parent != null) {
                    treeSet.add(((Node)object).atm);
                    object = ((Node)object).parent;
                }
                n5 = 5;
                continue;
            }
            if (blArray[n4]) continue;
            blArray[n4] = true;
            for (int j = 0; j < molecule3D.getAllConnAtoms(n4); ++j) {
                n3 = molecule3D.getConnAtom(n4, j);
                if (blArray[n3]) continue;
                Node node2 = new Node(n3, node, molecule3D.getConnBond(n4, j));
                arrayList.add(node2);
            }
        }
        if (n5 >= 0) {
            treeSet.add(n);
            treeSet.add(n2);
        }
        int[] nArray = new int[treeSet.size()];
        n4 = 0;
        object = treeSet.iterator();
        while (object.hasNext()) {
            n3 = (Integer)object.next();
            nArray[n4++] = n3;
        }
        return nArray;
    }

    public static int getValence(Molecule3D molecule3D, int n) {
        int n2 = 0;
        for (int i = 0; i < molecule3D.getAllConnAtoms(n); ++i) {
            if (molecule3D.getAtomicNo(molecule3D.getConnAtom(n, i)) <= 1) continue;
            n2 += molecule3D.getConnBondOrder(n, i);
        }
        return n2;
    }

    public static final int getExplicitHydrogens(Molecule3D molecule3D, int n) {
        int n2 = 0;
        for (int i = 0; i < molecule3D.getAllConnAtoms(n); ++i) {
            if (molecule3D.getAtomicNo(molecule3D.getConnAtom(n, i)) != 1) continue;
            ++n2;
        }
        return n2;
    }

    public static int getStructureCenter(Molecule3D molecule3D, int[] nArray, int[][] nArray2) {
        return StructureCalculator.getStructureCenter(molecule3D, 0, nArray, nArray2);
    }

    public static int getStructureCenter(Molecule3D molecule3D, int n, int[] nArray, int[][] nArray2) {
        List<Integer> list = StructureCalculator.getBackbone(molecule3D, n);
        list = StructureCalculator.getBackbone(molecule3D, list.get(0));
        int n2 = list.get(list.size() / 2);
        return n2;
    }

    public static List<Integer> getBackbone(Molecule3D molecule3D, int n) {
        List<Integer> list = StructureCalculator.getLongestChain(molecule3D, n);
        list = StructureCalculator.getLongestChain(molecule3D, list.get(list.size() - 1));
        return list;
    }

    public static int dfs(Molecule3D molecule3D, int n, Set<Integer> set) {
        return StructureCalculator.dfs(molecule3D, n, set, 99, false);
    }

    public static int dfs(Molecule3D molecule3D, int n, Set<Integer> set, int n2, boolean bl) {
        return -1;
    }

    public static Molecule3D extractLigand(Molecule3D molecule3D) {
        if (molecule3D == null) {
            throw new IllegalArgumentException("The mol is null");
        }
        if (molecule3D.getNMovables() == molecule3D.getAllAtoms()) {
            return new Molecule3D(molecule3D);
        }
        Molecule3D molecule3D2 = new Molecule3D(molecule3D);
        int[] nArray = new int[molecule3D.getAllAtoms()];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (!molecule3D.isAtomFlag(i, 2) || nArray[i] >= 0) continue;
            nArray[i] = molecule3D2.addAtom(molecule3D, i);
            for (int j = 0; j < molecule3D.getAllConnAtoms(i); ++j) {
                int n = molecule3D.getConnAtom(i, j);
                if (nArray[n] < 0) continue;
                molecule3D2.addBond(nArray[i], nArray[n], molecule3D.getConnBondOrder(i, j));
            }
        }
        return molecule3D2;
    }

    public static void insertLigand(Molecule3D molecule3D, Molecule3D molecule3D2, Coordinates coordinates) {
        int n;
        for (int i = n = molecule3D.fusion(molecule3D2); i < molecule3D.getAllAtoms(); ++i) {
            molecule3D.setAtomFlag(i, 34, true);
        }
        if (coordinates != null && GeometryCalculator.getCenterGravity(molecule3D2).distance(coordinates) > 5.0) {
            StructureCalculator.translateLigand(molecule3D, coordinates.subC(GeometryCalculator.getCenterGravity(molecule3D2)));
        }
    }

    public static void replaceLigand(Molecule3D molecule3D, Molecule3D molecule3D2) {
        StructureCalculator.replaceLigand(molecule3D, molecule3D2, null);
    }

    public static void replaceLigand(Molecule3D molecule3D, Molecule3D molecule3D2, Coordinates coordinates) {
        if (coordinates == null) {
            coordinates = StructureCalculator.getLigandCenter(molecule3D);
        }
        StructureCalculator.removeLigand(molecule3D);
        if (molecule3D2 != null) {
            StructureCalculator.insertLigand(molecule3D, molecule3D2, coordinates);
        }
    }

    public static boolean deleteHydrogens(Molecule3D molecule3D) {
        boolean bl = false;
        for (int i = molecule3D.getAllAtoms() - 1; i >= 0; --i) {
            if (molecule3D.getAtomicNo(i) > 1) continue;
            bl = true;
            molecule3D.deleteAtom(i);
        }
        return bl;
    }

    public static boolean addHydrogens(Molecule3D molecule3D) {
        return StructureCalculator.addHydrogens(molecule3D, false);
    }

    public static boolean addHydrogens(Molecule3D molecule3D, boolean bl) {
        boolean bl2 = false;
        int n = molecule3D.getAllAtoms();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Coordinates[] coordinatesArray = null;
        if (bl) {
            coordinatesArray = StructureCalculator.getLigandBounds(molecule3D);
            coordinatesArray[0].sub(new Coordinates(11.0, 11.0, 11.0));
            coordinatesArray[1].add(new Coordinates(11.0, 11.0, 11.0));
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            if (molecule3D.isAtomFlag(i, 1) && (!bl || !molecule3D.getCoordinates(i).insideBounds(coordinatesArray))) continue;
            int n4 = StructureCalculator.getImplicitHydrogens(molecule3D, i);
            if (n4 < 0) {
                for (n3 = 0; n3 < molecule3D.getAllConnAtoms(i) && n4 < 0; ++n3) {
                    n2 = molecule3D.getConnAtom(i, n3);
                    if (molecule3D.getAtomicNo(n2) != 1) continue;
                    arrayList.add(n2);
                    bl2 = true;
                    ++n4;
                }
                continue;
            }
            if (n4 <= 0) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = molecule3D.addAtom(1);
                molecule3D.setAtomFlags(n2, molecule3D.getAtomFlags(i) & 0xFFFFFFDF);
                molecule3D.addBond(i, n2, 1);
                molecule3D.setCoordinates(n2, molecule3D.getCoordinates(i));
            }
            bl2 = true;
        }
        molecule3D.deleteAtoms(arrayList);
        return bl2;
    }

    public static boolean addHydrogensAroundLigand(Molecule3D molecule3D, double d) {
        return false;
    }

    public static void copyAtoms(Molecule3D molecule3D, Molecule3D molecule3D2, List<Integer> list) {
        int n;
        int n2;
        int n3;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (n3 = 0; n3 < list.size(); ++n3) {
            n2 = list.get(n3);
            if (hashMap.containsKey(n2)) continue;
            n = molecule3D2.addAtom(molecule3D, n2);
            hashMap.put(n2, n);
        }
        for (n3 = 0; n3 < molecule3D.getAllBonds(); ++n3) {
            n2 = molecule3D.getBondAtom(0, n3);
            n = molecule3D.getBondAtom(1, n3);
            Integer n4 = (Integer)hashMap.get(n2);
            Integer n5 = (Integer)hashMap.get(n);
            if (n4 == null || n5 == null) continue;
            molecule3D2.addBond(n4, n5, molecule3D.getBondOrder(n3));
        }
    }

    public static void removeWater(Molecule3D molecule3D) {
        StructureCalculator.removeWater(molecule3D, true);
    }

    public static void removeWater(Molecule3D molecule3D, boolean bl) {
        int n;
        if (molecule3D == null) {
            return;
        }
        for (n = 0; n < molecule3D.getAllAtoms(); ++n) {
            if (molecule3D.getAtomicNo(n) != 0) continue;
            molecule3D.deleteAtom(n);
            --n;
        }
        for (n = 0; n < molecule3D.getAllAtoms(); ++n) {
            if (molecule3D.getAtomicNo(n) != 8 || !bl && molecule3D.isAtomFlag(n, 16)) continue;
            if (molecule3D.getAllConnAtoms(n) == 0) {
                molecule3D.deleteAtom(n);
                --n;
                continue;
            }
            if (molecule3D.getAllConnAtoms(n) != 2 || molecule3D.getAtomicNo(molecule3D.getConnAtom(n, 0)) != 1 || molecule3D.getAtomicNo(molecule3D.getConnAtom(n, 1)) != 1) continue;
            int[] nArray = new int[]{molecule3D.getAllConnAtoms(n), molecule3D.getConnAtom(n, 0), molecule3D.getConnAtom(n, 1)};
            Arrays.sort(nArray);
            for (int i = 2; i >= 0; --i) {
                molecule3D.deleteAtom(nArray[i]);
            }
            n -= 3;
        }
    }

    public static void removeWaterSalts(Molecule3D molecule3D) {
        List<List<Integer>> list = StructureCalculator.getConnexComponents(molecule3D);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            List<Integer> list2 = list.get(i);
            if (list2.size() > 20 || list2.size() > molecule3D.getAtoms() / 30 || molecule3D.isAtomFlag(list2.get(0), 2)) continue;
            arrayList.addAll((Collection<Integer>)list.get(i));
        }
        molecule3D.deleteAtoms(arrayList);
    }

    public static void removeLigand(Molecule3D molecule3D) {
        for (int i = molecule3D.getAllAtoms() - 1; i >= 0; --i) {
            if (!molecule3D.isAtomFlag(i, 2)) continue;
            molecule3D.deleteAtom(i);
        }
    }

    public static Molecule3D crop(Molecule3D molecule3D, Coordinates coordinates, double d) {
        int n;
        int n2;
        Molecule3D molecule3D2 = new Molecule3D();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n2 = 0; n2 < molecule3D.getAllAtoms(); ++n2) {
            Coordinates coordinates2 = molecule3D.getCoordinates(n2);
            if (!(coordinates.distance(coordinates2) <= d)) continue;
            n = molecule3D2.addAtom(molecule3D, n2);
            hashMap.put(n2, n);
            if (molecule3D.getAllConnAtoms(n2) == 0) continue;
            treeSet.add(n);
        }
        for (n2 = 0; n2 < molecule3D.getAllBonds(); ++n2) {
            int n3 = molecule3D.getBondAtom(0, n2);
            n = molecule3D.getBondAtom(1, n2);
            Integer n4 = (Integer)hashMap.get(n3);
            Integer n5 = (Integer)hashMap.get(n);
            if (n4 == null || n5 == null) continue;
            molecule3D2.addBond(n4, n5, molecule3D.getBondOrder(n2));
        }
        for (n2 = molecule3D2.getAllAtoms() - 1; n2 >= 0; --n2) {
            if (molecule3D2.getAllConnAtoms(n2) != 0 || !treeSet.contains(n2)) continue;
            molecule3D2.deleteAtom(n2);
        }
        molecule3D2.setName(molecule3D.getName() + (molecule3D2.getAllAtoms() < molecule3D.getAllAtoms() ? " Crop" : ""));
        molecule3D2.getAuxiliaryInfos().putAll(molecule3D.getAuxiliaryInfos());
        return molecule3D2;
    }

    public static Molecule3D cropLigand(Molecule3D molecule3D, double d) {
        return null;
    }

    public static int markLigand(Molecule3D molecule3D, int n) {
        return -1;
    }

    public static void markLigands(Molecule3D molecule3D) {
        List<Integer> list;
        int n;
        List<List<Integer>> list2 = StructureCalculator.getConnexComponents(molecule3D);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n = 0; n < list2.size(); ++n) {
            list = list2.get(n);
            if (list2.size() > 1 && (list.size() > 90 || list.size() < 7)) continue;
            hashSet.add(n);
        }
        for (n = 0; n < list2.size(); ++n) {
            list = list2.get(n);
            for (int i = 0; i < list.size(); ++i) {
                int n2 = list.get(i);
                if (hashSet.contains(n)) {
                    molecule3D.setAtomFlag(n2, 2, true);
                    molecule3D.setAtomFlag(n2, 1, false);
                    continue;
                }
                molecule3D.setAtomFlag(n2, 1, true);
                molecule3D.setAtomFlag(n2, 2, false);
            }
        }
    }

    public static boolean markLigand(Molecule3D molecule3D) {
        return true;
    }

    public static Coordinates getCenter(Molecule3D molecule3D) {
        Coordinates coordinates = new Coordinates();
        int n = 0;
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            coordinates = coordinates.addC(molecule3D.getCoordinates(i));
            ++n;
        }
        return n == 0 ? null : coordinates.scaleC(1.0 / (double)n);
    }

    public static Coordinates getLigandCenter(Molecule3D molecule3D) {
        Coordinates coordinates = new Coordinates();
        int n = 0;
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (molecule3D.getAtomicNo(i) <= 1 || !molecule3D.isAtomFlag(i, 2)) continue;
            coordinates = coordinates.addC(molecule3D.getCoordinates(i));
            ++n;
        }
        return n == 0 ? null : coordinates.scaleC(1.0 / (double)n);
    }

    public static Coordinates[] getLigandBounds(Molecule3D molecule3D) {
        return StructureCalculator.getBounds(molecule3D, 2);
    }

    public static Coordinates[] getBounds(Molecule3D molecule3D) {
        return StructureCalculator.getBounds(molecule3D, 0);
    }

    private static Coordinates[] getBounds(Molecule3D molecule3D, int n) {
        Coordinates coordinates = new Coordinates(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Coordinates coordinates2 = new Coordinates(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (n != 0 && (molecule3D.getAtomFlags(i) & n) <= 0) continue;
            coordinates.x = Math.min(coordinates.x, molecule3D.getAtomX(i));
            coordinates.y = Math.min(coordinates.y, molecule3D.getAtomY(i));
            coordinates.z = Math.min(coordinates.z, molecule3D.getAtomZ(i));
            coordinates2.x = Math.max(coordinates2.x, molecule3D.getAtomX(i));
            coordinates2.y = Math.max(coordinates2.y, molecule3D.getAtomY(i));
            coordinates2.z = Math.max(coordinates2.z, molecule3D.getAtomZ(i));
        }
        if (coordinates.x > coordinates2.x) {
            return null;
        }
        return new Coordinates[]{coordinates, coordinates2};
    }

    public static double getLigandRMSD(Molecule3D molecule3D, Molecule3D molecule3D2) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (!molecule3D.isAtomFlag(i, 2) || molecule3D.getAtomicNo(i) <= 1) continue;
            long l = StructureCalculator.getAtomHashkey(molecule3D, i);
            double d2 = Double.MAX_VALUE;
            int n2 = -1;
            for (int j = 0; j < molecule3D2.getAllAtoms(); ++j) {
                double d3;
                long l2;
                if (!molecule3D2.isAtomFlag(j, 2) || molecule3D2.getAtomicNo(j) != molecule3D.getAtomicNo(i) || l != (l2 = StructureCalculator.getAtomHashkey(molecule3D2, j)) || !((d3 = molecule3D.getCoordinates(i).distSquareTo(molecule3D2.getCoordinates(j))) < d2)) continue;
                d2 = d3;
                n2 = j;
            }
            if (n2 < 0) {
                return -1.0;
            }
            d += d2;
            ++n;
        }
        double d4 = Math.sqrt(d / (double)n);
        return d4;
    }

    public static void translateLigand(Molecule3D molecule3D, Coordinates coordinates) {
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (!molecule3D.isAtomFlag(i, 2)) continue;
            molecule3D.setCoordinates(i, molecule3D.getCoordinates(i).addC(coordinates));
        }
    }

    public static void rotateLigand(Molecule3D molecule3D, double d, Coordinates coordinates, Coordinates coordinates2) {
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (!molecule3D.isAtomFlag(i, 2)) continue;
            molecule3D.setCoordinates(i, molecule3D.getCoordinates(i).subC(coordinates2).rotate(coordinates, d).addC(coordinates2));
        }
    }

    public static void vibrateLigand(Molecule3D molecule3D, double d) {
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (!molecule3D.isAtomFlag(i, 2)) continue;
            Coordinates coordinates = new Coordinates(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
            if (coordinates.dist() > 0.0) {
                coordinates = coordinates.unitC().scaleC(Math.random() * d);
            }
            molecule3D.setCoordinates(i, molecule3D.getCoordinates(i).addC(coordinates));
        }
    }

    public static long getAtomHashkey(Molecule3D molecule3D, int n) {
        long l = 0L;
        for (int i = 0; i < molecule3D.getAllConnAtoms(n); ++i) {
            int n2 = molecule3D.getConnAtom(n, i);
            if (molecule3D.getAtomicNo(n2) <= 1) continue;
            l += (long)((molecule3D.getAtomicNo(n2) * 10 + molecule3D.getConnBondOrder(n, i)) * 100);
            for (int j = 0; j < molecule3D.getAllConnAtoms(n2); ++j) {
                int n3 = molecule3D.getConnAtom(n2, j);
                if (molecule3D.getAtomicNo(n3) <= 1) continue;
                l += (long)(molecule3D.getAtomicNo(n3) * 10 + molecule3D.getConnBondOrder(n2, j));
            }
        }
        l = l * 100L + (long)molecule3D.getAtomicNo(n);
        return l;
    }

    public static int makeProteinFlexible(Molecule3D molecule3D, Coordinates coordinates, double d, boolean bl) {
        return -1;
    }

    public static void makeProteinRigid(Molecule3D molecule3D) {
        for (int i = molecule3D.getAllAtoms() - 1; i >= 0; --i) {
            if (molecule3D.isAtomFlag(i, 2)) continue;
            if (molecule3D.getAtomicNo(i) <= 1) {
                molecule3D.deleteAtom(i);
            }
            molecule3D.setAtomFlag(i, 1, true);
        }
    }

    public static int[] getHDonorsAcceptors(ExtendedMolecule extendedMolecule) {
        int[] nArray = new int[2];
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            if (extendedMolecule.getAtomicNo(i) != 8 && extendedMolecule.getAtomicNo(i) != 7) continue;
            if (extendedMolecule.getAllHydrogens(i) > 0) {
                nArray[0] = nArray[0] + 1;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    public static boolean isDonor(Molecule3D molecule3D, int n) {
        boolean bl;
        int n2 = molecule3D.getAtomicNo(n);
        boolean bl2 = bl = n2 == 7 || n2 == 8 || n2 == 15 || n2 == 16;
        if (!bl) {
            return false;
        }
        return StructureCalculator.getExplicitHydrogens(molecule3D, n) > 0 || StructureCalculator.getImplicitHydrogens(molecule3D, n) > 0;
    }

    public static boolean isAcceptor(Molecule3D molecule3D, int n) {
        return false;
    }

    public static void flagBackbone(Molecule3D molecule3D) {
        boolean[] blArray = StructureCalculator.getBackbones(molecule3D);
        for (int i = 0; i < blArray.length; ++i) {
            molecule3D.setAtomFlag(i, 4, blArray[i]);
        }
    }

    public static int connected(Molecule3D molecule3D, int n, int n2, int n3) {
        for (int i = 0; i < molecule3D.getAllConnAtoms(n); ++i) {
            int n4 = molecule3D.getConnAtom(n, i);
            if (n2 >= 0 && molecule3D.getAtomicNo(n4) != n2 || n3 > 0 && molecule3D.getConnBondOrder(n, i) != n3) continue;
            return n4;
        }
        return -1;
    }

    public static void rotateBond(Molecule3D molecule3D, int n, int n2, double d) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n);
        StructureCalculator.dfs(molecule3D, n2, hashSet);
        Coordinates coordinates = molecule3D.getCoordinates(n2).subC(molecule3D.getCoordinates(n)).unitC();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            Coordinates coordinates2 = molecule3D.getCoordinates(n3).subC(molecule3D.getCoordinates(n2));
            molecule3D.setCoordinates(n3, coordinates2.rotate(coordinates, d).addC(molecule3D.getCoordinates(n2)));
        }
    }

    public static boolean removeLonePairs(Molecule3D molecule3D) {
        boolean bl = false;
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (molecule3D.getAtomicNo(i) != 0) continue;
            molecule3D.deleteAtom(i);
            --i;
            bl = true;
        }
        return bl;
    }

    public static final double[][] getDistanceMatrix(Molecule3D molecule3D, Molecule3D molecule3D2) {
        double[][] dArray = new double[molecule3D.getAllAtoms()][molecule3D2.getAllAtoms()];
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            for (int j = 0; j < molecule3D2.getAllAtoms(); ++j) {
                dArray[i][j] = molecule3D.getCoordinates(i).distance(molecule3D2.getCoordinates(j));
            }
        }
        return dArray;
    }

    public static final int[] getOverlap(Molecule3D molecule3D, Molecule3D molecule3D2) {
        int n;
        int n2 = molecule3D.getAllAtoms();
        int n3 = molecule3D2.getAllAtoms();
        double[][] dArray = StructureCalculator.getDistanceMatrix(molecule3D, molecule3D2);
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                if (molecule3D.getAtomicNo(i) == molecule3D2.getAtomicNo(n)) continue;
                double[] dArray2 = dArray[i];
                int n4 = n;
                dArray2[n4] = dArray2[n4] + 0.3;
            }
        }
        boolean[] blArray = new boolean[n3];
        n = 0;
        int n5 = 0;
        while (true) {
            int[] nArray = null;
            for (int i = 0; i < n3; ++i) {
                if (molecule3D2.getAtomicNo(i) <= 1 || blArray[i]) continue;
                for (int j = 0; j < n2; ++j) {
                    if (molecule3D.getAtomicNo(j) <= 1 || nArray != null && !(dArray[j][i] < dArray[nArray[0]][nArray[1]])) continue;
                    nArray = new int[]{j, i};
                }
            }
            if (nArray == null) break;
            blArray[nArray[1]] = true;
            double d = dArray[nArray[0]][nArray[1]];
            if (d < 0.75) {
                ++n;
                continue;
            }
            if (!(d < 1.4)) continue;
            ++n5;
        }
        return new int[]{n, n5};
    }

    public static int getMolecularPathCount(Molecule3D molecule3D, int n) {
        int[][] nArray = StructureCalculator.getNumberOfBondsBetweenAtoms(molecule3D, n, null);
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = i; j < nArray.length; ++j) {
                if (nArray[i][j] != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static List<int[]> getFragmentMatches(Molecule3D molecule3D, Molecule3D molecule3D2) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        StructureCalculator.getFragmentMatchesRec(molecule3D, molecule3D2, new int[molecule3D.getAllAtoms()], 0, arrayList);
        return arrayList;
    }

    private static void getFragmentMatchesRec(Molecule3D molecule3D, Molecule3D molecule3D2, int[] nArray, int n, List<int[]> list) {
        if (n >= molecule3D.getAllAtoms()) {
            list.add((int[])nArray.clone());
        } else {
            block0: for (int i = 0; i < molecule3D2.getNMovables(); ++i) {
                int n2;
                if (molecule3D.getAtomicNo(n) != 6 && molecule3D.getAtomicNo(n) != molecule3D2.getAtomicNo(i)) continue;
                for (n2 = 0; n2 < n; ++n2) {
                    if (nArray[n2] == i) continue block0;
                }
                for (n2 = 0; n2 < molecule3D.getConnAtoms(n); ++n2) {
                    int n3;
                    int n4 = molecule3D.getConnAtom(n, n2);
                    if (n4 < n && (n3 = molecule3D2.getBond(i, nArray[n4])) < 0) continue block0;
                }
                nArray[n] = i;
                StructureCalculator.getFragmentMatchesRec(molecule3D, molecule3D2, nArray, n + 1, list);
            }
        }
    }

    public static List<int[]> getHBonds(Molecule3D molecule3D) {
        int[] nArray = new int[molecule3D.getAllAtoms()];
        int[] nArray2 = new int[molecule3D.getAllAtoms()];
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            if (molecule3D.getAtomicNo(i) != 8 && molecule3D.getAtomicNo(i) != 7 && molecule3D.getAtomicNo(i) != 16) continue;
            nArray[i] = StructureCalculator.getImplicitHydrogens(molecule3D, i) + StructureCalculator.getExplicitHydrogens(molecule3D, i);
            nArray2[i] = molecule3D.getAtomicNo(i) == 8 ? 2 : (molecule3D.getAtomicNo(i) == 7 ? 1 : 0);
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        MoleculeGrid moleculeGrid = new MoleculeGrid(molecule3D);
        for (int i = 0; i < molecule3D.getNMovables(); ++i) {
            if (!molecule3D.isAtomFlag(i, 2) || nArray[i] == 0 && nArray2[i] == 0) continue;
            Set<Integer> set = moleculeGrid.getNeighbours(molecule3D.getCoordinates(i), 5.0);
            for (int n : set) {
                double d;
                double d2;
                if (molecule3D.isAtomFlag(n, 2) || (nArray[i] <= 0 || nArray2[n] <= 0) && (nArray[n] <= 0 || nArray2[i] <= 0) || !((d2 = Math.sqrt(molecule3D.getCoordinates(n).distSquareTo(molecule3D.getCoordinates(i)))) > (d = (double)(VDWRadii.VDW_RADIUS[molecule3D.getAtomicNo(n)] + VDWRadii.VDW_RADIUS[molecule3D.getAtomicNo(i)])) - 0.5) || !(d2 < d + 0.5)) continue;
                boolean bl = false;
                for (int j = 0; j < molecule3D.getAllConnAtoms(i); ++j) {
                    if (molecule3D.getAtomicNo(molecule3D.getConnAtom(i, j)) <= 1) continue;
                    for (int k = 0; k < molecule3D.getAllConnAtoms(n); ++k) {
                        Coordinates coordinates;
                        if (molecule3D.getAtomicNo(molecule3D.getConnAtom(n, k)) <= 1) continue;
                        Coordinates coordinates2 = molecule3D.getCoordinates(i).subC(molecule3D.getCoordinates(molecule3D.getConnAtom(i, j)));
                        double d3 = coordinates2.getAngle(coordinates = molecule3D.getCoordinates(n).subC(molecule3D.getCoordinates(molecule3D.getConnAtom(n, k))));
                        if (Math.abs(2.0943951023931953 - d3) < 0.3141592653589793) {
                            bl = true;
                        }
                        if (!(Math.abs(1.0471975511965976 - d3) < 0.3141592653589793)) continue;
                        bl = true;
                    }
                }
                if (!bl) continue;
                arrayList.add(new int[]{i, n});
            }
        }
        return arrayList;
    }

    private static final class Node {
        int atm;
        int bond;
        Node parent;

        public Node(int n, Node node, int n2) {
            this.atm = n;
            this.parent = node;
            this.bond = n2;
        }

        public String toString() {
            Node node = this.parent;
            String string = "{" + this.atm;
            while (node != null) {
                string = string + "," + node.atm;
                node = node.parent;
            }
            return string + "}";
        }
    }

    private static class Item {
        public int a;
        public ArrayList<Integer> path = new ArrayList();

        public Item(int n) {
            this.a = n;
            this.path.add(n);
        }
    }
}

