/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.descriptor.flexophore.ClusterNode;
import com.actelion.research.chem.descriptor.flexophore.DistHist;
import com.actelion.research.chem.descriptor.flexophore.IMolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MDHIndexTables;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import com.actelion.research.chem.descriptor.flexophore.calculator.StructureCalculator;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.util.graph.complete.ICompleteGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class MolDistHistViz
extends DistHist
implements Serializable,
IMolDistHist,
ICompleteGraph {
    private static final long serialVersionUID = 15052013L;
    public static final int DESCRIBE_ALL = 1;
    public static final int DESCRIBE_MAPPED = 2;
    public static final int CAPACITY_INEVITABLE_PPPOINTS = 5;
    public static final String TAG_VIZ_INFO_ENCODED = "Flexophore2VizInfo";
    private static final int MIN_COUNTS_BLURR = 3;
    private static final double RATIO_BLURR = 0.2;
    private static transient MDHIndexTables indexTables;
    public static final transient String[] COLORS;
    private List<PPNodeViz> liPPNodeViz;
    protected Molecule3D molecule3D;
    private int flagsDescribe;
    private int numCNodes;
    private int numHeteroNodes;
    private boolean finalized;
    private HashSet<Integer> hsIndexInevitablePPPoints;
    private List<float[][]> liDistanceTable;
    private byte modeFlexophore;

    public MolDistHistViz() {
        this.molecule3D = null;
        this.flagsDescribe = 1;
        this.liPPNodeViz = new ArrayList<PPNodeViz>();
        this.hsIndexInevitablePPPoints = new HashSet();
        this.modeFlexophore = 0;
    }

    public MolDistHistViz(int n) {
        this.initHistogramArray(n);
        this.flagsDescribe = 1;
        this.hsIndexInevitablePPPoints = new HashSet();
        this.modeFlexophore = 0;
    }

    public MolDistHistViz(int n, Molecule3D molecule3D) {
        this.initHistogramArray(n);
        this.flagsDescribe = 1;
        if (molecule3D != null) {
            this.molecule3D = new Molecule3D(molecule3D);
            this.molecule3D.ensureHelperArrays(7);
        }
        this.hsIndexInevitablePPPoints = new HashSet();
        this.modeFlexophore = 0;
    }

    public MolDistHistViz(MolDistHistViz molDistHistViz) {
        this.hsIndexInevitablePPPoints = new HashSet();
        molDistHistViz.copy(this);
        this.flagsDescribe = 1;
        this.modeFlexophore = molDistHistViz.modeFlexophore;
    }

    public MolDistHistViz(MolDistHist molDistHist) {
        if (molDistHist.getNumPPNodes() == 0) {
            throw new RuntimeException("Empty object given into constructor.");
        }
        molDistHist.copy(this);
        this.modeFlexophore = molDistHist.getModeFlexophore();
        this.liPPNodeViz = new ArrayList<PPNodeViz>(molDistHist.getNumPPNodes());
        for (int i = 0; i < molDistHist.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = new PPNodeViz(molDistHist.getNode(i));
            this.liPPNodeViz.add(pPNodeViz);
        }
        this.hsIndexInevitablePPPoints = new HashSet();
        this.realize();
    }

    public static void createIndexTables() {
        indexTables = MDHIndexTables.getInstance();
    }

    public void addInevitablePharmacophorePoint(int n) {
        this.hsIndexInevitablePPPoints.add(n);
    }

    public void removeInevitablePharmacophorePoint(int n) {
        this.hsIndexInevitablePPPoints.remove(n);
    }

    public void setModeFlexophore(byte by) {
        this.modeFlexophore = by;
        for (PPNodeViz pPNodeViz : this.liPPNodeViz) {
            pPNodeViz.setModeFlexophore(by);
        }
    }

    public void setMarkAll(boolean bl) {
        for (PPNodeViz pPNodeViz : this.liPPNodeViz) {
            pPNodeViz.setMarked(bl);
        }
    }

    public void setMark(int n, boolean bl) {
        this.liPPNodeViz.get(n).setMarked(bl);
    }

    public boolean isMarked(int n) {
        return this.liPPNodeViz.get(n).isMarked();
    }

    public int addNode(PPNodeViz pPNodeViz) {
        int n = this.liPPNodeViz.size();
        pPNodeViz.setIndex(this.liPPNodeViz.size());
        pPNodeViz.setModeFlexophore(this.modeFlexophore);
        this.liPPNodeViz.add(pPNodeViz);
        if (this.liPPNodeViz.size() > this.getNumPPNodes()) {
            throw new RuntimeException("To many nodes added!");
        }
        this.finalized = false;
        return n;
    }

    public boolean check() {
        boolean bl = true;
        int n = this.getNumPPNodes();
        for (int i = 0; i < n; ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            int n2 = pPNodeViz.getInteractionTypeCount();
            for (int j = 0; j < n2; ++j) {
                int n3 = pPNodeViz.getInteractionType(j);
                String string = InteractionAtomTypeCalculator.getString(n3);
                if (string.length() != 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected void initHistogramArray(int n) {
        super.initHistogramArray(n);
        this.liPPNodeViz = new ArrayList<PPNodeViz>();
        this.finalized = false;
    }

    public MolDistHistViz copy() {
        return new MolDistHistViz(this);
    }

    public void copy(MolDistHistViz molDistHistViz) {
        super.copy(molDistHistViz);
        molDistHistViz.flagsDescribe = this.flagsDescribe;
        if (this.molecule3D != null) {
            molDistHistViz.molecule3D = new Molecule3D(this.molecule3D);
        }
        molDistHistViz.liPPNodeViz = new ArrayList<PPNodeViz>();
        for (int i = 0; i < this.liPPNodeViz.size(); ++i) {
            molDistHistViz.liPPNodeViz.add(new PPNodeViz(this.liPPNodeViz.get(i)));
        }
        molDistHistViz.numCNodes = this.numCNodes;
        molDistHistViz.numHeteroNodes = this.numHeteroNodes;
        molDistHistViz.finalized = this.finalized;
        molDistHistViz.hsIndexInevitablePPPoints.clear();
        molDistHistViz.hsIndexInevitablePPPoints.addAll(this.hsIndexInevitablePPPoints);
    }

    public void recalculateCoordPPPoints() {
        for (PPNodeViz pPNodeViz : this.liPPNodeViz) {
            List<Integer> list = pPNodeViz.getListIndexOriginalAtoms();
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = list.get(i);
            }
            Coordinates[] coordinatesArray = new Coordinates[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                double d = this.molecule3D.getAtomX(nArray[i]);
                double d2 = this.molecule3D.getAtomY(nArray[i]);
                double d3 = this.molecule3D.getAtomZ(nArray[i]);
                coordinatesArray[i] = new Coordinates(d, d2, d3);
            }
            Coordinates coordinates = Coordinates.createBarycenter(coordinatesArray);
            pPNodeViz.setCoordinates(coordinates.x, coordinates.y, coordinates.z);
        }
    }

    public void resetInevitablePharmacophorePoints() {
        this.hsIndexInevitablePPPoints.clear();
    }

    public void resetInfoColor() {
        int n = this.getNumPPNodes();
        for (int i = 0; i < n; ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            pPNodeViz.resetInfoColor();
        }
    }

    public void createNodeIndex() {
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            this.getNode(i).setIndex(i);
        }
    }

    public int getBondAtom(int n, int n2) {
        return indexTables.getAtomPairsBondsTable(this.getNumPPNodes())[n][n2];
    }

    public int getConnAtom(int n, int n2) {
        if (n2 >= n) {
            ++n2;
        }
        return n2;
    }

    public int getConnBond(int n, int n2) {
        return indexTables.getConnectionTable(this.getNumPPNodes())[n][n2];
    }

    public int getIndexFromCoord(double d, double d2, double d3) {
        int n = -1;
        Coordinates coordinates = new Coordinates(d, d2, d3);
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            if (!pPNodeViz.getCoordinates().equals(coordinates)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getInfo(int n) {
        return this.getNode(n).getMappingIndex();
    }

    @Override
    public PPNodeViz getNode(int n) {
        return this.liPPNodeViz.get(n);
    }

    public List<PPNodeViz> getNodes() {
        return this.liPPNodeViz;
    }

    public void set(List<PPNodeViz> list) {
        this.liPPNodeViz = list;
        this.calculate();
    }

    public void set(Molecule3D molecule3D) {
        if (molecule3D != null) {
            this.molecule3D = new Molecule3D(molecule3D);
        }
    }

    public void setMappingIndex(int n, int n2) {
        this.getNode(n).setMappingIndex(n2);
    }

    public void setSimilarityMappingNodes(int n, float f) {
        this.getNode(n).setSimilarityMappingNodes(f);
    }

    public String getName() {
        return this.molecule3D.getName();
    }

    public void setName(String string) {
        this.molecule3D.setName(string);
    }

    public boolean isOnlyCarbon(int n) {
        PPNodeViz pPNodeViz = this.getNode(n);
        boolean bl = true;
        for (int i = 0; i < pPNodeViz.getInteractionTypeCount(); ++i) {
            if (pPNodeViz.getAtomicNo(i) == 6) continue;
            bl = false;
        }
        return bl;
    }

    private int calcNumHeteroNodes() {
        int n = 0;
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            if (!pPNodeViz.hasHeteroAtom()) continue;
            ++n;
        }
        return n;
    }

    public void canonize() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.liPPNodeViz.size(); ++n2) {
            this.liPPNodeViz.get(n2).realize();
            this.liPPNodeViz.get(n2).sortInteractionTypes();
        }
        n2 = 0;
        while (n2 == 0) {
            n2 = 1;
            for (n = 1; n < this.liPPNodeViz.size(); ++n) {
                int n3 = this.compareNodes(n, n - 1);
                if (n3 >= 0) continue;
                n2 = 0;
                this.swapNodes(n, n - 1);
            }
        }
        for (n = 0; n < this.liPPNodeViz.size(); ++n) {
            this.liPPNodeViz.get(n).setIndex(n);
        }
    }

    private int compareNodes(int n, int n2) {
        PPNode pPNode;
        int n3 = 0;
        PPNode pPNode2 = this.liPPNodeViz.get(n);
        n3 = pPNode2.compareTo(pPNode = (PPNode)this.liPPNodeViz.get(n2));
        if (n3 == 0) {
            int n4;
            int n5 = this.getNumPPNodes() - 1;
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n5);
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(n5);
            for (n4 = 0; n4 < this.liPPNodeViz.size(); ++n4) {
                if (n4 != n) {
                    arrayList.add(this.getDistHist(n, n4));
                }
                if (n4 == n2) continue;
                arrayList2.add(this.getDistHist(n2, n4));
            }
            class CmpHists
            implements Comparator<byte[]> {
                CmpHists() {
                }

                @Override
                public int compare(byte[] byArray, byte[] byArray2) {
                    int n = 0;
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] > byArray2[i]) {
                            n = 1;
                            break;
                        }
                        if (byArray[i] >= byArray2[i]) continue;
                        n = -1;
                        break;
                    }
                    return n;
                }
            }
            Collections.sort(arrayList, new CmpHists());
            Collections.sort(arrayList2, new CmpHists());
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                int n6 = this.compare((byte[])arrayList.get(n4), (byte[])arrayList2.get(n4));
                if (n6 == 0) continue;
                n3 = n6;
                break;
            }
        }
        return n3;
    }

    public void swapNodes(int n, int n2) {
        PPNodeViz pPNodeViz = this.liPPNodeViz.get(n);
        int n3 = this.getNumPPNodes();
        this.liPPNodeViz.set(n, this.liPPNodeViz.get(n2));
        this.liPPNodeViz.set(n2, pPNodeViz);
        for (int i = 0; i < n3; ++i) {
            if (i == n || i == n2) continue;
            byte[] byArray = this.getDistHist(n, i);
            this.setDistHist(n, i, this.getDistHist(n2, i));
            this.setDistHist(n2, i, byArray);
        }
    }

    private int compare(byte[] byArray, byte[] byArray2) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] > byArray2[i]) {
                n = 1;
                break;
            }
            if (byArray[i] >= byArray2[i]) continue;
            n = -1;
            break;
        }
        return n;
    }

    public int getNumCExclusiveNodes() {
        return this.numCNodes;
    }

    public int getNumHeteroNodes() {
        return this.numHeteroNodes;
    }

    public List<Integer> getInevitablePharmacophorePoints() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.hsIndexInevitablePPPoints);
        return arrayList;
    }

    protected HashSet<Integer> getHashSetIndexInevitablePPPoints() {
        return this.hsIndexInevitablePPPoints;
    }

    @Override
    public int getNumInevitablePharmacophorePoints() {
        return this.hsIndexInevitablePPPoints.size();
    }

    @Override
    public boolean isInevitablePharmacophorePoint(int n) {
        return this.hsIndexInevitablePPPoints.contains(n);
    }

    public boolean isAliphatic(int n) {
        boolean bl;
        block2: {
            PPNodeViz pPNodeViz;
            block1: {
                bl = true;
                pPNodeViz = this.getNode(n);
                if (this.modeFlexophore != 1) break block1;
                if (5 != pPNodeViz.get()[0]) break block2;
                bl = true;
                break block2;
            }
            for (int i = 0; i < pPNodeViz.getInteractionTypeCount(); ++i) {
                if (pPNodeViz.getAtomicNo(i) == 6) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isAcceptor(int n) {
        boolean bl;
        block2: {
            PPNodeViz pPNodeViz;
            block1: {
                bl = false;
                pPNodeViz = this.getNode(n);
                if (this.modeFlexophore != 1) break block1;
                if (IPharmacophorePoint.Functionality.ACCEPTOR.getIndex() != pPNodeViz.get()[0]) break block2;
                bl = true;
                break block2;
            }
            for (int i = 0; i < pPNodeViz.getInteractionTypeCount(); ++i) {
                if (pPNodeViz.getAtomicNo(i) != 8 && pPNodeViz.getAtomicNo(i) != 7) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isDonor(int n) {
        boolean bl;
        block2: {
            PPNodeViz pPNodeViz;
            block1: {
                bl = false;
                pPNodeViz = this.getNode(n);
                if (this.modeFlexophore != 1) break block1;
                if (IPharmacophorePoint.Functionality.DONOR.getIndex() != pPNodeViz.get()[0]) break block2;
                bl = true;
                break block2;
            }
            List<Integer> list = pPNodeViz.getListIndexOriginalAtoms();
            Molecule3D molecule3D = new Molecule3D(this.molecule3D);
            molecule3D.ensureHelperArrays(7);
            for (int n2 : list) {
                if (molecule3D.getAtomicNo(n2) != 8 && molecule3D.getAtomicNo(n2) != 7 || molecule3D.getAllHydrogens(n2) <= 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isAromatic(int n) {
        boolean bl = false;
        PPNodeViz pPNodeViz = this.getNode(n);
        if (this.modeFlexophore == 1 && IPharmacophorePoint.Functionality.AROM_RING.getIndex() == pPNodeViz.get()[0]) {
            bl = true;
        }
        return bl;
    }

    public boolean isChargePos(int n) {
        boolean bl = false;
        PPNodeViz pPNodeViz = this.getNode(n);
        if (this.modeFlexophore == 1 && IPharmacophorePoint.Functionality.POS_CHARGE.getIndex() == pPNodeViz.get()[0]) {
            bl = true;
        }
        return bl;
    }

    public boolean isChargeNeg(int n) {
        boolean bl = false;
        PPNodeViz pPNodeViz = this.getNode(n);
        if (this.modeFlexophore == 1 && IPharmacophorePoint.Functionality.NEG_CHARGE.getIndex() == pPNodeViz.get()[0]) {
            bl = true;
        }
        return bl;
    }

    private int calcNumCExclusiveNodes() {
        int n = 0;
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            if (!pPNodeViz.isCarbonExclusiveNode()) continue;
            ++n;
        }
        return n;
    }

    public void realize() {
        for (PPNodeViz pPNodeViz : this.liPPNodeViz) {
            pPNodeViz.realize();
        }
        this.canonize();
        this.calculate();
        this.finalized = true;
    }

    public void blurrSingleBinHistograms() {
        int n = this.getNumPPNodes();
        byte[] byArray = new byte[80];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                byArray = this.getDistHist(i, j, byArray);
                int n2 = 0;
                int n3 = 0;
                for (int k = 0; k < byArray.length; ++k) {
                    if (byArray[k] <= 0) continue;
                    ++n2;
                    n3 += byArray[k];
                }
                if (n2 != true || n3 < 3) continue;
                this.blurrSingleBinHistogram(byArray);
                this.setDistHist(i, j, byArray);
            }
        }
    }

    private void blurrSingleBinHistogram(byte[] byArray) {
        int n;
        int n2 = -1;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] <= 0) continue;
            n2 = n;
            break;
        }
        n = byArray[n2];
        if (n2 == 0 || n2 == byArray.length - 1) {
            byte by = (byte)((double)n - (double)n * 0.2);
            byte by2 = (byte)((double)n * 0.2);
            if (n2 == 0) {
                byArray[0] = by;
                byArray[1] = by2;
            } else if (n2 == byArray.length - 1) {
                byArray[byArray.length - 1] = by;
                byArray[byArray.length - 2] = by2;
            }
        } else {
            byte by;
            byte by3 = (byte)((double)n - 2.0 * (double)n * 0.2);
            byArray[n2 - 1] = by = (byte)((double)n * 0.2);
            byArray[n2] = by3;
            byArray[n2 + 1] = by;
        }
    }

    public void calculate() {
        this.numCNodes = this.calcNumCExclusiveNodes();
        this.numHeteroNodes = this.calcNumHeteroNodes();
    }

    protected static Molecule3D finalizeMolecule(Molecule3D molecule3D) {
        Molecule3D molecule3D2 = new Molecule3D(molecule3D);
        molecule3D2.ensureHelperArrays(7);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < molecule3D2.getAllAtoms(); ++i) {
            if (molecule3D2.getConnAtoms(i) != 0) continue;
            hashSet.add(i);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        for (Integer n : arrayList) {
            molecule3D2.deleteAtom(n);
        }
        return molecule3D2;
    }

    public MolDistHist getMolDistHist() {
        int n;
        this.realize();
        int n2 = this.getNumPPNodes();
        MolDistHist molDistHist = new MolDistHist(n2);
        for (n = 0; n < n2; ++n) {
            molDistHist.addNode(this.getNode(n));
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                molDistHist.setDistHist(n, i, this.getDistHist(n, i));
            }
        }
        return molDistHist;
    }

    public double getMaximumDistanceInPPPoint(int n) {
        double d = 0.0;
        PPNodeViz pPNodeViz = this.getNode(n);
        List<Integer> list = pPNodeViz.getListIndexOriginalAtoms();
        ArrayList<Coordinates> arrayList = new ArrayList<Coordinates>();
        for (int n2 : list) {
            Coordinates coordinates = this.molecule3D.getCoordinates(n2);
            arrayList.add(coordinates);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Coordinates coordinates = (Coordinates)arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Coordinates coordinates2 = (Coordinates)arrayList.get(j);
                double d2 = coordinates.distance(coordinates2);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public Molecule3D getMolecule() {
        if (this.molecule3D == null) {
            return null;
        }
        return this.molecule3D;
    }

    public Molecule3D getMoleculeRemovedUnrelatedAtoms() {
        int n;
        Serializable serializable;
        Molecule3D molecule3D = MolDistHistViz.finalizeMolecule(this.molecule3D);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            serializable = this.getNode(i);
            List<Integer> list = ((PPNodeViz)serializable).getListIndexOriginalAtoms();
            hashSet.addAll(list);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        serializable = new HashSet();
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                int[] nArray = StructureCalculator.getAtomsOnPath(molecule3D, (Integer)arrayList.get(n), (Integer)arrayList.get(i));
                for (int j = 0; j < nArray.length; ++j) {
                    ((HashSet)serializable).add(nArray[j]);
                }
            }
        }
        hashSet.addAll((Collection<Integer>)((Object)serializable));
        for (n = molecule3D.getAllAtoms() - 1; n >= 0; --n) {
            if (hashSet.contains(n)) continue;
            molecule3D.deleteAtom(n);
        }
        return molecule3D;
    }

    public int hashCode() {
        String string = this.toString();
        string = string.replace(" ", "");
        return string.hashCode();
    }

    public String toStringInevitable() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Index inevitable ");
        for (int n : this.hsIndexInevitablePPPoints) {
            stringBuilder.append(n + " ");
        }
        stringBuilder.append("\n");
        stringBuilder.append("Num inevitable " + this.hsIndexInevitablePPPoints.size());
        return stringBuilder.toString();
    }

    public String toString() {
        int n;
        if (!this.finalized) {
            this.realize();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            stringBuffer.append(this.getNode(n).toString());
            if (n < this.getNumPPNodes() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("]");
        }
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            for (int i = n + 1; i < this.getNumPPNodes(); ++i) {
                byte[] byArray = this.getDistHist(n, i);
                if (byArray == null) continue;
                stringBuffer.append("[" + ArrayUtilsCalc.toString(byArray) + "]");
            }
        }
        return stringBuffer.toString();
    }

    public String toStringNodesText() {
        if (!this.finalized) {
            this.realize();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            stringBuffer.append(pPNodeViz.toString());
            if (i < this.getNumPPNodes() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toStringPPNodesText() {
        if (!this.finalized) {
            this.realize();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            stringBuffer.append(pPNodeViz.toStringPPNodeText());
            if (i < this.getNumPPNodes() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toStringPPNodesElusive() {
        if (!this.finalized) {
            this.realize();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.getNumPPNodes(); ++i) {
            PPNodeViz pPNodeViz = this.getNode(i);
            stringBuffer.append(pPNodeViz.toStringElusive());
            if (i < this.getNumPPNodes() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toStringShort() {
        int n;
        if (!this.finalized) {
            this.realize();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            stringBuffer.append(this.getNode(n).toStringShort());
            if (n < this.getNumPPNodes() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append("]");
        }
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            for (int i = n + 1; i < this.getNumPPNodes(); ++i) {
                byte[] byArray = this.getDistHist(n, i);
                if (byArray == null) continue;
                stringBuffer.append("[" + ArrayUtilsCalc.toString(byArray) + "]");
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        Object object2;
        int n;
        boolean bl = true;
        MolDistHistViz molDistHistViz = null;
        try {
            molDistHistViz = (MolDistHistViz)object;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        if (this.getNumPPNodes() != molDistHistViz.getNumPPNodes()) {
            return false;
        }
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            PPNodeViz pPNodeViz = this.getNode(n);
            if (pPNodeViz.equals(object2 = molDistHistViz.getNode(n))) continue;
            bl = false;
            break;
        }
        for (n = 0; n < this.getNumPPNodes(); ++n) {
            block4: for (int i = n + 1; i < this.getNumPPNodes(); ++i) {
                object2 = this.getDistHist(n, i);
                byte[] byArray = molDistHistViz.getDistHist(n, i);
                for (int j = 0; j < byArray.length; ++j) {
                    if (object2[j] == byArray[j]) continue;
                    bl = false;
                    continue block4;
                }
            }
        }
        return bl;
    }

    public void setDistanceTables(List<double[][]> list) {
        this.liDistanceTable = new ArrayList<float[][]>();
        for (double[][] dArray : list) {
            float[][] fArray = new float[dArray.length][dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    fArray[i][j] = (float)dArray[i][j];
                }
            }
            this.liDistanceTable.add(fArray);
        }
    }

    public List<float[][]> getDistanceTables() {
        return this.liDistanceTable;
    }

    protected static String formatDescription(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashSet<Object> hashSet = new HashSet<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (hashSet.contains(object)) continue;
            hashSet.add(object);
        }
        object = new ArrayList(hashSet);
        Collections.sort(object);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < object.size(); ++i) {
            if (i > 0 && i < object.size() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append((String)object.get(i));
        }
        return stringBuilder.toString();
    }

    public static void merge(MolDistHistViz molDistHistViz, MolDistHist molDistHist) {
        int n;
        if (molDistHist.getNumPPNodes() != molDistHistViz.getNumPPNodes()) {
            throw new RuntimeException("Size differs.");
        }
        for (n = 0; n < molDistHist.getNumPPNodes(); ++n) {
            if (molDistHist.getNode(n).equalAtoms(molDistHistViz.getNode(n))) continue;
            throw new RuntimeException("Node " + n + " differs. " + molDistHist.getNode(n) + "<>" + molDistHistViz.getNode(n) + " " + molDistHist.getNode(n).getAtomicNo(n) + " " + molDistHistViz.getNode(n).getAtomicNo(n));
        }
        for (n = 0; n < molDistHist.getNumPPNodes(); ++n) {
            for (int i = 1 + n; i < molDistHist.getNumPPNodes(); ++i) {
                molDistHistViz.setDistHist(n, i, molDistHist.getDistHist(n, i));
            }
        }
    }

    public static MolDistHistViz summarizeAlkaneCluster(MolDistHistViz molDistHistViz, int n) {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        List<ClusterNode> list = molDistHistViz.getClusterCenter(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n5 = 0; n5 < molDistHistViz.getNumPPNodes(); ++n5) {
            arrayList.add(n5);
        }
        for (n5 = 0; n5 < list.size(); ++n5) {
            ClusterNode clusterNode = list.get(n5);
            PPNodeViz pPNodeViz = molDistHistViz.getNode(clusterNode.getIndexCenter());
            List<Integer> list2 = clusterNode.getClusterMember();
            for (int i = list2.size() - 1; i >= 0; --i) {
                object = molDistHistViz.getNode(list2.get(i));
                if (!((PPNode)object).isCarbonExclusiveNode()) continue;
                arrayList.remove(list2.get(i));
                n4 = ((PPNode)object).getInteractionTypeCount();
                n3 = 0;
                for (int j = 0; j < n4; ++j) {
                    int n6 = ((PPNode)object).getInteractionType(j);
                    if (pPNodeViz.containsInteractionID(n6)) continue;
                    pPNodeViz.add(n6);
                    n3 = 1;
                }
                if (n3 == 0) continue;
                pPNodeViz.realize();
            }
        }
        MolDistHistViz molDistHistViz2 = new MolDistHistViz(arrayList.size(), molDistHistViz.getMolecule());
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            molDistHistViz2.addNode(molDistHistViz.getNode((Integer)arrayList.get(n2)));
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            for (int i = n2 + 1; i < arrayList.size(); ++i) {
                molDistHistViz2.setDistHist(n2, i, molDistHistViz.getDistHist((Integer)arrayList.get(n2), (Integer)arrayList.get(i)));
            }
        }
        if (molDistHistViz.getDistanceTables() != null) {
            List<float[][]> list3 = molDistHistViz.getDistanceTables();
            ArrayList<float[][]> arrayList2 = new ArrayList<float[][]>();
            for (float[][] fArray : list3) {
                object = new float[arrayList.size()][arrayList.size()];
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        object[n4][n3] = fArray[(Integer)arrayList.get(n4)][(Integer)arrayList.get(n3)];
                    }
                }
                arrayList2.add((float[][])object);
            }
            molDistHistViz2.liDistanceTable = arrayList2;
        }
        molDistHistViz2.realize();
        return molDistHistViz2;
    }

    static {
        COLORS = new String[]{"aquamarine", "blue", "violet", "cyan", "green", "lavender", "lime", "limegreen", "linen", "magenta", "maroon", "olive", "purple", "red", "tan", "turquoise", "yellow"};
    }
}

