/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import java.util.ArrayList;
import java.util.List;

public class MDHIndexTables {
    private static MDHIndexTables INSTANCE = null;
    private static final int MAX_SIZE = 50;
    private List<int[][]> liArrAtPairsBonds;
    private List<int[][]> liConnectionTable;

    private MDHIndexTables() {
        this.init();
    }

    public static MDHIndexTables getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MDHIndexTables();
        }
        return INSTANCE;
    }

    private void init() {
        int n;
        this.liArrAtPairsBonds = new ArrayList<int[][]>();
        this.liArrAtPairsBonds.add(0, null);
        this.liArrAtPairsBonds.add(1, null);
        for (n = 2; n < 51; ++n) {
            this.liArrAtPairsBonds.add(n, this.createBondTable(n));
        }
        this.liConnectionTable = new ArrayList<int[][]>();
        this.liConnectionTable.add(0, null);
        this.liConnectionTable.add(1, null);
        for (n = 2; n < 51; ++n) {
            this.liConnectionTable.add(n, this.createConnectionTable(n));
        }
    }

    private int[][] createBondTable(int n) {
        int n2 = (n * n - n) / 2;
        int[][] nArray = new int[2][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = i + 1;
            while (n4 < n) {
                nArray[0][n3] = i;
                nArray[1][n3] = n4++;
                ++n3;
            }
        }
        return nArray;
    }

    private int[][] createConnectionTable(int n) {
        int[][] nArray = this.liArrAtPairsBonds.get(n);
        int n2 = (n * n - n) / 2;
        int[][] nArray2 = new int[n][n - 1];
        int[] nArray3 = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[0][n3];
            int n5 = nArray[1][n3];
            int n6 = n4;
            int n7 = nArray3[n6];
            nArray3[n6] = n7 + 1;
            nArray2[n4][n7] = n3;
            int n8 = n5;
            int n9 = nArray3[n8];
            nArray3[n8] = n9 + 1;
            nArray2[n5][n9] = n3++;
        }
        return nArray2;
    }

    public int[][] getAtomPairsBondsTable(int n) {
        return this.liArrAtPairsBonds.get(n);
    }

    public int[][] getConnectionTable(int n) {
        return this.liConnectionTable.get(n);
    }
}

