/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.flexophore.DistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.util.datamodel.IntVec;
import java.util.ArrayList;

public class DistHistEncoder {
    private static DistHistEncoder INSTANCE;
    private int iNBitsEntriesCountOneHistogram;
    private int iNBitsPos;
    private int iNBitsConsequentEntries;
    private int iNBitsCountOneField;

    public DistHistEncoder() {
        this.init();
    }

    private void init() {
        int n = 250;
        int n2 = 80;
        int n3 = 40;
        this.iNBitsEntriesCountOneHistogram = 1;
        while (Math.pow(2.0, this.iNBitsEntriesCountOneHistogram) < (double)n3) {
            ++this.iNBitsEntriesCountOneHistogram;
        }
        this.iNBitsConsequentEntries = this.iNBitsEntriesCountOneHistogram;
        this.iNBitsPos = 1;
        while (Math.pow(2.0, this.iNBitsPos) < (double)n2) {
            ++this.iNBitsPos;
        }
        this.iNBitsCountOneField = 1;
        while (Math.pow(2.0, this.iNBitsCountOneField) < (double)n) {
            ++this.iNBitsCountOneField;
        }
    }

    public String encodeHistograms(DistHist distHist) {
        int n;
        int n2;
        int n3 = distHist.getNumPPNodes();
        if (distHist.getNumPPNodes() == 1) {
            return "";
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (n2 = i + 1; n2 < n3; ++n2) {
                byte[] byArray = distHist.getDistHist(i, n2);
                n = 0;
                for (int j = 0; j < byArray.length; ++j) {
                    if (byArray[j] <= 0) continue;
                    ++n;
                }
                n4 += this.iNBitsEntriesCountOneHistogram + n * (this.iNBitsPos + this.iNBitsCountOneField + this.iNBitsConsequentEntries);
            }
        }
        boolean[] blArray = new boolean[n4];
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            for (n = i + 1; n < n3; ++n) {
                int n5;
                byte[] byArray = distHist.getDistHist(i, n);
                int n6 = 0;
                for (n5 = 0; n5 < byArray.length; ++n5) {
                    if (byArray[n5] <= 0) continue;
                    ++n6;
                }
                for (n5 = 0; n5 < this.iNBitsEntriesCountOneHistogram; ++n5) {
                    if ((n6 & 1) == 1) {
                        blArray[n2] = true;
                    }
                    n6 >>>= 1;
                    ++n2;
                }
                n5 = 0;
                int n7 = 0;
                while (n5 == 0) {
                    if (byArray[n7] > 0) {
                        int n8;
                        int n9;
                        int n10;
                        int n11 = n7;
                        for (n10 = 0; n10 < this.iNBitsPos; ++n10) {
                            if ((n11 & 1) == 1) {
                                blArray[n2] = true;
                            }
                            n11 >>>= 1;
                            ++n2;
                        }
                        n10 = 1;
                        for (n9 = n7 + 1; n9 < byArray.length && byArray[n9] > 0; ++n9) {
                            ++n10;
                        }
                        n9 = n10;
                        for (n8 = 0; n8 < this.iNBitsConsequentEntries; ++n8) {
                            if ((n9 & 1) == 1) {
                                blArray[n2] = true;
                            }
                            n9 >>>= 1;
                            ++n2;
                        }
                        n8 = n7;
                        int n12 = n7 + n10;
                        for (int j = n8; j < n12; ++j) {
                            int n13 = byArray[j];
                            for (int k = 0; k < this.iNBitsCountOneField; ++k) {
                                if ((n13 & 1) == 1) {
                                    blArray[n2] = true;
                                }
                                n13 >>>= 1;
                                ++n2;
                            }
                        }
                        n7 += n10;
                    }
                    if (++n7 < byArray.length) continue;
                    n5 = 1;
                }
            }
        }
        boolean[] blArray2 = new boolean[n2];
        System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
        IntVec intVec = new IntVec(blArray2);
        String string = new String(new DescriptorEncoder().encode(intVec.get()));
        return string;
    }

    public void decodeHistograms(String string, MolDistHist molDistHist) {
        int n;
        int n2;
        int n3;
        IntVec intVec = new IntVec(new DescriptorEncoder().decode(string));
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        boolean bl = false;
        int n4 = 0;
        while (!bl && (n3 = DistHistEncoder.getDecodedValue(intVec, n4, this.iNBitsEntriesCountOneHistogram)) != 0) {
            int n5;
            n4 += this.iNBitsEntriesCountOneHistogram;
            byte[] byArray = new byte[80];
            for (n2 = 0; n2 != n3; n2 += n5) {
                n = DistHistEncoder.getDecodedValue(intVec, n4, this.iNBitsPos);
                n5 = DistHistEncoder.getDecodedValue(intVec, n4 += this.iNBitsPos, this.iNBitsConsequentEntries);
                n4 += this.iNBitsConsequentEntries;
                for (int i = 0; i < n5; ++i) {
                    int n6 = DistHistEncoder.getDecodedValue(intVec, n4, this.iNBitsCountOneField);
                    n4 += this.iNBitsCountOneField;
                    byArray[n++] = (byte)n6;
                }
            }
            arrayList.add(byArray);
            if (n4 + this.iNBitsEntriesCountOneHistogram < intVec.sizeBits()) continue;
            break;
        }
        if ((n3 = DistHistEncoder.getNumNodes(arrayList.size())) == 0) {
            throw new RuntimeException("Number of pharmacophore points is 0.");
        }
        int n7 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3; ++n) {
                molDistHist.setDistHist(n2, n, (byte[])arrayList.get(n7++));
            }
        }
    }

    private static int getNumNodes(int n) {
        int n2 = 0;
        for (int i = 0; i <= n; i += ++n2) {
        }
        return n2;
    }

    private static int getDecodedValue(IntVec intVec, int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n3 - 1; i >= n; --i) {
            n4 <<= 1;
            if (!intVec.isBitSet(i)) continue;
            n4 |= 1;
        }
        return n4;
    }

    public static DistHistEncoder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DistHistEncoder();
        }
        return INSTANCE;
    }
}

