/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.descriptor.flexophore.ClusterNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DistHist
implements Serializable {
    private static final long serialVersionUID = 17042013L;
    protected byte[] arrDistHists;
    private int numPPNodes;
    private int identifier;

    public DistHist() {
        this.arrDistHists = new byte[0];
        this.numPPNodes = 0;
        this.identifier = -1;
    }

    public DistHist(int n) {
        this.initHistogramArray(n);
    }

    public DistHist(DistHist distHist) {
        distHist.copy(this);
    }

    public void copy(DistHist distHist) {
        distHist.identifier = this.identifier;
        if (distHist.numPPNodes != this.numPPNodes) {
            distHist.numPPNodes = this.numPPNodes;
            distHist.arrDistHists = new byte[this.arrDistHists.length];
        }
        System.arraycopy(this.arrDistHists, 0, distHist.arrDistHists, 0, this.arrDistHists.length);
    }

    public int getBonds() {
        return (this.numPPNodes * this.numPPNodes - this.numPPNodes) / 2;
    }

    public int getNumPPNodes() {
        return this.numPPNodes;
    }

    public int getSizeBytes() {
        int n = 0;
        if (this.getNumPPNodes() > 1) {
            n += this.arrDistHists.length;
        }
        return n += 8;
    }

    protected void initHistogramArray(int n) {
        this.numPPNodes = n;
        int n2 = (this.numPPNodes * this.numPPNodes - this.numPPNodes) / 2;
        this.arrDistHists = new byte[n2 * 80];
    }

    public static final int getIndex(int n, int n2, int n3) {
        int n4 = Math.min(n, n2);
        int n5 = Math.max(n, n2);
        int n6 = n4 + 1;
        int n7 = n4 * n3 + n5 - (n6 * n6 - n6) / 2 - n6;
        return n7;
    }

    public int getMinDist(int n, int n2) {
        byte[] byArray = this.getDistHist(n, n2);
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public List<ClusterNode> getClusterCenter(int n) {
        int n2;
        Object object;
        int n3;
        ClusterNode clusterNode;
        int n4;
        ArrayList<ClusterNode> arrayList = new ArrayList<ClusterNode>();
        for (n4 = 0; n4 < this.getNumPPNodes(); ++n4) {
            clusterNode = new ClusterNode(n4);
            for (n3 = 0; n3 < this.getNumPPNodes(); ++n3) {
                if (n4 == n3) continue;
                object = this.getDistHist(n4, n3);
                n2 = 0;
                for (int i = 0; i < n + 1; ++i) {
                    if (object[i] <= 0) continue;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) continue;
                clusterNode.add(n3);
            }
            if (!clusterNode.isCluster()) continue;
            arrayList.add(clusterNode);
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            clusterNode = (ClusterNode)arrayList.get(n4);
            n3 = ClusterNode.getRMSD(clusterNode, this);
            clusterNode.setRMSD(n3);
        }
        ArrayList<ClusterNode> arrayList2 = new ArrayList<ClusterNode>();
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            ClusterNode clusterNode2 = (ClusterNode)arrayList.get(i);
            object = new ArrayList();
            object.add(clusterNode2);
            for (n2 = arrayList.size() - 1; n2 > i; --n2) {
                if (!clusterNode2.equals(arrayList.get(n2))) continue;
                object.add(arrayList.remove(n2));
            }
            Collections.sort(object);
            arrayList2.add((ClusterNode)object.get(0));
        }
        return arrayList2;
    }

    public void setDistHist(int n, int n2, byte[] byArray) {
        if (n >= this.numPPNodes) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 >= this.numPPNodes) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = DistHist.getIndex(n, n2, this.numPPNodes);
        int n4 = n3 * 80;
        System.arraycopy(byArray, 0, this.arrDistHists, n4, 80);
    }

    public byte[] getDistHists() {
        return this.arrDistHists;
    }

    public void setDistHists(byte[] byArray, int n, int n2) {
        this.arrDistHists = byArray;
        this.numPPNodes = n;
        this.identifier = n2;
    }

    public byte[] getDistHist(int n, int n2) {
        int n3 = DistHist.getIndex(n, n2, this.numPPNodes);
        int n4 = n3 * 80;
        byte[] byArray = new byte[80];
        System.arraycopy(this.arrDistHists, n4, byArray, 0, 80);
        return byArray;
    }

    public int getIndexPosStartForDistHist(int n, int n2) {
        int n3 = DistHist.getIndex(n, n2, this.numPPNodes);
        int n4 = n3 * 80;
        return n4;
    }

    public byte getValueAtAbsolutePosition(int n) {
        return this.arrDistHists[n];
    }

    public byte[] getDistHist(int n, int n2, byte[] byArray) {
        int n3 = DistHist.getIndex(n, n2, this.numPPNodes);
        int n4 = n3 * 80;
        System.arraycopy(this.arrDistHists, n4, byArray, 0, 80);
        return byArray;
    }

    public double getRelMaxDistInHist(int n, int n2) {
        byte[] byArray = this.getDistHist(n, n2);
        double d = -2.147483648E9;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] <= 0) continue;
            d = i;
            break;
        }
        return d / (double)byArray.length;
    }

    public double getMaxDistInHist(int n, int n2) {
        byte[] byArray = this.getDistHist(n, n2);
        double d = -2.147483648E9;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] <= 0) continue;
            d = i;
            break;
        }
        return d;
    }

    public double getRelMaxDistInHist() {
        int n = this.getNumPPNodes();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d2 = this.getRelMaxDistInHist(i, j);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public String toStringHistsIndexed() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numPPNodes; ++i) {
            for (int j = i + 1; j < this.numPPNodes; ++j) {
                byte[] byArray = this.getDistHist(i, j);
                if (byArray == null) continue;
                stringBuffer.append(i + "\t" + j + "\t[" + ArrayUtilsCalc.toString(byArray) + "]\n");
            }
        }
        return stringBuffer.toString();
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }
}

