/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.descriptor.flexophore.DistHist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClusterNode
implements Comparable<ClusterNode> {
    private int indexCenter;
    private List<Integer> liIndexMember;
    private int rmsd;

    public ClusterNode(int n) {
        this.indexCenter = n;
        this.liIndexMember = new ArrayList<Integer>();
        this.rmsd = 0;
    }

    public void add(int n) {
        this.liIndexMember.add(n);
    }

    @Override
    public int compareTo(ClusterNode clusterNode) {
        return Double.compare(this.rmsd, clusterNode.rmsd);
    }

    public boolean equals(Object object) {
        boolean bl = true;
        ClusterNode clusterNode = (ClusterNode)object;
        if (this.liIndexMember.size() != clusterNode.liIndexMember.size()) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.liIndexMember);
        arrayList.add(this.indexCenter);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(clusterNode.liIndexMember);
        arrayList2.add(clusterNode.indexCenter);
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            int n2 = (Integer)arrayList.get(i);
            if (n2 == (n = ((Integer)arrayList2.get(i)).intValue())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public int getIndexCenter() {
        return this.indexCenter;
    }

    public int getRMSD() {
        return this.rmsd;
    }

    public void setRMSD(int n) {
        this.rmsd = n;
    }

    public static int getRMSD(ClusterNode clusterNode, DistHist distHist) {
        int n = 0;
        List<Integer> list = clusterNode.getClusterMember();
        for (int i = 0; i < list.size(); ++i) {
            int n2 = distHist.getMinDist(clusterNode.getIndexCenter(), list.get(i));
            n += n2 * n2;
        }
        return n;
    }

    public List<Integer> getClusterMember() {
        return this.liIndexMember;
    }

    public boolean isCluster() {
        return this.liIndexMember.size() > 0;
    }
}

