/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class SimpleFragmentGraph {
    private static final int HASH_INIT = 13;
    private static final int MAX_CONN_ATOMS = 8;
    private static final int ATOM_INDEX_BITS = 4;
    private static final int BOND_DESC_BITS = 2;
    private static final long ATOM_INDEX_MASK = 15L;
    private int[] mConnAtoms;
    private int[] mFragmentAtomFromOrig;
    private int[] mCanRank;
    private int[] mGraphAtom;
    private int[] mGraphIndex;
    private int[][] mConnAtom;
    private int[][] mConnBond;
    private int[][] mConnRank;
    private int mAtoms;
    private int mBonds;
    private byte[] mAtomDescriptor;
    private byte[] mBondDescriptor;
    private byte[] mBuffer;

    public SimpleFragmentGraph(int n) {
        this.init(n, 256);
    }

    public SimpleFragmentGraph(StereoMolecule stereoMolecule, int[] nArray, int n) {
        stereoMolecule.ensureHelperArrays(1);
        this.init(n, stereoMolecule.getAtoms());
        this.setMolecule(stereoMolecule, nArray, n);
    }

    private void init(int n, int n2) {
        int n3 = n + 1;
        this.mAtomDescriptor = new byte[n3];
        this.mBondDescriptor = new byte[n];
        this.mConnAtoms = new int[n3];
        this.mCanRank = new int[n3];
        this.mGraphAtom = new int[n3];
        this.mGraphIndex = new int[n3];
        this.mFragmentAtomFromOrig = new int[n2];
        this.mConnAtom = new int[n3][8];
        this.mConnBond = new int[n3][8];
        this.mConnRank = new int[9][];
        for (int i = 1; i <= 8; ++i) {
            this.mConnRank[i] = new int[i];
        }
        this.mBuffer = new byte[3 * n];
    }

    public void set(StereoMolecule stereoMolecule, int[] nArray, int n) {
        this.mAtoms = 0;
        this.mBonds = 0;
        int n2 = this.mFragmentAtomFromOrig.length;
        if (n2 < stereoMolecule.getAtoms()) {
            while ((n2 *= 2) < stereoMolecule.getAtoms()) {
            }
            this.mFragmentAtomFromOrig = new int[n2];
        }
        stereoMolecule.ensureHelperArrays(1);
        this.setMolecule(stereoMolecule, nArray, n);
    }

    private void setMolecule(StereoMolecule stereoMolecule, int[] nArray, int n) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        Arrays.fill(this.mConnAtoms, 0);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = nArray[i];
            for (n3 = 0; n3 < 2; ++n3) {
                n2 = stereoMolecule.getBondAtom(n3, n4);
                if (blArray[n2]) continue;
                blArray[n2] = true;
                this.mFragmentAtomFromOrig[n2] = this.mAtoms;
                this.mAtomDescriptor[this.mAtoms++] = this.createAtomDescriptor(stereoMolecule, n2);
            }
            for (n3 = 0; n3 < 2; ++n3) {
                n2 = stereoMolecule.getBondAtom(n3, n4);
                int n5 = this.mFragmentAtomFromOrig[n2];
                this.mConnAtom[n5][this.mConnAtoms[n5]] = this.mFragmentAtomFromOrig[stereoMolecule.getBondAtom(1 - n3, n4)];
                this.mConnBond[n5][this.mConnAtoms[n5]] = this.mBonds;
                int n6 = n5;
                this.mConnAtoms[n6] = this.mConnAtoms[n6] + 1;
            }
            this.mBondDescriptor[this.mBonds++] = this.createBondDescriptor(stereoMolecule, n4);
        }
    }

    public int createHashValue(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long[] lArray = new long[this.mAtoms];
        for (n6 = 0; n6 < this.mAtoms; ++n6) {
            lArray[n6] = (this.mAtomDescriptor[n6] << 4) + n6;
        }
        Arrays.sort(lArray);
        n6 = 1;
        for (n5 = 0; n5 < this.mAtoms; ++n5) {
            if (n5 == 0 || ((lArray[n5] ^ lArray[n5 - 1]) & 0xFFFFFFFFFFFFFFF0L) != 0L) {
                // empty if block
            }
            this.mCanRank[(int)(lArray[n5] & 0xFL)] = ++n6;
        }
        while (true) {
            for (n5 = 0; n5 < this.mAtoms; ++n5) {
                int[] nArray = this.mConnRank[this.mConnAtoms[n5]];
                for (n4 = 0; n4 < this.mConnAtoms[n5]; ++n4) {
                    nArray[n4] = this.mBondDescriptor[this.mConnBond[n5][n4]] << 4 | this.mCanRank[this.mConnAtom[n5][n4]];
                }
                Arrays.sort(nArray);
                lArray[n5] = this.mCanRank[n5];
                for (n4 = 0; n4 < this.mConnAtoms[n5]; ++n4) {
                    lArray[n5] = lArray[n5] << 6 | (long)nArray[n4];
                }
                lArray[n5] = lArray[n5] << 4 | (long)n5;
            }
            Arrays.sort(lArray);
            n5 = 1;
            for (n3 = 0; n3 < this.mAtoms; ++n3) {
                if (n3 == 0 || ((lArray[n3] ^ lArray[n3 - 1]) & 0xFFFFFFFFFFFFFFF0L) != 0L) {
                    // empty if block
                }
                this.mCanRank[(int)(lArray[n3] & 0xFL)] = ++n5;
            }
            if (n5 == n6) break;
            n6 = n5;
        }
        n5 = -1;
        n3 = -1;
        for (n4 = 0; n4 < this.mAtoms; ++n4) {
            if (n5 >= this.mCanRank[n4]) continue;
            n5 = this.mCanRank[n4];
            n3 = n4;
        }
        boolean[] blArray = new boolean[this.mAtoms];
        boolean[] blArray2 = new boolean[this.mBonds];
        this.mGraphAtom[0] = n3;
        this.mGraphIndex[n3] = 0;
        blArray[n3] = true;
        int n7 = this.mBonds - this.mAtoms + 1;
        int n8 = 1;
        int n9 = this.mAtoms;
        int n10 = this.mAtoms + this.mBonds - n7;
        this.mBuffer[0] = (byte)(this.mAtomDescriptor[n3] << 4 | n7);
        int n11 = -1;
        int n12 = 0;
        int n13 = 0;
        while (n12 <= n13) {
            n2 = this.mGraphAtom[n12];
            n5 = -1;
            n3 = -1;
            for (int i = 0; i < this.mConnAtoms[n2]; ++i) {
                int n14;
                int n15 = this.mConnBond[n2][i];
                if (blArray2[n15] || n5 >= this.mCanRank[n14 = this.mConnAtom[n2][i]]) continue;
                n5 = this.mCanRank[n14];
                n3 = n14;
                n11 = n15;
            }
            if (n5 != -1) {
                if (blArray[n3]) {
                    this.mBuffer[n10++] = (byte)(this.mGraphIndex[n2] << 4 | this.mGraphIndex[n3]);
                    this.mBuffer[n10++] = this.mBondDescriptor[n11];
                } else {
                    this.mGraphIndex[n3] = ++n13;
                    this.mGraphAtom[n13] = n3;
                    blArray[n3] = true;
                    this.mBuffer[n8++] = this.mAtomDescriptor[n3];
                    this.mBuffer[n9++] = (byte)(this.mGraphIndex[n2] << 2 | this.mBondDescriptor[n11]);
                }
                blArray2[n11] = true;
                continue;
            }
            ++n12;
        }
        n2 = BurtleHasher.hashlittle(this.mBuffer, 13L, this.mAtoms + this.mBonds + (this.mBonds - this.mAtoms + 1));
        return n2 & BurtleHasher.hashmask(n);
    }

    private byte createAtomDescriptor(StereoMolecule stereoMolecule, int n) {
        return (byte)stereoMolecule.getAtomicNo(n);
    }

    private byte createBondDescriptor(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.isDelocalizedBond(n)) {
            return 0;
        }
        int n2 = Math.min(3, stereoMolecule.getBondOrder(n));
        return (byte)(n2 == 0 ? 3 : n2);
    }
}

