/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.calc.distance.DistanceMetrics;
import com.actelion.research.chem.descriptor.ISimilarityCalculator;
import com.actelion.research.chem.descriptor.SimilarityCalculatorInfo;

public class SimilarityCalculatorDoubleArray
implements ISimilarityCalculator<double[]> {
    public static final String NAME = "SimilarityCalculatorDoubleArray";
    public static final String SHORT_NAME = "SimCalcDblArray";

    @Override
    public float getSimilarity(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return Float.NaN;
        }
        return (float)DistanceMetrics.getCosine(dArray, dArray2);
    }

    @Override
    public SimilarityCalculatorInfo getInfo() {
        return new SimilarityCalculatorInfo(NAME, SHORT_NAME);
    }

    @Override
    public ISimilarityCalculator<double[]> getThreadSafeCopy() {
        return new SimilarityCalculatorDoubleArray();
    }
}

