/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public class FingerPrintGenerator {
    private static final int MAX_BITS = 512;
    private static final int MAX_DEPTH = 6;
    private static final boolean DEBUG = false;
    private static int debugCounter = 0;
    private Hashtable paths;

    public BitSet getFingerprint(StereoMolecule stereoMolecule) {
        return this.getFingerprint(stereoMolecule, 512);
    }

    public BitSet getFingerprint(StereoMolecule stereoMolecule, int n) {
        String string = null;
        stereoMolecule.ensureHelperArrays(7);
        this.findAllPaths(stereoMolecule);
        BitSet bitSet = new BitSet(n);
        Enumeration enumeration = this.paths.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            int n2 = new Random(string.hashCode()).nextInt(n);
            bitSet.set(n2);
        }
        return bitSet;
    }

    private static boolean matches(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.and(bitSet2);
        return bitSet3.equals(bitSet2);
    }

    public static byte[] getBitSetBits(BitSet bitSet) {
        int n = bitSet.size();
        int n2 = n % 8 == 0 ? n / 8 : n / 8 + 1;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n; ++i) {
            int n3;
            if (!bitSet.get(i)) continue;
            byte by = (byte)(1 << 7 - i % 8);
            int n4 = n3 = i / 8;
            byArray[n4] = (byte)(byArray[n4] | by);
        }
        return byArray;
    }

    private void findAllPaths(StereoMolecule stereoMolecule) {
        this.paths = new Hashtable();
        debugCounter = 0;
        int n = stereoMolecule.getAtoms();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            String string = stereoMolecule.getAtomLabel(i);
            for (int j = 0; j < n; ++j) {
                blArray[j] = false;
            }
            this.addPath(string);
            this.traverseDFS(stereoMolecule, -1, i, string, 0, blArray);
        }
    }

    private void traverseDFS(StereoMolecule stereoMolecule, int n, int n2, String string, int n3, boolean[] blArray) {
        int n4 = stereoMolecule.getConnAtoms(n2) + stereoMolecule.getMetalBondedConnAtoms(n2);
        int n5 = 0;
        int n6 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ++n3;
        for (int i = 0; i < n4; ++i) {
            blArray[n2] = true;
            n5 = stereoMolecule.getConnAtom(n2, i);
            if (n5 == n || blArray[n5]) continue;
            n6 = stereoMolecule.getConnBond(n2, i);
            stringBuilder.setLength(0);
            stringBuilder.append(string);
            if (stereoMolecule.isDelocalizedBond(n6) || stereoMolecule.isAromaticBond(n6)) {
                stringBuilder.append(":");
            } else if (stereoMolecule.getBondOrder(n6) == 1) {
                stringBuilder.append("-");
            } else if (stereoMolecule.getBondOrder(n6) == 2) {
                stringBuilder.append("=");
            } else if (stereoMolecule.getBondOrder(n6) >= 3) {
                stringBuilder.append("#");
            } else if (stereoMolecule.getBondOrder(n6) == 0) {
                stringBuilder.append(".");
            } else {
                System.out.println("FingerPrintGenerator.depthFirstSearch() Error: Invalid Bond order! " + stereoMolecule.getBondOrder(n6));
            }
            stringBuilder.append(stereoMolecule.getAtomLabel(n5));
            blArray[n5] = true;
            this.addPath(stringBuilder.toString());
            if (n3 == 6) {
                blArray[n5] = false;
            }
            if (n3 >= 6) continue;
            this.traverseDFS(stereoMolecule, n2, n5, stringBuilder.toString(), n3, blArray);
            blArray[n5] = false;
        }
    }

    private boolean addPath(String string) {
        String string2 = string;
        String string3 = new StringBuilder(string2).reverse().toString();
        boolean bl = false;
        if (string3.compareTo(string) < 0) {
            string2 = string3;
        }
        if (!this.paths.containsKey(string2)) {
            this.paths.put(string2, string2);
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "sFp@DiTt@@@@ S~x>xixix>";
        IDCodeParser iDCodeParser = new IDCodeParser(false);
        StereoMolecule stereoMolecule = new StereoMolecule();
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        FingerPrintGenerator fingerPrintGenerator = null;
        try {
            String string2;
            if (stringArray.length > 0) {
                System.out.println("Query set");
                string = stringArray[0];
                iDCodeParser.parse(stereoMolecule, string);
                stereoMolecule.ensureHelperArrays(7);
                fingerPrintGenerator = new FingerPrintGenerator();
                bitSet2 = fingerPrintGenerator.getFingerprint(stereoMolecule);
                while (true) {
                    System.out.print("Molecule:");
                    String string3 = bufferedReader.readLine();
                    if (string3 == null || string3.trim().length() <= 0) continue;
                    iDCodeParser.parse(stereoMolecule, string3);
                    stereoMolecule.ensureHelperArrays(7);
                    fingerPrintGenerator = new FingerPrintGenerator();
                    bitSet = fingerPrintGenerator.getFingerprint(stereoMolecule);
                    if (FingerPrintGenerator.matches(bitSet, bitSet2)) {
                        System.out.println(string3.trim() + "\tOK");
                        continue;
                    }
                    System.out.println(string3.trim() + "\tNOT OK");
                }
            }
            string = bufferedReader.readLine();
            iDCodeParser.parse(stereoMolecule, string);
            stereoMolecule.ensureHelperArrays(7);
            fingerPrintGenerator = new FingerPrintGenerator();
            bitSet2 = fingerPrintGenerator.getFingerprint(stereoMolecule);
            int n = 0;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null && string2.trim().length() > 0) {
                System.out.println("*********************");
                string2 = string2.trim();
                iDCodeParser.parse(stereoMolecule, string2);
                stereoMolecule.ensureHelperArrays(7);
                fingerPrintGenerator = new FingerPrintGenerator();
                bitSet = fingerPrintGenerator.getFingerprint(stereoMolecule);
                if (!FingerPrintGenerator.matches(bitSet, bitSet2)) {
                    ++n2;
                }
                ++n;
            }
            System.out.println("Total/Not OK " + n + " " + n2);
        }
        catch (Exception exception) {
            System.err.println("Server Exception: " + exception);
            exception.printStackTrace();
        }
    }
}

