/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class DescriptorHandlerReactionFP
extends AbstractDescriptorHandlerLongFP<Reaction> {
    public static final String cVersion = "1.0.0";
    public static final int REACTION_CENTER_LONG_COUNT = 8;
    public static final float REACTION_CENTER_WEIGHT = 0.8f;
    public static final float PERIPHERY_WEIGHT = 0.19999999f;
    private static final int SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;
    private static DescriptorHandlerReactionFP sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DescriptorHandlerReactionFP getDefaultInstance() {
        if (sDefaultInstance != null) return sDefaultInstance;
        Class<DescriptorHandlerReactionFP> clazz = DescriptorHandlerReactionFP.class;
        synchronized (DescriptorHandlerReactionFP.class) {
            sDefaultInstance = new DescriptorHandlerReactionFP();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_ReactionFP;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_ReactionFP.version;
    }

    @Override
    public long[] createDescriptor(Reaction reaction) {
        if (reaction == null) {
            return null;
        }
        boolean[] blArray = reaction.getReactionCenterMapNos();
        if (blArray == null) {
            return FAILED_OBJECT;
        }
        long[] lArray = new long[16];
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            StereoMolecule stereoMolecule = reaction.getMolecule(i);
            stereoMolecule.ensureHelperArrays(7);
            boolean[] blArray2 = new boolean[stereoMolecule.getAllAtoms()];
            int n = reaction.getReactionCenterAtoms(i, blArray, blArray2, null);
            StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAllAtoms(), stereoMolecule.getAllBonds());
            int[] nArray = new int[stereoMolecule.getAllAtoms()];
            boolean[] blArray3 = new boolean[stereoMolecule.getAllAtoms()];
            block1: for (int j = 0; j < stereoMolecule.getAtoms(); ++j) {
                if (j != 0) {
                    Arrays.fill(blArray3, false);
                }
                int n2 = 0;
                int n3 = 0;
                for (int k = 0; k < 5 && n3 < stereoMolecule.getAtoms(); ++k) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    if (n3 == 0) {
                        nArray[0] = j;
                        blArray3[j] = true;
                        n3 = 1;
                    } else {
                        int n8 = n3;
                        for (n7 = n2; n7 < n3; ++n7) {
                            n6 = nArray[n7];
                            for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n6); ++n5) {
                                n4 = stereoMolecule.getConnAtom(n6, n5);
                                if (blArray3[n4] || !blArray2[j] && blArray2[n4]) continue;
                                blArray3[n4] = true;
                                nArray[n8++] = n4;
                            }
                        }
                        if (n3 == n8) continue block1;
                        n2 = n3;
                        n3 = n8;
                    }
                    stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray3, true, null);
                    String string = new Canonizer(stereoMolecule2).getIDCode();
                    if (i >= reaction.getReactants()) {
                        string = string.concat("P");
                    }
                    n7 = blArray2[j] ? 5 - k : 1;
                    for (n6 = 0; n6 < n7; ++n6) {
                        n5 = BurtleHasher.hashlittle(string.concat(Integer.toString(n6)), 13L);
                        n5 &= BurtleHasher.hashmask(9);
                        if (blArray2[j]) {
                            n5 += 512;
                        }
                        int n9 = n4 = 16 - n5 / 64 - 1;
                        lArray[n9] = lArray[n9] | 1L << n5 % 64;
                    }
                }
            }
        }
        return lArray;
    }

    @Override
    public float getSimilarity(long[] lArray, long[] lArray2) {
        if (lArray == null || lArray2 == null || lArray.length == 0 || lArray2.length == 0) {
            return 0.0f;
        }
        float f = DescriptorHandlerReactionFP.getSimilarityTanimoto(lArray, lArray2, 0, 8);
        float f2 = DescriptorHandlerReactionFP.getSimilarityTanimoto(lArray, lArray2, 8, lArray.length);
        return 0.8f * f + 0.19999999f * f2;
    }

    public float getReactionCenterSimilarity(long[] lArray, long[] lArray2) {
        if (lArray == null || lArray2 == null || lArray.length == 0 || lArray2.length == 0) {
            return 0.0f;
        }
        return DescriptorHandlerReactionFP.getSimilarityTanimoto(lArray, lArray2, 0, 8);
    }

    public float getPeripherySimilarity(long[] lArray, long[] lArray2) {
        if (lArray == null || lArray2 == null || lArray.length == 0 || lArray2.length == 0) {
            return 0.0f;
        }
        return DescriptorHandlerReactionFP.getSimilarityTanimoto(lArray, lArray2, 8, lArray.length);
    }

    public static float getSimilarityTanimoto(long[] lArray, long[] lArray2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += Long.bitCount(lArray[i] & lArray2[i]);
            n4 += Long.bitCount(lArray[i] | lArray2[i]);
        }
        return n4 == 0 ? 1.0f : (float)n3 / (float)n4;
    }

    @Override
    public DescriptorHandler<long[], Reaction> getThreadSafeCopy() {
        return this;
    }
}

