/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.FingerPrintGenerator;
import java.util.BitSet;

public class DescriptorHandlerLongPFP512
extends AbstractDescriptorHandlerLongFP<StereoMolecule>
implements DescriptorConstants {
    private static final double CORRECTION_FACTOR = 0.85;
    private static DescriptorHandlerLongPFP512 sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerLongPFP512 getDefaultInstance() {
        Class<DescriptorHandlerLongPFP512> clazz = DescriptorHandlerLongPFP512.class;
        synchronized (DescriptorHandlerLongPFP512.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerLongPFP512();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DESCRIPTOR_PFP512;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_PFP512.version;
    }

    @Override
    public long[] createDescriptor(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            return null;
        }
        BitSet bitSet = new FingerPrintGenerator().getFingerprint(stereoMolecule);
        if (bitSet == null) {
            return FAILED_OBJECT;
        }
        long[] lArray = new long[8];
        long l = 1L;
        long l2 = 0x100000000L;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (bitSet.get(16 * i + 2 * j + 1)) {
                    int n = j;
                    lArray[n] = lArray[n] + l;
                }
                if (!bitSet.get(16 * i + 2 * j)) continue;
                int n = j;
                lArray[n] = lArray[n] + l2;
            }
            l <<= 1;
            l2 <<= 1;
        }
        return lArray;
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }

    @Override
    public float getSimilarity(long[] lArray, long[] lArray2) {
        return this.normalizeValue(super.getSimilarity(lArray, lArray2));
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.85), 1.1764705882352942)));
    }
}

