/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;

public class DescriptorHandlerLongFFP512
extends AbstractDescriptorHandlerLongFP<StereoMolecule> {
    public static final String VERSION = "1.2.1";
    private static DescriptorHandlerLongFFP512 sDefaultInstance;
    private static final int sLongCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerLongFFP512 getDefaultInstance() {
        Class<DescriptorHandlerLongFFP512> clazz = DescriptorHandlerLongFFP512.class;
        synchronized (DescriptorHandlerLongFFP512.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerLongFFP512();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_FFP512;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public long[] decode(String string) {
        long[] lArray = string != null && string.length() == 128 ? SSSearcherWithIndex.getLongIndexFromHexString(string) : super.decode(string);
        return lArray != null && lArray.length == sLongCount ? lArray : null;
    }

    @Override
    public long[] decode(byte[] byArray) {
        long[] lArray = byArray != null && byArray.length == 128 ? SSSearcherWithIndex.getLongIndexFromHexString(byArray) : super.decode(byArray);
        return lArray != null && lArray.length == sLongCount ? lArray : null;
    }

    @Override
    public long[] createDescriptor(StereoMolecule stereoMolecule) {
        long[] lArray = new SSSearcherWithIndex().createLongIndex(stereoMolecule);
        return lArray == null ? FAILED_OBJECT : lArray;
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }

    static {
        sLongCount = (SSSearcherWithIndex.getNoOfKeys() + 63) / 64;
    }
}

