/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.calc.Logarithm;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorHandlerSkeletonSpheres;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.datamodel.IntVec;

public class DescriptorHandlerBinarySkelSpheres
extends AbstractDescriptorHandlerFP<StereoMolecule> {
    public static final String VERSION = DescriptorConstants.DESCRIPTOR_BINARY_SKELETONSPHERES.version;
    private static final double FAC_WIDTH = 8.0;
    private static final double OFFSET_MOVE = 0.5;
    private static final double OFFSET_CENTER = 0.2;
    private static DescriptorHandlerBinarySkelSpheres DEFAULT_INSTANCE;
    private DescriptorHandlerSkeletonSpheres dhSkeletonSpheres = new DescriptorHandlerSkeletonSpheres();

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_BINARY_SKELETONSPHERES;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int[] createDescriptor(StereoMolecule stereoMolecule) {
        byte[] byArray = this.dhSkeletonSpheres.createDescriptor(stereoMolecule);
        return DescriptorHandlerBinarySkelSpheres.createDescriptorFromSkelSpheresArrayCompressed(byArray);
    }

    public static int[] createDescriptorFromSkelSpheresArrayCompressed(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n = byArray.length / 64;
        int n2 = byArray.length / 2;
        IntVec intVec = new IntVec(n);
        for (int i = 0; i < byArray.length; i += 2) {
            int n3 = byArray[i] + byArray[i + 1];
            if (n3 <= 0) continue;
            int n4 = 0;
            n4 = n3 > 8 ? 8 + Logarithm.log2(n3 - 8) + 1 : n3;
            for (int j = 0; j < n4; ++j) {
                int n5 = i / 2 + j;
                int n6 = DescriptorHandlerBinarySkelSpheres.getCircularIndexOffset(n5, n2);
                intVec.setBit(n6);
            }
        }
        return intVec.get();
    }

    private static int getCircularIndexOffset(int n, int n2) {
        int n3 = n;
        if (n3 < n2) {
            return n3;
        }
        n3 = n - n2;
        return n3;
    }

    @Override
    public DescriptorHandler getThreadSafeCopy() {
        return new DescriptorHandlerBinarySkelSpheres();
    }

    @Override
    public float getSimilarity(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int n4 = nArray2[i];
            n += Integer.bitCount(n3 & n4);
            n2 += Integer.bitCount(n3 | n4);
        }
        double d = (double)n / (double)n2;
        return (float)DescriptorHandlerBinarySkelSpheres.correctionTS(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerBinarySkelSpheres getDefaultInstance() {
        Class<DescriptorHandlerBinarySkelSpheres> clazz = DescriptorHandlerBinarySkelSpheres.class;
        synchronized (DescriptorHandlerBinarySkelSpheres.class) {
            if (DEFAULT_INSTANCE == null) {
                DEFAULT_INSTANCE = new DescriptorHandlerBinarySkelSpheres();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT_INSTANCE;
        }
    }

    public static double standardize(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        double d2 = d - 0.2;
        double d3 = Math.exp(-8.0 * d2) - 0.5;
        return d3;
    }

    public static double correctionTS(double d) {
        double d2 = 0.7;
        double d3 = 0.7;
        double d4 = 1.0 - Math.pow(1.0 - Math.pow(d, d2), 1.0 / d3);
        if (d4 <= 0.0) {
            return 0.0;
        }
        if (d4 >= 1.0) {
            return 1.0;
        }
        return d4;
    }
}

