/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.StereoMolecule;

public class InventorTemplate {
    private StereoMolecule mFragment;
    private long[] mFFP;
    private double mAVBL;
    private boolean mKeepAbsoluteOrientation;

    public InventorTemplate(StereoMolecule stereoMolecule, long[] lArray, boolean bl) {
        this.mFragment = stereoMolecule;
        this.mFFP = lArray;
        this.mKeepAbsoluteOrientation = bl;
    }

    public boolean keepAbsoluteOrientation() {
        return this.mKeepAbsoluteOrientation;
    }

    public void normalizeCoordinates() {
        this.mAVBL = this.mFragment.getAverageBondLength();
    }

    public double getNormalizedAtomX(int n) {
        return this.mFragment.getAtomX(n) / this.mAVBL;
    }

    public double getNormalizedAtomY(int n) {
        return this.mFragment.getAtomY(n) / this.mAVBL;
    }

    public StereoMolecule getFragment() {
        return this.mFragment;
    }

    public long[] getFFP() {
        return this.mFFP;
    }
}

