/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.coords.InventorAngle;
import java.util.ArrayList;
import java.util.Arrays;

public class InventorFragment {
    private static final double cCollisionLimitBondRotation = 0.8;
    private static final double cCollisionLimitAtomMovement = 0.5;
    private final int CIRCULAR_BINS = 36;
    protected int[] mGlobalAtom;
    protected int[] mGlobalBond;
    protected int[] mGlobalToLocalAtom;
    protected int[] mPriority;
    protected double[] mAtomX;
    protected double[] mAtomY;
    protected boolean mKeepMarkedAtoms;
    private StereoMolecule mMol;
    private boolean mMinMaxAvail;
    private double mMinX;
    private double mMinY;
    private double mMaxX;
    private double mMaxY;
    private double mCollisionPanalty;
    private int[][] mFlipList;
    private int[] mSortedAtom;

    protected InventorFragment(StereoMolecule stereoMolecule, int n, boolean bl) {
        this.mMol = stereoMolecule;
        this.mKeepMarkedAtoms = bl;
        this.mGlobalAtom = new int[n];
        this.mPriority = new int[n];
        this.mAtomX = new double[n];
        this.mAtomY = new double[n];
    }

    protected InventorFragment(InventorFragment inventorFragment) {
        int n;
        this.mMol = inventorFragment.mMol;
        this.mKeepMarkedAtoms = inventorFragment.mKeepMarkedAtoms;
        this.mGlobalAtom = new int[inventorFragment.size()];
        this.mPriority = new int[inventorFragment.size()];
        this.mAtomX = new double[inventorFragment.size()];
        this.mAtomY = new double[inventorFragment.size()];
        for (n = 0; n < inventorFragment.size(); ++n) {
            this.mGlobalAtom[n] = inventorFragment.mGlobalAtom[n];
            this.mPriority[n] = inventorFragment.mPriority[n];
            this.mAtomX[n] = inventorFragment.mAtomX[n];
            this.mAtomY[n] = inventorFragment.mAtomY[n];
        }
        if (inventorFragment.mGlobalBond != null) {
            this.mGlobalBond = new int[inventorFragment.mGlobalBond.length];
            for (n = 0; n < inventorFragment.mGlobalBond.length; ++n) {
                this.mGlobalBond[n] = inventorFragment.mGlobalBond[n];
            }
        }
        if (inventorFragment.mGlobalToLocalAtom != null) {
            this.mGlobalToLocalAtom = new int[inventorFragment.mGlobalToLocalAtom.length];
            for (n = 0; n < inventorFragment.mGlobalToLocalAtom.length; ++n) {
                this.mGlobalToLocalAtom[n] = inventorFragment.mGlobalToLocalAtom[n];
            }
        }
    }

    protected int size() {
        return this.mGlobalAtom.length;
    }

    protected boolean equals(InventorFragment inventorFragment) {
        if (inventorFragment.size() != this.size()) {
            return false;
        }
        int[] nArray = this.getSortedAtoms();
        int[] nArray2 = inventorFragment.getSortedAtoms();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int[] getSortedAtoms() {
        if (this.mSortedAtom == null) {
            this.mSortedAtom = (int[])this.mGlobalAtom.clone();
            Arrays.sort(this.mSortedAtom);
        }
        return this.mSortedAtom;
    }

    protected double getAtomX(int n) {
        return this.mAtomX[n];
    }

    protected double getAtomY(int n) {
        return this.mAtomY[n];
    }

    protected double getWidth() {
        this.calculateMinMax();
        return this.mMaxX - this.mMinX + 1.0;
    }

    protected double getHeight() {
        this.calculateMinMax();
        return this.mMaxY - this.mMinY + 1.0;
    }

    protected boolean isMember(int n) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            if (n != this.mGlobalAtom[i]) continue;
            return true;
        }
        return false;
    }

    protected int getGlobalAtom(int n) {
        return this.mGlobalAtom[n];
    }

    protected int getLocalAtom(int n) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            if (n != this.mGlobalAtom[i]) continue;
            return i;
        }
        return -1;
    }

    protected void translate(double d, double d2) {
        int n = 0;
        while (n < this.mGlobalAtom.length) {
            int n2 = n;
            this.mAtomX[n2] = this.mAtomX[n2] + d;
            int n3 = n++;
            this.mAtomY[n3] = this.mAtomY[n3] + d2;
        }
    }

    protected void rotate(double d, double d2, double d3) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double d4 = Math.sqrt((this.mAtomX[i] - d) * (this.mAtomX[i] - d) + (this.mAtomY[i] - d2) * (this.mAtomY[i] - d2));
            double d5 = InventorAngle.getAngle(d, d2, this.mAtomX[i], this.mAtomY[i]) + d3;
            this.mAtomX[i] = d + d4 * Math.sin(d5);
            this.mAtomY[i] = d2 + d4 * Math.cos(d5);
        }
    }

    protected void flip(double d, double d2, double d3) {
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double d4 = Math.sqrt((this.mAtomX[i] - d) * (this.mAtomX[i] - d) + (this.mAtomY[i] - d2) * (this.mAtomY[i] - d2));
            double d5 = 2.0 * d3 - InventorAngle.getAngle(d, d2, this.mAtomX[i], this.mAtomY[i]);
            this.mAtomX[i] = d + d4 * Math.sin(d5);
            this.mAtomY[i] = d2 + d4 * Math.cos(d5);
        }
    }

    protected void flipOneSide(int n) {
        int n2;
        int n3;
        if (this.mFlipList == null) {
            this.mFlipList = new int[this.mMol.getAllBonds()][];
        }
        if (this.mFlipList[n] == null) {
            int n4;
            int[] nArray = new int[this.mGlobalAtom.length];
            boolean[] blArray = new boolean[this.mMol.getAllAtoms()];
            int n5 = this.mMol.getBondAtom(0, n);
            int n6 = this.mMol.getBondAtom(1, n);
            nArray[0] = n5;
            blArray[n5] = true;
            int n7 = 0;
            for (int i = 0; i <= n7; ++i) {
                for (n3 = 0; n3 < this.mMol.getAllConnAtoms(nArray[i]); ++n3) {
                    n2 = this.mMol.getConnAtom(nArray[i], n3);
                    if (blArray[n2] || n2 == n6) continue;
                    nArray[++n7] = n2;
                    blArray[n2] = true;
                }
                if (i == n7) break;
            }
            int n8 = n3 = n7 + 1 > this.mGlobalAtom.length / 2 ? 1 : 0;
            if (this.mKeepMarkedAtoms) {
                n2 = 0;
                n4 = 0;
                for (int i = 0; i < this.mGlobalAtom.length; ++i) {
                    int n9 = this.mGlobalAtom[i];
                    if (!this.mMol.isMarkedAtom(n9) || n9 == n5 || n9 == n6) continue;
                    if (blArray[this.mGlobalAtom[i]]) {
                        n2 = 1;
                        continue;
                    }
                    n4 = 1;
                }
                if (n2 != n4) {
                    n3 = n2;
                }
            }
            n2 = 2;
            this.mFlipList[n] = new int[n3 != 0 ? this.mGlobalAtom.length - n7 : n7 + 2];
            for (n4 = 0; n4 < this.mGlobalAtom.length; ++n4) {
                if (this.mGlobalAtom[n4] == n5) {
                    this.mFlipList[n][n3 != 0 ? 0 : 1] = n4;
                    continue;
                }
                if (this.mGlobalAtom[n4] == n6) {
                    this.mFlipList[n][n3 != 0 ? 1 : 0] = n4;
                    continue;
                }
                if ((n3 ^ blArray[this.mGlobalAtom[n4]]) == 0) continue;
                this.mFlipList[n][n2++] = n4;
            }
        }
        double d = this.mAtomX[this.mFlipList[n][0]];
        double d2 = this.mAtomY[this.mFlipList[n][0]];
        double d3 = InventorAngle.getAngle(d, d2, this.mAtomX[this.mFlipList[n][1]], this.mAtomY[this.mFlipList[n][1]]);
        for (n3 = 2; n3 < this.mFlipList[n].length; ++n3) {
            n2 = this.mFlipList[n][n3];
            double d4 = Math.sqrt((this.mAtomX[n2] - d) * (this.mAtomX[n2] - d) + (this.mAtomY[n2] - d2) * (this.mAtomY[n2] - d2));
            double d5 = 2.0 * d3 - InventorAngle.getAngle(d, d2, this.mAtomX[n2], this.mAtomY[n2]);
            this.mAtomX[n2] = d + d4 * Math.sin(d5);
            this.mAtomY[n2] = d2 + d4 * Math.cos(d5);
        }
    }

    protected void arrangeWith(InventorFragment inventorFragment) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            double d2 = this.getCornerDistance(i) + inventorFragment.getCornerDistance(i >= 2 ? i - 2 : i + 2);
            if (!(d < d2)) continue;
            d = d2;
            n = i;
        }
        double d3 = this.getHeight() + inventorFragment.getHeight();
        double d4 = 0.75 * (this.getWidth() + inventorFragment.getWidth());
        double d5 = Math.max(this.getHeight(), inventorFragment.getHeight());
        double d6 = 0.75 * Math.max(this.getWidth(), inventorFragment.getWidth());
        double d7 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - 0.75 * d) * (d4 - 0.75 * d));
        double d8 = Math.max(d6, d3);
        double d9 = Math.max(d5, d4);
        if (d7 < d8 && d7 < d9) {
            switch (n) {
                case 0: {
                    inventorFragment.translate(this.mMaxX - inventorFragment.mMinX - d + 1.0, this.mMinY - inventorFragment.mMaxY + d - 1.0);
                    break;
                }
                case 1: {
                    inventorFragment.translate(this.mMaxX - inventorFragment.mMinX - d + 1.0, this.mMaxY - inventorFragment.mMinY - d + 1.0);
                    break;
                }
                case 2: {
                    inventorFragment.translate(this.mMinX - inventorFragment.mMaxX + d - 1.0, this.mMaxY - inventorFragment.mMinY - d + 1.0);
                    break;
                }
                case 3: {
                    inventorFragment.translate(this.mMinX - inventorFragment.mMaxX + d - 1.0, this.mMinY - inventorFragment.mMaxY + d - 1.0);
                }
            }
        } else if (d9 < d8) {
            inventorFragment.translate(this.mMaxX - inventorFragment.mMinX + 1.0, (this.mMaxY + this.mMinY - inventorFragment.mMaxY - inventorFragment.mMinY) / 2.0);
        } else {
            inventorFragment.translate((this.mMaxX + this.mMinX - inventorFragment.mMaxX - inventorFragment.mMinX) / 2.0, this.mMaxY - inventorFragment.mMinY + 1.0);
        }
    }

    private void calculateMinMax() {
        if (this.mMinMaxAvail) {
            return;
        }
        this.mMinX = this.mAtomX[0];
        this.mMaxX = this.mAtomX[0];
        this.mMinY = this.mAtomY[0];
        this.mMaxY = this.mAtomY[0];
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double d = this.getAtomSurplus(i);
            if (this.mMinX > this.mAtomX[i] - d) {
                this.mMinX = this.mAtomX[i] - d;
            }
            if (this.mMaxX < this.mAtomX[i] + d) {
                this.mMaxX = this.mAtomX[i] + d;
            }
            if (this.mMinY > this.mAtomY[i] - d) {
                this.mMinY = this.mAtomY[i] - d;
            }
            if (!(this.mMaxY < this.mAtomY[i] + d)) continue;
            this.mMaxY = this.mAtomY[i] + d;
        }
        this.mMinMaxAvail = true;
    }

    private double getCornerDistance(int n) {
        double d = 9999.0;
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double d2 = this.getAtomSurplus(i);
            double d3 = 0.0;
            switch (n) {
                case 0: {
                    d3 = this.mMaxX - 0.5 * (this.mMaxX + this.mMinY + this.mAtomX[i] - this.mAtomY[i]);
                    break;
                }
                case 1: {
                    d3 = this.mMaxX - 0.5 * (this.mMaxX - this.mMaxY + this.mAtomX[i] + this.mAtomY[i]);
                    break;
                }
                case 2: {
                    d3 = 0.5 * (this.mMinX + this.mMaxY + this.mAtomX[i] - this.mAtomY[i]) - this.mMinX;
                    break;
                }
                case 3: {
                    d3 = 0.5 * (this.mMinX - this.mMinY + this.mAtomX[i] + this.mAtomY[i]) - this.mMinX;
                }
            }
            if (!(d > d3 - d2)) continue;
            d = d3 - d2;
        }
        return d;
    }

    private double getAtomSurplus(int n) {
        return this.mMol.getAtomQueryFeatures(this.mGlobalAtom[n]) != 0L ? 0.6 : (this.mMol.getAtomicNo(this.mGlobalAtom[n]) != 6 ? 0.25 : 0.0);
    }

    protected ArrayList<int[]> getCollisionList() {
        this.mCollisionPanalty = 0.0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 1; i < this.mGlobalAtom.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double d;
                double d2 = Math.abs(this.mAtomX[i] - this.mAtomX[j]);
                double d3 = Math.sqrt(d2 * d2 + (d = Math.abs(this.mAtomY[i] - this.mAtomY[j])) * d);
                if (d3 < 0.8) {
                    int[] nArray = new int[]{this.mGlobalAtom[i], this.mGlobalAtom[j]};
                    arrayList.add(nArray);
                }
                double d4 = 1.0 - Math.min(d3, 1.0);
                this.mCollisionPanalty += d4 * d4;
            }
        }
        return arrayList;
    }

    protected double getCollisionPanalty() {
        return this.mCollisionPanalty;
    }

    protected void locateBonds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.mGlobalAtom.length; ++n4) {
            n3 = this.mGlobalAtom[n4];
            n2 = this.mMol.getAllConnAtoms(n3);
            for (n = 0; n < n2; ++n) {
                if (this.mMol.getConnAtom(n3, n) <= n3) continue;
                ++n5;
            }
        }
        this.mGlobalBond = new int[n5];
        this.mGlobalToLocalAtom = new int[this.mMol.getAllAtoms()];
        n5 = 0;
        for (n4 = 0; n4 < this.mGlobalAtom.length; ++n4) {
            n3 = this.mGlobalAtom[n4];
            n2 = this.mMol.getAllConnAtoms(n3);
            this.mGlobalToLocalAtom[n3] = n4;
            for (n = 0; n < n2; ++n) {
                if (this.mMol.getConnAtom(n3, n) <= n3) continue;
                this.mGlobalBond[n5++] = this.mMol.getConnBond(n3, n);
            }
        }
    }

    protected void optimizeAtomCoordinates(int n) {
        double d = this.mAtomX[n];
        double d2 = this.mAtomY[n];
        InventorAngle[] inventorAngleArray = new InventorAngle[4];
        int n2 = 0;
        for (int i = 0; i < this.mGlobalBond.length && n2 < 4; ++i) {
            if (n == this.mGlobalToLocalAtom[this.mMol.getBondAtom(0, this.mGlobalBond[i])] || n == this.mGlobalToLocalAtom[this.mMol.getBondAtom(1, this.mGlobalBond[i])]) continue;
            double d3 = this.mAtomX[this.mGlobalToLocalAtom[this.mMol.getBondAtom(0, this.mGlobalBond[i])]];
            double d4 = this.mAtomY[this.mGlobalToLocalAtom[this.mMol.getBondAtom(0, this.mGlobalBond[i])]];
            double d5 = this.mAtomX[this.mGlobalToLocalAtom[this.mMol.getBondAtom(1, this.mGlobalBond[i])]];
            double d6 = this.mAtomY[this.mGlobalToLocalAtom[this.mMol.getBondAtom(1, this.mGlobalBond[i])]];
            double d7 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
            double d8 = Math.sqrt((d5 - d) * (d5 - d) + (d6 - d2) * (d6 - d2));
            double d9 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
            if (d7 < d9 && d8 < d9) {
                double d10;
                if (d3 == d5) {
                    d10 = Math.abs(d - d3);
                    if (!(d10 < 0.5)) continue;
                    inventorAngleArray[n2++] = new InventorAngle(InventorAngle.getAngle(d3, d2, d, d2), (0.5 - d10) / 2.0);
                    continue;
                }
                if (d4 == d6) {
                    d10 = Math.abs(d2 - d4);
                    if (!(d10 < 0.5)) continue;
                    inventorAngleArray[n2++] = new InventorAngle(InventorAngle.getAngle(d, d4, d, d2), (0.5 - d10) / 2.0);
                    continue;
                }
                d10 = (d6 - d4) / (d5 - d3);
                double d11 = -1.0 / d10;
                double d12 = d2 - d11 * d;
                double d13 = d4 - d10 * d3;
                double d14 = (d12 - d13) / (d10 - d11);
                double d15 = d10 * d14 + d13;
                double d16 = Math.sqrt((d14 - d) * (d14 - d) + (d15 - d2) * (d15 - d2));
                if (!(d16 < 0.5)) continue;
                inventorAngleArray[n2++] = new InventorAngle(InventorAngle.getAngle(d14, d15, d, d2), (0.5 - d16) / 2.0);
                continue;
            }
            if (d7 < 0.5) {
                inventorAngleArray[n2++] = new InventorAngle(InventorAngle.getAngle(d3, d4, d, d2), (0.5 - d7) / 2.0);
                continue;
            }
            if (!(d8 < 0.5)) continue;
            inventorAngleArray[n2++] = new InventorAngle(InventorAngle.getAngle(d5, d6, d, d2), (0.5 - d8) / 2.0);
        }
        if (n2 > 0) {
            InventorAngle inventorAngle = CoordinateInventor.getMeanAngle(inventorAngleArray, n2);
            int n3 = n;
            this.mAtomX[n3] = this.mAtomX[n3] + inventorAngle.mLength * Math.sin(inventorAngle.mAngle);
            int n4 = n;
            this.mAtomY[n4] = this.mAtomY[n4] + inventorAngle.mLength * Math.cos(inventorAngle.mAngle);
        }
    }

    protected double calculatePreferredAttachmentAngle(double d, double d2, int n, double d3) {
        int n2;
        int n3;
        if (this.size() == 1) {
            return 0.0;
        }
        double d4 = d3 + Math.sqrt(n);
        double[] dArray = new double[36];
        for (int i = 0; i < this.mGlobalAtom.length; ++i) {
            double d5;
            double d6;
            double d7;
            double d8 = InventorAngle.getAngle(d, d2, this.mAtomX[i], this.mAtomY[i]);
            n3 = this.correctBin((int)Math.round(d8 * 36.0 / (Math.PI * 2)));
            if (!(dArray[n3] < (d7 = (d6 = d - this.mAtomX[i]) * d6 + (d5 = d2 - this.mAtomY[i]) * d5))) continue;
            dArray[n3] = d7;
        }
        double d9 = -1.0;
        int n4 = -1;
        for (n3 = 0; n3 < 36; ++n3) {
            dArray[n3] = Math.sqrt(dArray[n3]);
            if (!(d9 < dArray[n3])) continue;
            d9 = dArray[n3];
            n4 = n3;
        }
        n3 = this.correctBin(n4 - 18);
        for (n2 = 0; n2 <= 18; ++n2) {
            int n5 = this.correctBin(n3 + n2);
            dArray[n5] = dArray[n5] + 0.01 * (double)n2;
            int n6 = this.correctBin(n3 - n2);
            dArray[n6] = dArray[n6] + 0.01 * (double)n2;
        }
        n2 = 9;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 1; i < n2; ++i) {
            dArray2[i] = Math.sin((double)i * 0.17453292519943295);
            dArray3[i] = Math.cos((double)i * 0.17453292519943295);
        }
        double d10 = d4 * d4;
        double d11 = Double.MAX_VALUE;
        int n7 = -1;
        for (int i = 0; i < 36; ++i) {
            if (dArray[i] >= d11) continue;
            double d12 = dArray[i];
            for (int j = 1; j < n2; ++j) {
                double d13;
                int n8;
                for (int k = -1; !(k > 1 || !(dArray[n8 = this.correctBin(i + k * j)] * dArray3[j] <= d12) && d12 < (d13 = dArray3[j] * Math.min(dArray[n8], d4 / dArray2[j])) && d11 <= (d12 = d13)); k += 2) {
                }
                if (d11 <= d12) break;
            }
            if (!(d11 > d12)) continue;
            d11 = d12;
            n7 = i;
        }
        return Math.PI * 2 * (double)n7 / 36.0;
    }

    private int correctBin(int n) {
        return n < 0 ? n + 36 : (n >= 36 ? n - 36 : n);
    }
}

