/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.contrib;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.util.Arrays;
import java.util.Vector;

public class HoseCodeCreator {
    public static final int FULL_HOSE_CODE = 0;
    public static final int HOSE_CODE_CUT_C_SP3_SP3 = 1;
    static final boolean DEBUG = false;

    public static String[][] getHoseCodes(StereoMolecule stereoMolecule, int n, int n2) {
        String[][] stringArray = new String[stereoMolecule.getAtoms()][n];
        stereoMolecule.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            stringArray[i] = HoseCodeCreator.getHoseCodesForAtom(stereoMolecule, i, n, n2);
        }
        return stringArray;
    }

    private static boolean isCsp3(ExtendedMolecule extendedMolecule, int n) {
        if (extendedMolecule.getAtomicNo(n) != 6) {
            return false;
        }
        if (extendedMolecule.getAtomCharge(n) != 0) {
            return false;
        }
        return extendedMolecule.getImplicitHydrogens(n) + extendedMolecule.getConnAtoms(n) == 4;
    }

    private static String[] getHoseCodesForAtom(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        Vector<String> vector = new Vector<String>();
        int n4 = 0;
        int n5 = 0;
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        int[] nArray = new int[stereoMolecule.getAtoms()];
        for (int i = 0; i < n2 && n5 < stereoMolecule.getAtoms(); ++i) {
            if (n5 == 0) {
                nArray[0] = n;
                blArray[n] = true;
                n5 = 1;
            } else {
                int n6 = n5;
                for (int j = n4; j < n5; ++j) {
                    int n7 = nArray[j];
                    block6: for (int k = 0; k < stereoMolecule.getConnAtoms(n7); ++k) {
                        int n8 = stereoMolecule.getConnAtom(n7, k);
                        if (blArray[n8]) continue;
                        switch (n3) {
                            case 0: {
                                blArray[n8] = true;
                                nArray[n6++] = n8;
                                continue block6;
                            }
                            case 1: {
                                if (HoseCodeCreator.isCsp3(stereoMolecule, n7) && HoseCodeCreator.isCsp3(stereoMolecule, n8)) continue block6;
                                blArray[n8] = true;
                                nArray[n6++] = n8;
                            }
                        }
                    }
                }
                n4 = n5;
                n5 = n6;
            }
            stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
            vector.add(new Canonizer(stereoMolecule2, 8).getIDCode());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static String[] getHoseCodesFromDiaID(String string, int n, int n2) {
        StereoMolecule stereoMolecule = new IDCodeParser(true).getCompactMolecule(string);
        int n3 = -1;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            String string2 = stereoMolecule.getAtomCustomLabel(i);
            if (string2 == null || !string2.endsWith("*")) continue;
            n3 = i;
            break;
        }
        if (n3 >= 0) {
            return HoseCodeCreator.getHoseCodesForAtom(stereoMolecule, n3, n, n2);
        }
        return new String[0];
    }

    public static void main(String[] stringArray) {
        int n;
        StereoMolecule stereoMolecule = new IDCodeParser(false).getCompactMolecule("deT@@DjU_k``b`@@");
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        Arrays.fill(blArray, true);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
        System.out.println(new Canonizer(stereoMolecule2, 8).getIDCode());
        String string = "fi{qa@DyZkQPSI`cHhhdhdhddhekF\\\\fNXBBjfjjjaXTh@\u007fRB@QJh";
        String[] stringArray2 = HoseCodeCreator.getHoseCodesFromDiaID(string, 20, 0);
        for (n = 0; n < stringArray2.length; ++n) {
            System.out.println(stringArray2[n]);
        }
        stringArray2 = HoseCodeCreator.getHoseCodesFromDiaID(string, 8, 1);
        for (n = 0; n < stringArray2.length; ++n) {
            System.out.println(stringArray2[n]);
        }
    }
}

