/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionDescriptor;

public class TorsionDescriptorHelper {
    private static final int SYMMETRY_360 = 0;
    private static final int SYMMETRY_180 = 1;
    private static final int SYMMETRY_120 = 2;
    private static final int SYMMETRY_60 = 3;
    private static double[] SYMMETRY_REDUNDANCY_ANGLE = new double[]{Math.PI * 2, Math.PI, 2.0943951023931953, 1.0471975511965976};
    private static final int HALF_SYMMETRY_C1 = 0;
    private static final int HALF_SYMMETRY_D1 = 1;
    private static final int HALF_SYMMETRY_D2 = 2;
    private static final int HALF_SYMMETRY_D3 = 3;
    private static final int[][] SYMMETRY = new int[][]{{0, 0, 0, 2}, {0, 0, 1, 2}, {0, 1, 1, 3}, {2, 2, 3, 2}};
    private StereoMolecule mMol;
    private int[] mRotatableBond;
    private int[][] mAtomSequence;
    private int[][] mRearAtom;
    private int[] mSymmetryClass;

    public TorsionDescriptorHelper(StereoMolecule stereoMolecule) {
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(63);
        this.mRotatableBond = TorsionDescriptorHelper.findRotatableBonds(stereoMolecule);
        this.findAtomSequences();
    }

    public TorsionDescriptorHelper(StereoMolecule stereoMolecule, int[] nArray) {
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(63);
        this.mRotatableBond = nArray;
        this.findAtomSequences();
    }

    public TorsionDescriptor getTorsionDescriptor() {
        float[] fArray = new float[this.mRotatableBond.length];
        float[] fArray2 = new float[this.mRotatableBond.length];
        for (int i = 0; i < this.mRotatableBond.length; ++i) {
            fArray[i] = (float)TorsionDescriptorHelper.getNormalizedTorsion(TorsionDB.calculateTorsionExtended(this.mMol, this.mAtomSequence[i]), this.mSymmetryClass[i]);
            fArray2[i] = (float)SYMMETRY_REDUNDANCY_ANGLE[this.mSymmetryClass[i]];
        }
        return new TorsionDescriptor(fArray, fArray2);
    }

    public TorsionDescriptor getTorsionDescriptor(Conformer conformer) {
        float[] fArray = new float[this.mRotatableBond.length];
        float[] fArray2 = new float[this.mRotatableBond.length];
        for (int i = 0; i < this.mRotatableBond.length; ++i) {
            fArray[i] = (float)TorsionDescriptorHelper.getNormalizedTorsion(TorsionDB.calculateTorsionExtended(conformer, this.mAtomSequence[i]), this.mSymmetryClass[i]);
            fArray2[i] = (float)SYMMETRY_REDUNDANCY_ANGLE[this.mSymmetryClass[i]];
        }
        return new TorsionDescriptor(fArray, fArray2);
    }

    public static int[] findRotatableBonds(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        boolean[] blArray = new boolean[stereoMolecule.getBonds()];
        int n = 0;
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (!TorsionDescriptorHelper.qualifiesAsDescriptorBond(stereoMolecule, i)) continue;
            blArray[i] = true;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (!blArray[i]) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private static boolean qualifiesAsDescriptorBond(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        if (stereoMolecule.getBondOrder(n) != 1 || stereoMolecule.isAromaticBond(n) || stereoMolecule.getBondRingSize(n) == 3) {
            return false;
        }
        int[] nArray = new int[2];
        for (n3 = 0; n3 < 2; ++n3) {
            nArray[n3] = stereoMolecule.getBondAtom(n3, n);
            if (!stereoMolecule.isMarkedAtom(nArray[n3]) && stereoMolecule.getNonHydrogenNeighbourCount(nArray[n3]) > 1) continue;
            return false;
        }
        if (TorsionDescriptorHelper.isLinearAtom(stereoMolecule, nArray[0]) || TorsionDescriptorHelper.isLinearAtom(stereoMolecule, nArray[1])) {
            int[] nArray2 = new int[]{n};
            int[][] nArrayArray = new int[2][];
            for (n2 = 0; n2 < 2; ++n2) {
                if (!TorsionDescriptorHelper.isLinearAtom(stereoMolecule, nArray[n2])) continue;
                nArrayArray[n2] = new int[2];
                nArrayArray[n2][0] = nArray[1 - n2];
                nArrayArray[n2][1] = nArray[n2];
                if (TorsionDescriptorHelper.getFirstNonSPAtom(stereoMolecule, nArray[1 - n2], nArrayArray[n2], nArray2)) continue;
                return false;
            }
            if (nArray2 != null && n != nArray2[0]) {
                return false;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                if (nArrayArray[n2] == null) continue;
                nArray[n2] = nArrayArray[n2][1];
            }
        }
        for (n3 = 0; n3 < 2; ++n3) {
            int n4 = stereoMolecule.getConnAtoms(nArray[n3]);
            if (n4 == 1) {
                return false;
            }
            n2 = 0;
            for (int i = 0; i < n4; ++i) {
                int n5 = stereoMolecule.getConnAtom(nArray[n3], i);
                if (stereoMolecule.isMarkedAtom(n5)) continue;
                ++n2;
            }
            if (n2 >= 2) continue;
            return false;
        }
        return true;
    }

    private static boolean isLinearAtom(StereoMolecule stereoMolecule, int n) {
        return stereoMolecule.getConnAtoms(n) == 2 && stereoMolecule.getAtomPi(n) == 2 && stereoMolecule.getAtomicNo(n) <= 7;
    }

    private static boolean getFirstNonSPAtom(StereoMolecule stereoMolecule, int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < 2; ++i) {
            int n2 = stereoMolecule.getConnAtom(nArray[1], i);
            if (n2 == nArray[0]) continue;
            if (n2 == n) {
                return false;
            }
            int n3 = stereoMolecule.getConnBond(nArray[1], i);
            nArray[0] = nArray[1];
            nArray[1] = n2;
            if (stereoMolecule.getConnAtoms(n2) == 1) {
                return false;
            }
            if (nArray2 != null && !stereoMolecule.isMarkedAtom(nArray[0]) && !stereoMolecule.isMarkedAtom(nArray[1])) {
                nArray2[0] = Math.max(nArray2[0], n3);
            }
            if (!TorsionDescriptorHelper.isLinearAtom(stereoMolecule, n2)) {
                return true;
            }
            return TorsionDescriptorHelper.getFirstNonSPAtom(stereoMolecule, n, nArray, nArray2);
        }
        return false;
    }

    private void findAtomSequences() {
        this.mAtomSequence = new int[this.mRotatableBond.length][4];
        this.mRearAtom = new int[this.mRotatableBond.length][2];
        this.mSymmetryClass = new int[this.mRotatableBond.length];
        int[] nArray = new int[2];
        for (int i = 0; i < this.mRotatableBond.length; ++i) {
            int n;
            for (n = 0; n < 2; ++n) {
                nArray[0] = this.mMol.getBondAtom(1 - n, this.mRotatableBond[i]);
                nArray[1] = this.mMol.getBondAtom(n, this.mRotatableBond[i]);
                if (TorsionDescriptorHelper.isLinearAtom(this.mMol, nArray[1])) {
                    TorsionDescriptorHelper.getFirstNonSPAtom(this.mMol, nArray[0], nArray, null);
                }
                this.mAtomSequence[i][1 + n] = nArray[1];
                this.mRearAtom[i][n] = nArray[0];
            }
            n = this.getHalfSymmetry(this.mAtomSequence[i][1], this.mRearAtom[i][0]);
            int n2 = this.getHalfSymmetry(this.mAtomSequence[i][2], this.mRearAtom[i][1]);
            this.mSymmetryClass[i] = SYMMETRY[n][n2];
            this.mAtomSequence[i][0] = this.chooseSequenceEndAtom(this.mAtomSequence[i][1], this.mRearAtom[i][0], n);
            this.mAtomSequence[i][3] = this.chooseSequenceEndAtom(this.mAtomSequence[i][2], this.mRearAtom[i][1], n2);
        }
    }

    private int getHalfSymmetry(int n, int n2) {
        if (this.mMol.getConnAtoms(n) == 2) {
            return 1;
        }
        int[] nArray = this.getTerminalAtoms(n, n2);
        if (this.mMol.getConnAtoms(n) == 3) {
            if (this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[1])) {
                return this.isFlatAtom(n) ? 2 : 1;
            }
            return this.isFlatAtom(n) ? 1 : 0;
        }
        if (this.mMol.getConnAtoms(n) == 4) {
            if (this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[1]) && this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[2])) {
                return 3;
            }
            if (this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[1]) || this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[2]) || this.mMol.getSymmetryRank(nArray[1]) == this.mMol.getSymmetryRank(nArray[2])) {
                return 1;
            }
        }
        return 0;
    }

    private boolean isFlatAtom(int n) {
        return this.mMol.getAtomPi(n) == 1 && this.mMol.getAtomicNo(n) < 10 || this.mMol.isAromaticAtom(n) || this.mMol.isFlatNitrogen(n);
    }

    private int[] getTerminalAtoms(int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[this.mMol.getConnAtoms(n) - 1];
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mMol.getConnAtom(n, i) == n2) continue;
            nArray[n3++] = this.mMol.getConnAtom(n, i);
        }
        return nArray;
    }

    private int chooseSequenceEndAtom(int n, int n2, int n3) {
        if (n3 == 1 && !this.isFlatAtom(n)) {
            if (this.mMol.getConnAtoms(n) == 3) {
                return -1;
            }
            if (this.mMol.getConnAtoms(n) == 3) {
                int[] nArray = this.getTerminalAtoms(n, n2);
                if (this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[1])) {
                    return nArray[2];
                }
                if (this.mMol.getSymmetryRank(nArray[0]) == this.mMol.getSymmetryRank(nArray[2])) {
                    return nArray[1];
                }
                return nArray[0];
            }
        }
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n6 = this.mMol.getConnAtom(n, i);
            if (n6 == n2 || n4 >= this.mMol.getSymmetryRank(n6)) continue;
            n4 = this.mMol.getSymmetryRank(n6);
            n5 = n6;
        }
        return n5;
    }

    private static double getNormalizedTorsion(double d, int n) {
        double d2 = SYMMETRY_REDUNDANCY_ANGLE[n] / 2.0;
        while (d < -d2) {
            d += Math.PI * 2;
        }
        while (d >= d2) {
            d -= SYMMETRY_REDUNDANCY_ANGLE[n];
        }
        return d;
    }
}

