/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.TorsionRelevanceHelper;
import com.actelion.research.util.Angle;
import com.actelion.research.util.DoubleFormat;

public class TorsionDescriptor
implements Comparable<TorsionDescriptor> {
    private static final float TORSION_EQUIVALENCE_TOLERANCE = 0.2617994f;
    private float[] mTorsion;
    private float[] mMaxTorsion;

    public TorsionDescriptor(float[] fArray, float[] fArray2) {
        this.mTorsion = fArray;
        this.mMaxTorsion = fArray2;
    }

    public boolean equals(TorsionDescriptor torsionDescriptor) {
        for (int i = 0; i < this.mTorsion.length; ++i) {
            float f = Math.abs(this.mTorsion[i] - torsionDescriptor.mTorsion[i]);
            if (!(f > 0.2617994f) || !(f < this.mMaxTorsion[i] - 0.2617994f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TorsionDescriptor torsionDescriptor) {
        for (int i = 0; i < this.mTorsion.length; ++i) {
            float f = Math.abs(this.mTorsion[i] - torsionDescriptor.mTorsion[i]);
            if (!(f > 0.2617994f) || !(f < this.mMaxTorsion[i] - 0.2617994f)) continue;
            return f < this.mMaxTorsion[i] / 2.0f ^ this.mTorsion[i] < torsionDescriptor.mTorsion[i] ? 1 : -1;
        }
        return 0;
    }

    public static float[] getRotatableBondWeights(StereoMolecule stereoMolecule, int[] nArray) {
        return TorsionRelevanceHelper.getRelevance(stereoMolecule, nArray);
    }

    public float getDissimilarity(TorsionDescriptor torsionDescriptor, float[] fArray) {
        assert (this.mTorsion.length == torsionDescriptor.mTorsion.length);
        if (this.mTorsion.length == 0) {
            return 0.0f;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.mTorsion.length; ++i) {
            f = (float)((double)f + (double)fArray[i] * Math.abs(Angle.difference(this.mTorsion[i], torsionDescriptor.mTorsion[i])));
            f2 += fArray[i];
        }
        return f / ((float)Math.PI * f2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.mTorsion.length; ++i) {
            stringBuilder.append(i == 0 ? "Torsions: " : ", ");
            stringBuilder.append(DoubleFormat.toString(this.mTorsion[i], 3) + "(" + Math.round(this.mMaxTorsion[i] + 0.5f) + ")");
        }
        return stringBuilder.toString();
    }
}

