/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDetail;
import com.actelion.research.chem.conf.TorsionInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeMap;

public class TorsionDB {
    public static final int MODE_ANGLES = 1;
    public static final int MODE_BINS = 2;
    public static final int DEFAULT_MERGE_SPAN = 15;
    private static final String DATABASE_COD = "cod/";
    private static final String DATABASE_CSD = "csd/";
    public static final int TORSION_NOT_FOUND = -1;
    public static final int TORSION_GREEN = 0;
    public static final int TORSION_YELLOW = 1;
    public static final int TORSION_RED = 2;
    private static final String cBasePath = "/resources/";
    private static final String cTorsionIDFile = "torsionID.txt";
    private static final String cTorsionAngleFile = "torsionAngle.txt";
    private static final String cTorsionRangeFile = "torsionRange.txt";
    private static final String cTorsionFrequencyFile = "torsionFrequency.txt";
    private static final String cTorsionBinsFile = "torsionBins.txt";
    private static final int MAX_SP_CHAIN_LENGTH = 15;
    private static TorsionDB sInstance;
    private static String sDatabase;
    private static String sExternalResourcePath;
    private int mSupportedModes = 0;
    private int mMergeSpan;
    private TreeMap<String, TorsionInfo> mTreeMap = new TreeMap();

    public static void setResourcePath(String string) {
        sExternalResourcePath = string;
    }

    public static void initialize(int n) {
        TorsionDB.initialize(n, 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(int n, int n2) {
        Class<TorsionDB> clazz = TorsionDB.class;
        synchronized (TorsionDB.class) {
            int n3;
            if (sInstance == null) {
                sInstance = new TorsionDB();
            }
            if (n == 1 && (TorsionDB.sInstance.mSupportedModes & 1) != 0 && TorsionDB.sInstance.mMergeSpan != n2) {
                System.out.println("WARNING: TorsionDB already initialized in ANGLE mode with different merge span.");
            }
            if ((n3 = n & ~TorsionDB.sInstance.mSupportedModes) != 0) {
                sInstance.init(n3);
                if (n3 == 1 && n2 != 0) {
                    sInstance.mergeTorsions(n2);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static int findRotatableBonds(StereoMolecule stereoMolecule, boolean bl, boolean[] blArray) {
        stereoMolecule.ensureHelperArrays(7);
        if (blArray == null) {
            blArray = new boolean[stereoMolecule.getBonds()];
        }
        int n = 0;
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (stereoMolecule.getBondOrder(i) != 1 || stereoMolecule.isAromaticBond(i) || stereoMolecule.getNonHydrogenNeighbourCount(stereoMolecule.getBondAtom(0, i)) <= 1 || stereoMolecule.getNonHydrogenNeighbourCount(stereoMolecule.getBondAtom(1, i)) <= 1 || bl && stereoMolecule.isRingBond(i) || stereoMolecule.isSmallRingBond(i) && stereoMolecule.getBondRingSize(i) <= 5) continue;
            blArray[i] = true;
            ++n;
        }
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        boolean[] blArray2 = null;
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (!blArray[i] || blArray2 != null && blArray2[i] != false) continue;
            int n6 = 0;
            block2: for (n5 = 0; n5 < 2; ++n5) {
                nArray[n5] = stereoMolecule.getBondAtom(n5, i);
                nArray2[n5] = stereoMolecule.getBondAtom(1 - n5, i);
                n4 = nArray2[n5];
                while (stereoMolecule.getAtomPi(nArray[n5]) == 2 && stereoMolecule.getNonHydrogenNeighbourCount(nArray[n5]) == 2 && stereoMolecule.getAtomicNo(nArray[n5]) < 10) {
                    for (n3 = 0; n3 < 2; ++n3) {
                        n2 = stereoMolecule.getConnAtom(nArray[n5], n3);
                        if (n2 == nArray2[n5]) continue;
                        int n7 = stereoMolecule.getConnBond(nArray[n5], n3);
                        if (blArray[n7] && stereoMolecule.getBondOrder(n7) == 1) {
                            blArray[n7] = false;
                            --n;
                        }
                        nArray2[n5] = nArray[n5];
                        nArray[n5] = n2;
                        ++n6;
                        break;
                    }
                    if (nArray[n5] != n4) continue;
                    n6 = 0;
                    continue block2;
                }
            }
            if (n6 == 0) continue;
            blArray[i] = false;
            --n;
            if (stereoMolecule.getNonHydrogenNeighbourCount(nArray[0]) <= 1 || stereoMolecule.getNonHydrogenNeighbourCount(nArray[1]) <= 1) continue;
            n5 = stereoMolecule.getSubstituentSize(nArray2[0], nArray[0]);
            n3 = n5 < (n4 = stereoMolecule.getSubstituentSize(nArray2[1], nArray[1])) ? 0 : 1;
            n2 = stereoMolecule.getBond(nArray2[n3], nArray[n3]);
            if (blArray2 == null) {
                blArray2 = new boolean[stereoMolecule.getBonds()];
            }
            blArray2[n2] = true;
            blArray[n2] = true;
            ++n;
        }
        return n;
    }

    private TorsionDB() {
    }

    private void mergeTorsions(int n) {
        this.mMergeSpan = n;
        for (TorsionInfo torsionInfo : this.mTreeMap.values()) {
            torsionInfo.mergeTorsions(n);
        }
    }

    private void init(int n) {
        this.mSupportedModes |= n;
        try {
            BufferedReader bufferedReader = TorsionDB.openReader(cTorsionIDFile);
            BufferedReader bufferedReader2 = (n & 1) == 0 ? null : TorsionDB.openReader(cTorsionAngleFile);
            BufferedReader bufferedReader3 = (n & 1) == 0 ? null : TorsionDB.openReader(cTorsionRangeFile);
            BufferedReader bufferedReader4 = (n & 1) == 0 ? null : TorsionDB.openReader(cTorsionFrequencyFile);
            BufferedReader bufferedReader5 = (n & 2) == 0 ? null : TorsionDB.openReader(cTorsionBinsFile);
            String string = bufferedReader.readLine();
            while (string != null) {
                int n2;
                String[] stringArray;
                TorsionInfo torsionInfo = this.mTreeMap.get(string);
                if (torsionInfo == null) {
                    torsionInfo = new TorsionInfo(TorsionDB.getSymmetryType(string));
                    this.mTreeMap.put(string, torsionInfo);
                }
                if (bufferedReader2 != null) {
                    stringArray = bufferedReader2.readLine().split(",");
                    torsionInfo.angle = new short[stringArray.length];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        torsionInfo.angle[n2] = Short.parseShort(stringArray[n2]);
                    }
                }
                if (bufferedReader3 != null) {
                    stringArray = bufferedReader3.readLine().split(",");
                    torsionInfo.range = new short[stringArray.length][2];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        int n3 = stringArray[n2].indexOf(45, 1);
                        torsionInfo.range[n2][0] = Short.parseShort(stringArray[n2].substring(0, n3));
                        torsionInfo.range[n2][1] = Short.parseShort(stringArray[n2].substring(n3 + 1));
                    }
                }
                if (bufferedReader4 != null) {
                    stringArray = bufferedReader4.readLine().split(",");
                    torsionInfo.frequency = new short[stringArray.length];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        torsionInfo.frequency[n2] = Byte.parseByte(stringArray[n2]);
                    }
                }
                if (bufferedReader5 != null) {
                    stringArray = bufferedReader5.readLine().split(",");
                    torsionInfo.binSize = new byte[stringArray.length];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        torsionInfo.binSize[n2] = Byte.parseByte(stringArray[n2]);
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (bufferedReader2 != null) {
                bufferedReader2.close();
            }
            if (bufferedReader3 != null) {
                bufferedReader3.close();
            }
            if (bufferedReader4 != null) {
                bufferedReader4.close();
            }
            if (bufferedReader5 != null) {
                bufferedReader5.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected static BufferedReader openReader(String string) throws IOException {
        if (sExternalResourcePath != null) {
            return new BufferedReader(new FileReader(sExternalResourcePath + string));
        }
        if (sDatabase == null) {
            InputStream inputStream = TorsionDB.class.getResourceAsStream("/resources/csd/" + string);
            if (inputStream != null) {
                sDatabase = DATABASE_CSD;
                return new BufferedReader(new InputStreamReader(inputStream));
            }
            sDatabase = DATABASE_COD;
        }
        return new BufferedReader(new InputStreamReader(TorsionDB.class.getResourceAsStream(cBasePath + sDatabase + string)));
    }

    public static short[] getTorsions(String string) {
        TorsionInfo torsionInfo = sInstance.getTorsionInfo(string);
        return torsionInfo == null ? null : torsionInfo.get360DegreeAngles();
    }

    public static short[][] getTorsionRanges(String string) {
        TorsionInfo torsionInfo = sInstance.getTorsionInfo(string);
        return torsionInfo == null ? (short[][])null : torsionInfo.get360DegreeRanges();
    }

    public static short[] getTorsionFrequencies(String string) {
        TorsionInfo torsionInfo = sInstance.getTorsionInfo(string);
        return torsionInfo == null ? null : torsionInfo.get360DegreeFrequencies();
    }

    public static byte[] getTorsionBinCounts(String string) {
        TorsionInfo torsionInfo = sInstance.getTorsionInfo(string);
        return torsionInfo == null ? null : torsionInfo.get72BinCounts();
    }

    private TorsionInfo getTorsionInfo(String string) {
        if (string == null) {
            return null;
        }
        TorsionInfo torsionInfo = this.mTreeMap.get(string);
        if (torsionInfo != null) {
            return torsionInfo;
        }
        if (TorsionDB.isInverted(string) && (torsionInfo = this.mTreeMap.get(TorsionDB.normalizeID(string))) != null) {
            torsionInfo = new TorsionInfo(torsionInfo);
            this.mTreeMap.put(string, torsionInfo);
            return torsionInfo;
        }
        return null;
    }

    public static String getTorsionID(StereoMolecule stereoMolecule, int n, int[] nArray, TorsionDetail torsionDetail) {
        if (torsionDetail == null) {
            torsionDetail = new TorsionDetail();
        }
        torsionDetail.classify(stereoMolecule, n);
        if (nArray != null) {
            nArray[0] = torsionDetail.getReferenceAtom(0);
            nArray[1] = torsionDetail.getCentralAtom(0);
            nArray[2] = torsionDetail.getCentralAtom(1);
            nArray[3] = torsionDetail.getReferenceAtom(1);
        }
        return torsionDetail.getID();
    }

    public static int getSymmetryType(String string) {
        return string.endsWith("<") || string.endsWith(">") ? 0 : (string.endsWith("-") || string.endsWith("+") ? 1 : (string.endsWith("=") ? 3 : 2));
    }

    public static boolean isInverted(String string) {
        return string.endsWith("<") || string.endsWith("-");
    }

    public static String normalizeID(String string) {
        return string.endsWith("<") ? string.substring(0, string.length() - 1) + ">" : (string.endsWith("-") ? string.substring(0, string.length() - 1) + "+" : string);
    }

    public static double calculateTorsionExtended(StereoMolecule stereoMolecule, int[] nArray) {
        if (nArray[0] != -1 && nArray[3] != -1) {
            return stereoMolecule.calculateTorsion(nArray);
        }
        return TorsionDB.calculateTorsionExtended(stereoMolecule, null, nArray);
    }

    public static double calculateTorsionExtended(Conformer conformer, int[] nArray) {
        if (nArray[0] != -1 && nArray[3] != -1) {
            return conformer.calculateTorsion(nArray);
        }
        return TorsionDB.calculateTorsionExtended(conformer.getMolecule(), conformer, nArray);
    }

    private static double calculateTorsionExtended(StereoMolecule stereoMolecule, Conformer conformer, int[] nArray) {
        double[] dArray = new double[2];
        int[] nArray2 = TorsionDB.findRearAtoms(stereoMolecule, nArray);
        for (int i = 0; i < 2; ++i) {
            if (nArray[3 * i] == -1) continue;
            int n = 2 - i;
            int n2 = 3 - 3 * i;
            assert (stereoMolecule.getNonHydrogenNeighbourCount(nArray[n]) == 3);
            int n3 = 0;
            for (int j = 0; j < 3; ++j) {
                int n4 = stereoMolecule.getConnAtom(nArray[n], j);
                if (n4 == nArray2[1 - i] || stereoMolecule.getAtomicNo(n4) == 1) continue;
                nArray[n2] = n4;
                dArray[n3++] = conformer != null ? conformer.calculateTorsion(nArray) : stereoMolecule.calculateTorsion(nArray);
            }
            nArray[n2] = -1;
            return TorsionDB.calculateVirtualTorsion(dArray);
        }
        double[] dArray2 = new double[2];
        int n = 0;
        assert (stereoMolecule.getNonHydrogenNeighbourCount(nArray[1]) == 3);
        for (int i = 0; i < 3; ++i) {
            int n5 = stereoMolecule.getConnAtom(nArray[1], i);
            if (n5 == nArray2[0] || stereoMolecule.getAtomicNo(n5) == 1) continue;
            assert (stereoMolecule.getNonHydrogenNeighbourCount(nArray[2]) == 3);
            nArray[0] = n5;
            int n6 = 0;
            for (int j = 0; j < 3; ++j) {
                int n7 = stereoMolecule.getConnAtom(nArray[2], j);
                if (n7 == nArray2[1] || stereoMolecule.getAtomicNo(n7) == 1) continue;
                nArray[3] = n7;
                dArray2[n6++] = conformer != null ? conformer.calculateTorsion(nArray) : stereoMolecule.calculateTorsion(nArray);
            }
            dArray[n++] = TorsionDB.calculateVirtualTorsion(dArray2);
        }
        nArray[0] = -1;
        nArray[3] = -1;
        return TorsionDB.calculateVirtualTorsion(dArray);
    }

    public static int[] findRearAtoms(StereoMolecule stereoMolecule, int[] nArray) {
        int[] nArray2 = new int[2];
        if (stereoMolecule.getBond(nArray[1], nArray[2]) != -1) {
            nArray2[0] = nArray[2];
            nArray2[1] = nArray[1];
        } else {
            int[] nArray3 = new int[16];
            int n = stereoMolecule.getPath(nArray3, nArray[1], nArray[2], 15, null);
            nArray2[0] = nArray3[1];
            nArray2[1] = nArray3[n - 1];
        }
        return nArray2;
    }

    public static int[] getExtendedAtomSequence(StereoMolecule stereoMolecule, int[] nArray) {
        if (stereoMolecule.getBond(nArray[1], nArray[2]) != -1) {
            return nArray;
        }
        int[] nArray2 = new int[16];
        int n = stereoMolecule.getPath(nArray2, nArray[1], nArray[2], 15, null);
        int[] nArray3 = new int[3 + n];
        nArray3[0] = nArray[0];
        for (int i = 0; i <= n; ++i) {
            nArray3[i + 1] = nArray2[i];
        }
        nArray3[n + 2] = nArray[3];
        return nArray3;
    }

    private static double calculateVirtualTorsion(double[] dArray) {
        double d = (dArray[1] + dArray[0]) / 2.0;
        double d2 = Math.abs(dArray[1] - dArray[0]);
        if (d2 > Math.PI) {
            return d;
        }
        return d < 0.0 ? d + Math.PI : d - Math.PI;
    }

    public static int getTorsionStrainClass(String string, double d) {
        short[][] sArray = TorsionDB.getTorsionRanges(TorsionDB.normalizeID(string));
        if (sArray == null) {
            return -1;
        }
        int n = 2;
        int n2 = TorsionDB.getNormalizedTorsionIndex(string, d);
        for (short[] sArray2 : sArray) {
            if (n2 >= sArray2[0] && n2 <= sArray2[1]) {
                return 0;
            }
            if (n2 < sArray2[0] - 5 || n2 > sArray2[1] + 5) continue;
            n = 1;
        }
        return n;
    }

    public static int getNormalizedTorsionIndex(String string, double d) {
        int n;
        if (TorsionDB.isInverted(string)) {
            d = -d;
        }
        if ((n = (int)Math.floor(0.5 + (d = 180.0 * d / Math.PI))) == 180) {
            n = -180;
        }
        int n2 = TorsionDB.getSymmetryType(string);
        switch (n2) {
            case 0: {
                if (n >= 0) break;
                n += 360;
                break;
            }
            case 1: {
                if (n >= 0) break;
                n += 180;
                break;
            }
            case 2: {
                n = Math.abs(n);
                break;
            }
            case 3: {
                if (n < 0) {
                    n += 180;
                }
                if (n <= 90) break;
                n = 180 - n;
            }
        }
        return n;
    }
}

