/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.util.ArrayUtils;
import java.util.Iterator;
import java.util.TreeSet;

public class ConformerSet
extends TreeSet<Conformer> {
    public ConformerSet() {
        this((String)null);
    }

    public ConformerSet(String string) {
        String[] stringArray;
        if (string != null && (stringArray = string.split(" ")).length >= 2) {
            IDCodeParserWithoutCoordinateInvention iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
            StereoMolecule stereoMolecule = iDCodeParserWithoutCoordinateInvention.getCompactMolecule(stringArray[0], stringArray[1]);
            Conformer conformer = new Conformer(stereoMolecule);
            this.add(conformer);
            for (int i = 2; i < stringArray.length; ++i) {
                Conformer conformer2 = new Conformer(conformer);
                try {
                    iDCodeParserWithoutCoordinateInvention.parseCoordinates(stringArray[i].getBytes(), 0, stereoMolecule, conformer2.getCoordinates());
                    this.add(conformer2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public ConformerSet(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray2 != null) {
            IDCodeParserWithoutCoordinateInvention iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
            StereoMolecule stereoMolecule = iDCodeParserWithoutCoordinateInvention.getCompactMolecule(byArray, byArray2);
            Conformer conformer = new Conformer(stereoMolecule);
            this.add(conformer);
            int n = ArrayUtils.indexOf(byArray2, (byte)32, 0);
            while (n != -1) {
                Conformer conformer2 = new Conformer(conformer);
                try {
                    iDCodeParserWithoutCoordinateInvention.parseCoordinates(byArray2, n + 1, stereoMolecule, conformer2.getCoordinates());
                    this.add(conformer2);
                }
                catch (Exception exception) {}
            }
        }
    }

    public ConformerSet getSubset(int n) {
        ConformerSet conformerSet = new ConformerSet();
        this.stream().limit(n).forEach(conformer -> conformerSet.add(conformer));
        return conformerSet;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isEmpty()) {
            Iterator iterator = this.iterator();
            StereoMolecule stereoMolecule = ((Conformer)iterator.next()).toMolecule();
            Canonizer canonizer = new Canonizer(stereoMolecule, 64);
            stringBuilder.append(canonizer.getIDCode());
            stringBuilder.append(" ");
            stringBuilder.append(canonizer.getEncodedCoordinates(true));
            while (iterator.hasNext()) {
                canonizer.invalidateCoordinates();
                ((Conformer)iterator.next()).toMolecule(stereoMolecule);
                stringBuilder.append(" ");
                stringBuilder.append(canonizer.getEncodedCoordinates(true));
            }
        }
        return stringBuilder.toString();
    }
}

