/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.chemicalspaces.synthon;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.MoleculeStandardizer;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SynthonReactor {
    public static final int CONNECTOR_OFFSET = 92;

    public static StereoMolecule react(List<StereoMolecule> list3) {
        int n3;
        int[] nArray = new int[10];
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        ArrayList arrayList3 = new ArrayList();
        list3.stream().forEach(stereoMolecule -> arrayList3.add(new StereoMolecule((Molecule)stereoMolecule)));
        arrayList3.forEach(stereoMolecule -> stereoMolecule.ensureHelperArrays(31));
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>();
        for (int i = 0; i < arrayList3.size(); ++i) {
            StereoMolecule stereoMolecule2 = (StereoMolecule)arrayList3.get(i);
            for (int j = 0; j < stereoMolecule2.getAtoms(); ++j) {
                int n4;
                int n5 = stereoMolecule2.getAtomicNo(j);
                if (n5 < 92) continue;
                hashMap.putIfAbsent(n5 - 92 + 1, new ArrayList());
                n3 = stereoMolecule2.getConnAtom(j, 0);
                int n6 = stereoMolecule2.getBond(j, n3);
                int n7 = stereoMolecule2.getBondAtom(0, n6) == j ? -1 : 1;
                int n8 = stereoMolecule2.getBondType(n6);
                ((List)hashMap.get(n5 - 92 + 1)).add(new int[]{i, n3, j, n7, n8});
                nArray[0] = n4 = stereoMolecule2.getConnBondOrder(j, 0);
            }
        }
        ArrayList arrayList4 = new ArrayList();
        hashMap.forEach((n, list2) -> {
            if (list2.size() < 2) {
                arrayList4.add(n);
            }
        });
        hashMap.keySet().removeAll(arrayList4);
        hashMap.forEach((n, list2) -> {
            ((StereoMolecule)arrayList3.get(((int[])list2.get(0))[0])).markAtomForDeletion(((int[])list2.get(0))[2]);
            ((StereoMolecule)arrayList3.get(((int[])list2.get(1))[0])).markAtomForDeletion(((int[])list2.get(1))[2]);
            int n2 = ((int[])list2.get(0))[0];
            int n3 = ((int[])list2.get(1))[0];
            int n4 = ((int[])list2.get(0))[2];
            int n5 = ((int[])list2.get(1))[2];
            int n6 = ((int[])list2.get(0))[1];
            int n7 = ((int[])list2.get(1))[1];
            SynthonReactor.alignSynthons((StereoMolecule)arrayList3.get(n2), (StereoMolecule)arrayList3.get(n3), n4, n5, n6, n7);
        });
        int n9 = 0;
        while (n9 < arrayList3.size()) {
            StereoMolecule stereoMolecule3 = (StereoMolecule)arrayList3.get(n9);
            int[] nArray2 = stereoMolecule3.deleteMarkedAtomsAndBonds();
            arrayList.add(nArray2);
            n3 = n9++;
            hashMap.forEach((n2, list) -> list.stream().forEach(nArray2 -> {
                if (nArray2[0] == n3) {
                    nArray2[1] = nArray2[nArray2[1]];
                }
            }));
        }
        StereoMolecule stereoMolecule4 = new StereoMolecule();
        arrayList2.add(stereoMolecule4.addMolecule((Molecule)arrayList3.get(0)));
        int n10 = 1;
        while (n10 < arrayList3.size()) {
            int[] nArray3 = stereoMolecule4.addMolecule((Molecule)arrayList3.get(n10));
            arrayList2.add(nArray3);
            n3 = n10++;
            hashMap.forEach((n2, list) -> list.stream().forEach(nArray2 -> {
                if (nArray2[0] == n3) {
                    nArray2[1] = nArray3[nArray2[1]];
                }
            }));
        }
        hashMap.forEach((n, list) -> {
            int n2 = ((int[])list.get(0))[1];
            int n3 = ((int[])list.get(1))[1];
            int n4 = ((int[])list.get(0))[4];
            int n5 = ((int[])list.get(0))[3];
            int n6 = -1;
            n6 = n5 == 1 ? stereoMolecule4.addBond(n2, n3) : stereoMolecule4.addBond(n3, n2);
            stereoMolecule4.setBondOrder(n6, nArray[n - 1]);
            stereoMolecule4.setBondType(n6, n4);
        });
        stereoMolecule4.ensureHelperArrays(31);
        try {
            MoleculeStandardizer.standardize(stereoMolecule4, 0);
            stereoMolecule4.ensureHelperArrays(31);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stereoMolecule4;
    }

    public static void alignSynthons(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n, int n2, int n3, int n4) {
        int n5;
        Coordinates coordinates;
        Coordinates coordinates2 = stereoMolecule.getCoordinates(n).subC(stereoMolecule.getCoordinates(n3));
        Coordinates coordinates3 = stereoMolecule2.getCoordinates(n4).subC(stereoMolecule2.getCoordinates(n2));
        coordinates2.unit();
        coordinates3.unit();
        double d = Math.acos(coordinates2.dot(coordinates3));
        Coordinates coordinates4 = coordinates2.cross(coordinates3);
        if (coordinates4.dist() < 0.001) {
            coordinates = new Coordinates(0.0, 0.0, 1.0);
            d = Math.PI;
        } else {
            coordinates = coordinates4.unit();
        }
        Coordinates coordinates5 = stereoMolecule.getCoordinates(n3).scaleC(-1.0);
        for (n5 = 0; n5 < stereoMolecule.getAtoms(); ++n5) {
            stereoMolecule.getCoordinates(n5).add(coordinates5);
        }
        coordinates5 = stereoMolecule2.getCoordinates(n2).scaleC(-1.0);
        for (n5 = 0; n5 < stereoMolecule2.getAtoms(); ++n5) {
            stereoMolecule2.getCoordinates(n5).add(coordinates5);
        }
        for (n5 = 0; n5 < stereoMolecule2.getAtoms(); ++n5) {
            Coordinates coordinates6 = SynthonReactor.eulerRodrigues(stereoMolecule2.getCoordinates(n5), coordinates, -d);
            stereoMolecule2.setAtomX(n5, coordinates6.x);
            stereoMolecule2.setAtomY(n5, coordinates6.y);
            stereoMolecule2.setAtomZ(n5, coordinates6.z);
        }
    }

    public static Coordinates eulerRodrigues(Coordinates coordinates, Coordinates coordinates2, double d) {
        Coordinates coordinates3 = coordinates.scaleC(Math.cos(d));
        Coordinates coordinates4 = coordinates2.cross(coordinates).scale(Math.sin(d));
        Coordinates coordinates5 = coordinates2.scaleC(coordinates2.dot(coordinates) * (1.0 - Math.cos(d)));
        Coordinates coordinates6 = coordinates3.addC(coordinates4);
        coordinates6.add(coordinates5);
        return coordinates6;
    }
}

