/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.phesa.EncodeFunctions;
import java.util.Base64;

public class Translation
implements Transformation {
    private static final long serialVersionUID = 20211905L;
    private double[] translation;

    public Translation(double[] dArray) {
        this.translation = dArray;
    }

    public Translation(Coordinates coordinates) {
        this.translation = new double[3];
        this.translation[0] = coordinates.x;
        this.translation[1] = coordinates.y;
        this.translation[2] = coordinates.z;
    }

    public Translation(double d, double d2, double d3) {
        this.translation = new double[3];
        this.translation[0] = d;
        this.translation[1] = d2;
        this.translation[2] = d3;
    }

    @Override
    public void apply(Coordinates coordinates) {
        coordinates.add(this.translation[0], this.translation[1], this.translation[2]);
    }

    @Override
    public void apply(double[] dArray) {
        dArray[0] = dArray[0] + this.translation[0];
        dArray[1] = dArray[1] + this.translation[1];
        dArray[2] = dArray[2] + this.translation[2];
    }

    public static Translation decode(String string) {
        double[] dArray = EncodeFunctions.byteArrayToDoubleArray(Base64.getDecoder().decode(string));
        return new Translation(dArray);
    }

    @Override
    public String encode() {
        Base64.Encoder encoder = Base64.getEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("t");
        stringBuilder.append(" ");
        stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleArrayToByteArray(this.translation)));
        return stringBuilder.toString();
    }
}

