/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.phesa.EncodeFunctions;
import java.util.Base64;

public class Rotation
implements Transformation {
    private static final String DELIMITER = ";";
    private double[][] m;

    public double[][] getRotation() {
        return this.m;
    }

    public Rotation(double[][] dArray) {
        this.m = dArray;
    }

    public Rotation() {
        this(new double[3][3]);
    }

    public void setRotation(double[][] dArray) {
        this.m = dArray;
    }

    public Rotation getInvert() {
        double[][] dArray = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[j][i] = this.m[i][j];
            }
        }
        return new Rotation(dArray);
    }

    @Override
    public void apply(Coordinates coordinates) {
        coordinates.rotate(this.m);
    }

    @Override
    public void apply(double[] dArray) {
        assert (dArray.length == 3);
        Coordinates coordinates = new Coordinates(dArray[0], dArray[1], dArray[2]);
        this.apply(coordinates);
        dArray[0] = coordinates.x;
        dArray[1] = coordinates.y;
        dArray[2] = coordinates.z;
    }

    @Override
    public String encode() {
        Base64.Encoder encoder = Base64.getEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("r");
        stringBuilder.append(" ");
        for (double[] dArray : this.m) {
            stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleArrayToByteArray(dArray)));
            stringBuilder.append(DELIMITER);
        }
        return stringBuilder.toString();
    }

    public static Rotation decode(String string) {
        String[] stringArray = string.split(DELIMITER);
        double[] dArray = EncodeFunctions.byteArrayToDoubleArray(Base64.getDecoder().decode(stringArray[0]));
        double[] dArray2 = EncodeFunctions.byteArrayToDoubleArray(Base64.getDecoder().decode(stringArray[1]));
        double[] dArray3 = EncodeFunctions.byteArrayToDoubleArray(Base64.getDecoder().decode(stringArray[2]));
        double[][] dArray4 = new double[3][3];
        dArray4[0] = dArray;
        dArray4[1] = dArray2;
        dArray4[2] = dArray3;
        return new Rotation(dArray4);
    }
}

