/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;

public class ExponentialMap {
    public static final double EPSILON = 1.0E-6;
    public static final double CUTOFF_ANGLE = Math.PI;
    private Coordinates p;

    public ExponentialMap(Quaternion quaternion) {
        this.calc(quaternion);
        this.checkParameterization();
    }

    public ExponentialMap(Coordinates coordinates) {
        this.p = coordinates;
        this.checkParameterization();
    }

    public ExponentialMap(double d, double d2, double d3) {
        this.p = new Coordinates(d, d2, d3);
    }

    public Coordinates getP() {
        return this.p;
    }

    private void calc(Quaternion quaternion) {
        Coordinates coordinates = new Coordinates(0.0, 0.0, 0.0);
        Coordinates coordinates2 = new Coordinates(quaternion.getQ1(), quaternion.getQ2(), quaternion.getQ3());
        double d = quaternion.getQ0();
        double d2 = coordinates2.getLength();
        double d3 = 2.0 * Math.atan2(d2, d);
        if (d3 > 1.0E-6) {
            coordinates = coordinates2.scaleC(1.0 / Math.sin(d3 / 2.0));
        }
        coordinates.scale(d3);
        this.p = coordinates;
    }

    public Quaternion toQuaternion() {
        double d = this.p.getLength();
        double d2 = Math.cos(0.5 * d);
        double d3 = Math.sin(0.5 * d);
        double d4 = d2;
        Coordinates coordinates = d < 1.0E-6 ? this.p.scaleC(0.5 - d * d / 48.0) : this.p.scaleC(d3 / d);
        return new Quaternion(d4, coordinates.x, coordinates.y, coordinates.z);
    }

    private void checkParameterization() {
        double d = this.p.getLength();
        if (d > Math.PI) {
            double d2 = d;
            if (d > Math.PI * 2) {
                d2 = (d %= Math.PI * 2) / d2;
                this.p.scale(d2);
            }
            if (d > Math.PI) {
                d2 = d;
                d = Math.PI * 2 - d;
                d2 = 1.0 - Math.PI * 2 / d2;
                this.p.scale(d2);
            }
        }
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray;
        double d = 0.707106781;
        for (double[] dArray : dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {d, d, 0.0, 0.0}, {d, 0.0, d, 0.0}, {d, 0.0, 0.0, d}, {-0.5, 0.5, 0.5, -0.5}, {0.5, -0.5, 0.5, -0.5}, {0.5, 0.5, 0.5, -0.5}, {0.5, -0.5, -0.5, -0.5}, {0.5, 0.5, -0.5, -0.5}}) {
            ExponentialMap exponentialMap = new ExponentialMap(new Quaternion(dArray[0], dArray[1], dArray[2], dArray[3]));
            System.out.println(exponentialMap.toQuaternion());
        }
    }
}

