/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.PheSAMolecule;
import com.actelion.research.chem.phesa.ShapeVolume;
import com.actelion.research.chem.phesa.pharmacophore.PPTriangle;
import com.actelion.research.chem.phesa.pharmacophore.PPTriangleCreator;
import com.actelion.research.chem.phesa.pharmacophore.PPTriangleMatcher;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class PheSAAlignmentOptimizer {
    public static int TRIANGLE_OPTIMIZATIONS = 50;
    public static int PMI_OPTIMIZATIONS = 10;
    private static double EXIT_VECTOR_WEIGHT = 10.0;
    private static final int BEST_RESULT_SIZE = 20;

    private PheSAAlignmentOptimizer() {
    }

    public static double alignTwoMolsInPlace(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        return PheSAAlignmentOptimizer.alignTwoMolsInPlace(stereoMolecule, stereoMolecule2, 0.5);
    }

    public static double alignTwoMolsInPlace(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, double d) {
        PheSASetting pheSASetting = new PheSASetting();
        pheSASetting.setPpWeight(d);
        double d2 = 0.0;
        MolecularVolume molecularVolume = new MolecularVolume(stereoMolecule);
        MolecularVolume molecularVolume2 = new MolecularVolume(stereoMolecule2);
        Coordinates coordinates = new Coordinates(molecularVolume.getCOM());
        Conformer conformer = new Conformer(stereoMolecule);
        Conformer conformer2 = new Conformer(stereoMolecule2);
        Rotation rotation = molecularVolume.preProcess(conformer);
        rotation = rotation.getInvert();
        molecularVolume2.preProcess(conformer2);
        AlignmentResult alignmentResult = PheSAAlignmentOptimizer.createAlignmentSolutions(Collections.singletonList(molecularVolume), Collections.singletonList(molecularVolume2), pheSASetting).get(0);
        d2 = alignmentResult.getSimilarity();
        for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
            stereoMolecule2.setAtomX(i, conformer2.getX(i));
            stereoMolecule2.setAtomY(i, conformer2.getY(i));
            stereoMolecule2.setAtomZ(i, conformer2.getZ(i));
        }
        alignmentResult.getTransform().apply(stereoMolecule2);
        rotation.apply(stereoMolecule2);
        stereoMolecule2.translate(coordinates.x, coordinates.y, coordinates.z);
        return d2;
    }

    public static List<AlignmentResult> alignToNegRecImg(ShapeVolume shapeVolume, List<? extends ShapeVolume> list, PheSASetting pheSASetting) {
        for (ShapeVolume object2 : list) {
            object2.removeRings();
        }
        List<AlignmentResult> list2 = PheSAAlignmentOptimizer.createAlignmentSolutions(Collections.singletonList(shapeVolume), list, pheSASetting);
        ArrayList<AlignmentResult> arrayList = new ArrayList<AlignmentResult>();
        int n = 0;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            AlignmentResult alignmentResult = (AlignmentResult)iterator.next();
            if (n++ >= 20) break;
            arrayList.add(alignmentResult);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<AlignmentResult> createAlignmentSolutions(List<? extends ShapeVolume> list, List<? extends ShapeVolume> list2, PheSASetting pheSASetting) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = pheSASetting.nrOptimizationsPMI;
        ArrayList<AlignmentResult> arrayList = new ArrayList<AlignmentResult>();
        for (ShapeVolume object62 : list) {
            for (PPGaussian n2 : object62.getPPGaussians()) {
                if (n2.getPharmacophorePoint().getFunctionalityIndex() != 7) continue;
                n2.setWeight(EXIT_VECTOR_WEIGHT);
            }
        }
        List<AlignmentResult> list3 = new ArrayList();
        if (pheSASetting.useTriangle) {
            list3 = PheSAAlignmentOptimizer.getBestTriangleAlignments(list, list2, pheSASetting);
        }
        arrayList.addAll(list3);
        ArrayList<AlignmentResult> arrayList2 = new ArrayList<AlignmentResult>();
        for (int list4 = 0; list4 < list.size(); ++list4) {
            ShapeVolume shapeVolume = list.get(list4);
            for (int i = 0; i < list2.size(); ++i) {
                Object object6 = new ShapeVolume(list2.get(i));
                object5 = new PheSAAlignment(shapeVolume, (ShapeVolume)object6, pheSASetting.ppWeight);
                object4 = new TransformationSequence();
                object3 = PheSAAlignment.initialTransform(2);
                object2 = ((PheSAAlignment)object5).findAlignment((double[][])object3, (TransformationSequence)object4, false, pheSASetting.getSimMode());
                object = new AlignmentResult(object2[0], (TransformationSequence)object4, list4, i);
                ((AlignmentResult)object).setSimilarityContributions((double[])object2);
                arrayList2.add((AlignmentResult)object);
            }
        }
        List list4 = arrayList2.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        boolean bl = false;
        for (Object object6 : list4) {
            void var8_15;
            if (++var8_15 > n) break;
            object5 = list.get(((AlignmentResult)object6).getRefConformerIndex());
            object4 = new ShapeVolume(list2.get(((AlignmentResult)object6).getConformerIndex()));
            object3 = ((AlignmentResult)object6).getTransform();
            ((ShapeVolume)object4).transform((Transformation)object3);
            object2 = new PheSAAlignment((ShapeVolume)object5, (ShapeVolume)object4, pheSASetting.ppWeight);
            object = new TransformationSequence();
            double[] dArray = ((PheSAAlignment)object2).findAlignment(PheSAAlignment.initialTransform(0), (TransformationSequence)object, true, pheSASetting.simMode);
            ((AlignmentResult)object6).getTransform().addTransformation((Transformation)object);
            AlignmentResult alignmentResult = new AlignmentResult(dArray[0], ((AlignmentResult)object6).getTransform(), ((AlignmentResult)object6).getRefConformerIndex(), ((AlignmentResult)object6).getConformerIndex());
            alignmentResult.setSimilarityContributions(dArray);
            arrayList.add(alignmentResult);
        }
        List list5 = arrayList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        return list5;
    }

    public static double[] align(PheSAMolecule pheSAMolecule, PheSAMolecule pheSAMolecule2, StereoMolecule[] stereoMoleculeArray, PheSASetting pheSASetting) {
        double[] dArray = new double[4];
        List<AlignmentResult> list = PheSAAlignmentOptimizer.createAlignmentSolutions(pheSAMolecule.getVolumes(), pheSAMolecule2.getVolumes(), pheSASetting);
        AlignmentResult alignmentResult = list.get(0);
        StereoMolecule stereoMolecule = pheSAMolecule.getConformer(alignmentResult.getRefConformerIndex());
        StereoMolecule stereoMolecule2 = pheSAMolecule2.getConformer(alignmentResult.getConformerIndex());
        alignmentResult.getTransform().apply(stereoMolecule2);
        dArray = alignmentResult.getSimilarityContributions();
        stereoMoleculeArray[0] = stereoMolecule;
        stereoMoleculeArray[1] = stereoMolecule2;
        int n = pheSAMolecule.getVolumes().get(0).getExitVectorGaussians().size();
        int n2 = pheSAMolecule2.getVolumes().get(0).getExitVectorGaussians().size();
        if ((pheSAMolecule.getVolumes().get(0).getExitVectorGaussians().size() != 0 || pheSAMolecule.getVolumes().get(0).getExitVectorGaussians().size() != 0) && n != n2) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 0.0;
        }
        return dArray;
    }

    private static List<AlignmentResult> getBestTriangleAlignments(List<? extends ShapeVolume> list, List<? extends ShapeVolume> list2, PheSASetting pheSASetting) {
        int n;
        List<AlignmentResult> list3;
        Object object;
        ArrayList<AlignmentResult> arrayList = new ArrayList<AlignmentResult>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            list3 = PPTriangleCreator.create(((ShapeVolume)object).getPPGaussians(), ((ShapeVolume)object).getCOM());
            for (n = 0; n < list2.size(); ++n) {
                ShapeVolume shapeVolume = list2.get(n);
                Object object2 = PPTriangleCreator.create(shapeVolume.getPPGaussians(), shapeVolume.getCOM());
                arrayList.addAll(PPTriangleMatcher.getMatchingTransforms(list3, (Map<Integer, ArrayList<PPTriangle>>)object2, i, n, pheSASetting.useDirectionality));
            }
        }
        List list4 = arrayList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        object = new ArrayList();
        if (arrayList.size() != 0) {
            list3 = (List<AlignmentResult>)PheSAAlignment.initialTransform(0);
            n = 0;
            for (Object object2 : list4) {
                if (n++ > pheSASetting.nrOptimizationsTriangle) break;
                ShapeVolume shapeVolume = list.get(((AlignmentResult)object2).getRefConformerIndex());
                ShapeVolume shapeVolume2 = new ShapeVolume(list2.get(((AlignmentResult)object2).getConformerIndex()));
                TransformationSequence transformationSequence = ((AlignmentResult)object2).getTransform();
                shapeVolume2.transform(transformationSequence);
                PheSAAlignment pheSAAlignment = new PheSAAlignment(shapeVolume, shapeVolume2, pheSASetting.ppWeight);
                TransformationSequence transformationSequence2 = new TransformationSequence();
                double[] dArray = pheSAAlignment.findAlignment((double[][])list3, transformationSequence2, true, pheSASetting.simMode);
                transformationSequence.addTransformation(transformationSequence2);
                AlignmentResult alignmentResult = new AlignmentResult(dArray[0], transformationSequence, ((AlignmentResult)object2).getRefConformerIndex(), ((AlignmentResult)object2).getConformerIndex());
                alignmentResult.setSimilarityContributions(dArray);
                object.add(alignmentResult);
            }
        }
        list3 = object.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        return list3;
    }

    private static double[][] createSubAlignments(ShapeVolume shapeVolume, double[][] dArray) {
        int n = Math.min(shapeVolume.getAtomicGaussians().size(), 10);
        Random random = new Random(12345L);
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(shapeVolume.getAtomicGaussians().size());
            Coordinates coordinates = shapeVolume.getAtomicGaussians().get(n2).getCenter();
            for (double[] dArray2 : dArray) {
                arrayList.add(new double[]{dArray2[0], dArray2[1], dArray2[2], coordinates.x, coordinates.y, coordinates.z});
            }
        }
        for (double[] dArray3 : dArray) {
            arrayList.add(dArray3);
        }
        return (double[][])arrayList.toArray((T[])new double[0][]);
    }

    public static class PheSASetting {
        private double ppWeight = 0.5;
        private SimilarityMode simMode = SimilarityMode.TANIMOTO;
        private boolean useDirectionality = true;
        private boolean useTriangle = true;
        private int nrOptimizationsPMI = PMI_OPTIMIZATIONS;
        private int nrOptimizationsTriangle = TRIANGLE_OPTIMIZATIONS;
        private static final String DELIMITER1 = "_";

        public double getPpWeight() {
            return this.ppWeight;
        }

        public void setPpWeight(double d) {
            this.ppWeight = d;
        }

        public SimilarityMode getSimMode() {
            return this.simMode;
        }

        public void setSimMode(SimilarityMode similarityMode) {
            this.simMode = similarityMode;
        }

        public boolean isUseDirectionality() {
            return this.useDirectionality;
        }

        public void setUseDirectionality(boolean bl) {
            this.useDirectionality = bl;
        }

        public int getNrOptimizationsPMI() {
            return this.nrOptimizationsPMI;
        }

        public void setNrOptimizationsPMI(int n) {
            this.nrOptimizationsPMI = n;
        }

        public int getNrOptimizationsTriangle() {
            return this.nrOptimizationsTriangle;
        }

        public void setNrOptimizationsTriangle(int n) {
            this.nrOptimizationsTriangle = n;
        }

        public boolean isUseTriangle() {
            return this.useTriangle;
        }

        public void setUseTriangle(boolean bl) {
            this.useTriangle = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Double.toString(this.ppWeight));
            stringBuilder.append(DELIMITER1);
            stringBuilder.append(this.simMode.toString());
            stringBuilder.append(DELIMITER1);
            stringBuilder.append(Boolean.toString(this.useDirectionality));
            stringBuilder.append(DELIMITER1);
            stringBuilder.append(Boolean.toString(this.useTriangle));
            stringBuilder.append(DELIMITER1);
            stringBuilder.append(Integer.toString(this.nrOptimizationsPMI));
            stringBuilder.append(DELIMITER1);
            stringBuilder.append(Integer.toString(this.nrOptimizationsTriangle));
            return stringBuilder.toString();
        }

        public static PheSASetting fromString(String string) {
            PheSASetting pheSASetting = new PheSASetting();
            String[] stringArray = string.split(DELIMITER1);
            pheSASetting.setPpWeight(Double.parseDouble(stringArray[0]));
            pheSASetting.setSimMode(SimilarityMode.valueOf(stringArray[1]));
            pheSASetting.setUseDirectionality(Boolean.parseBoolean(stringArray[2]));
            pheSASetting.setUseTriangle(Boolean.parseBoolean(stringArray[3]));
            pheSASetting.setNrOptimizationsPMI(Integer.parseInt(stringArray[4]));
            pheSASetting.setNrOptimizationsTriangle(Integer.parseInt(stringArray[5]));
            return pheSASetting;
        }
    }

    public static class AlignmentResult
    implements Comparable<AlignmentResult> {
        private double similarity;
        private TransformationSequence transformation;
        private int conformerIndex;
        private int refConformerIndex;
        private double[] similarityContributions;

        public AlignmentResult(double d, TransformationSequence transformationSequence, int n, int n2) {
            this.similarity = d;
            this.transformation = transformationSequence;
            this.refConformerIndex = n;
            this.conformerIndex = n2;
        }

        public double[] getSimilarityContributions() {
            return this.similarityContributions;
        }

        public void setSimilarityContributions(double[] dArray) {
            this.similarityContributions = dArray;
        }

        public TransformationSequence getTransform() {
            return this.transformation;
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public int getConformerIndex() {
            return this.conformerIndex;
        }

        public int getRefConformerIndex() {
            return this.refConformerIndex;
        }

        @Override
        public int compareTo(AlignmentResult alignmentResult) {
            return Double.compare(this.similarity, alignmentResult.similarity);
        }
    }

    public static enum SimilarityMode {
        REFTVERSKY,
        TVERSKY,
        TANIMOTO;

    }
}

