/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import java.util.TreeMap;

public class StereoIsomerEnumerator {
    private boolean mSkipEnantiomers;
    private StereoMolecule mMol;
    private int[][] mAtomGroupList;
    private int[][] mBondGroupList;
    private int[][] mUnknownDoubleBondList;
    private boolean[][] mAtomIsParity1;
    private boolean[][] mBondIsParity1;

    public StereoIsomerEnumerator(StereoMolecule stereoMolecule, boolean bl) {
        int n;
        int[] nArray;
        int[] nArray2;
        int n2;
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(15);
        TreeMap<Object, int[]> treeMap = new TreeMap<Object, int[]>();
        this.mSkipEnantiomers = bl;
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            Object object;
            if (this.mMol.getAtomParity(n2) == 0 || this.mMol.isAtomParityPseudo(n2)) continue;
            if (this.mMol.getAtomParity(n2) == 3) {
                object = new int[]{n2};
                treeMap.put("U" + n2, (int[])object);
                continue;
            }
            if (this.mMol.getAtomESRType(n2) == 0) {
                this.mSkipEnantiomers = false;
                continue;
            }
            object = (this.mMol.getAtomESRType(n2) == 2 ? "O" : "A") + this.mMol.getAtomESRGroup(n2);
            nArray2 = (int[])treeMap.get(object);
            if (nArray2 == null) {
                nArray2 = new int[]{n2};
                treeMap.put(object, nArray2);
                continue;
            }
            nArray = new int[nArray2.length + 1];
            for (n = 0; n < nArray2.length; ++n) {
                nArray[n] = nArray2[n];
            }
            nArray[nArray2.length] = n2;
            treeMap.put(object, nArray);
        }
        this.mAtomGroupList = (int[][])treeMap.values().toArray((T[])new int[0][]);
        this.mAtomIsParity1 = new boolean[this.mAtomGroupList.length][];
        for (n2 = 0; n2 < this.mAtomGroupList.length; ++n2) {
            this.mAtomIsParity1[n2] = new boolean[this.mAtomGroupList[n2].length];
            for (int i = 0; i < this.mAtomGroupList[n2].length; ++i) {
                this.mAtomIsParity1[n2][i] = this.mMol.getAtomParity(this.mAtomGroupList[n2][i]) == 1;
            }
        }
        treeMap.clear();
        for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
            Object object;
            if (this.mMol.getBondParity(n2) == 0 || this.mMol.isBondParityPseudo(n2) || this.mMol.getBondOrder(n2) != 1) continue;
            if (this.mMol.getBondParity(n2) == 3) {
                object = new int[]{n2};
                treeMap.put("U" + n2, (int[])object);
                continue;
            }
            if (this.mMol.getBondESRType(n2) == 0) {
                this.mSkipEnantiomers = false;
                continue;
            }
            object = (this.mMol.getBondESRType(n2) == 2 ? "O" : "A") + this.mMol.getBondESRGroup(n2);
            nArray2 = (int[])treeMap.get(object);
            if (nArray2 == null) {
                nArray2 = new int[]{n2};
                treeMap.put(object, nArray2);
                continue;
            }
            nArray = new int[nArray2.length + 1];
            for (n = 0; n < nArray2.length; ++n) {
                nArray[n] = nArray2[n];
            }
            nArray[nArray2.length] = n2;
            treeMap.put(object, nArray);
        }
        this.mBondGroupList = (int[][])treeMap.values().toArray((T[])new int[0][]);
        this.mBondIsParity1 = new boolean[this.mBondGroupList.length][];
        for (n2 = 0; n2 < this.mBondGroupList.length; ++n2) {
            this.mBondIsParity1[n2] = new boolean[this.mBondGroupList[n2].length];
            for (int i = 0; i < this.mBondGroupList[n2].length; ++i) {
                this.mBondIsParity1[n2][i] = this.mMol.getBondParity(this.mBondGroupList[n2][i]) == 1;
            }
        }
        if (this.mAtomGroupList.length == 0 && this.mBondGroupList.length == 0) {
            this.mSkipEnantiomers = false;
        }
        treeMap.clear();
        for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
            if (this.mMol.getBondParity(n2) != 3 || this.mMol.isBondParityPseudo(n2) || this.mMol.getBondOrder(n2) != 2) continue;
            int[] nArray3 = new int[]{n2};
            treeMap.put("U" + n2, nArray3);
        }
        this.mUnknownDoubleBondList = (int[][])treeMap.values().toArray((T[])new int[0][]);
    }

    public boolean isSkippingEnantiomers() {
        return this.mSkipEnantiomers;
    }

    public int getStereoIsomerCount() {
        return 1 << this.mAtomGroupList.length + this.mBondGroupList.length + this.mUnknownDoubleBondList.length - (this.mSkipEnantiomers ? 1 : 0);
    }

    public StereoMolecule getStereoIsomer(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        StereoMolecule stereoMolecule = new StereoMolecule(this.mMol);
        boolean bl = this.mSkipEnantiomers;
        for (n6 = 0; n6 < this.mAtomGroupList.length; ++n6) {
            n5 = !bl && (n & 1) != 0 ? 1 : 0;
            for (n4 = 0; n4 < this.mAtomGroupList[n6].length; ++n4) {
                n3 = (n5 ^ this.mAtomIsParity1[n6][n4]) != 0 ? 2 : 1;
                n2 = this.mAtomGroupList[n6][n4];
                stereoMolecule.setAtomParity(n2, n3, false);
                stereoMolecule.setAtomESR(n2, 0, 0);
            }
            if (bl) {
                bl = false;
                continue;
            }
            n >>= 1;
        }
        for (n6 = 0; n6 < this.mBondGroupList.length; ++n6) {
            n5 = !bl && (n & 1) != 0 ? 1 : 0;
            for (n4 = 0; n4 < this.mBondGroupList[n6].length; ++n4) {
                n3 = (n5 ^ this.mBondIsParity1[n6][n4]) != 0 ? 2 : 1;
                n2 = this.mBondGroupList[n6][n4];
                stereoMolecule.setBondParity(n2, n3, false);
                stereoMolecule.setBondESR(n2, 0, 0);
            }
            if (bl) {
                bl = false;
                continue;
            }
            n >>= 1;
        }
        for (n6 = 0; n6 < this.mUnknownDoubleBondList.length; ++n6) {
            n5 = (n & 1) != 0 ? 2 : 1;
            n4 = this.mUnknownDoubleBondList[n6][0];
            stereoMolecule.setBondType(n4, 2);
            stereoMolecule.setBondParity(n4, n5, false);
            n >>= 1;
        }
        stereoMolecule.setParitiesValid(0);
        stereoMolecule.setStereoBondsFromParity();
        if (this.mUnknownDoubleBondList.length != 0) {
            stereoMolecule.setParitiesValid(0);
            new CoordinateInventor(0).invent(stereoMolecule);
        }
        return stereoMolecule;
    }

    public boolean isCorrectStereoIsomer(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        stereoMolecule.ensureHelperArrays(15);
        boolean bl = this.mSkipEnantiomers;
        for (n6 = 0; n6 < this.mAtomGroupList.length; ++n6) {
            n5 = !bl && (n & 1) != 0 ? 1 : 0;
            for (n4 = 0; n4 < this.mAtomGroupList[n6].length; ++n4) {
                n3 = (n5 ^ this.mAtomIsParity1[n6][n4]) != 0 ? 2 : 1;
                n2 = this.mAtomGroupList[n6][n4];
                if (stereoMolecule.getAtomParity(n2) == n3) continue;
                return false;
            }
            if (bl) {
                bl = false;
                continue;
            }
            n >>= 1;
        }
        for (n6 = 0; n6 < this.mBondGroupList.length; ++n6) {
            n5 = !bl && (n & 1) != 0 ? 1 : 0;
            for (n4 = 0; n4 < this.mBondGroupList[n6].length; ++n4) {
                n3 = (n5 ^ this.mBondIsParity1[n6][n4]) != 0 ? 2 : 1;
                n2 = this.mBondGroupList[n6][n4];
                if (stereoMolecule.getBondParity(n2) == n3) continue;
                return false;
            }
            if (bl) {
                bl = false;
                continue;
            }
            n >>= 1;
        }
        for (n6 = 0; n6 < this.mUnknownDoubleBondList.length; ++n6) {
            n5 = (n & 1) != 0 ? 2 : 1;
            n4 = this.mUnknownDoubleBondList[n6][0];
            if (stereoMolecule.getBondParity(n4) != n5) {
                return false;
            }
            n >>= 1;
        }
        return true;
    }
}

