/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class SSSearcher {
    public static final int cMatchAtomCharge = 1;
    public static final int cMatchAtomMass = 2;
    public static final int cMatchDBondToDelocalized = 4;
    public static final int cMatchAromDBondToDelocalized = 8;
    public static final int cIndexMatchMode = 4;
    public static final int cDefaultMatchMode = 8;
    public static final int cCountModeExistence = 1;
    public static final int cCountModeFirstMatch = 2;
    public static final int cCountModeSeparated = 3;
    public static final int cCountModeOverlapping = 4;
    public static final int cCountModeRigorous = 5;
    public static final int cCountModeUnique = 6;
    private int mDefaultMatchMode;
    protected StereoMolecule mMolecule;
    protected StereoMolecule mFragment;
    private int[] mMoleculeAtomType;
    private int[] mFragmentAtomType;
    private long[] mMoleculeAtomFeatures;
    private long[] mFragmentAtomFeatures;
    private long[] mMoleculeRingFeatures;
    private long[] mFragmentRingFeatures;
    private int[] mMoleculeBondFeatures;
    private int[] mFragmentBondFeatures;
    private int mFragmentExcludeAtoms;
    private int mFragmentExcludeBonds;
    private int mFragmentGraphSize;
    private int mFragmentGraphSizeWithExcludeGroups;
    private int[] mFragmentGraphAtom;
    private int[] mFragmentGraphParentAtom;
    private int[] mFragmentGraphParentBond;
    private boolean[] mFragmentGraphIsRingClosure;
    private boolean[] mIsExcludeAtom;
    private boolean[] mIsBridgeBondAtom;
    private int[] mFragmentConnAtoms;
    private int[] mMatchTable;
    private int[] mExcludeGroupNo;
    private int[] mExcludeGroupGraphIndex;
    private int[] mFragmentAtomContextRank;
    private TreeSet<int[]> mSortedMatchSet;
    private ArrayList<int[]> mMatchList;
    private ArrayList<BridgeBond> mBridgeBondList;
    private ArrayList<boolean[]> mBridgeBondAtomList;
    private boolean mMoleculeFeaturesValid;
    private boolean mFragmentFeaturesValid;
    private int mRequiredHelperLevel;
    private int mExcludeGroupCount;
    private volatile boolean mStop;

    public SSSearcher() {
        this.mDefaultMatchMode = 8;
        this.mSortedMatchSet = new TreeSet<int[]>(new IntArrayComparator());
    }

    public SSSearcher(int n) {
        this.mDefaultMatchMode = n;
        this.mSortedMatchSet = new TreeSet<int[]>(new IntArrayComparator());
    }

    public void setMol(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this.setMolecule(stereoMolecule2);
        this.setFragment(stereoMolecule);
    }

    public void setMolecule(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null || stereoMolecule.getAllAtoms() == 0) {
            this.mMolecule = null;
            return;
        }
        this.mMolecule = stereoMolecule;
        this.mMoleculeFeaturesValid = false;
        this.mMolecule.ensureHelperArrays(1);
    }

    public void stop() {
        this.mStop = true;
    }

    public void setFragment(StereoMolecule stereoMolecule) {
        int n;
        if (stereoMolecule == null || stereoMolecule.getAllAtoms() == 0 || !stereoMolecule.isFragment()) {
            this.mFragment = null;
            return;
        }
        this.mFragment = stereoMolecule;
        this.mFragmentFeaturesValid = false;
        this.mFragment.ensureHelperArrays(1);
        this.mRequiredHelperLevel = 7;
        for (n = 0; n < this.mFragment.getAtoms(); ++n) {
            if ((this.mFragment.getAtomQueryFeatures(n) & 0x300000002000L) == 0L) continue;
            this.mRequiredHelperLevel = 15;
        }
        for (n = 0; n < this.mFragment.getBonds(); ++n) {
            if ((this.mFragment.getBondQueryFeatures(n) & 0x100000) == 0) continue;
            this.mRequiredHelperLevel = 15;
        }
        if (this.mMoleculeFeaturesValid && this.mRequiredHelperLevel != 7) {
            this.mMolecule.ensureHelperArrays(this.mRequiredHelperLevel);
        }
        this.mFragmentExcludeAtoms = 0;
        this.mFragmentExcludeBonds = 0;
        this.mIsExcludeAtom = new boolean[this.mFragment.getAtoms()];
        for (n = 0; n < this.mFragment.getAtoms(); ++n) {
            boolean bl = this.mIsExcludeAtom[n] = (this.mFragment.getAtomQueryFeatures(n) & 0x20000000L) != 0L;
            if (!this.mIsExcludeAtom[n]) continue;
            ++this.mFragmentExcludeAtoms;
        }
        this.mExcludeGroupCount = 0;
        this.mExcludeGroupNo = null;
        this.mFragmentAtomContextRank = null;
        if (this.mFragmentExcludeAtoms != 0) {
            if (this.mFragmentExcludeAtoms != 0) {
                for (n = 0; n < this.mFragment.getBonds(); ++n) {
                    if (!this.mIsExcludeAtom[this.mFragment.getBondAtom(0, n)] && !this.mIsExcludeAtom[this.mFragment.getBondAtom(1, n)]) continue;
                    ++this.mFragmentExcludeBonds;
                }
            }
            for (n = 0; n < this.mFragment.getAllAtoms(); ++n) {
                this.mFragment.setAtomMarker(n, this.mIsExcludeAtom[n]);
            }
            this.mExcludeGroupNo = new int[this.mFragment.getAllAtoms()];
            this.mExcludeGroupCount = this.mFragment.getFragmentNumbers(this.mExcludeGroupNo, true, false);
        }
    }

    public void setFragmentSymmetryConstraints(int[] nArray) {
        this.mFragmentAtomContextRank = nArray;
    }

    private void buildFragmentGraph() {
        int n;
        int n2;
        int n3;
        this.mFragment.ensureHelperArrays(this.mRequiredHelperLevel);
        int n4 = Math.max(this.mFragment.getAtoms(), this.mFragment.getBonds()) + 16;
        this.mFragmentGraphAtom = new int[n4];
        this.mFragmentGraphParentAtom = new int[n4];
        this.mFragmentGraphParentBond = new int[n4];
        this.mFragmentGraphIsRingClosure = new boolean[n4 + 1];
        boolean[] blArray = new boolean[this.mFragment.getAtoms()];
        boolean[] blArray2 = new boolean[this.mFragment.getBonds()];
        int n5 = 0;
        for (n3 = 0; n3 < this.mFragment.getAtoms(); ++n3) {
            if (this.mIsExcludeAtom[n3] || blArray[n3]) continue;
            this.mFragmentGraphAtom[n5] = n3;
            this.mFragmentGraphParentBond[n5] = -1;
            this.mFragmentGraphParentAtom[n5] = -1;
            n2 = n5;
            while (n5 <= n2) {
                for (n = 0; n < this.mFragment.getAllConnAtomsPlusMetalBonds(this.mFragmentGraphAtom[n5]); ++n) {
                    n2 = this.tryAddCandidate(n5, n2, n, blArray, blArray2, -1);
                }
                while (this.mFragmentGraphIsRingClosure[++n5]) {
                }
            }
        }
        this.mFragmentGraphSize = n5;
        if (this.mFragmentExcludeAtoms != 0) {
            n3 = this.mFragmentGraphSize - 1;
            for (n2 = 0; n2 < this.mExcludeGroupCount; ++n2) {
                n5 = 0;
                while (n5 <= n3) {
                    for (n = 0; n < this.mFragment.getAllConnAtomsPlusMetalBonds(this.mFragmentGraphAtom[n5]); ++n) {
                        n3 = this.tryAddCandidate(n5, n3, n, blArray, blArray2, n2);
                    }
                    while (this.mFragmentGraphIsRingClosure[++n5]) {
                    }
                }
            }
            for (n2 = 0; n2 < this.mFragment.getAtoms(); ++n2) {
                if (!this.mIsExcludeAtom[n2] || blArray[n2]) continue;
                this.mFragmentGraphAtom[n5] = n2;
                this.mFragmentGraphParentBond[n5] = -1;
                this.mFragmentGraphParentAtom[n5] = -1;
                n3 = n5;
                while (n5 <= n3) {
                    for (n = 0; n < this.mFragment.getAllConnAtomsPlusMetalBonds(this.mFragmentGraphAtom[n5]); ++n) {
                        if (this.mFragment.getConnAtom(this.mFragmentGraphAtom[n5], n) >= this.mFragment.getAtoms()) continue;
                        n3 = this.tryAddCandidate(n5, n3, n, blArray, blArray2, this.mExcludeGroupNo[n2]);
                    }
                    while (this.mFragmentGraphIsRingClosure[++n5]) {
                    }
                }
            }
            this.mExcludeGroupGraphIndex = new int[this.mExcludeGroupCount];
            for (n2 = 0; n2 < this.mExcludeGroupCount; ++n2) {
                this.mExcludeGroupGraphIndex[n2] = -1;
            }
            for (n2 = this.mFragmentGraphSize; n2 < n5; ++n2) {
                n = this.mExcludeGroupNo[this.mFragmentGraphAtom[n2]];
                if (this.mExcludeGroupGraphIndex[n] != -1) continue;
                this.mExcludeGroupGraphIndex[n] = n2;
            }
        }
        this.mFragmentGraphSizeWithExcludeGroups = n5;
    }

    private int tryAddCandidate(int n, int n2, int n3, boolean[] blArray, boolean[] blArray2, int n4) {
        int n5;
        int n6 = this.mFragment.getConnAtom(this.mFragmentGraphAtom[n], n3);
        if (!(this.mIsExcludeAtom[n6] && this.mExcludeGroupNo[n6] != n4 || n6 == this.mFragmentGraphParentAtom[n] || blArray2[n5 = this.mFragment.getConnBond(this.mFragmentGraphAtom[n], n3)] || this.mFragment.isBondBridge(n5))) {
            this.mFragmentGraphAtom[++n2] = n6;
            this.mFragmentGraphParentAtom[n2] = this.mFragmentGraphAtom[n];
            this.mFragmentGraphParentBond[n2] = n5;
            blArray2[n5] = true;
            if (blArray[n6]) {
                this.mFragmentGraphIsRingClosure[n2] = true;
            } else {
                blArray[n6] = true;
            }
        }
        return n2;
    }

    public ArrayList<int[]> getMatchList() {
        return this.mMatchList;
    }

    public boolean[] getMatchingBridgeBondAtoms(int n) {
        return this.mBridgeBondAtomList.size() <= n ? null : this.mBridgeBondAtomList.get(n);
    }

    public boolean isFragmentInMolecule() {
        return this.findFragmentInMolecule(1, this.mDefaultMatchMode) > 0;
    }

    public boolean isFragmentInMolecule(int n) {
        return this.findFragmentInMolecule(1, n) > 0;
    }

    public int findFragmentInMolecule() {
        return this.findFragmentInMolecule(4, this.mDefaultMatchMode);
    }

    public int findFragmentInMolecule(int n, int n2) {
        return this.findFragmentInMolecule(n, n2, null);
    }

    public int findFragmentInMolecule(int n, int n2, boolean[] blArray) {
        this.mStop = false;
        this.mMatchList = new ArrayList();
        this.mBridgeBondAtomList = new ArrayList();
        this.mSortedMatchSet.clear();
        if (this.mMolecule == null || this.mFragment == null) {
            return 0;
        }
        if (this.mFragment.getAtoms() - this.mFragmentExcludeAtoms > this.mMolecule.getAtoms() || this.mFragment.getBonds() - this.mFragmentExcludeBonds > this.mMolecule.getBonds()) {
            return 0;
        }
        if (this.mFragment.getAtoms() == 0) {
            return 0;
        }
        if (n == 6) {
            this.mRequiredHelperLevel = 63;
        }
        this.setupAtomAndBondFeatures(n2);
        boolean[] blArray2 = new boolean[this.mMolecule.getAtoms()];
        if (blArray != null) {
            for (int i = 0; i < this.mMolecule.getAtoms(); ++i) {
                blArray2[i] = blArray[i];
            }
        }
        this.mMatchTable = new int[this.mFragment.getAtoms()];
        Arrays.fill(this.mMatchTable, -1);
        int[] nArray = new int[this.mFragmentGraphSizeWithExcludeGroups];
        Arrays.fill(nArray, -1);
        int n3 = 0;
        while (!this.mStop) {
            int n4;
            int n5;
            if (this.mFragmentGraphSize != 0) {
                n5 = this.mFragmentGraphParentAtom[n3] == -1 ? this.mMolecule.getAtoms() : this.mMolecule.getAllConnAtomsPlusMetalBonds(this.mMatchTable[this.mFragmentGraphParentAtom[n3]]);
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                if (nArray[n3] == n5) {
                    nArray[n3] = -1;
                    if (n3 == 0) break;
                    if (this.mFragmentGraphIsRingClosure[--n3]) continue;
                    blArray2[this.mMatchTable[this.mFragmentGraphAtom[n3]]] = false;
                    continue;
                }
                if (this.mFragmentGraphParentAtom[n3] == -1) {
                    if (!blArray2[nArray[n3]] && this.areAtomsSimilar(nArray[n3], this.mFragmentGraphAtom[n3])) {
                        this.mMatchTable[this.mFragmentGraphAtom[n3]] = nArray[n3];
                        blArray2[nArray[n3]] = true;
                        ++n3;
                    }
                } else {
                    if (this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[n3]], nArray[n3]) >= this.mMolecule.getAtoms()) continue;
                    n4 = this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[n3]], nArray[n3]);
                    if (!this.mFragmentGraphIsRingClosure[n3]) {
                        if (!blArray2[n4] && this.areAtomsSimilar(n4, this.mFragmentGraphAtom[n3]) && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[n3]], nArray[n3]), this.mFragmentGraphParentBond[n3])) {
                            blArray2[n4] = true;
                            this.mMatchTable[this.mFragmentGraphAtom[n3]] = n4;
                            ++n3;
                        }
                    } else if (n4 == this.mMatchTable[this.mFragmentGraphAtom[n3]] && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[n3]], nArray[n3]), this.mFragmentGraphParentBond[n3])) {
                        ++n3;
                    }
                }
            }
            if (n3 != this.mFragmentGraphSize) continue;
            if (this.doTHParitiesMatch(-1) && this.doEZParitiesMatch(-1) && this.doBridgeBondsMatch(blArray2, -1)) {
                n5 = 0;
                for (n4 = 0; n4 < this.mExcludeGroupCount; ++n4) {
                    if (!this.isExcludeGroupMatch(blArray2, nArray, n4)) continue;
                    n5 = 1;
                    break;
                }
                if (n == 1 && n5 == 0) {
                    return 1;
                }
                if (n5 == 0) {
                    this.addMatchIfQualifies(n);
                    if (n == 2) {
                        return 1;
                    }
                }
            }
            if (n3 == 0) break;
            if (this.mFragmentGraphIsRingClosure[--n3]) continue;
            blArray2[this.mMatchTable[this.mFragmentGraphAtom[n3]]] = false;
        }
        return this.mMatchList.size();
    }

    private void addMatchIfQualifies(int n) {
        int[] nArray;
        if (n == 2 || n == 5) {
            this.addMatchAtoms();
        } else if (n == 4) {
            int[] nArray2 = this.getSortedMatch(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
            if (!this.mSortedMatchSet.contains(nArray2)) {
                this.mSortedMatchSet.add(nArray2);
                this.addMatchAtoms();
            }
        } else if (n == 3) {
            int[] nArray3 = this.getSortedMatch(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
            if (!this.mSortedMatchSet.contains(nArray3)) {
                boolean bl = false;
                for (int[] nArray4 : this.mSortedMatchSet) {
                    int n2 = 0;
                    for (int n3 : nArray3) {
                        while (n2 < nArray4.length && nArray4[n2] < n3) {
                            ++n2;
                        }
                        if (n2 >= nArray4.length || n3 != nArray4[n2]) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
                if (!bl) {
                    this.mSortedMatchSet.add(nArray3);
                    this.addMatchAtoms();
                }
            }
        } else if (n == 6 && !this.mSortedMatchSet.contains(nArray = this.getSortedSymmetryMatch(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length)))) {
            this.mSortedMatchSet.add(nArray);
            this.addMatchAtoms();
        }
    }

    private void addMatchAtoms() {
        this.mMatchList.add(SSSearcher.copyOf(this.mMatchTable, this.mMatchTable.length));
        if (this.mBridgeBondList != null) {
            this.mBridgeBondAtomList.add(SSSearcher.copyOf(this.mIsBridgeBondAtom, this.mIsBridgeBondAtom.length));
        }
    }

    private int[] getSortedMatch(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 != -1) continue;
            ++n;
        }
        if (n != 0) {
            int[] nArray2 = nArray;
            nArray = new int[nArray2.length - n];
            int n3 = 0;
            for (int n4 : nArray2) {
                if (n4 == -1) continue;
                nArray[n3++] = n4;
            }
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private int[] getSortedSymmetryMatch(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 != -1) continue;
            ++n;
        }
        int[] nArray2 = new int[nArray.length - n];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[n3] = this.mFragment.getSymmetryRank(i) << 16 | this.mMolecule.getSymmetryRank(nArray[i]);
            if (this.mFragmentAtomContextRank != null) {
                int n4 = n3;
                nArray2[n4] = nArray2[n4] | this.mFragmentAtomContextRank[i] << 24;
            }
            ++n3;
        }
        Arrays.sort(nArray2);
        return nArray2;
    }

    public boolean areAtomsSimilar(int n, int n2) {
        int n3;
        long l;
        int n4 = this.mFragmentConnAtoms[n2];
        int n5 = this.mMolecule.getConnAtoms(n);
        if (n4 > n5) {
            return false;
        }
        long l2 = this.mMolecule.getAtomQueryFeatures(n);
        long l3 = this.mFragment.getAtomQueryFeatures(n2);
        int[] nArray = this.mFragment.getAtomList(n2);
        int[] nArray2 = this.mMolecule.getAtomList(n);
        if ((l3 & 1L) != 0L) {
            if (nArray != null) {
                if ((l2 & 1L) != 0L) {
                    if (nArray2 == null) {
                        return false;
                    }
                    if (!this.isSubListOf(nArray, nArray2)) {
                        return false;
                    }
                } else if (nArray2 != null ? this.listsOverlap(nArray2, nArray) : this.isListMember(this.mMolecule.getAtomicNo(n), nArray)) {
                    return false;
                }
            }
        } else {
            if ((l2 & 1L) != 0L) {
                return false;
            }
            if (nArray != null) {
                if (nArray2 != null ? !this.isSubListOf(nArray2, nArray) : !this.isListMember(this.mMolecule.getAtomicNo(n), nArray)) {
                    return false;
                }
            } else {
                if (nArray2 != null) {
                    return false;
                }
                if (this.mMoleculeAtomType[n] != this.mFragmentAtomType[n2]) {
                    return false;
                }
            }
        }
        if ((l2 | l3) != 0L) {
            if ((l3 & 0x800L) != 0L) {
                if (this.mMolecule.isFragment() && (l2 & 0x800L) == 0L) {
                    return false;
                }
                if (n4 != n5) {
                    return false;
                }
            }
            if ((l3 & 0x1000L) != 0L && n4 >= n5 && (l2 & 0x1000L) == 0L) {
                return false;
            }
        }
        if ((this.mMoleculeAtomFeatures[n] & (this.mFragmentAtomFeatures[n2] ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return false;
        }
        if ((this.mFragmentRingFeatures[n2] & (this.mMoleculeRingFeatures[n] ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return false;
        }
        long l4 = l3 & 0x7F00000000L;
        if (this.mMolecule.isFragment() ? (l = l3 & 0x7F00000000L) != 0L && (l4 == 0L || (l4 & (l ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) : l4 != 0L && (l4 & this.mMoleculeRingFeatures[n]) == 0L) {
            return false;
        }
        if (this.mFragment.getAtomCharge(n2) != 0 && this.mFragment.getAtomCharge(n2) != this.mMolecule.getAtomCharge(n)) {
            return false;
        }
        if (this.mFragment.getAtomMass(n2) != 0 && this.mFragment.getAtomMass(n2) != this.mMolecule.getAtomMass(n)) {
            return false;
        }
        if (this.mFragment.getAtomRadical(n2) != 0 && this.mFragment.getAtomRadical(n2) != this.mMolecule.getAtomRadical(n)) {
            return false;
        }
        int n6 = (int)((this.mFragment.getAtomQueryFeatures(n2) & 0x1C00000L) >> 22);
        return n6 == 0 || !(!this.mMolecule.isFragment() ? this.mMolecule.getAtomRingSize(n) != n6 : n6 != (n3 = (int)((this.mMolecule.getAtomQueryFeatures(n) & 0x1C00000L) >> 22)));
    }

    private boolean doTHParitiesMatch(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (int i = 0; i < this.mFragment.getAtoms(); ++i) {
            if (this.mExcludeGroupNo != null && this.mExcludeGroupNo[i] != n || (this.mFragment.getAtomQueryFeatures(i) & 0x2000L) == 0L) continue;
            n4 = this.mMatchTable[i];
            n3 = this.mFragment.getAtomParity(i);
            n2 = this.mMolecule.getAtomParity(n4);
            if (n3 == 0 || n3 == 3) continue;
            if (n2 == 0 || n2 == 3) {
                return false;
            }
            if (this.mFragment.getAtomESRType(i) == 1) {
                ++n5;
                continue;
            }
            if (this.mMolecule.getAtomESRType(n4) == 1) {
                return false;
            }
            if (this.mFragment.getAtomESRType(i) == 2) {
                ++n5;
                continue;
            }
            if (this.mMolecule.getAtomESRType(n4) == 2) {
                return false;
            }
            if (this.isTHParityInversion(i) != (n3 == n2)) continue;
            return false;
        }
        if (n5 != 0) {
            int[] nArray = new int[n5];
            n4 = 0;
            for (n3 = 0; n3 < this.mFragment.getAtoms(); ++n3) {
                if (this.mExcludeGroupNo != null && this.mExcludeGroupNo[n3] != n || (this.mFragment.getAtomQueryFeatures(n3) & 0x2000L) == 0L || (n2 = this.mFragment.getAtomParity(n3)) == 0 || n2 == 3) continue;
                nArray[n4++] = this.mFragment.getAtomESRGroup(n3) << 24 | this.mFragment.getAtomESRType(n3) << 22 | n3;
            }
            Arrays.sort(nArray);
            n4 = 0;
            while (n4 < nArray.length) {
                n3 = nArray[n4] & 0x3FFFFF;
                n2 = this.mMatchTable[n3];
                int n6 = nArray[n4] & 0xFFC00000;
                boolean bl = this.isTHParityInversion(n3) ^ this.mFragment.getAtomParity(n3) == this.mMolecule.getAtomParity(n2);
                ++n4;
                while (n4 < nArray.length && (nArray[n4] & 0xFFC00000) == n6) {
                    int n7 = nArray[n4] & 0x3FFFFF;
                    int n8 = this.mMatchTable[n7];
                    if (this.mMolecule.getAtomESRType(n8) != this.mMolecule.getAtomESRType(n2) || this.mMolecule.getAtomESRGroup(n8) != this.mMolecule.getAtomESRGroup(n2)) {
                        return false;
                    }
                    boolean bl2 = this.isTHParityInversion(n7) ^ this.mFragment.getAtomParity(n7) == this.mMolecule.getAtomParity(n8);
                    if (bl2 != bl) {
                        return false;
                    }
                    ++n4;
                }
            }
        }
        return true;
    }

    private boolean isTHParityInversion(int n) {
        boolean bl = false;
        if (this.mFragment.getAtomPi(n) == 0) {
            for (int i = 1; i < this.mFragment.getConnAtoms(n); ++i) {
                for (int j = 0; j < i; ++j) {
                    int n2;
                    int n3 = this.mFragment.getConnAtom(n, i);
                    if (!(this.mMatchTable[n3] > this.mMatchTable[n2 = this.mFragment.getConnAtom(n, j)] ^ n3 > n2)) continue;
                    bl = !bl;
                }
            }
        } else {
            for (int i = 0; i < this.mFragment.getConnAtoms(n); ++i) {
                int n4 = this.mFragment.getConnAtom(n, i);
                int n5 = 0;
                int[] nArray = new int[3];
                for (int j = 0; j < this.mFragment.getConnAtoms(n4); ++j) {
                    nArray[n5] = this.mFragment.getConnAtom(n4, j);
                    if (nArray[n5] == n) continue;
                    ++n5;
                }
                if (n5 != 2 || !(this.mMatchTable[nArray[0]] > this.mMatchTable[nArray[1]] ^ nArray[0] > nArray[1])) continue;
                bl = !bl;
            }
        }
        return bl;
    }

    private boolean doEZParitiesMatch(int n) {
        for (int i = 0; i < this.mFragment.getBonds(); ++i) {
            int n2;
            if ((this.mFragment.getBondQueryFeatures(i) & 0x100000) == 0 || (n2 = this.mFragment.getBondParity(i)) == 0) continue;
            int n3 = this.mFragment.getBondAtom(0, i);
            int n4 = this.mFragment.getBondAtom(1, i);
            if (this.mExcludeGroupNo != null && (n != -1 || this.mExcludeGroupNo[n3] != -1 || this.mExcludeGroupNo[n4] != -1) && (n == -1 || this.mExcludeGroupNo[n3] != n && this.mExcludeGroupNo[n4] != n)) continue;
            int n5 = this.mMatchTable[n3];
            int n6 = this.mMatchTable[n4];
            int n7 = this.mMolecule.getBond(n5, n6);
            int n8 = this.mMolecule.getBondParity(n7);
            if (n8 == 0) {
                if (this.mMolecule.isSmallRingBond(n7)) {
                    n8 = this.calculateImplicitSmallRingBondParity(n7);
                }
                if (n8 == 0) continue;
            }
            if (n2 == 3 || n8 == 3 || this.isEZParityInversion(i, n7) != (n2 == n8)) continue;
            return false;
        }
        return true;
    }

    private int calculateImplicitSmallRingBondParity(int n) {
        RingCollection ringCollection = this.mMolecule.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            int n2;
            if (!ringCollection.isBondMember(i, n)) continue;
            int[] nArray = new int[2];
            for (n2 = 0; n2 < 2; ++n2) {
                nArray[n2] = Integer.MAX_VALUE;
                int n3 = this.mMolecule.getBondAtom(n2, n);
                for (int j = 0; j < this.mMolecule.getConnAtoms(n3); ++j) {
                    int n4 = this.mMolecule.getConnAtom(n3, j);
                    if (n4 == this.mMolecule.getBondAtom(1 - n2, n) || nArray[n2] <= n4) continue;
                    nArray[n2] = n4;
                }
            }
            n2 = 0;
            if (ringCollection.isAtomMember(i, nArray[0])) {
                ++n2;
            }
            if (ringCollection.isAtomMember(i, nArray[1])) {
                ++n2;
            }
            if (n2 == 2) {
                return 2;
            }
            if (n2 == 1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private boolean isEZParityInversion(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            int n3;
            int n4;
            int n5 = this.mFragment.getBondAtom(i, n);
            int n6 = this.mMatchTable[n5];
            if (this.mMolecule.getConnAtoms(n6) <= 2) continue;
            int n7 = this.mFragment.getBondAtom(1 - i, n);
            int n8 = Integer.MAX_VALUE;
            for (n4 = 0; n4 < this.mFragment.getConnAtoms(n5); ++n4) {
                n3 = this.mFragment.getConnAtom(n5, n4);
                if (n3 == n7 || n8 <= n3) continue;
                n8 = n3;
            }
            n4 = this.mMatchTable[n7];
            n3 = Integer.MAX_VALUE;
            for (int j = 0; j < this.mMolecule.getConnAtoms(n6); ++j) {
                int n9 = this.mMolecule.getConnAtom(n6, j);
                if (n9 == n4 || n3 <= n9) continue;
                n3 = n9;
            }
            if (this.mMatchTable[n8] == n3) continue;
            bl = !bl;
        }
        return bl;
    }

    private boolean isExcludeGroupMatch(boolean[] blArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = this.mExcludeGroupGraphIndex[n];
        for (n3 = n4 + 1; n3 < this.mFragmentGraphSizeWithExcludeGroups && this.mExcludeGroupNo[this.mFragmentGraphAtom[n3]] == n; ++n3) {
        }
        for (n2 = n4; n2 < n3; ++n2) {
            nArray[n2] = -1;
        }
        n2 = n4;
        while (true) {
            int n5;
            int n6 = this.mFragmentGraphParentAtom[n2] == -1 ? this.mMolecule.getAtoms() : this.mMolecule.getAllConnAtomsPlusMetalBonds(this.mMatchTable[this.mFragmentGraphParentAtom[n2]]);
            int n7 = n2;
            nArray[n7] = nArray[n7] + 1;
            if (nArray[n2] == n6) {
                nArray[n2] = -1;
                if (n2 == n4) break;
                if (this.mFragmentGraphIsRingClosure[--n2]) continue;
                blArray[this.mMatchTable[this.mFragmentGraphAtom[n2]]] = false;
                this.mMatchTable[this.mFragmentGraphAtom[n2]] = -1;
                continue;
            }
            if (this.mFragmentGraphParentAtom[n2] == -1) {
                if (!blArray[nArray[n2]] && this.areAtomsSimilar(nArray[n2], this.mFragmentGraphAtom[n2])) {
                    this.mMatchTable[this.mFragmentGraphAtom[n2]] = nArray[n2];
                    blArray[nArray[n2]] = true;
                    ++n2;
                }
            } else {
                if (this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[n2]], nArray[n2]) >= this.mMolecule.getAtoms()) {
                    int n8 = n2;
                    nArray[n8] = nArray[n8] + 1;
                    continue;
                }
                n5 = this.mMolecule.getConnAtom(this.mMatchTable[this.mFragmentGraphParentAtom[n2]], nArray[n2]);
                if (!this.mFragmentGraphIsRingClosure[n2]) {
                    if (!blArray[n5] && this.areAtomsSimilar(n5, this.mFragmentGraphAtom[n2]) && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[n2]], nArray[n2]), this.mFragmentGraphParentBond[n2])) {
                        blArray[n5] = true;
                        this.mMatchTable[this.mFragmentGraphAtom[n2]] = n5;
                        ++n2;
                    }
                } else if (n5 == this.mMatchTable[this.mFragmentGraphAtom[n2]] && this.areBondsSimilar(this.mMolecule.getConnBond(this.mMatchTable[this.mFragmentGraphParentAtom[n2]], nArray[n2]), this.mFragmentGraphParentBond[n2])) {
                    ++n2;
                }
            }
            if (n2 != n3) continue;
            if (this.doTHParitiesMatch(n) && this.doEZParitiesMatch(n) && this.doBridgeBondsMatch(blArray, n)) {
                for (n5 = n4; n5 < n3; ++n5) {
                    if (this.mFragmentGraphIsRingClosure[n5]) continue;
                    int n9 = this.mFragmentGraphAtom[n5];
                    blArray[this.mMatchTable[n9]] = false;
                    this.mMatchTable[n9] = -1;
                }
                return true;
            }
            if (this.mFragmentGraphIsRingClosure[--n2]) continue;
            blArray[this.mMatchTable[this.mFragmentGraphAtom[n2]]] = false;
            this.mMatchTable[this.mFragmentGraphAtom[n2]] = -1;
        }
        return false;
    }

    private boolean doBridgeBondsMatch(boolean[] blArray, int n) {
        if (this.mBridgeBondList != null) {
            this.mIsBridgeBondAtom = new boolean[blArray.length];
            for (BridgeBond bridgeBond : this.mBridgeBondList) {
                if (this.mExcludeGroupNo != null && (n != -1 || this.mExcludeGroupNo[bridgeBond.atom1] != -1 || this.mExcludeGroupNo[bridgeBond.atom2] != -1) && (n == -1 || this.mExcludeGroupNo[bridgeBond.atom1] != n && this.mExcludeGroupNo[bridgeBond.atom2] != n)) continue;
                int[] nArray = new int[bridgeBond.maxBridgeSize + 2];
                int n2 = this.mMolecule.getPath(nArray, this.mMatchTable[bridgeBond.atom1], this.mMatchTable[bridgeBond.atom2], bridgeBond.maxBridgeSize + 1, blArray, null) - 1;
                if (n2 < bridgeBond.minBridgeSize || n2 > bridgeBond.maxBridgeSize) {
                    return false;
                }
                for (int i = 1; i <= n2; ++i) {
                    this.mIsBridgeBondAtom[nArray[i]] = true;
                }
            }
        }
        return true;
    }

    public boolean areBondsSimilar(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.mMoleculeBondFeatures[n];
        int n6 = this.mFragmentBondFeatures[n2];
        if ((this.mFragment.getBondQueryFeatures(n2) & 0x800000) != 0) {
            n4 = this.mMolecule.getBondTypeSimple(n);
            n3 = this.mFragment.getBondTypeSimple(n2);
            int n7 = this.mFragment.getBondQueryFeatures(n2) & 0x1F;
            if (!(n4 == n3 || n4 == 1 && (n7 & 1) != 0 || n4 == 2 && (n7 & 2) != 0 || n4 == 4 && (n7 & 4) != 0 || n4 == 8 && (n7 & 0x20) != 0 || n4 == 16 && (n7 & 0x40) != 0 || n4 == 32 && (n7 & 0x10) != 0 || n4 == 64 && (n7 & 8) != 0)) {
                return false;
            }
            n5 &= 0xFFFFFFE0;
            n6 &= 0xFFFFFFE0;
        }
        if ((n5 & ~n6) != 0) {
            return false;
        }
        n4 = (this.mFragment.getBondQueryFeatures(n2) & 0xE0000) >> 17;
        if (n4 != 0) {
            if (this.mMolecule.isFragment() && n4 == (this.mMolecule.getBondQueryFeatures(n2) & 0xE0000) >> 17) {
                return true;
            }
            n3 = 0;
            RingCollection ringCollection = this.mMolecule.getRingSet();
            for (int i = 0; i < ringCollection.getSize(); ++i) {
                if (ringCollection.getRingSize(i) != n4 || !ringCollection.isBondMember(i, n)) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isSubListOf(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            while (nArray2[n] < n2) {
                if (++n != nArray2.length) continue;
                return false;
            }
            if (nArray2[n] <= n2) continue;
            return false;
        }
        return true;
    }

    private boolean listsOverlap(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        while (n < nArray.length && n2 < nArray2.length) {
            int n3 = nArray[n];
            int n4 = nArray2[n2];
            if (n3 == n4) {
                return true;
            }
            if (n3 < n4) {
                ++n;
                continue;
            }
            ++n2;
        }
        return false;
    }

    private boolean isListMember(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public void setupAtomAndBondFeatures(int n) {
        if (!this.mMoleculeFeaturesValid) {
            this.setupMoleculeFeatures(n);
            this.mMoleculeFeaturesValid = true;
        }
        if (!this.mFragmentFeaturesValid) {
            this.setupFragmentFeatures(n);
            this.buildFragmentGraph();
            this.buildBridgeBondList();
            this.mFragmentFeaturesValid = true;
        }
    }

    private void setupMoleculeFeatures(int n) {
        int n2;
        int n3;
        this.mMolecule.ensureHelperArrays(this.mRequiredHelperLevel);
        int n4 = this.mMolecule.getAtoms();
        this.mMoleculeAtomType = new int[n4];
        this.mMoleculeAtomFeatures = new long[n4];
        for (int i = 0; i < n4; ++i) {
            this.mMoleculeAtomFeatures[i] = (this.getAtomQueryDefaults(this.mMolecule, i) | this.mMolecule.getAtomQueryFeatures(i)) & 0x7F800E3FC7FEL ^ 0x7FFF0FFFFFFEL;
            this.mMoleculeAtomType[i] = this.mMolecule.getAtomicNo(i);
            if ((n & 1) != 0) {
                int n5 = i;
                this.mMoleculeAtomType[n5] = this.mMoleculeAtomType[n5] + (this.mMolecule.getAtomCharge(i) + 16 << 8);
            }
            if ((n & 2) == 0) continue;
            int n6 = i;
            this.mMoleculeAtomType[n6] = this.mMoleculeAtomType[n6] + (this.mMolecule.getAtomMass(i) << 16);
        }
        this.mMoleculeRingFeatures = new long[n4];
        RingCollection ringCollection = this.mMolecule.getRingSet();
        for (n3 = 0; n3 < ringCollection.getSize(); ++n3) {
            n2 = ringCollection.getRingSize(n3);
            for (int n7 : ringCollection.getRingAtoms(n3)) {
                if (n2 == 3) {
                    int n8 = n7;
                    this.mMoleculeRingFeatures[n8] = this.mMoleculeRingFeatures[n8] | 0x200000000L;
                    continue;
                }
                if (n2 == 4) {
                    int n9 = n7;
                    this.mMoleculeRingFeatures[n9] = this.mMoleculeRingFeatures[n9] | 0x400000000L;
                    continue;
                }
                if (n2 == 5) {
                    int n10 = n7;
                    this.mMoleculeRingFeatures[n10] = this.mMoleculeRingFeatures[n10] | 0x800000000L;
                    continue;
                }
                if (n2 == 6) {
                    int n11 = n7;
                    this.mMoleculeRingFeatures[n11] = this.mMoleculeRingFeatures[n11] | 0x1000000000L;
                    continue;
                }
                if (n2 != 7) continue;
                int n12 = n7;
                this.mMoleculeRingFeatures[n12] = this.mMoleculeRingFeatures[n12] | 0x2000000000L;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.mMolecule.getAtomRingSize(n3);
            if (n2 == 0) {
                int n13 = n3;
                this.mMoleculeRingFeatures[n13] = this.mMoleculeRingFeatures[n13] | 0x100000000L;
                continue;
            }
            if (n2 <= 7) continue;
            int n14 = n3;
            this.mMoleculeRingFeatures[n14] = this.mMoleculeRingFeatures[n14] | 0x4000000000L;
        }
        n3 = this.mMolecule.getBonds();
        this.mMoleculeBondFeatures = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.mMoleculeBondFeatures[n2] = (this.getBondQueryDefaults(this.mMolecule, n2) | this.mMolecule.getBondQueryFeatures(n2)) & 0x61FFFF ^ 0x600180;
        }
    }

    private void setupFragmentFeatures(int n) {
        int n2;
        long[] lArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        this.mFragment.ensureHelperArrays(this.mRequiredHelperLevel);
        this.mFragmentConnAtoms = new int[this.mFragment.getAtoms()];
        for (n2 = 0; n2 < this.mFragment.getAtoms(); ++n2) {
            this.mFragmentConnAtoms[n2] = this.mFragment.getConnAtoms(n2);
        }
        if (this.mFragmentExcludeAtoms != 0) {
            int n3;
            StereoMolecule stereoMolecule = new StereoMolecule(this.mFragment.getAllAtoms(), this.mFragment.getAllBonds());
            boolean[] blArray = new boolean[this.mFragment.getAllAtoms()];
            for (n3 = 0; n3 < this.mFragment.getAllAtoms(); ++n3) {
                blArray[n3] = !this.mIsExcludeAtom[n3];
            }
            this.mFragment.copyMoleculeByAtoms(stereoMolecule, blArray, true, null);
            stereoMolecule.ensureHelperArrays(this.mRequiredHelperLevel);
            this.setupFragmentFeatures(stereoMolecule, n);
            lArray = this.mFragmentAtomFeatures;
            nArray = this.mFragmentBondFeatures;
            nArray2 = this.mFragmentAtomType;
            n3 = 0;
            for (int i = 0; i < this.mFragment.getAtoms(); ++i) {
                if (this.mIsExcludeAtom[i]) continue;
                this.mFragmentConnAtoms[i] = stereoMolecule.getConnAtoms(n3++);
            }
        }
        this.setupFragmentFeatures(this.mFragment, n);
        if (this.mFragmentExcludeAtoms != 0) {
            int n4;
            n2 = 0;
            for (n4 = 0; n4 < this.mFragment.getAllAtoms(); ++n4) {
                if (this.mIsExcludeAtom[n4]) continue;
                this.mFragmentAtomFeatures[n4] = lArray[n2];
                this.mFragmentAtomType[n4] = nArray2[n2++];
            }
            n2 = 0;
            for (n4 = 0; n4 < this.mFragment.getAllBonds(); ++n4) {
                if (this.mIsExcludeAtom[this.mFragment.getBondAtom(0, n4)] || this.mIsExcludeAtom[this.mFragment.getBondAtom(1, n4)]) continue;
                this.mFragmentBondFeatures[n4] = nArray[n2++];
            }
        }
    }

    private void setupFragmentFeatures(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        int n4 = stereoMolecule.getAtoms();
        this.mFragmentAtomFeatures = new long[stereoMolecule.getAtoms()];
        this.mFragmentAtomType = new int[stereoMolecule.getAtoms()];
        for (int i = 0; i < n4; ++i) {
            this.mFragmentAtomFeatures[i] = (this.getAtomQueryDefaults(stereoMolecule, i) | stereoMolecule.getAtomQueryFeatures(i)) & 0x7F800E3FC7FEL ^ 0x7FFF0FFFFFFEL;
            this.mFragmentAtomType[i] = stereoMolecule.getAtomicNo(i);
            if ((n & 1) != 0) {
                int n5 = i;
                this.mFragmentAtomType[n5] = this.mFragmentAtomType[n5] + (stereoMolecule.getAtomCharge(i) + 16 << 8);
            }
            if ((n & 2) == 0) continue;
            int n6 = i;
            this.mFragmentAtomType[n6] = this.mFragmentAtomType[n6] + (stereoMolecule.getAtomMass(i) << 16);
        }
        this.mFragmentRingFeatures = new long[stereoMolecule.getAtoms()];
        RingCollection ringCollection = stereoMolecule.getRingSet();
        for (n3 = 0; n3 < ringCollection.getSize(); ++n3) {
            n2 = 0;
            for (int n7 : ringCollection.getRingBonds(n3)) {
                if (!stereoMolecule.isBondBridge(n7)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            int n8 = ringCollection.getRingSize(n3);
            int[] nArray = ringCollection.getRingAtoms(n3);
            int n9 = nArray.length;
            for (int n7 = 0; n7 < n9; ++n7) {
                int n10 = nArray[n7];
                if (n8 == 3) {
                    int n11 = n10;
                    this.mFragmentRingFeatures[n11] = this.mFragmentRingFeatures[n11] | 0x200000000L;
                    continue;
                }
                if (n8 == 4) {
                    int n12 = n10;
                    this.mFragmentRingFeatures[n12] = this.mFragmentRingFeatures[n12] | 0x400000000L;
                    continue;
                }
                if (n8 == 5) {
                    int n13 = n10;
                    this.mFragmentRingFeatures[n13] = this.mFragmentRingFeatures[n13] | 0x800000000L;
                    continue;
                }
                if (n8 == 6) {
                    int n14 = n10;
                    this.mFragmentRingFeatures[n14] = this.mFragmentRingFeatures[n14] | 0x1000000000L;
                    continue;
                }
                if (n8 != 7) continue;
                int n15 = n10;
                this.mFragmentRingFeatures[n15] = this.mFragmentRingFeatures[n15] | 0x2000000000L;
            }
        }
        n3 = stereoMolecule.getBonds();
        this.mFragmentBondFeatures = new int[stereoMolecule.getBonds()];
        for (n2 = 0; n2 < n3; ++n2) {
            this.mFragmentBondFeatures[n2] = (this.getBondQueryDefaults(stereoMolecule, n2) | stereoMolecule.getBondQueryFeatures(n2)) & 0x6001FF ^ 0x600180;
            if ((n & 4) != 0) {
                if ((this.mFragmentBondFeatures[n2] & 2) == 0) continue;
                int n16 = n2;
                this.mFragmentBondFeatures[n16] = this.mFragmentBondFeatures[n16] | 8;
                continue;
            }
            if ((n & 8) == 0 || (this.mFragmentBondFeatures[n2] & 2) == 0 || !stereoMolecule.isAromaticBond(n2)) continue;
            int n17 = n2;
            this.mFragmentBondFeatures[n17] = this.mFragmentBondFeatures[n17] | 8;
        }
    }

    private long getAtomQueryDefaults(StereoMolecule stereoMolecule, int n) {
        long l = 0L;
        if (!stereoMolecule.isFragment()) {
            l = stereoMolecule.isHeteroAromaticAtom(n) ? (l |= 0x400000000002L) : (stereoMolecule.isAromaticAtom(n) ? (l |= 2L) : (l |= 4L));
            l = stereoMolecule.isAtomStereoCenter(n) ? (l |= 0x100000000000L) : (l |= 0x200000000000L);
            int n2 = stereoMolecule.getAtomRingBondCount(n);
            l = n2 == 0 ? (l |= 0x70L) : (n2 == 2 ? (l |= 0x68L) : (n2 == 3 ? (l |= 0x58L) : (l |= 0x38L)));
            int n3 = stereoMolecule.getAtomCharge(n);
            if (n3 == 0) {
                l |= 0xA000000L;
            } else if (n3 < 0) {
                l |= 0xC000000L;
            } else if (n3 > 0) {
                l |= 0x6000000L;
            }
            int n4 = stereoMolecule.getAllHydrogens(n);
            switch (n4) {
                case 0: {
                    l |= 0x700L;
                    break;
                }
                case 1: {
                    l |= 0x680L;
                    break;
                }
                case 2: {
                    l |= 0x580L;
                    break;
                }
                default: {
                    l |= 0x380L;
                }
            }
            int n5 = stereoMolecule.getConnAtoms(n);
            switch (n5) {
                case 0: {
                    l |= 0x3C0000L;
                    break;
                }
                case 1: {
                    l |= 0x3A0000L;
                    break;
                }
                case 2: {
                    l |= 0x360000L;
                    break;
                }
                case 3: {
                    l |= 0x2E0000L;
                    break;
                }
                default: {
                    l |= 0x1E0000L;
                }
            }
            int n6 = stereoMolecule.getAtomElectronegativeNeighbours(n);
            switch (n6) {
                case 0: {
                    l |= 0xF0000000000L;
                    break;
                }
                case 1: {
                    l |= 0xE8000000000L;
                    break;
                }
                case 2: {
                    l |= 0xD8000000000L;
                    break;
                }
                case 3: {
                    l |= 0xB8000000000L;
                    break;
                }
                default: {
                    l |= 0x78000000000L;
                }
            }
            int n7 = stereoMolecule.getAtomPi(n);
            switch (n7) {
                case 0: {
                    l |= 0x18000L;
                    break;
                }
                case 1: {
                    l |= 0x14000L;
                    break;
                }
                default: {
                    l |= 0xC000L;
                    break;
                }
            }
        } else {
            int n8;
            if (stereoMolecule.isHeteroAromaticAtom(n)) {
                l |= 0x400000000002L;
            } else if (stereoMolecule.isAromaticAtom(n)) {
                l |= 2L;
            }
            int n9 = stereoMolecule.getAtomRingBondCount(n);
            if (n9 != 0) {
                l |= 8L;
                if (n9 > 2) {
                    l |= 0x10L;
                }
                if (n9 > 3) {
                    l |= 0x20L;
                }
            }
            if ((n8 = stereoMolecule.getAtomCharge(n)) < 0) {
                l |= 0xC000000L;
            } else if (n8 > 0) {
                l |= 0x6000000L;
            }
            int n10 = stereoMolecule.getConnAtoms(n);
            switch (n10) {
                case 0: {
                    break;
                }
                case 1: {
                    l |= 0x20000L;
                    break;
                }
                case 2: {
                    l |= 0x60000L;
                    break;
                }
                case 3: {
                    l |= 0xE0000L;
                    break;
                }
                default: {
                    l |= 0x1E0000L;
                }
            }
            int n11 = stereoMolecule.getAtomElectronegativeNeighbours(n);
            switch (n11) {
                case 0: {
                    break;
                }
                case 1: {
                    l |= 0x8000000000L;
                    break;
                }
                case 2: {
                    l |= 0x18000000000L;
                    break;
                }
                case 3: {
                    l |= 0x38000000000L;
                    break;
                }
                default: {
                    l |= 0x78000000000L;
                }
            }
            int n12 = stereoMolecule.getAtomPi(n);
            if (n12 > 0) {
                l |= 0x4000L;
            }
            if (n12 > 1) {
                l |= 0x8000L;
            }
        }
        return l;
    }

    private int getBondQueryDefaults(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        if (stereoMolecule.isDelocalizedBond(n) || stereoMolecule.getBondType(n) == 64) {
            n2 |= 8;
        } else {
            switch (stereoMolecule.getBondOrder(n)) {
                case 0: {
                    n2 |= 0x20;
                    break;
                }
                case 1: {
                    n2 |= 1;
                    break;
                }
                case 2: {
                    n2 |= 2;
                    break;
                }
                case 3: {
                    n2 |= 4;
                    break;
                }
                case 4: {
                    n2 |= 0x20;
                    break;
                }
                case 5: {
                    n2 |= 0x40;
                }
            }
        }
        if (stereoMolecule.isRingBond(n)) {
            n2 |= 0x100;
        } else if (!stereoMolecule.isFragment()) {
            n2 |= 0x80;
        }
        if (stereoMolecule.isAromaticBond(n)) {
            n2 |= 0x200000;
        } else if (!stereoMolecule.isFragment()) {
            n2 |= 0x400000;
        }
        return n2;
    }

    private void buildBridgeBondList() {
        this.mBridgeBondList = null;
        for (int i = 0; i < this.mFragment.getBonds(); ++i) {
            if (!this.mFragment.isBondBridge(i)) continue;
            if (this.mBridgeBondList == null) {
                this.mBridgeBondList = new ArrayList();
            }
            BridgeBond bridgeBond = new BridgeBond();
            bridgeBond.atom1 = this.mFragment.getBondAtom(0, i);
            bridgeBond.atom2 = this.mFragment.getBondAtom(1, i);
            bridgeBond.minBridgeSize = this.mFragment.getBondBridgeMinSize(i);
            bridgeBond.maxBridgeSize = this.mFragment.getBondBridgeMaxSize(i);
            this.mBridgeBondList.add(bridgeBond);
        }
    }

    private static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    private static boolean[] copyOf(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, Math.min(blArray.length, n));
        return blArray2;
    }

    private class BridgeBond {
        int atom1;
        int atom2;
        int minBridgeSize;
        int maxBridgeSize;

        private BridgeBond() {
        }
    }
}

