/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import java.util.ArrayList;

public class RingCollection {
    public static final int MAX_SMALL_RING_SIZE = 7;
    public static final int MAX_SMALL_RING_COUNT = 1024;
    private static final int MODE_SMALL_RINGS = 1;
    private static final int MODE_LARGE_RINGS = 2;
    private static final int MODE_AROMATICITY = 4;
    public static final int MODE_SMALL_RINGS_ONLY = 1;
    public static final int MODE_SMALL_AND_LARGE_RINGS = 3;
    public static final int MODE_SMALL_RINGS_AND_AROMATICITY = 5;
    public static final int MODE_SMALL_AND_LARGE_RINGS_AND_AROMATICITY = 7;
    public static final int MODE_INCLUDE_TAUTOMERIC_BONDS = 8;
    private static final int FEATURES_RING_SIZE = 65535;
    private static final int FEATURES_AROMATIC = 65536;
    private static final int FEATURES_DELOCALIZED = 131072;
    private static final int FEATURES_HETERO_AROMATIC = 262144;
    private ExtendedMolecule mMol;
    private ArrayList<int[]> mRingAtomSet;
    private ArrayList<int[]> mRingBondSet;
    private int[] mAtomRingFeatures;
    private int[] mBondRingFeatures;
    private int[] mHeteroPosition;
    private boolean[] mIsAromatic;
    private boolean[] mIsDelocalized;
    private int mMaxSmallRingSize;

    public RingCollection(ExtendedMolecule extendedMolecule, int n) {
        this(extendedMolecule, n, 7);
    }

    public RingCollection(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        this.mMol = extendedMolecule;
        this.mMaxSmallRingSize = n2;
        this.mRingAtomSet = new ArrayList();
        this.mRingBondSet = new ArrayList();
        this.mAtomRingFeatures = new int[this.mMol.getAtoms()];
        this.mBondRingFeatures = new int[this.mMol.getBonds()];
        this.mMol.ensureHelperArrays(1);
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        boolean[] blArray2 = new boolean[this.mMol.getBonds()];
        do {
            bl = false;
            for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
                int n5;
                if (blArray[n4]) continue;
                int n6 = 0;
                for (n5 = 0; n5 < this.mMol.getConnAtoms(n4); ++n5) {
                    if (blArray[this.mMol.getConnAtom(n4, n5)]) continue;
                    ++n6;
                }
                if (n6 >= 2) continue;
                blArray[n4] = true;
                for (n5 = 0; n5 < this.mMol.getConnAtoms(n4); ++n5) {
                    blArray2[this.mMol.getConnBond((int)n4, (int)n5)] = true;
                }
                bl = true;
            }
        } while (bl);
        for (n4 = 0; n4 < this.mMol.getAtoms() && blArray[n4]; ++n4) {
        }
        if (n4 == this.mMol.getAtoms()) {
            return;
        }
        int[] nArray = new int[this.mMol.getAtoms()];
        nArray[0] = n4;
        int[] nArray2 = new int[this.mMol.getAtoms()];
        nArray2[0] = -1;
        int[] nArray3 = new int[this.mMol.getAtoms()];
        nArray3[n4] = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        block5: while (n7 <= n8) {
            for (n3 = 0; n3 < this.mMol.getConnAtoms(nArray[n7]); ++n3) {
                int n10 = this.mMol.getConnAtom(nArray[n7], n3);
                if (n10 == nArray2[nArray[n7]]) continue;
                if (nArray3[n10] != 0) {
                    this.addSmallRingsToSet(this.mMol.getConnBond(nArray[n7], n3), blArray);
                    continue;
                }
                if (blArray[n10]) continue;
                nArray3[n10] = n9;
                nArray2[n10] = nArray[n7];
                nArray[++n8] = n10;
            }
            if (++n7 <= n8) continue;
            for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                if (nArray3[n3] != 0 || blArray[n3]) continue;
                nArray3[n3] = ++n9;
                nArray[++n8] = n3;
                nArray2[n3] = -1;
                continue block5;
            }
        }
        if ((n & 4) != 0) {
            this.mIsAromatic = new boolean[this.mRingAtomSet.size()];
            this.mIsDelocalized = new boolean[this.mRingAtomSet.size()];
            this.mHeteroPosition = new int[this.mRingAtomSet.size()];
            this.determineAromaticity(this.mIsAromatic, this.mIsDelocalized, this.mHeteroPosition, (n & 8) != 0);
            this.updateAromaticity();
        }
        if ((n & 2) != 0) {
            for (n3 = 0; n3 < this.mMol.getBonds(); ++n3) {
                int[] nArray4;
                if (blArray2[n3] || this.mMol.getBondOrder(n3) == 0 || (nArray4 = this.findSmallestRing(n3, blArray)) == null) continue;
                this.updateRingSize(nArray4, this.getRingBonds(nArray4));
            }
        }
    }

    private int[] findSmallestRing(int n, boolean[] blArray) {
        int n2 = this.mMol.getBondAtom(0, n);
        int n3 = this.mMol.getBondAtom(1, n);
        int[] nArray = new int[this.mMol.getAtoms()];
        int[] nArray2 = new int[this.mMol.getAtoms()];
        int[] nArray3 = new int[this.mMol.getAtoms()];
        nArray[0] = n2;
        nArray[1] = n3;
        nArray2[n2] = 1;
        nArray2[n3] = 2;
        nArray3[n2] = -1;
        nArray3[n3] = n2;
        int n4 = 1;
        for (int i = 1; i <= n4; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                int n5 = this.mMol.getConnAtom(nArray[i], j);
                if (i > 1 && n5 == n2) {
                    int[] nArray4 = new int[nArray2[nArray[i]]];
                    int n6 = nArray[i];
                    for (int k = 0; k < nArray4.length; ++k) {
                        nArray4[k] = n6;
                        n6 = nArray3[n6];
                    }
                    return nArray4;
                }
                if (nArray2[n5] != 0 || blArray[n5]) continue;
                nArray[++n4] = n5;
                nArray2[n5] = nArray2[nArray[i]] + 1;
                nArray3[n5] = nArray[i];
            }
        }
        return null;
    }

    public int getAtomRingSize(int n) {
        return this.mAtomRingFeatures[n] & 0xFFFF;
    }

    public int getBondRingSize(int n) {
        return this.mBondRingFeatures[n] & 0xFFFF;
    }

    private void addSmallRingsToSet(int n, boolean[] blArray) {
        int[] nArray = new int[this.mMaxSmallRingSize];
        int[] nArray2 = new int[this.mMaxSmallRingSize];
        boolean[] blArray2 = new boolean[this.mMol.getAtoms()];
        int n2 = this.mMol.getBondAtom(0, n);
        int n3 = this.mMol.getBondAtom(1, n);
        nArray[0] = n2;
        nArray[1] = n3;
        nArray2[1] = -1;
        blArray2[n3] = true;
        int n4 = 1;
        while (n4 >= 1) {
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + 1;
            if (nArray2[n4] == this.mMol.getConnAtoms(nArray[n4])) {
                blArray2[nArray[n4]] = false;
                --n4;
                continue;
            }
            int n6 = this.mMol.getConnAtom(nArray[n4], nArray2[n4]);
            if (blArray2[n6] || blArray[n6]) continue;
            if (n6 == n2 && n4 > 1) {
                this.addRingIfNew(nArray, n4 + 1);
                if (this.mRingAtomSet.size() < 1024) continue;
                return;
            }
            if (n4 + 1 >= this.mMaxSmallRingSize) continue;
            nArray[++n4] = n6;
            blArray2[n6] = true;
            nArray2[n4] = -1;
        }
    }

    private void addRingIfNew(int[] nArray, int n) {
        int n2;
        int n3 = this.mMol.getMaxAtoms();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (n3 <= nArray[i]) continue;
            n3 = nArray[i];
            n4 = i;
        }
        int[] nArray2 = new int[n];
        int n5 = n4 > 0 ? n4 - 1 : n - 1;
        int n6 = n4 < n - 1 ? n4 + 1 : 0;
        boolean bl = nArray[n5] < nArray[n6];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = nArray[n4];
            if (bl) {
                if (--n4 >= 0) continue;
                n4 = n - 1;
                continue;
            }
            if (++n4 != n) continue;
            n4 = 0;
        }
        for (n2 = 0; n2 < this.mRingAtomSet.size(); ++n2) {
            int[] nArray3 = this.mRingAtomSet.get(n2);
            if (nArray3.length != n) continue;
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                if (nArray3[i] == nArray2[i]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return;
        }
        this.mRingAtomSet.add(nArray2);
        int[] nArray4 = this.getRingBonds(nArray2);
        this.mRingBondSet.add(nArray4);
        this.updateRingSize(nArray2, nArray4);
    }

    public int getSize() {
        return this.mRingAtomSet.size();
    }

    public int[] getRingAtoms(int n) {
        return this.mRingAtomSet.get(n);
    }

    public int[] getRingBonds(int n) {
        return this.mRingBondSet.get(n);
    }

    public int getRingSize(int n) {
        return this.mRingBondSet.get(n).length;
    }

    public boolean isAromatic(int n) {
        return this.mIsAromatic[n];
    }

    public boolean isAromaticAtom(int n) {
        return (this.mAtomRingFeatures[n] & 0x10000) != 0;
    }

    public boolean isDelocalizedAtom(int n) {
        return (this.mAtomRingFeatures[n] & 0x20000) != 0;
    }

    public boolean isHeteroAromaticAtom(int n) {
        return (this.mAtomRingFeatures[n] & 0x40000) != 0;
    }

    public boolean isAromaticBond(int n) {
        return (this.mBondRingFeatures[n] & 0x10000) != 0;
    }

    public boolean isDelocalizedBond(int n) {
        return (this.mBondRingFeatures[n] & 0x20000) != 0;
    }

    public boolean isHeteroAromaticBond(int n) {
        return (this.mBondRingFeatures[n] & 0x40000) != 0;
    }

    public boolean isDelocalized(int n) {
        return this.mIsDelocalized[n];
    }

    public int getAtomIndex(int n, int n2) {
        int[] nArray = this.mRingAtomSet.get(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int getBondIndex(int n, int n2) {
        int[] nArray = this.mRingBondSet.get(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int validateMemberIndex(int n, int n2) {
        int n3 = this.mRingBondSet.get(n).length;
        while (n2 >= n3) {
            n2 -= n3;
        }
        while (n2 < 0) {
            n2 += n3;
        }
        return n2;
    }

    public int getHeteroPosition(int n) {
        return this.mHeteroPosition[n];
    }

    public boolean isAtomMember(int n, int n2) {
        int[] nArray = this.mRingAtomSet.get(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isBondMember(int n, int n2) {
        int[] nArray = this.mRingBondSet.get(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public int getSharedRing(int n, int n2) {
        for (int i = 0; i < this.mRingBondSet.size(); ++i) {
            if (!this.isBondMember(i, n) || !this.isBondMember(i, n2)) continue;
            return i;
        }
        return -1;
    }

    private void updateRingSize(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.mAtomRingFeatures[nArray[n2]] & 0xFFFF;
            if (n != 0 && n <= n3) continue;
            int n4 = nArray[n2];
            this.mAtomRingFeatures[n4] = this.mAtomRingFeatures[n4] & 0xFFFF0000;
            int n5 = nArray[n2];
            this.mAtomRingFeatures[n5] = this.mAtomRingFeatures[n5] | n3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.mBondRingFeatures[nArray2[n2]] & 0xFFFF;
            if (n != 0 && n <= n3) continue;
            int n6 = nArray2[n2];
            this.mBondRingFeatures[n6] = this.mBondRingFeatures[n6] & 0xFFFF0000;
            int n7 = nArray2[n2];
            this.mBondRingFeatures[n7] = this.mBondRingFeatures[n7] | n3;
        }
    }

    private void updateAromaticity() {
        for (int i = 0; i < this.mIsAromatic.length; ++i) {
            int n;
            int n2;
            if (!this.mIsAromatic[i]) continue;
            boolean bl = false;
            int[] nArray = this.mRingAtomSet.get(i);
            int n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = n = nArray[n2];
                this.mAtomRingFeatures[n4] = this.mAtomRingFeatures[n4] | 0x10000;
                if (!this.qualifiesAsHeteroAtom(n)) continue;
                bl = true;
            }
            nArray = this.mRingBondSet.get(i);
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = n = nArray[n2];
                this.mBondRingFeatures[n5] = this.mBondRingFeatures[n5] | 0x10000;
            }
            if (this.mIsDelocalized[i]) {
                nArray = this.mRingAtomSet.get(i);
                n3 = nArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n6 = n = nArray[n2];
                    this.mAtomRingFeatures[n6] = this.mAtomRingFeatures[n6] | 0x20000;
                }
                nArray = this.mRingBondSet.get(i);
                n3 = nArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n7 = n = nArray[n2];
                    this.mBondRingFeatures[n7] = this.mBondRingFeatures[n7] | 0x20000;
                }
            }
            if (!bl) continue;
            nArray = this.mRingAtomSet.get(i);
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n8 = n = nArray[n2];
                this.mAtomRingFeatures[n8] = this.mAtomRingFeatures[n8] | 0x40000;
            }
            nArray = this.mRingBondSet.get(i);
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int n9 = n = nArray[n2];
                this.mBondRingFeatures[n9] = this.mBondRingFeatures[n9] | 0x40000;
            }
        }
    }

    private boolean qualifiesAsHeteroAtom(int n) {
        if (this.mMol.isFragment()) {
            if ((this.mMol.getAtomQueryFeatures(n) & 1L) != 0L) {
                return false;
            }
            int[] nArray = this.mMol.getAtomList(n);
            if (nArray != null) {
                for (int n2 : nArray) {
                    if (Molecule.isAtomicNoElectronegative(n2)) continue;
                    return false;
                }
                return true;
            }
        }
        return Molecule.isAtomicNoElectronegative(this.mMol.getAtomicNo(n));
    }

    private int[] getRingBonds(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        block0: for (int i = 0; i < n; ++i) {
            int n2 = i == n - 1 ? nArray[0] : nArray[i + 1];
            for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                if (this.mMol.getConnAtom(nArray[i], j) != n2) continue;
                nArray2[i] = this.mMol.getConnBond(nArray[i], j);
                continue block0;
            }
        }
        return nArray2;
    }

    public void determineAromaticity(boolean[] blArray, boolean[] blArray2, int[] nArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int[][] nArrayArray = new int[this.mRingAtomSet.size()][];
        for (int i = 0; i < this.mRingAtomSet.size(); ++i) {
            nArrayArray[i] = new int[this.mRingAtomSet.get(i).length];
            for (n3 = 0; n3 < this.mRingAtomSet.get(i).length; ++n3) {
                nArrayArray[i][n3] = -1;
            }
        }
        int[] nArray2 = new int[this.mMol.getBonds()];
        for (n3 = 0; n3 < this.mRingBondSet.size(); ++n3) {
            int[] nArray3 = this.mRingBondSet.get(n3);
            if (nArray3.length != 3 && (nArray3.length < 5 || nArray3.length > 7)) continue;
            for (n2 = 0; n2 < nArray3.length; ++n2) {
                n = nArray3[n2];
                if (this.mMol.getConnAtoms(this.mMol.getBondAtom(0, n)) != 3 || this.mMol.getConnAtoms(this.mMol.getBondAtom(1, n)) != 3) continue;
                if (nArray2[n] > 0) {
                    nArrayArray[nArray2[n] >>> 16][nArray2[n] & Short.MAX_VALUE] = n3;
                    nArrayArray[n3][n2] = nArray2[n] >>> 16;
                    continue;
                }
                nArray2[n] = (n3 << 16) + 32768 + n2;
            }
        }
        boolean[] blArray3 = new boolean[this.mRingAtomSet.size()];
        int n4 = 0;
        n2 = -1;
        while (n4 > n2) {
            n2 = n4;
            for (n = 0; n < this.mRingAtomSet.size(); ++n) {
                if (blArray3[n] || !this.determineAromaticity(n, nArrayArray, blArray3, blArray, blArray2, nArray, bl)) continue;
                blArray3[n] = true;
                ++n4;
            }
        }
    }

    private boolean determineAromaticity(int n, int[][] nArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, int[] nArray2, boolean bl) {
        int n2;
        int n32;
        int[] nArray3;
        for (int n32 : nArray3 = this.mRingAtomSet.get(n)) {
            if (this.qualifiesAsAromaticAtom(n32)) continue;
            return true;
        }
        int[] nArray4 = this.mRingBondSet.get(n);
        int n4 = nArray4.length;
        int n5 = 0;
        n32 = 0;
        boolean bl2 = false;
        for (n2 = 0; n2 < n4; ++n2) {
            n5 <<= 1;
            n32 <<= 1;
            if (this.qualifiesAsPiBond(nArray4[n2])) {
                n5 |= 1;
                continue;
            }
            if (bl && this.qualifiesAsAmideTypeBond(nArray4[n2])) {
                n5 |= 1;
                n32 |= 1;
                continue;
            }
            int n6 = nArray[n][n2];
            if (n6 == -1) continue;
            if (blArray[n6]) {
                if (!blArray2[n6]) continue;
                n5 |= 1;
                if (blArray3[n6]) continue;
                n32 |= 1;
                continue;
            }
            bl2 = true;
        }
        n2 = 0;
        switch (n4) {
            case 3: {
                int[] nArray5 = new int[]{2, 1, 4};
                n2 = 1;
                for (int i = 0; i < 3; ++i) {
                    if ((n5 & nArray5[i]) != nArray5[i] || (this.mMol.getAtomicNo(nArray3[i]) != 6 || this.mMol.getAtomCharge(nArray3[i]) != 1) && (this.mMol.getAtomicNo(nArray3[i]) != 5 || this.mMol.getAtomCharge(nArray3[i]) != 0)) continue;
                    blArray2[n] = true;
                    nArray2[n] = i;
                    if ((n32 & nArray5[i]) != 0) continue;
                    n2 = 0;
                }
                break;
            }
            case 5: {
                int[] nArray6 = new int[]{10, 5, 18, 9, 20};
                n2 = 1;
                block15: for (int i = 0; i < 5; ++i) {
                    if ((n5 & nArray6[i]) != nArray6[i]) continue;
                    switch (this.mMol.getAtomicNo(nArray3[i])) {
                        case 6: {
                            if (this.mMol.getAtomCharge(nArray3[i]) != -1) continue block15;
                            blArray2[n] = true;
                            nArray2[n] = i;
                            if ((n32 & nArray6[i]) != 0) continue block15;
                            n2 = 0;
                            continue block15;
                        }
                        case 7: {
                            if (this.mMol.getAtomCharge(nArray3[i]) > 0) continue block15;
                            blArray2[n] = true;
                            nArray2[n] = i;
                            continue block15;
                        }
                        case 8: {
                            blArray2[n] = true;
                            nArray2[n] = i;
                            continue block15;
                        }
                        case 16: 
                        case 34: 
                        case 52: {
                            if (this.mMol.getConnAtoms(nArray3[i]) != 2) continue block15;
                            blArray2[n] = true;
                            nArray2[n] = i;
                        }
                    }
                }
                break;
            }
            case 6: {
                n2 = 1;
                if ((n5 & 0x15) == 21) {
                    blArray2[n] = true;
                    if ((n32 & 0x15) == 0) {
                        n2 = 0;
                    }
                }
                if ((n5 & 0x2A) != 42) break;
                blArray2[n] = true;
                if ((n32 & 0x2A) != 0) break;
                n2 = 0;
                break;
            }
            case 7: {
                int[] nArray7 = new int[]{42, 21, 74, 37, 82, 41, 84};
                n2 = 1;
                for (int i = 0; i < 7; ++i) {
                    if ((n5 & nArray7[i]) != nArray7[i] || (this.mMol.getAtomicNo(nArray3[i]) != 6 || this.mMol.getAtomCharge(nArray3[i]) != 1) && (this.mMol.getAtomicNo(nArray3[i]) != 5 || this.mMol.getAtomCharge(nArray3[i]) != 0)) continue;
                    blArray2[n] = true;
                    nArray2[n] = i;
                    if ((n32 & nArray7[i]) != 0) continue;
                    n2 = 0;
                }
                break;
            }
        }
        if (blArray2[n] && n2 == 0) {
            blArray3[n] = true;
        }
        if (blArray2[n]) {
            return true;
        }
        return !bl2;
    }

    private boolean qualifiesAsPiBond(int n) {
        return this.mMol.getBondOrder(n) > 1 || this.mMol.getBondType(n) == 64;
    }

    public boolean qualifiesAsAmideTypeBond(int n) {
        for (int i = 0; i < 2; ++i) {
            int n2;
            int n3 = this.mMol.getBondAtom(i, n);
            if (this.mMol.getAtomicNo(n3) != 7 || this.mMol.getConnAtoms(n3) != 2 || this.mMol.getAtomicNo(n2 = this.mMol.getBondAtom(1 - i, n)) != 6) continue;
            for (int j = 0; j < this.mMol.getConnAtoms(n2); ++j) {
                int n4 = this.mMol.getConnAtom(n2, j);
                int n5 = this.mMol.getConnBond(n2, j);
                if (this.mMol.getAtomicNo(n4) != 8 && this.mMol.getAtomicNo(n4) != 16 || this.mMol.getBondOrder(n5) != 2 || this.mMol.getConnAtoms(n4) != 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean qualifiesAsAromaticAtom(int n) {
        if (this.mMol.isFragment()) {
            if ((this.mMol.getAtomQueryFeatures(n) & 1L) != 0L) {
                return true;
            }
            int[] nArray = this.mMol.getAtomList(n);
            if (nArray != null) {
                for (int n2 : nArray) {
                    if (!RingCollection.qualifiesAsAromaticAtomicNo(n2)) continue;
                    return true;
                }
                return false;
            }
        }
        return RingCollection.qualifiesAsAromaticAtomicNo(this.mMol.getAtomicNo(n));
    }

    public static boolean qualifiesAsAromaticAtomicNo(int n) {
        return n == 5 || n == 6 || n == 7 || n == 8 || n == 15 || n == 16 || n == 33 || n == 34;
    }
}

