/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;

public class MoleculeStandardizer {
    public static final int MODE_GET_PARENT = 1;
    public static final int MODE_ADD_NA_AND_CL = 2;

    public static StereoMolecule getStandardized(String string, String string2, int n) throws Exception {
        StereoMolecule stereoMolecule = new IDCodeParser().getCompactMolecule(string, string2);
        MoleculeStandardizer.standardize(stereoMolecule, n);
        return stereoMolecule;
    }

    public static void standardize(StereoMolecule stereoMolecule, int n) throws Exception {
        if ((n & 1) != 0) {
            stereoMolecule.stripSmallFragments();
            stereoMolecule.stripIsotopInfo();
        }
        MoleculeStandardizer.repairAndUnify(stereoMolecule);
        stereoMolecule.normalizeAmbiguousBonds();
        int n2 = stereoMolecule.canonizeCharge(true, true);
        if (n2 != 0) {
            MoleculeStandardizer.neutralizeCharges(stereoMolecule, n, n2);
        }
        stereoMolecule.validateAtomQueryFeatures();
        stereoMolecule.validateBondQueryFeatures();
    }

    private static void repairAndUnify(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        MoleculeStandardizer.repairCovalentBoundChargedAlkaliAndHalogen(stereoMolecule);
        MoleculeStandardizer.chargeTrivalentOxygen(stereoMolecule);
        MoleculeStandardizer.repairBadAmideTautomer(stereoMolecule);
        MoleculeStandardizer.repairQuaternaryNitrogen(stereoMolecule);
        MoleculeStandardizer.unifyIsoCyano(stereoMolecule);
        MoleculeStandardizer.unifyAzido(stereoMolecule);
    }

    private static void neutralizeCharges(StereoMolecule stereoMolecule, int n, int n2) {
        int n3;
        stereoMolecule.ensureHelperArrays(1);
        for (n3 = 0; n3 < stereoMolecule.getAllAtoms() && n2 > 0; ++n3) {
            if (!AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, n3)) continue;
            stereoMolecule.setAtomCharge(n3, -1);
            --n2;
        }
        for (n3 = 0; n3 < stereoMolecule.getAllAtoms() && n2 < 0; ++n3) {
            if (!AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, n3)) continue;
            stereoMolecule.setAtomCharge(n3, 1);
            ++n2;
        }
        if (n2 != 0 && (n & 2) != 0) {
            for (n3 = 0; n3 < stereoMolecule.getAllAtoms(); ++n3) {
                stereoMolecule.setAtomMarker(n3, true);
            }
            while (n2 > 0) {
                n3 = stereoMolecule.addAtom(17);
                stereoMolecule.setAtomCharge(n3, -1);
                --n2;
            }
            while (n2 < 0) {
                n3 = stereoMolecule.addAtom(11);
                stereoMolecule.setAtomCharge(n3, 1);
                ++n2;
            }
            new CoordinateInventor(6).invent(stereoMolecule);
        }
    }

    private static void repairCovalentBoundChargedAlkaliAndHalogen(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.isHalogene(i)) {
                if (stereoMolecule.getOccupiedValence(i) != 1 || stereoMolecule.getAtomCharge(i) != -1) continue;
                stereoMolecule.setAtomCharge(i, 0);
                stereoMolecule.setAtomAbnormalValence(i, -1);
                continue;
            }
            if (stereoMolecule.isAlkaliMetal(i)) {
                if (stereoMolecule.getOccupiedValence(i) != 1 || stereoMolecule.getAtomCharge(i) != 1) continue;
                stereoMolecule.setAtomCharge(i, 0);
                stereoMolecule.setAtomAbnormalValence(i, -1);
                continue;
            }
            if (!stereoMolecule.isEarthAlkaliMetal(i) || stereoMolecule.getOccupiedValence(i) != 2 || stereoMolecule.getAtomCharge(i) != 2) continue;
            stereoMolecule.setAtomCharge(i, 0);
            stereoMolecule.setAtomAbnormalValence(i, -1);
        }
    }

    private static void chargeTrivalentOxygen(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 8 && stereoMolecule.getAtomicNo(i) != 16 || stereoMolecule.getOccupiedValence(i) != 3 || stereoMolecule.getAtomCharge(i) == 1) continue;
            stereoMolecule.setAtomCharge(i, 1);
        }
    }

    private static void repairBadAmideTautomer(StereoMolecule stereoMolecule) {
        block0: for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n;
            if (stereoMolecule.getAtomicNo(i) != 8 || stereoMolecule.getConnAtoms(i) != 1 || stereoMolecule.getConnBondOrder(i, 0) != 1 || stereoMolecule.getAtomicNo(n = stereoMolecule.getConnAtom(i, 0)) != 6 || stereoMolecule.getAtomPi(n) != 1) continue;
            for (int j = 0; j < stereoMolecule.getConnAtoms(n); ++j) {
                int n2;
                if (stereoMolecule.getConnBondOrder(n, j) != 2 || stereoMolecule.getAtomicNo(n2 = stereoMolecule.getConnAtom(n, j)) != 7 || stereoMolecule.isRingAtom(n2)) continue;
                boolean bl = false;
                for (int k = 0; k < stereoMolecule.getConnAtoms(n2); ++k) {
                    int n3 = stereoMolecule.getConnAtom(n2, k);
                    if (n3 == n || stereoMolecule.getAtomPi(n3) == 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stereoMolecule.setBondType(stereoMolecule.getConnBond(i, 0), 2);
                stereoMolecule.setBondType(stereoMolecule.getConnBond(n, j), 1);
                continue block0;
            }
        }
    }

    private static void unifyIsoCyano(StereoMolecule stereoMolecule) {
        block0: for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (stereoMolecule.getBondType(i) != 4) continue;
            for (int j = 0; j < 2; ++j) {
                int n = stereoMolecule.getBondAtom(j, i);
                int n2 = stereoMolecule.getBondAtom(1 - j, i);
                if (stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.getConnAtoms(n) != 2 || stereoMolecule.getAtomicNo(n2) != 6 || stereoMolecule.getConnAtoms(n2) != 1) continue;
                if (stereoMolecule.getAtomCharge(n) != 1) {
                    stereoMolecule.setAtomCharge(n, 1);
                }
                if (stereoMolecule.getAtomCharge(n2) == -1) continue block0;
                stereoMolecule.setAtomCharge(n2, -1);
                continue block0;
            }
        }
    }

    private static void unifyAzido(StereoMolecule stereoMolecule) {
        block0: for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 7 || stereoMolecule.getConnAtoms(i) != 2 || stereoMolecule.getConnBondOrder(i, 0) != 2 || stereoMolecule.getConnBondOrder(i, 1) != 2 || stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(i, 0)) != 7 || stereoMolecule.getAtomicNo(stereoMolecule.getConnAtom(i, 1)) != 7) continue;
            for (int j = 0; j < 2; ++j) {
                int n = stereoMolecule.getConnAtom(i, j);
                int n2 = stereoMolecule.getConnAtom(i, 1 - j);
                if (stereoMolecule.getConnAtoms(n) != 1 || stereoMolecule.getConnAtoms(n2) != 2) continue;
                if (stereoMolecule.getAtomCharge(i) != 1) {
                    stereoMolecule.setAtomCharge(i, 1);
                }
                if (stereoMolecule.getAtomCharge(n) != -1) {
                    stereoMolecule.setAtomCharge(n, -1);
                }
                if (stereoMolecule.getAtomCharge(n2) == 0) continue block0;
                stereoMolecule.setAtomCharge(n2, 0);
                continue block0;
            }
        }
    }

    private static void repairQuaternaryNitrogen(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 7 || stereoMolecule.getOccupiedValence(i) != 4 || stereoMolecule.getAtomCharge(i) == 1) continue;
            stereoMolecule.setAtomCharge(i, 1);
        }
    }
}

