/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IsotopeHelper;
import com.actelion.research.chem.Molecule;

public class MolecularFormula {
    private static final double[] sRelativeMass = new double[]{0.0, 1.00794, 4.0026, 6.941, 9.0122, 10.811, 12.011, 14.007, 15.999, 18.998, 20.18, 22.99, 24.305, 26.982, 28.086, 30.974, 32.066, 35.453, 39.948, 39.098, 40.078, 44.956, 47.867, 50.942, 51.996, 54.938, 55.845, 58.933, 58.693, 63.546, 65.39, 69.723, 72.61, 74.922, 78.96, 79.904, 83.8, 85.468, 87.62, 88.906, 91.224, 92.906, 95.94, 98.906, 101.07, 102.91, 106.42, 107.87, 112.41, 114.82, 118.71, 121.76, 127.6, 126.9, 131.29, 132.91, 137.33, 138.91, 140.12, 140.91, 144.24, 146.92, 150.36, 151.96, 157.25, 158.93, 162.5, 164.93, 167.26, 168.93, 173.04, 174.97, 178.49, 180.95, 183.84, 186.21, 190.23, 192.22, 195.08, 196.97, 200.59, 204.38, 207.2, 208.98, 209.98, 209.99, 222.02, 223.02, 226.03, 227.03, 232.04, 231.04, 238.03, 237.05, 239.05, 241.06, 244.06, 249.08, 252.08, 252.08, 257.1, 258.1, 259.1, 262.11, 267.12, 268.13, 271.13, 270.13, 277.15, 276.15, 281.17, 281.17, 283.17, 285.18, 289.19, 289.19, 293.2, 294.21, 294.21, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0141, 3.016, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 71.0787, 156.18828, 114.10364, 115.0877, 103.1447, 128.13052, 129.11458, 57.05182, 137.14158, 113.15934, 113.15934, 128.17428, 131.19846, 147.17646, 97.11658, 87.0777, 101.10458, 186.2134, 163.17546, 99.13246};
    private static final double[] sAbsoluteMass = new double[]{0.0, 1.007825, 4.0026, 7.016003, 9.012182, 11.009305, 12.0, 14.003074, 15.994915, 18.998403, 19.992435, 22.989767, 23.985042, 26.98153, 27.976927, 30.973762, 31.97207, 34.968852, 39.962384, 38.963707, 39.962591, 44.95591, 47.947947, 50.943962, 51.940509, 54.938047, 55.934939, 58.933198, 57.935346, 62.939598, 63.929145, 68.92558, 73.921177, 74.921594, 79.91652, 78.918336, 83.911507, 84.911794, 87.905619, 88.905849, 89.904703, 92.906377, 97.905406, 89.92381, 101.904348, 102.9055, 105.903478, 106.905092, 113.903357, 114.90388, 119.9022, 120.903821, 129.906229, 126.904473, 131.904144, 132.905429, 137.905232, 138.906346, 139.905433, 140.907647, 141.907719, 135.92398, 151.919729, 152.921225, 157.924099, 158.925342, 163.929171, 164.930319, 165.93029, 168.934212, 173.938859, 174.94077, 179.946545, 180.947992, 183.950928, 186.955744, 191.961467, 192.962917, 194.964766, 196.966543, 201.970617, 204.974401, 207.976627, 208.980374, 193.98818, 195.99573, 199.9957, 201.00411, 206.0038, 210.00923, 232.038054, 216.01896, 238.050784, 229.03623, 232.041169, 237.05005, 238.05302, 242.06194, 240.06228, 243.06947, 243.07446, 248.08275, 251.08887, 253.09515, 257.10295, 257.10777, 271.13, 270.13, 277.15, 276.15, 281.17, 281.17, 283.17, 285.18, 289.19, 289.19, 291.2, 294.21, 294.21, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.014, 3.01605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final int[] sFirstFormulaAtomicNo = new int[]{6, 1, 7, 8};
    private int[] mAtomCount;
    private int[] mAtomicNo;
    private double mAbsoluteIsotopeWeightIncrement;
    private double mRelativeIsotopeWeightIncrement;

    public MolecularFormula(ExtendedMolecule extendedMolecule) {
        int n;
        int n2;
        int n3;
        int n4;
        extendedMolecule.ensureHelperArrays(1);
        int[] nArray = new int[191];
        block28: for (n4 = 0; n4 < extendedMolecule.getAllAtoms(); ++n4) {
            switch (extendedMolecule.getAtomicNo(n4)) {
                case 171: {
                    nArray[1] = nArray[1] + 5;
                    nArray[6] = nArray[6] + 3;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 172: {
                    nArray[1] = nArray[1] + 12;
                    nArray[6] = nArray[6] + 6;
                    nArray[7] = nArray[7] + 4;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 173: {
                    nArray[1] = nArray[1] + 6;
                    nArray[6] = nArray[6] + 4;
                    nArray[7] = nArray[7] + 2;
                    nArray[8] = nArray[8] + 2;
                    continue block28;
                }
                case 174: {
                    nArray[1] = nArray[1] + 5;
                    nArray[6] = nArray[6] + 4;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 3;
                    continue block28;
                }
                case 175: {
                    nArray[1] = nArray[1] + 5;
                    nArray[6] = nArray[6] + 3;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    nArray[16] = nArray[16] + 1;
                    continue block28;
                }
                case 176: {
                    nArray[1] = nArray[1] + 8;
                    nArray[6] = nArray[6] + 5;
                    nArray[7] = nArray[7] + 2;
                    nArray[8] = nArray[8] + 2;
                    continue block28;
                }
                case 177: {
                    nArray[1] = nArray[1] + 7;
                    nArray[6] = nArray[6] + 5;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 3;
                    continue block28;
                }
                case 178: {
                    nArray[1] = nArray[1] + 3;
                    nArray[6] = nArray[6] + 2;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 179: {
                    nArray[1] = nArray[1] + 7;
                    nArray[6] = nArray[6] + 6;
                    nArray[7] = nArray[7] + 3;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 180: {
                    nArray[1] = nArray[1] + 11;
                    nArray[6] = nArray[6] + 6;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 181: {
                    nArray[1] = nArray[1] + 11;
                    nArray[6] = nArray[6] + 6;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 182: {
                    nArray[1] = nArray[1] + 12;
                    nArray[6] = nArray[6] + 6;
                    nArray[7] = nArray[7] + 2;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 183: {
                    nArray[1] = nArray[1] + 9;
                    nArray[6] = nArray[6] + 5;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    nArray[16] = nArray[16] + 1;
                    continue block28;
                }
                case 184: {
                    nArray[1] = nArray[1] + 9;
                    nArray[6] = nArray[6] + 9;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 185: {
                    nArray[1] = nArray[1] + 7;
                    nArray[6] = nArray[6] + 5;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 186: {
                    nArray[1] = nArray[1] + 5;
                    nArray[6] = nArray[6] + 3;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 2;
                    continue block28;
                }
                case 187: {
                    nArray[1] = nArray[1] + 7;
                    nArray[6] = nArray[6] + 4;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 2;
                    continue block28;
                }
                case 188: {
                    nArray[1] = nArray[1] + 10;
                    nArray[6] = nArray[6] + 11;
                    nArray[7] = nArray[7] + 2;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 189: {
                    nArray[1] = nArray[1] + 9;
                    nArray[6] = nArray[6] + 9;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 2;
                    continue block28;
                }
                case 190: {
                    nArray[1] = nArray[1] + 9;
                    nArray[6] = nArray[6] + 5;
                    nArray[7] = nArray[7] + 1;
                    nArray[8] = nArray[8] + 1;
                    continue block28;
                }
                case 1: {
                    switch (extendedMolecule.getAtomMass(n4)) {
                        case 0: 
                        case 1: {
                            nArray[1] = nArray[1] + 1;
                            break;
                        }
                        case 2: {
                            nArray[151] = nArray[151] + 1;
                            break;
                        }
                        case 3: {
                            nArray[152] = nArray[152] + 1;
                        }
                    }
                    continue block28;
                }
                default: {
                    int n5 = extendedMolecule.getAtomicNo(n4);
                    nArray[n5] = nArray[n5] + 1;
                }
            }
        }
        for (n4 = 0; n4 < extendedMolecule.getAllAtoms(); ++n4) {
            nArray[1] = extendedMolecule.getAtomicNo(n4) >= 171 && extendedMolecule.getAtomicNo(n4) <= 190 ? nArray[1] + (2 - extendedMolecule.getOccupiedValence(n4)) : nArray[1] + extendedMolecule.getImplicitHydrogens(n4);
        }
        n4 = 0;
        for (n3 = 1; n3 <= 190; ++n3) {
            if (nArray[n3] == 0) continue;
            ++n4;
        }
        this.mAtomCount = new int[n4];
        this.mAtomicNo = new int[n4];
        n4 = 0;
        for (n3 = 0; n3 < sFirstFormulaAtomicNo.length; ++n3) {
            if (nArray[sFirstFormulaAtomicNo[n3]] == 0) continue;
            this.mAtomCount[n4] = nArray[sFirstFormulaAtomicNo[n3]];
            this.mAtomicNo[n4] = sFirstFormulaAtomicNo[n3];
            ++n4;
            nArray[MolecularFormula.sFirstFormulaAtomicNo[n3]] = 0;
        }
        while (true) {
            String string = "zzz";
            n2 = -1;
            for (n = 1; n <= 190; ++n) {
                if (nArray[n] <= 0 || string.compareTo(Molecule.cAtomLabel[n]) <= 0) continue;
                string = Molecule.cAtomLabel[n];
                n2 = n;
            }
            if (n2 == -1) break;
            this.mAtomCount[n4] = nArray[n2];
            this.mAtomicNo[n4] = n2;
            ++n4;
            nArray[n2] = 0;
        }
        this.mAbsoluteIsotopeWeightIncrement = 0.0;
        this.mRelativeIsotopeWeightIncrement = 0.0;
        for (int i = 0; i < extendedMolecule.getAtoms(); ++i) {
            if (extendedMolecule.getAtomicNo(i) == 1 || extendedMolecule.isNaturalAbundance(i)) continue;
            n2 = extendedMolecule.getAtomicNo(i);
            n = extendedMolecule.getAtomMass(i);
            this.mAbsoluteIsotopeWeightIncrement += IsotopeHelper.getAbsoluteMass(n2, n) - sAbsoluteMass[n2];
            this.mRelativeIsotopeWeightIncrement += IsotopeHelper.getAbsoluteMass(n2, n) - sRelativeMass[n2];
        }
    }

    public double getRelativeWeight() {
        double d = this.mRelativeIsotopeWeightIncrement;
        for (int i = 0; i < this.mAtomCount.length; ++i) {
            d += (double)this.mAtomCount[i] * sRelativeMass[this.mAtomicNo[i]];
        }
        return d;
    }

    public double getAbsoluteWeight() {
        double d = this.mAbsoluteIsotopeWeightIncrement;
        for (int i = 0; i < this.mAtomCount.length; ++i) {
            d += (double)this.mAtomCount[i] * sAbsoluteMass[this.mAtomicNo[i]];
        }
        return d;
    }

    public String getFormula() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mAtomCount.length; ++i) {
            stringBuffer.append(Molecule.cAtomLabel[this.mAtomicNo[i]]);
            if (this.mAtomCount[i] <= 1) continue;
            stringBuffer.append(this.mAtomCount[i]);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MolecularFormula)) {
            return false;
        }
        for (int i = 0; i < this.mAtomCount.length; ++i) {
            if (this.mAtomCount[i] == ((MolecularFormula)object).mAtomCount[i]) continue;
            return false;
        }
        return true;
    }
}

