/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.util.Angle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ExtendedMolecule
extends Molecule
implements Serializable {
    static final long serialVersionUID = 537316094L;
    public static final float FISCHER_PROJECTION_LIMIT = 0.08726647f;
    public static final float FISCHER_PROJECTION_RING_LIMIT = 24.0f;
    public static final float STEREO_ANGLE_LIMIT = 0.08726647f;
    public static final int cMaxConnAtoms = 16;
    private transient int mAtoms;
    private transient int mBonds;
    private transient RingCollection mRingSet;
    private transient int[] mPi;
    private transient int[] mConnAtoms;
    private transient int[] mAllConnAtoms;
    private transient int[][] mConnAtom;
    private transient int[][] mConnBond;
    private transient int[][] mConnBondOrder;
    private boolean[] mReallySimpleHydrogens;

    public ExtendedMolecule() {
    }

    public ExtendedMolecule(int n, int n2) {
        super(n, n2);
    }

    public ExtendedMolecule(Molecule molecule) {
        super(molecule == null ? 256 : molecule.getMaxAtoms(), molecule == null ? 256 : molecule.getMaxBonds());
        if (molecule != null) {
            molecule.copyMolecule(this);
        }
    }

    public void copyMoleculeByAtoms(ExtendedMolecule extendedMolecule, boolean[] blArray, boolean bl, int[] nArray) {
        int n;
        if (bl) {
            this.ensureHelperArrays(7);
        }
        extendedMolecule.mAtomList = null;
        if (this.mIsFragment) {
            extendedMolecule.setFragment(true);
        }
        int n2 = blArray.length;
        if (nArray == null) {
            nArray = new int[n2];
        }
        extendedMolecule.mAllAtoms = 0;
        for (n = 0; n < n2; ++n) {
            nArray[n] = blArray[n] ? this.copyAtom(extendedMolecule, n, 0, 0) : -1;
        }
        extendedMolecule.mAllBonds = 0;
        for (n = 0; n < this.mAllBonds; ++n) {
            int n3 = this.mBondAtom[0][n];
            int n4 = this.mBondAtom[1][n];
            if (n3 >= n2 || n4 >= n2) continue;
            if (blArray[n3] && blArray[n4]) {
                this.copyBond(extendedMolecule, n, 0, 0, nArray, bl);
                continue;
            }
            if (this.mAtomCharge[n3] == 0 || this.mAtomCharge[n4] == 0 || !(this.mAtomCharge[n3] < 0 ^ this.mAtomCharge[n4] < 0)) continue;
            if (blArray[n3]) {
                int n5 = nArray[n3];
                extendedMolecule.mAtomCharge[n5] = extendedMolecule.mAtomCharge[n5] + (this.mAtomCharge[n3] < 0 ? 1 : -1);
            }
            if (!blArray[n4]) continue;
            int n6 = nArray[n4];
            extendedMolecule.mAtomCharge[n6] = extendedMolecule.mAtomCharge[n6] + (this.mAtomCharge[n4] < 0 ? 1 : -1);
        }
        this.copyMoleculeProperties(extendedMolecule);
        extendedMolecule.mValidHelperArrays = 0;
        extendedMolecule.renumberESRGroups(1);
        extendedMolecule.renumberESRGroups(2);
        if (extendedMolecule.mAllAtoms != n2) {
            extendedMolecule.setFragment(true);
        }
        if (bl) {
            new AromaticityResolver(extendedMolecule).locateDelocalizedDoubleBonds(null);
        }
    }

    public int[] copyMoleculeByBonds(ExtendedMolecule extendedMolecule, boolean[] blArray, boolean bl, int[] nArray) {
        int n;
        int n2;
        if (bl) {
            this.ensureHelperArrays(7);
        }
        extendedMolecule.mAtomList = null;
        if (this.mIsFragment) {
            extendedMolecule.setFragment(true);
        }
        if (nArray == null) {
            nArray = new int[this.mAllAtoms];
        }
        extendedMolecule.mAllAtoms = 0;
        block0: for (n2 = 0; n2 < this.mAllAtoms; ++n2) {
            nArray[n2] = -1;
            for (n = 0; n < this.mConnAtoms[n2]; ++n) {
                if (!blArray[this.mConnBond[n2][n]]) continue;
                nArray[n2] = this.copyAtom(extendedMolecule, n2, 0, 0);
                continue block0;
            }
        }
        extendedMolecule.mAllBonds = 0;
        for (n2 = 0; n2 < this.mAllBonds; ++n2) {
            int n3;
            if (blArray[n2]) {
                this.copyBond(extendedMolecule, n2, 0, 0, nArray, bl);
                continue;
            }
            n = this.mBondAtom[0][n2];
            if (!(nArray[n] == -1 ^ nArray[n3 = this.mBondAtom[1][n2]] == -1) || this.mAtomCharge[n] == 0 || this.mAtomCharge[n3] == 0 || !(this.mAtomCharge[n] < 0 ^ this.mAtomCharge[n3] < 0)) continue;
            if (nArray[n] != -1) {
                int n4 = nArray[n];
                extendedMolecule.mAtomCharge[n4] = extendedMolecule.mAtomCharge[n4] + (this.mAtomCharge[n] < 0 ? 1 : -1);
            }
            if (nArray[n3] == -1) continue;
            int n5 = nArray[n3];
            extendedMolecule.mAtomCharge[n5] = extendedMolecule.mAtomCharge[n5] + (this.mAtomCharge[n3] < 0 ? 1 : -1);
        }
        this.copyMoleculeProperties(extendedMolecule);
        extendedMolecule.mValidHelperArrays = 0;
        extendedMolecule.renumberESRGroups(1);
        extendedMolecule.renumberESRGroups(2);
        if (extendedMolecule.mAllAtoms != this.mAllAtoms) {
            extendedMolecule.setFragment(true);
        }
        if (bl) {
            new AromaticityResolver(extendedMolecule).locateDelocalizedDoubleBonds(null);
        }
        return nArray;
    }

    public int getAllConnAtoms(int n) {
        return this.mAllConnAtoms[n];
    }

    public int getPlainHydrogens(int n) {
        return this.getExplicitHydrogens(n) + this.getImplicitHydrogens(n);
    }

    public int getAllHydrogens(int n) {
        return this.mAllConnAtoms[n] - this.getNonHydrogenNeighbourCount(n) + this.getImplicitHydrogens(n);
    }

    public int getAtoms() {
        return this.mAtoms;
    }

    public int getMetalBondedConnAtoms(int n) {
        return this.mConnAtom[n].length - this.mAllConnAtoms[n];
    }

    public boolean isReallySimpleHydrogen(int n) {
        return this.mReallySimpleHydrogens != null && this.mReallySimpleHydrogens[n];
    }

    public int getAtomPi(int n) {
        return this.mPi[n];
    }

    public int getAtomElectronegativeNeighbours(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            if (!this.isElectronegative(this.mConnAtom[n][i]) || this.isBondBridge(this.mConnBond[n][i])) continue;
            ++n2;
        }
        return n2;
    }

    public int getAtomZValue(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            if (!this.isElectronegative(this.mConnAtom[n][i])) continue;
            if (this.isDelocalizedBond(this.mConnBond[n][i])) {
                ++n2;
                ++n3;
                continue;
            }
            n2 += this.mConnBondOrder[n][i];
        }
        return n2 + n3 / 2;
    }

    public int getAtomRingSize(int n) {
        return this.mRingSet != null && n < this.mAtoms ? this.mRingSet.getAtomRingSize(n) : 0;
    }

    public int getBondRingSize(int n) {
        return this.mRingSet != null && n < this.mBonds ? this.mRingSet.getBondRingSize(n) : 0;
    }

    public int getBonds() {
        return this.mBonds;
    }

    public int getBond(int n, int n2) {
        for (int i = 0; i < this.getAllConnAtomsPlusMetalBonds(n); ++i) {
            if (this.mConnAtom[n][i] != n2) continue;
            return this.mConnBond[n][i];
        }
        return -1;
    }

    public ExtendedMolecule getCompactCopy() {
        ExtendedMolecule extendedMolecule = new ExtendedMolecule(this.mAllAtoms, this.mAllBonds);
        this.copyMolecule(extendedMolecule);
        return extendedMolecule;
    }

    public int getConnAtom(int n, int n2) {
        return this.mConnAtom[n][n2];
    }

    public int getConnAtoms(int n) {
        return this.mConnAtoms[n];
    }

    public int getAllConnAtomsPlusMetalBonds(int n) {
        return this.mConnAtom[n].length;
    }

    public int getConnBond(int n, int n2) {
        return this.mConnBond[n][n2];
    }

    public int getConnBondOrder(int n, int n2) {
        return this.mConnBondOrder[n][n2];
    }

    public int getNonHydrogenNeighbourCount(int n) {
        int n2 = this.mConnAtoms[n];
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            if (this.mAtomicNo[this.mConnAtom[n][i]] != 1) continue;
            --n2;
        }
        return n2;
    }

    public int getExcludedNeighbourCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            if ((this.mAtomQueryFeatures[i] & 0x20000000L) == 0L) continue;
            ++n2;
        }
        return n2;
    }

    public double getAverageBondLength(boolean bl) {
        if (bl) {
            this.ensureHelperArrays(1);
            return this.getAverageBondLength(this.mAtoms, this.mBonds);
        }
        return this.getAverageBondLength(this.mAllAtoms, this.mAllBonds);
    }

    private int[] getSortedConnMap(int n) {
        int n2;
        int n3 = this.mAllConnAtoms[n];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = (this.mConnAtom[n][n2] << 16) + n2;
        }
        Arrays.sort(nArray);
        n2 = 0;
        while (n2 < n3) {
            int n4 = n2++;
            nArray[n4] = nArray[n4] & 0xFFFF;
        }
        return nArray;
    }

    @Override
    public int getOccupiedValence(int n) {
        this.ensureHelperArrays(1);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < this.mAllConnAtoms[n]; ++i) {
            int n3;
            if (this.mIsFragment && (this.mAtomQueryFeatures[this.mConnAtom[n][i]] & 0x20000000L) != 0L) continue;
            int n4 = this.mConnBondOrder[n][i];
            n2 += n4;
            if (n4 > 1) {
                bl = true;
            }
            if (this.mBondType[n3 = this.mConnBond[n][i]] != 64) continue;
            bl2 = true;
        }
        if (bl2 && !bl) {
            ++n2;
        }
        return n2;
    }

    public int getFreeValence(int n) {
        return this.getMaxValence(n) - this.getOccupiedValence(n);
    }

    public int getLowestFreeValence(int n) {
        int n2 = this.getOccupiedValence(n);
        int n3 = this.getElectronValenceCorrection(n, n2);
        int n4 = this.getAtomAbnormalValence(n);
        if (n4 == -1) {
            int n5;
            byte[] byArray = ExtendedMolecule.getAllowedValences(this.mAtomicNo[n]);
            for (n5 = 0; n2 > byArray[n5] + n3 && n5 < byArray.length - 1; ++n5) {
            }
            n4 = byArray[n5];
        }
        return n4 + n3 - n2;
    }

    public int getImplicitHigherValence(int n, boolean bl) {
        byte[] byArray;
        int n2 = this.getOccupiedValence(n);
        n2 -= this.getElectronValenceCorrection(n, n2);
        if (bl) {
            n2 -= this.mAllConnAtoms[n] - this.mConnAtoms[n];
        }
        if (n2 <= (byArray = ExtendedMolecule.getAllowedValences(this.mAtomicNo[n]))[0]) {
            return -1;
        }
        for (int i = 1; i < byArray.length; ++i) {
            if (byArray[i] < n2) continue;
            return byArray[i];
        }
        return n2;
    }

    public float[] getAverageTopologicalAtomDistance() {
        this.ensureHelperArrays(1);
        float[] fArray = new float[this.mAtoms];
        int[] nArray = new int[this.mAtoms];
        int n = 0;
        while (n < this.mAtoms) {
            nArray[0] = n;
            int[] nArray2 = new int[this.mAtoms];
            nArray2[n] = 1;
            int n2 = 0;
            for (int i = 0; i <= n2; ++i) {
                for (int j = 0; j < this.mConnAtoms[nArray[i]]; ++j) {
                    int n3 = this.mConnAtom[nArray[i]][j];
                    if (nArray2[n3] != 0) continue;
                    nArray2[n3] = nArray2[nArray[i]] + 1;
                    nArray[++n2] = n3;
                    int n4 = n;
                    fArray[n4] = fArray[n4] + (float)(nArray2[n3] - 1);
                }
            }
            int n5 = n++;
            fArray[n5] = fArray[n5] / (float)n2;
        }
        return fArray;
    }

    public int getPathLength(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int[] nArray = new int[this.mAllAtoms];
        int[] nArray2 = new int[this.mAllAtoms];
        nArray2[0] = n;
        nArray[n] = 1;
        int n3 = 0;
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < this.mAllConnAtoms[nArray2[i]]; ++j) {
                int n4 = this.mConnAtom[nArray2[i]][j];
                if (n4 == n2) {
                    return nArray[nArray2[i]];
                }
                if (nArray[n4] != 0) continue;
                nArray2[++n3] = n4;
                nArray[n4] = nArray[nArray2[i]] + 1;
            }
        }
        return -1;
    }

    public int getPathLength(int n, int n2, int n3, boolean[] blArray) {
        if (n == n2) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int[] nArray = new int[this.mAllAtoms];
        int[] nArray2 = new int[this.mAllAtoms];
        nArray2[0] = n;
        nArray[n] = 1;
        int n4 = 0;
        for (int i = 0; i <= n4 && nArray[nArray2[i]] <= n3; ++i) {
            for (int j = 0; j < this.mAllConnAtoms[nArray2[i]]; ++j) {
                int n5 = this.mConnAtom[nArray2[i]][j];
                if (n5 == n2) {
                    return nArray[nArray2[i]];
                }
                if (nArray[n5] != 0 || blArray != null && blArray.length > n5 && blArray[n5]) continue;
                nArray2[++n4] = n5;
                nArray[n5] = nArray[nArray2[i]] + 1;
            }
        }
        return -1;
    }

    public int getPath(int[] nArray, int n, int n2, int n3, boolean[] blArray) {
        return this.getPath(nArray, n, n2, n3, null, blArray);
    }

    public int getPath(int[] nArray, int n, int n2, int n3, boolean[] blArray, boolean[] blArray2) {
        if (n == n2) {
            nArray[0] = n;
            return 0;
        }
        this.ensureHelperArrays(1);
        int[] nArray2 = new int[this.mAllAtoms];
        int[] nArray3 = new int[this.mAllAtoms];
        int[] nArray4 = new int[this.mAllAtoms];
        nArray3[0] = n;
        nArray2[n] = 1;
        int n4 = 0;
        for (int i = 0; i <= n4 && nArray2[nArray3[i]] <= n3; ++i) {
            int n5 = nArray3[i];
            for (int j = 0; j < this.mAllConnAtoms[n5]; ++j) {
                if (blArray2 != null && blArray2.length > this.mConnBond[n5][j] && blArray2[this.mConnBond[n5][j]]) continue;
                int n6 = this.mConnAtom[n5][j];
                if (n6 == n2) {
                    int n7 = nArray2[n5];
                    nArray[n7] = n6;
                    nArray[--n7] = n5;
                    while (n7 > 0) {
                        nArray[n7 - 1] = nArray4[nArray[n7]];
                        --n7;
                    }
                    return nArray2[n5];
                }
                if (nArray2[n6] != 0 || blArray != null && blArray.length > n6 && blArray[n6]) continue;
                nArray3[++n4] = n6;
                nArray2[n6] = nArray2[n5] + 1;
                nArray4[n6] = n5;
            }
        }
        return -1;
    }

    public void getPathBonds(int[] nArray, int[] nArray2, int n) {
        this.ensureHelperArrays(1);
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.mAllConnAtoms[nArray[i]]; ++j) {
                if (this.mConnAtom[nArray[i]][j] != nArray[i + 1]) continue;
                nArray2[i] = this.mConnBond[nArray[i]][j];
                continue block0;
            }
        }
    }

    public boolean shareSameFragment(int n, int n2) {
        return this.getPathLength(n, n2) != -1;
    }

    public void addFragment(ExtendedMolecule extendedMolecule, int n, int[] nArray) {
        int n2;
        extendedMolecule.ensureHelperArrays(1);
        if (nArray == null) {
            nArray = new int[extendedMolecule.mAllAtoms];
        }
        int n3 = this.renumberESRGroups(1);
        int n4 = this.renumberESRGroups(2);
        boolean[] blArray = new boolean[extendedMolecule.mAllAtoms];
        int[] nArray2 = new int[extendedMolecule.mAllAtoms];
        nArray2[0] = n;
        blArray[n] = true;
        nArray[n] = extendedMolecule.copyAtom(this, n, n3, n4);
        int n5 = 0;
        for (int i = 0; i <= n5; ++i) {
            for (n2 = 0; n2 < extendedMolecule.getAllConnAtoms(nArray2[i]); ++n2) {
                int n6 = extendedMolecule.mConnAtom[nArray2[i]][n2];
                if (blArray[n6]) continue;
                nArray2[++n5] = n6;
                blArray[n6] = true;
                nArray[n6] = extendedMolecule.copyAtom(this, n6, n3, n4);
            }
        }
        for (n2 = 0; n2 < extendedMolecule.mAllBonds; ++n2) {
            if (!blArray[extendedMolecule.mBondAtom[0][n2]]) continue;
            extendedMolecule.copyBond(this, n2, n3, n4, nArray, false);
        }
        this.renumberESRGroups(1);
        this.renumberESRGroups(2);
        this.mValidHelperArrays = 0;
    }

    public int[] getFragmentAtoms(int n) {
        return this.getFragmentAtoms(n, false);
    }

    public int[] getFragmentAtoms(int n, boolean bl) {
        int n2;
        this.ensureHelperArrays(1);
        boolean[] blArray = new boolean[this.mAllAtoms];
        int[] nArray = new int[this.mAllAtoms];
        nArray[0] = n;
        blArray[n] = true;
        int n3 = 0;
        int n4 = 1;
        for (int i = 0; i <= n3; ++i) {
            int n5 = bl ? this.getAllConnAtomsPlusMetalBonds(nArray[i]) : this.mAllConnAtoms[nArray[i]];
            for (n2 = 0; n2 < n5; ++n2) {
                int n6 = this.mConnAtom[nArray[i]][n2];
                if (blArray[n6]) continue;
                nArray[++n3] = n6;
                blArray[n6] = true;
                ++n4;
            }
        }
        int[] nArray2 = new int[n4];
        n4 = 0;
        for (n2 = 0; n2 < this.mAllAtoms; ++n2) {
            if (!blArray[n2]) continue;
            nArray2[n4++] = n2;
        }
        return nArray2;
    }

    public int getFragmentNumbers(int[] nArray, boolean[] blArray, boolean bl) {
        int n;
        this.ensureHelperArrays(1);
        for (n = 0; n < this.mAllAtoms; ++n) {
            nArray[n] = -1;
        }
        n = 0;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (nArray[i] != -1) continue;
            nArray[i] = n;
            int[] nArray2 = new int[this.mAllAtoms];
            nArray2[0] = i;
            int n2 = 0;
            for (int j = 0; j <= n2; ++j) {
                int n3 = bl ? this.getAllConnAtomsPlusMetalBonds(nArray2[j]) : this.mAllConnAtoms[nArray2[j]];
                for (int k = 0; k < n3; ++k) {
                    int n4 = this.mConnAtom[nArray2[j]][k];
                    if (nArray[n4] != -1 || blArray[this.mConnBond[nArray2[j]][k]]) continue;
                    nArray2[++n2] = n4;
                    nArray[n4] = n;
                }
            }
            ++n;
        }
        return n;
    }

    public int getFragmentNumbers(int[] nArray, boolean bl, boolean bl2) {
        int n;
        this.ensureHelperArrays(1);
        for (n = 0; n < this.mAllAtoms; ++n) {
            nArray[n] = -1;
        }
        n = 0;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            if (nArray[i] != -1 || bl && !this.isMarkedAtom(i)) continue;
            nArray[i] = n;
            int[] nArray2 = new int[this.mAllAtoms];
            nArray2[0] = i;
            int n2 = 0;
            for (int j = 0; j <= n2; ++j) {
                int n3 = bl2 ? this.getAllConnAtomsPlusMetalBonds(nArray2[j]) : this.mAllConnAtoms[nArray2[j]];
                for (int k = 0; k < n3; ++k) {
                    int n4 = this.mConnAtom[nArray2[j]][k];
                    if (nArray[n4] != -1 || bl && !this.isMarkedAtom(n4)) continue;
                    nArray2[++n2] = n4;
                    nArray[n4] = n;
                }
            }
            ++n;
        }
        return n;
    }

    public int[] stripSmallFragments() {
        return this.stripSmallFragments(false);
    }

    public int[] stripSmallFragments(boolean bl) {
        int n;
        int n2;
        int[] nArray = new int[this.mAllAtoms];
        int n3 = this.getFragmentNumbers(nArray, false, bl);
        if (n3 <= 1) {
            return null;
        }
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < this.mAtoms; ++n2) {
            int n4 = nArray[n2];
            nArray2[n4] = nArray2[n4] + 1;
        }
        n2 = 0;
        int n5 = nArray2[0];
        for (n = 1; n < n3; ++n) {
            if (n5 >= nArray2[n]) continue;
            n5 = nArray2[n];
            n2 = n;
        }
        for (n = 0; n < this.mAllAtoms; ++n) {
            if (nArray[n] == n2) continue;
            this.mAtomicNo[n] = -1;
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            if ((bl || this.mBondType[n] != 32) && nArray[this.mBondAtom[0][n]] == n2) continue;
            this.mBondType[n] = 512;
        }
        int[] nArray3 = this.compressMolTable();
        this.mValidHelperArrays = 0;
        try {
            this.canonizeCharge(true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray3;
    }

    public void findRingSystem(int n, boolean bl, boolean[] blArray, boolean[] blArray2) {
        this.ensureHelperArrays(7);
        if (!this.isRingAtom(n) || bl && !this.isAromaticAtom(n)) {
            return;
        }
        int[] nArray = new int[this.mAtoms];
        nArray[0] = n;
        blArray[n] = true;
        int n2 = 0;
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j < this.mConnAtoms[nArray[i]]; ++j) {
                int n3 = this.mConnBond[nArray[i]][j];
                if (blArray2[n3] || !this.isRingBond(n3) || bl && !this.isAromaticBond(n3)) continue;
                blArray2[n3] = true;
                int n4 = this.mConnAtom[nArray[i]][j];
                if (blArray[n4]) continue;
                blArray[n4] = true;
                nArray[++n2] = n4;
            }
        }
    }

    public int getSubstituent(int n, int n2, boolean[] blArray, ExtendedMolecule extendedMolecule, int[] nArray) {
        this.ensureHelperArrays(1);
        if (extendedMolecule != null) {
            extendedMolecule.clear();
            extendedMolecule.mIsFragment = false;
        }
        int[] nArray2 = new int[this.mAllAtoms];
        if (blArray == null) {
            blArray = new boolean[this.mAllAtoms];
        } else {
            Arrays.fill(blArray, false);
        }
        nArray2[0] = n;
        nArray2[1] = n2;
        blArray[n] = true;
        blArray[n2] = true;
        int n3 = 1;
        for (int i = 1; i <= n3; ++i) {
            for (int j = 0; j < this.mAllConnAtoms[nArray2[i]]; ++j) {
                int n4 = this.mConnAtom[nArray2[i]][j];
                if (n4 == n && i != 1) {
                    return -1;
                }
                if (blArray[n4]) continue;
                blArray[n4] = true;
                nArray2[++n3] = n4;
            }
        }
        if (extendedMolecule != null) {
            if (nArray == null) {
                nArray = new int[blArray.length];
            }
            this.copyMoleculeByAtoms(extendedMolecule, blArray, false, nArray);
            extendedMolecule.changeAtom(nArray[n], 0, 0, -1, 0);
        }
        blArray[n] = false;
        return n3;
    }

    public int getSubstituentSize(int n, int n2) {
        this.ensureHelperArrays(1);
        int[] nArray = new int[this.mAtoms];
        boolean[] blArray = new boolean[this.mAtoms];
        nArray[0] = n;
        nArray[1] = n2;
        blArray[n] = true;
        blArray[n2] = true;
        int n3 = 1;
        for (int i = 1; i <= n3; ++i) {
            for (int j = 0; j < this.mConnAtoms[nArray[i]]; ++j) {
                int n4 = this.mConnAtom[nArray[i]][j];
                if (n4 == n && i != 1) {
                    return -1;
                }
                if (blArray[n4]) continue;
                blArray[n4] = true;
                nArray[++n3] = n4;
            }
        }
        return n3;
    }

    public boolean supportsImplicitHydrogen(int n) {
        if ((this.mAtomFlags[n] & 0x78000000) != 0) {
            return true;
        }
        if (this.mAtomicNo[n] == 1) {
            return false;
        }
        return this.isOrganicAtom(n) || this.mAtomicNo[n] == 13 || this.mAtomicNo[n] >= 171;
    }

    public int getImplicitHydrogens() {
        if (this.mIsFragment) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int n = 0;
        for (int i = 0; i < this.mAtoms; ++i) {
            n += this.getImplicitHydrogens(i);
        }
        return n;
    }

    public int getImplicitHydrogens(int n) {
        int n2;
        if (this.mIsFragment && (this.mAtomQueryFeatures[n] & 0x800L) == 0L) {
            return 0;
        }
        if (!this.supportsImplicitHydrogen(n)) {
            return 0;
        }
        this.ensureHelperArrays(1);
        int n3 = 0;
        for (n2 = 0; n2 < this.mAllConnAtoms[n]; ++n2) {
            n3 += this.mConnBondOrder[n][n2];
        }
        if (this.mIsFragment) {
            n2 = 1;
            for (int i = 0; i < this.mConnAtoms[n]; ++i) {
                if (this.mBondType[this.mConnBond[n][i]] != 64) continue;
                ++n2;
            }
            n3 += n2 >> 1;
        }
        n3 -= this.getElectronValenceCorrection(n, n3);
        n2 = this.getAtomAbnormalValence(n);
        if (n2 == -1) {
            byte[] byArray = Molecule.getAllowedValences(this.mAtomicNo[n]);
            n2 = byArray[0];
            for (int i = 1; n2 < n3 && i < byArray.length; ++i) {
                n2 = byArray[i];
            }
        }
        return Math.max(0, n2 - n3);
    }

    public int getExplicitHydrogens(int n) {
        return this.mAllConnAtoms[n] - this.mConnAtoms[n];
    }

    public int getMolweight() {
        this.ensureHelperArrays(1);
        int n = 0;
        for (int i = 0; i < this.mAllAtoms; ++i) {
            int n2;
            int n3 = this.mAtomMass[i] != 0 ? this.mAtomMass[i] : cRoundedMass[this.mAtomicNo[i]];
            n += n3 + this.getImplicitHydrogens(i) * cRoundedMass[1];
            if (this.mAtomicNo[i] < 171 || this.mAtomicNo[i] > 190 || (n2 = this.mAllConnAtoms[i]) <= 2) continue;
            n -= (n2 - 2) * cRoundedMass[1];
        }
        return n;
    }

    public int getRotatableBondCount() {
        int n = 0;
        this.ensureHelperArrays(7);
        for (int i = 0; i < this.mBonds; ++i) {
            if (this.getBondOrder(i) != 1 || this.isRingBond(i)) continue;
            boolean bl = true;
            block1: for (int j = 0; j < 2; ++j) {
                int n2 = this.mBondAtom[j][i];
                if (this.mConnAtoms[n2] == 1) {
                    bl = false;
                    break;
                }
                if (this.mAtomicNo[n2] != 7 || this.isAromaticAtom(n2)) continue;
                int n3 = this.mBondAtom[1 - j][i];
                for (int k = 0; k < this.mConnAtoms[n3]; ++k) {
                    int n4 = this.mConnAtom[n3][k];
                    int n5 = this.mConnBond[n3][k];
                    if (n5 == i || this.getBondOrder(n5) <= 1 || this.isAromaticAtom(n4) || !this.isElectronegative(n4)) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (!bl || this.isPseudoRotatableBond(i)) continue;
            ++n;
        }
        return n;
    }

    public boolean isPseudoRotatableBond(int n) {
        if (this.getBondOrder(n) != 1) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            int n2 = this.mBondAtom[i][n];
            int n3 = this.mBondAtom[1 - i][n];
            block1: while (this.mPi[n2] == 2 && this.mConnAtoms[n2] == 2 && this.mAtomicNo[n2] < 10) {
                for (int j = 0; j < 2; ++j) {
                    int n4 = this.mConnAtom[n2][j];
                    if (n4 == n3) continue;
                    if (this.mConnAtoms[n4] == 1) {
                        return true;
                    }
                    int n5 = this.mConnBond[n2][j];
                    if (this.getBondOrder(n5) == 1 && n5 < n) {
                        return true;
                    }
                    n3 = n2;
                    n2 = n4;
                    continue block1;
                }
            }
            if (this.mConnAtoms[n2] != 1) continue;
            return true;
        }
        return false;
    }

    public int getAromaticRingCount() {
        this.ensureHelperArrays(7);
        int n = 0;
        for (int i = 0; i < this.mRingSet.getSize(); ++i) {
            if (!this.mRingSet.isAromatic(i)) continue;
            ++n;
        }
        return n;
    }

    public int getAtomRingCount(int n, int n2) {
        this.ensureHelperArrays(7);
        boolean[] blArray = new boolean[this.mBonds];
        boolean[] blArray2 = new boolean[this.mBonds];
        int[] nArray = new int[this.mAtoms];
        int n3 = 0;
        for (int i = 1; i < this.mConnAtoms[n]; ++i) {
            int n4 = this.mConnBond[n][i];
            if (!this.isRingBond(n4)) continue;
            for (int j = 0; j < i; ++j) {
                int n5 = this.mConnBond[n][j];
                if (!this.isRingBond(n5)) continue;
                blArray2[n4] = true;
                blArray2[n5] = true;
                int n6 = this.getPath(nArray, this.mConnAtom[n][i], this.mConnAtom[n][j], n2 - 2, blArray2);
                blArray2[n4] = false;
                blArray2[n5] = false;
                if (n6 == -1) continue;
                boolean bl = false;
                int[] nArray2 = new int[n6];
                this.getPathBonds(nArray, nArray2, n6);
                for (int k = 0; k < n6; ++k) {
                    if (blArray[nArray2[k]]) continue;
                    blArray[nArray2[k]] = true;
                    bl = true;
                }
                if (!bl) continue;
                ++n3;
            }
        }
        return n3;
    }

    public RingCollection getRingSet() {
        this.ensureHelperArrays(7);
        return this.mRingSet;
    }

    public RingCollection getRingSetSimple() {
        this.ensureHelperArrays(3);
        return this.mRingSet;
    }

    public int getAtomPreferredStereoBond(int n) {
        this.ensureHelperArrays(7);
        if (this.mPi[n] == 2 && this.mConnAtoms[n] == 2) {
            return this.preferredAlleneStereoBond(n, false);
        }
        return this.preferredTHStereoBond(n, false);
    }

    public int getBondPreferredStereoBond(int n) {
        return this.preferredBinapStereoBond(n);
    }

    private int getStereoBondScore(int n, int n2) {
        if (this.getBondOrder(n) != 1) {
            return 0;
        }
        return 16 - this.mAllConnAtoms[n2] + ((this.mBondType[n] & 0x180) == 0 || this.mBondAtom[0][n] != n2 ? 32768 : 0) + (this.mAtomicNo[n2] == 1 ? 4096 : 0) + (this.mAllConnAtoms[n2] == 1 ? 2048 : 0) + (this.getAtomParity(n2) == 0 ? 1024 : 0) + (!this.isRingBond(n) ? 512 : 0) + (this.mAtomicNo[n2] != 6 ? 256 : 0);
    }

    public boolean isAllylicAtom(int n) {
        return (this.mAtomFlags[n] & 0x1000) != 0;
    }

    public boolean isAromaticAtom(int n) {
        return n < this.mAtoms ? this.mRingSet.isAromaticAtom(n) : false;
    }

    public boolean isHeteroAromaticAtom(int n) {
        return n < this.mAtoms ? this.mRingSet.isHeteroAromaticAtom(n) : false;
    }

    public boolean isDelocalizedAtom(int n) {
        return n < this.mAtoms ? this.mRingSet.isDelocalizedAtom(n) : false;
    }

    public boolean isAromaticBond(int n) {
        return n < this.mBonds ? this.mRingSet.isAromaticBond(n) : false;
    }

    public boolean isHeteroAromaticBond(int n) {
        return n < this.mBonds ? this.mRingSet.isHeteroAromaticBond(n) : false;
    }

    @Override
    public boolean isDelocalizedBond(int n) {
        return n < this.mBonds ? this.mRingSet.isDelocalizedBond(n) || this.mBondType[n] == 64 : false;
    }

    public boolean isRingAtom(int n) {
        return (this.mAtomFlags[n] & 0xC00) != 0;
    }

    public boolean isRingBond(int n) {
        return (this.mBondFlags[n] & 0x40) != 0;
    }

    public boolean isSmallRingAtom(int n) {
        return (this.mAtomFlags[n] & 8) != 0;
    }

    public boolean isSmallRingBond(int n) {
        return (this.mBondFlags[n] & 0x80) != 0;
    }

    public boolean isStabilizedAtom(int n) {
        return (this.mAtomFlags[n] & 0x2000) != 0;
    }

    public int getAtomRingBondCount(int n) {
        int n2 = this.mAtomFlags[n] & 0xC00;
        return n2 == 0 ? 0 : (n2 == 1024 ? 2 : (n2 == 2048 ? 3 : 4));
    }

    public String getChiralText() {
        return null;
    }

    public int getStereoBond(int n) {
        this.ensureHelperArrays(1);
        if (this.mConnAtoms[n] == 2 && this.mConnBondOrder[n][0] == 2 && this.mConnBondOrder[n][1] == 2) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.mAllConnAtoms[this.mConnAtom[n][i]]; ++j) {
                    if (!this.isStereoBond(this.mConnBond[this.mConnAtom[n][i]][j], this.mConnAtom[n][i])) continue;
                    return this.mConnBond[this.mConnAtom[n][i]][j];
                }
            }
        } else {
            for (int i = 0; i < this.mAllConnAtoms[n]; ++i) {
                if (!this.isStereoBond(this.mConnBond[n][i], n)) continue;
                return this.mConnBond[n][i];
            }
        }
        return -1;
    }

    public void setParitiesValid(int n) {
        this.mValidHelperArrays |= 0xF8 & (8 | n);
    }

    public void setStereoBondsFromParity() {
        int n;
        assert ((this.mValidHelperArrays & 8) != 0);
        this.ensureHelperArrays(7);
        for (n = 0; n < this.mBonds; ++n) {
            if (!this.isStereoBond(n)) continue;
            this.mBondType[n] = 1;
        }
        for (n = 0; n < this.mAtoms; ++n) {
            this.setStereoBondFromAtomParity(n);
        }
        for (n = 0; n < this.mBonds; ++n) {
            this.setStereoBondFromBondParity(n);
        }
        for (n = 0; n < this.mBonds; ++n) {
            if (this.mBondType[n] != 2 || this.getBondParity(n) != 3) continue;
            this.mBondType[n] = 386;
        }
        assert ((this.mValidHelperArrays & 8) != 0);
    }

    public void convertStereoBondsToSingleBonds(int n) {
        if (this.mPi[n] == 2 && this.mConnAtoms[n] == 2 && this.mConnBondOrder[n][0] == 2) {
            for (int i = 0; i < 2; ++i) {
                int n2 = this.findAlleneEndAtom(n, this.mConnAtom[n][i]);
                if (n2 == -1) continue;
                for (int j = 0; j < this.mConnAtoms[n2]; ++j) {
                    int n3 = this.mConnBond[n2][j];
                    if (!this.isStereoBond(n3) || this.mBondAtom[0][n3] != n2) continue;
                    this.mBondType[this.mConnBond[n2][j]] = 1;
                }
            }
            return;
        }
        if (this.mPi[n] == 0 || this.mAtomicNo[n] >= 15) {
            for (int i = 0; i < this.mAllConnAtoms[n]; ++i) {
                int n4 = this.mConnBond[n][i];
                if (!this.isStereoBond(n4, n) || this.mBondAtom[0][n4] != n) continue;
                this.mBondType[n4] = 1;
            }
        }
    }

    public void setStereoBondFromAtomParity(int n) {
        int n2;
        int n3;
        this.convertStereoBondsToSingleBonds(n);
        if (this.getAtomParity(n) == 0 || this.getAtomParity(n) == 3) {
            return;
        }
        if (this.mPi[n] == 2 && this.mConnAtoms[n] == 2) {
            this.setAlleneStereoBondFromParity(n);
            return;
        }
        if (this.mConnAtoms[n] < 3 || this.mConnAtoms[n] > 4) {
            this.setAtomParity(n, 0, false);
            return;
        }
        int n4 = this.mAllConnAtoms[n];
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            if (this.getBondOrder(this.mConnBond[n][i]) != 1) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        int[] nArray = this.getSortedConnMap(n);
        double[] dArray = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = this.getBondAngle(this.mConnAtom[n][nArray[n3]], n);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.mBondAtom[0][this.mConnBond[n][n3]] != n || this.getBondOrder(this.mConnBond[n][n3]) != 1) continue;
            this.mBondType[this.mConnBond[n][n3]] = 1;
        }
        if ((float)this.getAtomRingSize(n) <= 24.0f && this.setFisherProjectionStereoBondsFromParity(n, nArray, dArray)) {
            return;
        }
        n3 = this.preferredTHStereoBond(n, true);
        if (this.mBondAtom[0][n3] != n) {
            this.mBondAtom[1][n3] = this.mBondAtom[0][n3];
            this.mBondAtom[0][n3] = n;
        }
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (n3 != this.mConnBond[n][nArray[i]]) continue;
            n5 = i;
            break;
        }
        int[][] nArrayArray = new int[][]{{2, 1, 2, 1}, {1, 2, 2, 1}, {1, 1, 2, 2}, {2, 1, 1, 2}, {2, 2, 1, 1}, {1, 2, 1, 2}};
        for (n2 = 1; n2 < n4; ++n2) {
            if (!(dArray[n2] < dArray[0])) continue;
            int n6 = n2;
            dArray[n6] = dArray[n6] + Math.PI * 2;
        }
        if (n4 == 3) {
            boolean bl2 = false;
            switch (n5) {
                case 0: {
                    bl2 = dArray[1] < dArray[2] && dArray[2] - dArray[1] < Math.PI || dArray[1] > dArray[2] && dArray[1] - dArray[2] > Math.PI;
                    break;
                }
                case 1: {
                    bl2 = dArray[2] - dArray[0] > Math.PI;
                    break;
                }
                case 2: {
                    bl2 = dArray[1] - dArray[0] < Math.PI;
                }
            }
            n2 = this.getAtomParity(n) == 1 ^ bl2 ? 257 : 129;
        } else {
            int n7 = 0;
            if (dArray[1] <= dArray[2] && dArray[2] <= dArray[3]) {
                n7 = 0;
            } else if (dArray[1] <= dArray[3] && dArray[3] <= dArray[2]) {
                n7 = 1;
            } else if (dArray[2] <= dArray[1] && dArray[1] <= dArray[3]) {
                n7 = 2;
            } else if (dArray[2] <= dArray[3] && dArray[3] <= dArray[1]) {
                n7 = 3;
            } else if (dArray[3] <= dArray[1] && dArray[1] <= dArray[2]) {
                n7 = 4;
            } else if (dArray[3] <= dArray[2] && dArray[2] <= dArray[1]) {
                n7 = 5;
            }
            n2 = this.getAtomParity(n) == 1 ^ nArrayArray[n7][n5] == 1 ? 129 : 257;
        }
        this.mBondType[n3] = n2;
    }

    private boolean setFisherProjectionStereoBondsFromParity(int n, int[] nArray, double[] dArray) {
        int n2 = this.mAllConnAtoms[n];
        int[] nArray2 = new int[n2];
        int n3 = this.getFisherProjectionParity(n, nArray, dArray, nArray2);
        if (n3 == 3) {
            return false;
        }
        int n4 = this.getAtomParity(n) == n3 ? 257 : 129;
        for (int i = 0; i < n2; ++i) {
            if ((nArray2[i] & 1) != 1) continue;
            int n5 = this.mConnBond[n][nArray[i]];
            this.mBondType[n5] = n4;
            if (this.mBondAtom[0][n5] == n) continue;
            this.mBondAtom[1][n5] = this.mBondAtom[0][n5];
            this.mBondAtom[0][n5] = n;
        }
        return true;
    }

    public int getFisherProjectionParity(int n, int[] nArray, double[] dArray, int[] nArray2) {
        int n2;
        int n3;
        if ((float)this.getAtomRingSize(n) > 24.0f) {
            return 3;
        }
        int n4 = this.mAllConnAtoms[n];
        if (nArray2 == null) {
            nArray2 = new int[n4];
        }
        if (!this.getFisherProjectionBondDirections(n, nArray, dArray, nArray2)) {
            return 3;
        }
        int n5 = -1;
        for (n3 = 0; n3 < n4; ++n3) {
            if ((nArray2[n3] & 1) != 1) continue;
            n2 = this.mBondType[this.mConnBond[n][nArray[n3]]];
            if (n5 != -1 && n5 != n2) {
                return 3;
            }
            n5 = n2;
        }
        n3 = Math.abs(nArray2[0] - nArray2[1]) == 2 ? 1 : 0;
        n2 = nArray2[n3] - nArray2[n3 + 1];
        boolean bl = Math.abs(n2) == 3 ^ nArray2[n3] < nArray2[n3 + 1];
        boolean bl2 = n4 == 3 || (nArray2[3] & 1) == 1;
        return bl ^ bl2 ^ n5 == 129 ? 1 : 2;
    }

    private boolean getFisherProjectionBondDirections(int n, int[] nArray, double[] dArray, int[] nArray2) {
        int n2 = this.mAllConnAtoms[n];
        if (this.mPi[n] != 0 || this.isAromaticAtom(n) || this.mConnAtoms[n] < 3 || n2 > 4) {
            return false;
        }
        boolean[] blArray = new boolean[4];
        for (int i = 0; i < n2; ++i) {
            double d = 3.9269908169872414 - dArray[i];
            if (Math.abs(0.7853981633974483 - d % 1.5707963267948966) > 0.0872664675116539) {
                return false;
            }
            nArray2[i] = 3 & (int)(d / 1.5707963267948966);
            if (blArray[nArray2[i]]) {
                return false;
            }
            blArray[nArray2[i]] = true;
            if (!((nArray2[i] & 1) == 0 ? this.mBondType[this.mConnBond[n][nArray[i]]] != 1 : !this.isStereoBond(this.mConnBond[n][nArray[i]], n))) continue;
            return false;
        }
        return blArray[0] && blArray[2];
    }

    private void setAlleneStereoBondFromParity(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mConnAtoms[n] != 2 || this.mConnBondOrder[n][0] != 2 || this.mConnBondOrder[n][1] != 2 || this.mConnAtoms[this.mConnAtom[n][0]] < 2 || this.mConnAtoms[this.mConnAtom[n][1]] < 2 || this.mPi[this.mConnAtom[n][0]] != 1 || this.mPi[this.mConnAtom[n][1]] != 1) {
            this.setAtomParity(n, 0, false);
            return;
        }
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        for (n6 = 0; n6 < 2; ++n6) {
            n5 = this.mConnAtom[n][n6];
            for (n4 = 0; n4 < this.mAllConnAtoms[n5]; ++n4) {
                int n12;
                n3 = this.mConnAtom[n5][n4];
                if (n3 == n || n11 >= (n12 = this.getStereoBondScore(n2 = this.mConnBond[n5][n4], n3))) continue;
                n11 = n12;
                n8 = n3;
                n7 = n2;
                n9 = n5;
                n10 = this.mConnAtom[n][1 - n6];
            }
        }
        if (n8 == -1) {
            return;
        }
        for (n6 = 0; n6 < 2; ++n6) {
            n5 = this.mConnAtom[n][n6];
            for (n4 = 0; n4 < this.mAllConnAtoms[n5]; ++n4) {
                n3 = this.mConnAtom[n5][n4];
                n2 = this.mConnBond[n5][n4];
                if (n3 == n || this.mBondAtom[0][n2] != n5) continue;
                this.mBondType[n2] = 1;
            }
        }
        if (this.mBondAtom[1][n7] != n8) {
            this.mBondAtom[0][n7] = this.mBondAtom[1][n7];
            this.mBondAtom[1][n7] = n8;
        }
        n6 = Integer.MAX_VALUE;
        for (n5 = 0; n5 < this.mConnAtoms[n9]; ++n5) {
            n4 = this.mConnAtom[n9][n5];
            if (n4 == n || n6 <= n4) continue;
            n6 = n4;
        }
        int[] nArray = new int[2];
        n4 = 0;
        for (n3 = 0; n3 < this.mConnAtoms[n10]; ++n3) {
            n2 = this.mConnAtom[n10][n3];
            if (n2 == n) continue;
            nArray[n4++] = n2;
        }
        double d = this.getBondAngle(n, n10);
        double d2 = 0.0;
        if (n4 == 2) {
            if (nArray[0] > nArray[1]) {
                int n13 = nArray[0];
                nArray[0] = nArray[1];
                nArray[1] = n13;
            }
            double d3 = ExtendedMolecule.getAngleDif(d, this.getBondAngle(n10, nArray[0]));
            double d4 = ExtendedMolecule.getAngleDif(d, this.getBondAngle(n10, nArray[1]));
            d2 = d3 - d4;
        } else {
            d2 = ExtendedMolecule.getAngleDif(d, this.getBondAngle(n10, nArray[0]));
        }
        this.mBondType[n7] = d2 < 0.0 ^ this.getAtomParity(n) == 1 ^ n6 == n8 ? 257 : 129;
    }

    public void setStereoBondFromBondParity(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.getBondParity(n) == 0 || this.getBondParity(n) == 3 || !this.isBINAPChiralityBond(n)) {
            return;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = 0;
        for (n5 = 0; n5 < 2; ++n5) {
            n4 = this.mBondAtom[n5][n];
            for (n3 = 0; n3 < this.mAllConnAtoms[n4]; ++n3) {
                int n11;
                int n12;
                n2 = this.mConnBond[n4][n3];
                if (n2 == n || this.getBondOrder(n2) != 1 || n10 >= (n12 = this.getStereoBondScore(n2, n11 = this.mConnAtom[n4][n3]))) continue;
                n10 = n12;
                n7 = n11;
                n6 = n2;
                n8 = n4;
                n9 = this.mBondAtom[1 - n5][n];
            }
        }
        if (n7 == -1) {
            return;
        }
        for (n5 = 0; n5 < 2; ++n5) {
            for (n4 = 0; n4 < this.mAllConnAtoms[this.mBondAtom[n5][n]]; ++n4) {
                n3 = this.mConnBond[this.mBondAtom[n5][n]][n4];
                if (n3 == n || this.getBondOrder(n3) != 1) continue;
                this.mBondType[n3] = 1;
            }
        }
        if (this.mBondAtom[1][n6] != n7) {
            this.mBondAtom[0][n6] = this.mBondAtom[1][n6];
            this.mBondAtom[1][n6] = n7;
        }
        n5 = Integer.MAX_VALUE;
        for (n4 = 0; n4 < this.mConnAtoms[n8]; ++n4) {
            n3 = this.mConnAtom[n8][n4];
            if (this.mConnBond[n8][n4] == n || n5 <= n3) continue;
            n5 = n3;
        }
        int[] nArray = new int[2];
        n3 = 0;
        for (n2 = 0; n2 < this.mConnAtoms[n9]; ++n2) {
            if (this.mConnBond[n9][n2] == n) continue;
            nArray[n3++] = this.mConnAtom[n9][n2];
        }
        double d = this.getBondAngle(n8, n9);
        double d2 = 0.0;
        if (n3 == 2) {
            if (nArray[0] > nArray[1]) {
                int n13 = nArray[0];
                nArray[0] = nArray[1];
                nArray[1] = n13;
            }
            double d3 = ExtendedMolecule.getAngleDif(d, this.getBondAngle(n9, nArray[0]));
            double d4 = ExtendedMolecule.getAngleDif(d, this.getBondAngle(n9, nArray[1]));
            d2 = d3 - d4;
        } else {
            d2 = ExtendedMolecule.getAngleDif(d, this.getBondAngle(n9, nArray[0]));
        }
        this.mBondType[n6] = d2 < 0.0 ^ this.getBondParity(n) == 2 ^ n5 == n7 ? 257 : 129;
    }

    protected boolean bondsAreParallel(double d, double d2) {
        double d3 = Math.abs(ExtendedMolecule.getAngleDif(d, d2));
        return d3 < 0.08 || d3 > 3.061592653589793;
    }

    private int preferredTHStereoBond(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5 = this.mAllConnAtoms[n];
        double[] dArray = new double[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray[n4] = this.getBondAngle(n, this.mConnAtom[n][n4]);
        }
        for (n4 = 1; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n4; ++n3) {
                int n6;
                if (!this.bondsAreParallel(dArray[n4], dArray[n3])) continue;
                float f = 0.0f;
                float f2 = 0.0f;
                for (n6 = 0; n6 < n5; ++n6) {
                    if (n6 == n4 || n6 == n3) continue;
                    f = (float)((double)f + Math.abs(Angle.difference(dArray[n4], dArray[n6])));
                    f2 = (float)((double)f2 + Math.abs(Angle.difference(dArray[n3], dArray[n6])));
                }
                int n7 = n6 = f < f2 ? this.mConnBond[n][n4] : this.mConnBond[n][n3];
                if (this.getBondOrder(n6) != 1 || bl && this.isStereoBond(n6)) continue;
                return n6;
            }
        }
        boolean[] blArray = new boolean[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            double d = -10.0;
            double d2 = 10.0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (n2 != n3) {
                    double d3 = Angle.difference(dArray[n3], dArray[n2]);
                    if (d3 < 0.0) {
                        if (d < d3) {
                            d = d3;
                        }
                    } else if (d2 > d3) {
                        d2 = d3;
                    }
                }
                blArray[n3] = d2 - d < Math.PI;
            }
        }
        n3 = -1;
        int n8 = 0;
        for (int i = 0; i < n5; ++i) {
            int n9 = this.mConnAtom[n][i];
            int n10 = this.mConnBond[n][i];
            n2 = this.getStereoBondScore(n10, n9);
            if (blArray[i]) {
                n2 += 16384;
            }
            if (n8 >= n2 || bl && this.isStereoBond(n10)) continue;
            n8 = n2;
            n3 = n10;
        }
        return n3;
    }

    private int preferredAlleneStereoBond(int n, boolean bl) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < 2; ++i) {
            int n4 = this.mConnAtom[n][i];
            for (int j = 0; j < this.mAllConnAtoms[n4]; ++j) {
                int n5;
                int n6;
                int n7 = this.mConnAtom[n4][j];
                if (n7 == n || n3 >= (n6 = this.getStereoBondScore(n5 = this.mConnBond[n4][j], n7)) || bl && this.isStereoBond(n5)) continue;
                n3 = n6;
                n2 = n5;
            }
        }
        return n2;
    }

    private int preferredBinapStereoBond(int n) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < 2; ++i) {
            int n4 = this.mBondAtom[i][n];
            for (int j = 0; j < this.mAllConnAtoms[n4]; ++j) {
                int n5;
                int n6;
                int n7 = this.mConnAtom[n4][j];
                if (n7 == this.mBondAtom[1 - i][n] || n3 >= (n6 = this.getStereoBondScore(n5 = this.mConnBond[n4][j], n7))) continue;
                n3 = n6;
                n2 = n5;
            }
        }
        return n2;
    }

    public int findAlleneCenterAtom(int n) {
        int n2 = -1;
        if (this.mPi[n] == 1) {
            block0: for (int i = 0; i < this.mConnAtoms[n]; ++i) {
                if (this.mConnBondOrder[n][i] != 2) continue;
                int n3 = this.mConnAtom[n][i];
                if (this.mConnAtoms[n3] != 2 || this.mPi[n3] != 2) break;
                for (int j = 0; j < 2; ++j) {
                    int n4 = this.mConnAtom[n3][j];
                    if (n4 == n || this.mPi[n4] != 1) continue;
                    n2 = n3;
                    break block0;
                }
                break;
            }
        }
        return n2;
    }

    public int findAlleneEndAtom(int n, int n2) {
        int n3 = n;
        while (this.mConnAtoms[n2] == 2 && this.mPi[n2] == 2 && n2 != n3) {
            int n4 = n2;
            n2 = this.mConnAtom[n2][0] == n ? this.mConnAtom[n2][1] : this.mConnAtom[n2][0];
            n = n4;
        }
        return n2 == n3 ? -1 : n2;
    }

    public int findBINAPChiralityBond(int n) {
        if (this.mConnAtoms[n] == 3 && this.isAromaticAtom(n) && this.getAtomRingSize(n) >= 5) {
            for (int i = 0; i < this.mConnAtoms[n]; ++i) {
                if (!this.isBINAPChiralityBond(this.mConnBond[n][i])) continue;
                return this.mConnBond[n][i];
            }
        }
        return -1;
    }

    public boolean isAmideTypeBond(int n) {
        this.ensureHelperArrays(1);
        for (int i = 0; i < 2; ++i) {
            int n2 = this.mBondAtom[i][n];
            if (this.mAtomicNo[n2] != 7) continue;
            int n3 = this.mBondAtom[1 - i][n];
            for (int j = 0; j < this.mConnAtoms[n3]; ++j) {
                int n4 = this.mConnAtom[n3][j];
                int n5 = this.mConnBond[n3][j];
                if (this.mAtomicNo[n4] != 7 && this.mAtomicNo[n4] != 8 && this.mAtomicNo[n4] != 16 || this.getBondOrder(n5) < 2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCentralAlleneAtom(int n) {
        return this.mPi[n] == 2 && this.mConnAtoms[n] == 2 && this.mConnBondOrder[n][0] == 2 && this.mConnBondOrder[n][1] == 2 && this.mAtomicNo[n] <= 7;
    }

    public boolean isFlatNitrogen(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mAtomicNo[n] != 7) {
            return false;
        }
        if (this.isAromaticAtom(n) || this.mPi[n] != 0 || (this.mAtomQueryFeatures[n] & 0x10000000L) != 0L) {
            return true;
        }
        if (this.mAtomCharge[n] == 1) {
            return false;
        }
        int n7 = 0;
        for (n6 = 0; n6 < this.mConnAtoms[n]; ++n6) {
            if (this.mConnBondOrder[n][n6] != 1 || (n5 = this.mAtomicNo[this.mConnAtom[n][n6]]) != 8 && n5 != 9 && n5 != 17) continue;
            ++n7;
        }
        if (n7 == 0) {
            for (n6 = 0; n6 < this.mConnAtoms[n]; ++n6) {
                n5 = this.mConnAtom[n][n6];
                if (this.mPi[n5] == 0) continue;
                if (this.isAromaticAtom(n5)) {
                    if (this.getAtomRingSize(n5) >= 5) {
                        n4 = 0;
                        for (n3 = 0; n3 < this.mConnAtoms[n5]; ++n3) {
                            n2 = this.mConnAtom[n5][n3];
                            if (n2 == n || this.getNonHydrogenNeighbourCount(n2) < 3) continue;
                            ++n4;
                        }
                        n3 = this.getNonHydrogenNeighbourCount(n);
                        if (n4 == 2 && n3 >= 2 || n4 == 1 && n3 == 3) continue;
                    }
                    return true;
                }
                for (n4 = 0; n4 < this.mConnAtoms[n5]; ++n4) {
                    if (this.mConnBondOrder[n5][n4] != 2 && !this.isAromaticBond(this.mConnBond[n5][n4])) continue;
                    return true;
                }
            }
        }
        if (n7 < 2) {
            for (n6 = 0; n6 < this.mConnAtoms[n]; ++n6) {
                n5 = this.mConnAtom[n][n6];
                n4 = 0;
                n3 = 0;
                for (n2 = 0; n2 < this.mConnAtoms[n5]; ++n2) {
                    if (this.mConnAtom[n5][n2] == n) continue;
                    if (this.mConnBondOrder[n5][n2] != 1 && (this.mAtomicNo[this.mConnAtom[n5][n2]] == 7 || this.mAtomicNo[this.mConnAtom[n5][n2]] == 8 || this.mAtomicNo[this.mConnAtom[n5][n2]] == 16)) {
                        n4 = 1;
                    }
                    if (this.mConnBondOrder[n5][n2] != 1 || this.mAtomicNo[this.mConnAtom[n5][n2]] != 7) continue;
                    n3 = 1;
                }
                if (n4 == 0 || n3 != 0 && n7 != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBINAPChiralityBond(int n) {
        if (this.mBondType[n] != 1 || this.isAromaticBond(n) || this.isRingBond(n) && this.getBondRingSize(n) < 7) {
            return false;
        }
        int n2 = this.mBondAtom[0][n];
        if (!this.isAromaticAtom(n2) || this.getAtomRingSize(n2) < 5) {
            return false;
        }
        int n3 = this.mBondAtom[1][n];
        if (!this.isAromaticAtom(n3) || this.getAtomRingSize(n3) < 5) {
            return false;
        }
        int n4 = this.getOrthoSubstituentCount(n2, n3);
        int n5 = this.getOrthoSubstituentCount(n3, n2);
        if (this.getAtomRingSize(n2) > 5 && this.getAtomRingSize(n3) > 5) {
            return n4 + n5 > 2;
        }
        int n6 = this.getSecondOrderOrthoSubstituentCount(n2, n3);
        int n7 = this.getSecondOrderOrthoSubstituentCount(n3, n2);
        if (n4 == 2 && n7 >= 1) {
            return true;
        }
        if (n5 == 2 && n6 >= 1) {
            return true;
        }
        if (n6 == 2 && (n5 >= 1 || n7 >= 1)) {
            return true;
        }
        return n7 == 2 && (n4 >= 1 || n6 >= 1);
    }

    private int getOrthoSubstituentCount(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            int n4 = this.mConnAtom[n][i];
            if (n4 == n2 || this.mConnAtoms[n4] <= 2) continue;
            ++n3;
        }
        return n3;
    }

    private int getSecondOrderOrthoSubstituentCount(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            int n4 = this.mConnAtom[n][i];
            if (n4 == n2) continue;
            int n5 = 0;
            for (int j = 0; j < this.mConnAtoms[n4]; ++j) {
                int n6 = this.mConnAtom[n4][j];
                if (n6 == n || !this.isAromaticBond(this.mConnBond[n4][j]) || this.mConnAtoms[n6] <= 2) continue;
                ++n5;
            }
            if (n5 != 2) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    protected boolean validateBondType(int n, int n2) {
        boolean bl = super.validateBondType(n, n2);
        if (bl && n2 == 386) {
            this.ensureHelperArrays(7);
            bl &= !this.isSmallRingBond(n);
        }
        return bl;
    }

    public void validate() throws Exception {
        int n;
        int n2;
        double d = this.getAverageBondLength();
        double d2 = d * d / 16.0;
        for (n2 = 1; n2 < this.mAllAtoms; ++n2) {
            for (n = 0; n < n2; ++n) {
                double d3 = this.mCoordinates[n].x - this.mCoordinates[n2].x;
                double d4 = this.mCoordinates[n].y - this.mCoordinates[n2].y;
                double d5 = this.mCoordinates[n].z - this.mCoordinates[n2].z;
                if (!(d3 * d3 + d4 * d4 + d5 * d5 < d2)) continue;
                throw new Exception("The distance between two atoms is too close.");
            }
        }
        this.ensureHelperArrays(1);
        n2 = 0;
        for (n = 0; n < this.mAtoms; ++n) {
            if (this.getOccupiedValence(n) > this.getMaxValence(n)) {
                throw new Exception("atom valence exceeded");
            }
            n2 += this.mAtomCharge[n];
        }
        if (n2 != 0) {
            throw new Exception("unbalanced atom charge");
        }
    }

    public boolean normalizeAmbiguousBonds() {
        int n;
        int n2;
        int n3;
        int n4;
        this.ensureHelperArrays(1);
        this.normalizeExplicitlyDelocalizedBonds();
        boolean bl = false;
        block0: for (n4 = 0; n4 < this.mAtoms; ++n4) {
            if (this.mAtomicNo[n4] != 7 || this.mAtomCharge[n4] != 0) continue;
            n3 = this.getOccupiedValence(n4);
            if (n3 == 4) {
                for (n2 = 0; n2 < this.mConnAtoms[n4]; ++n2) {
                    n = this.mConnAtom[n4][n2];
                    if (this.mConnBondOrder[n4][n2] != 1 || this.mAtomicNo[n] != 8 || this.mConnAtoms[n] != 1 || this.mAtomCharge[n] != 0) continue;
                    bl = true;
                    int n5 = n4;
                    this.mAtomCharge[n5] = this.mAtomCharge[n5] + 1;
                    int n6 = n;
                    this.mAtomCharge[n6] = this.mAtomCharge[n6] - 1;
                    continue block0;
                }
                continue;
            }
            if (n3 != 5) continue;
            for (n2 = 0; n2 < this.mConnAtoms[n4]; ++n2) {
                n = this.mConnAtom[n4][n2];
                int n7 = this.mConnBond[n4][n2];
                if (this.mConnBondOrder[n4][n2] == 2 && this.mAtomicNo[n] == 8) {
                    bl = true;
                    int n8 = n4;
                    this.mAtomCharge[n8] = this.mAtomCharge[n8] + 1;
                    int n9 = n;
                    this.mAtomCharge[n9] = this.mAtomCharge[n9] - 1;
                    this.mBondType[n7] = 1;
                    continue block0;
                }
                if (this.mConnBondOrder[n4][n2] != 3 || this.mAtomicNo[n] != 7) continue;
                bl = true;
                int n10 = n4;
                this.mAtomCharge[n10] = this.mAtomCharge[n10] + 1;
                int n11 = n;
                this.mAtomCharge[n11] = this.mAtomCharge[n11] - 1;
                this.mBondType[n7] = 2;
                continue block0;
            }
        }
        n4 = 0;
        block3: for (n3 = 0; n3 < this.mBonds; ++n3) {
            for (n2 = 0; n2 < 2; ++n2) {
                if (!this.isElectronegative(this.mBondAtom[n2][n3])) continue;
                n = this.mBondAtom[1 - n2][n3];
                if (!this.isAlkaliMetal(n) && !this.isEarthAlkaliMetal(n)) continue block3;
                if (this.getBondOrder(n3) == 1) {
                    int n12 = n;
                    this.mAtomCharge[n12] = this.mAtomCharge[n12] + 1;
                    int n13 = this.mBondAtom[n2][n3];
                    this.mAtomCharge[n13] = this.mAtomCharge[n13] - 1;
                    this.mBondType[n3] = 512;
                    n4 = 1;
                    continue block3;
                }
                if (this.mBondType[n3] != 32) continue block3;
                this.mBondType[n3] = 512;
                n4 = 1;
                continue block3;
            }
        }
        if (n4 != 0) {
            this.compressMolTable();
            bl = true;
        }
        if (bl) {
            this.mValidHelperArrays = 0;
        }
        return bl;
    }

    private boolean normalizeExplicitlyDelocalizedBonds() {
        for (int i = 0; i < this.mBonds; ++i) {
            if (this.mBondType[i] != 64) continue;
            return new AromaticityResolver(this).locateDelocalizedDoubleBonds(null);
        }
        return false;
    }

    public boolean isAlkaliMetal(int n) {
        int n2 = this.mAtomicNo[n];
        return n2 == 3 || n2 == 11 || n2 == 19 || n2 == 37 || n2 == 55;
    }

    public boolean isEarthAlkaliMetal(int n) {
        int n2 = this.mAtomicNo[n];
        return n2 == 12 || n2 == 20 || n2 == 38 || n2 == 56;
    }

    public boolean isNitrogenFamily(int n) {
        int n2 = this.mAtomicNo[n];
        return n2 == 7 || n2 == 15 || n2 == 33;
    }

    public boolean isChalcogene(int n) {
        int n2 = this.mAtomicNo[n];
        return n2 == 8 || n2 == 16 || n2 == 34 || n2 == 52;
    }

    public boolean isHalogene(int n) {
        int n2 = this.mAtomicNo[n];
        return n2 == 9 || n2 == 17 || n2 == 35 || n2 == 53;
    }

    public int canonizeCharge(boolean bl) throws Exception {
        return this.canonizeCharge(bl, false);
    }

    public int canonizeCharge(boolean bl, boolean bl2) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.ensureHelperArrays(1);
        if (bl2) {
            bl = true;
        }
        for (n8 = 0; n8 < this.mAllBonds; ++n8) {
            n7 = this.getBondOrder(n8);
            if (n7 != 1 && n7 != 2) continue;
            if (this.mAtomCharge[this.mBondAtom[0][n8]] > 0 && this.mAtomCharge[this.mBondAtom[1][n8]] < 0) {
                n6 = this.mBondAtom[0][n8];
                n5 = this.mBondAtom[1][n8];
            } else {
                if (this.mAtomCharge[this.mBondAtom[0][n8]] >= 0 || this.mAtomCharge[this.mBondAtom[1][n8]] <= 0) continue;
                n6 = this.mBondAtom[1][n8];
                n5 = this.mBondAtom[0][n8];
            }
            if (this.isMetalAtom(n6) || this.isMetalAtom(n5) || this.mAtomicNo[n6] < 9 && this.getOccupiedValence(n6) > 3 || this.mAtomicNo[n5] < 9 && this.getOccupiedValence(n5) > 3) continue;
            n4 = this.getImplicitHydrogens(n6) != 0 ? 1 : 0;
            int n9 = n6;
            this.mAtomCharge[n9] = this.mAtomCharge[n9] - 1;
            int n10 = n5;
            this.mAtomCharge[n10] = this.mAtomCharge[n10] + 1;
            if (n4 == 0) {
                n3 = this.mBondType[n8];
                this.mBondType[n8] = n7 == 1 ? 2 : 4;
                if ((n3 == 129 || n3 == 257) && this.mBondAtom[0][n2 = this.preferredTHStereoBond(n = this.mBondAtom[0][n8], false)] != n) {
                    this.mBondAtom[1][n2] = this.mBondAtom[0][n2];
                    this.mBondAtom[1][n2] = n;
                }
            }
            this.mValidHelperArrays = 0;
        }
        n8 = 0;
        n7 = 0;
        n6 = 0;
        for (n5 = 0; n5 < this.mAllAtoms; ++n5) {
            n8 += this.mAtomCharge[n5];
            if (this.mAtomCharge[n5] >= 0 || this.hasPositiveNeighbour(n5)) continue;
            ++n7;
            if (!this.isElectronegative(n5)) continue;
            n6 -= this.mAtomCharge[n5];
        }
        if (!bl && n8 != 0) {
            throw new Exception("molecule's overall charges are not balanced");
        }
        this.ensureHelperArrays(1);
        n5 = 0;
        n4 = bl2 ? n8 + n6 : n6;
        for (n3 = 0; n3 < this.mAllAtoms; ++n3) {
            if (this.mAtomCharge[n3] <= 0 || this.hasNegativeNeighbour(n3) || !this.isElectronegative(n3) || (n = Math.min(this.getImplicitHydrogens(n3), this.mAtomCharge[n3])) == 0 || n4 < n) continue;
            n8 -= n;
            n5 -= n;
            n4 -= n;
            int n11 = n3;
            this.mAtomCharge[n11] = this.mAtomCharge[n11] - n;
            this.mValidHelperArrays &= 1;
        }
        int n12 = n3 = bl2 ? n8 : n5;
        if (n3 < 0) {
            int[] nArray = new int[n7];
            n7 = 0;
            for (n2 = 0; n2 < this.mAllAtoms; ++n2) {
                if (this.mAtomCharge[n2] >= 0 || this.hasPositiveNeighbour(n2)) continue;
                nArray[n7++] = (this.mAtomicNo[n2] << 22) + n2;
            }
            Arrays.sort(nArray);
            for (n2 = nArray.length - 1; n3 < 0 && n2 >= nArray.length - n7; --n2) {
                int n13 = nArray[n2] & 0x3FFFFF;
                if (!this.isElectronegative(n13)) continue;
                int n14 = Math.min(-n3, -this.mAtomCharge[n13]);
                n8 += n14;
                n3 += n14;
                int n15 = n13;
                this.mAtomCharge[n15] = this.mAtomCharge[n15] + n14;
                this.mValidHelperArrays &= 1;
            }
        }
        return n8;
    }

    private boolean hasNegativeNeighbour(int n) {
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            if (this.mAtomCharge[this.mConnAtom[n][i]] >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasPositiveNeighbour(int n) {
        for (int i = 0; i < this.mConnAtoms[n]; ++i) {
            if (this.mAtomCharge[this.mConnAtom[n][i]] <= 0) continue;
            return true;
        }
        return false;
    }

    public int getZNeighbour(int n, int n2) {
        if (this.getBondOrder(n2) != 2 && !this.isAromaticBond(n2)) {
            return -1;
        }
        int n3 = this.getBondParity(n2);
        if (n3 != 1 && n3 != 2) {
            return -1;
        }
        for (int i = 0; i < 2; ++i) {
            int n4;
            int n5;
            int n6 = this.mBondAtom[i][n2];
            int n7 = this.mBondAtom[1 - i][n2];
            int n8 = -1;
            boolean bl = false;
            for (n5 = 0; n5 < this.mConnAtoms[n6]; ++n5) {
                n4 = this.mConnAtom[n6][n5];
                if (n4 == n7) continue;
                if (n4 == n) {
                    bl = true;
                    continue;
                }
                n8 = n4;
            }
            if (!bl) continue;
            n5 = -1;
            n4 = -1;
            for (int j = 0; j < this.mConnAtoms[n7]; ++j) {
                int n9 = this.mConnAtom[n7][j];
                if (n9 == n6) continue;
                if (n5 == -1) {
                    n5 = n9;
                    continue;
                }
                if (n9 > n5) {
                    n4 = n9;
                    continue;
                }
                n4 = n5;
                n5 = n9;
            }
            if (this.mConnAtoms[n6] == 2) {
                if (this.mConnAtoms[n7] == 2) {
                    return n3 == 2 ? n5 : -1;
                }
                return n3 == 2 ? n5 : n4;
            }
            if (this.mConnAtoms[n7] == 2) {
                return n3 == 2 ^ n < n8 ? -1 : n5;
            }
            return n3 == 2 ^ n < n8 ? n4 : n5;
        }
        return -1;
    }

    public int getHelperArrayStatus() {
        return this.mValidHelperArrays;
    }

    public void ensureHelperArrays(int n) {
        if ((n & ~this.mValidHelperArrays) == 0) {
            return;
        }
        if ((this.mValidHelperArrays & 1) == 0) {
            this.handleHydrogens();
            this.calculateNeighbours();
            this.mValidHelperArrays |= 1;
            if (this.convertHydrogenToQueryFeatures()) {
                this.handleHydrogens();
                this.calculateNeighbours();
            }
        }
        if ((n & ~this.mValidHelperArrays) == 0) {
            return;
        }
        if ((this.mValidHelperArrays & 0xFFFFFFF9) != 0) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            while (n6 < this.mAtoms) {
                int n7 = n6++;
                this.mAtomFlags[n7] = this.mAtomFlags[n7] & 0xFFFFC3F7;
            }
            n6 = 0;
            while (n6 < this.mBonds) {
                int n8 = n6++;
                this.mBondFlags[n8] = this.mBondFlags[n8] & 0xFFFFFD3F;
            }
            if ((n & 4) == 0) {
                this.findRings(1);
                this.mValidHelperArrays |= 2;
                return;
            }
            this.findRings(7);
            for (n6 = 0; n6 < this.mAtoms; ++n6) {
                for (n5 = 0; n5 < this.mConnAtoms[n6]; ++n5) {
                    n4 = this.mConnBond[n6][n5];
                    if (this.isAromaticBond(n4)) continue;
                    n3 = this.mConnAtom[n6][n5];
                    for (n2 = 0; n2 < this.mConnAtoms[n3]; ++n2) {
                        if (this.mConnBond[n3][n2] == n4 || this.mConnBondOrder[n3][n2] <= 1) continue;
                        if (this.mAtomicNo[this.mConnAtom[n3][n2]] == 6) {
                            int n9 = n6;
                            this.mAtomFlags[n9] = this.mAtomFlags[n9] | 0x1000;
                            continue;
                        }
                        if (this.isAromaticBond(this.mConnBond[n3][n2]) || !this.isElectronegative(this.mConnAtom[n3][n2])) continue;
                        int n10 = n6;
                        this.mAtomFlags[n10] = this.mAtomFlags[n10] | 0x2000;
                    }
                }
            }
            do {
                n6 = 0;
                for (n5 = 0; n5 < this.mAtoms; ++n5) {
                    if (this.mPi[n5] <= 0 || (this.mAtomFlags[n5] & 0x2000) == 0 || this.mRingSet.isAromaticAtom(n5)) continue;
                    for (n4 = 0; n4 < this.mConnAtoms[n5]; ++n4) {
                        if (this.mConnBondOrder[n5][n4] <= 1) continue;
                        n3 = this.mConnAtom[n5][n4];
                        n2 = this.mConnBond[n5][n4];
                        for (int i = 0; i < this.mConnAtoms[n3]; ++i) {
                            int n11;
                            if (this.mConnBond[n3][i] == n2 || (this.mAtomFlags[n11 = this.mConnAtom[n3][i]] & 0x2000) != 0) continue;
                            int n12 = n11;
                            this.mAtomFlags[n12] = this.mAtomFlags[n12] | 0x2000;
                            n6 = 1;
                        }
                    }
                }
            } while (n6 != 0);
        }
        this.mValidHelperArrays |= 6;
    }

    private void handleHydrogens() {
        int n;
        int n2;
        this.mReallySimpleHydrogens = this.findSimpleHydrogens();
        int n3 = this.mAllAtoms;
        while (--n3 >= 0 && this.mReallySimpleHydrogens[n3]) {
        }
        for (int i = 0; i < n3; ++i) {
            if (!this.mReallySimpleHydrogens[i]) continue;
            this.swapAtoms(i, n3);
            n2 = this.mReallySimpleHydrogens[i];
            this.mReallySimpleHydrogens[i] = this.mReallySimpleHydrogens[n3];
            this.mReallySimpleHydrogens[n3] = n2;
            while (this.mReallySimpleHydrogens[--n3]) {
            }
        }
        this.mAtoms = n3 + 1;
        if (this.mAllAtoms == this.mAtoms) {
            this.mBonds = this.mAllBonds;
            return;
        }
        boolean[] blArray = new boolean[this.mAllBonds];
        for (n2 = 0; n2 < this.mAllBonds; ++n2) {
            n = this.mBondAtom[0][n2];
            int n4 = this.mBondAtom[1][n2];
            if (!this.mReallySimpleHydrogens[n] && !this.mReallySimpleHydrogens[n4]) continue;
            blArray[n2] = true;
        }
        n2 = this.mAllBonds;
        while (--n2 >= 0 && blArray[n2]) {
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            this.swapBonds(n, n2);
            blArray[n] = false;
            while (blArray[--n2]) {
            }
        }
        this.mBonds = n2 + 1;
    }

    public int[] getHandleHydrogenMap() {
        return this.getHandleHydrogenAtomMap(this.findSimpleHydrogens());
    }

    public int[] getHandleHydrogenAtomMap(boolean[] blArray) {
        int n;
        int[] nArray = new int[this.mAllAtoms];
        for (n = 0; n < this.mAllAtoms; ++n) {
            nArray[n] = n;
        }
        n = this.mAllAtoms;
        while (--n >= 0 && blArray[n]) {
        }
        for (int i = 0; i < n; ++i) {
            if (!blArray[nArray[i]]) continue;
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
            boolean bl = blArray[i];
            blArray[i] = blArray[n];
            blArray[n] = bl;
            while (blArray[--n]) {
            }
        }
        return nArray;
    }

    public int[] getHandleHydrogenBondMap() {
        int n;
        boolean[] blArray = this.findSimpleHydrogens();
        int[] nArray = new int[this.mAllBonds];
        for (int i = 0; i < this.mAllBonds; ++i) {
            nArray[i] = i;
        }
        boolean[] blArray2 = new boolean[this.mAllBonds];
        for (n = 0; n < this.mAllBonds; ++n) {
            blArray2[n] = blArray[this.mBondAtom[0][n]] || blArray[this.mBondAtom[1][n]];
        }
        n = this.mAllBonds;
        while (--n >= 0 && blArray2[n]) {
        }
        for (int i = 0; i < n; ++i) {
            if (!blArray2[nArray[i]]) continue;
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
            while (blArray2[nArray[--n]]) {
            }
        }
        return nArray;
    }

    private boolean[] findSimpleHydrogens() {
        int n;
        boolean[] blArray = new boolean[this.mAllAtoms];
        for (int i = 0; i < this.mAllAtoms; ++i) {
            blArray[i] = this.isSimpleHydrogen(i);
        }
        boolean[] blArray2 = new boolean[this.mAllAtoms];
        for (n = 0; n < this.mAllBonds; ++n) {
            int n2 = this.mBondAtom[0][n];
            int n3 = this.mBondAtom[1][n];
            if (this.getBondOrder(n) != 1) {
                blArray[n2] = false;
                blArray[n3] = false;
                continue;
            }
            if (blArray2[n2]) {
                blArray[n2] = false;
            }
            if (blArray2[n3]) {
                blArray[n3] = false;
            }
            if (blArray[n2] && this.isMetalAtom(n3) && this.mAtomicNo[n3] != 13) {
                blArray[n2] = false;
            }
            if (blArray[n3] && this.isMetalAtom(n2) && this.mAtomicNo[n2] != 13) {
                blArray[n3] = false;
            }
            blArray2[n2] = true;
            blArray2[n3] = true;
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            if (!blArray[this.mBondAtom[0][n]] || !blArray[this.mBondAtom[1][n]]) continue;
            blArray[this.mBondAtom[0][n]] = false;
            blArray[this.mBondAtom[1][n]] = false;
        }
        for (n = 0; n < this.mAllAtoms; ++n) {
            if (blArray2[n]) continue;
            blArray[n] = false;
        }
        return blArray;
    }

    public boolean isSimpleHydrogen(int n) {
        return this.mAtomicNo[n] == 1 && this.mAtomMass[n] == 0 && this.mAtomCharge[n] == 0 && (this.mAtomCustomLabel == null || this.mAtomCustomLabel[n] == null);
    }

    public void removeExplicitHydrogens() {
        this.removeExplicitHydrogens(true, false);
    }

    public void removeExplicitHydrogens(boolean bl, boolean bl2) {
        this.removeExplicitHydrogensCarbonOnly(bl, false);
    }

    public void removeExplicitHydrogensCarbonOnly(boolean bl, boolean bl2) {
        this.ensureHelperArrays(bl ? 15 : 1);
        this.mAllAtoms = this.mAtoms;
        this.mAllBonds = this.mBonds;
        for (int i = 0; i < this.mAtoms; ++i) {
            int n;
            int n2;
            if (bl2 && this.getAtomicNo(i) < 0 || this.mAllConnAtoms[i] == this.mConnAtoms[i]) continue;
            int n3 = this.getImplicitHigherValence(i, false);
            this.mAllConnAtoms[i] = this.mConnAtoms[i];
            if (n3 == -1 || n3 == (n2 = this.getImplicitHigherValence(i, true)) || (n = this.getAtomAbnormalValence(i)) != -1 && n >= n3) continue;
            this.setAtomAbnormalValence(i, n3);
        }
        if (bl) {
            this.setStereoBondsFromParity();
        }
        this.mValidHelperArrays = 0;
    }

    private void calculateNeighbours() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.mConnAtoms = new int[this.mAllAtoms];
        this.mAllConnAtoms = new int[this.mAllAtoms];
        this.mConnAtom = new int[this.mAllAtoms][];
        this.mConnBond = new int[this.mAllAtoms][];
        this.mConnBondOrder = new int[this.mAllAtoms][];
        this.mPi = new int[this.mAtoms];
        int[] nArray = new int[this.mAllAtoms];
        for (n6 = 0; n6 < this.mAllBonds; ++n6) {
            int n7 = this.mBondAtom[0][n6];
            nArray[n7] = nArray[n7] + 1;
            int n8 = this.mBondAtom[1][n6];
            nArray[n8] = nArray[n8] + 1;
        }
        for (n6 = 0; n6 < this.mAllAtoms; ++n6) {
            this.mConnAtom[n6] = new int[nArray[n6]];
            this.mConnBond[n6] = new int[nArray[n6]];
            this.mConnBondOrder[n6] = new int[nArray[n6]];
        }
        n6 = 0;
        for (n5 = 0; n5 < this.mBonds; ++n5) {
            n4 = this.getBondOrder(n5);
            if (n4 == 0) {
                n6 = 1;
                continue;
            }
            for (n3 = 0; n3 < 2; ++n3) {
                n2 = this.mBondAtom[n3][n5];
                n = this.mAllConnAtoms[n2];
                this.mConnBondOrder[n2][n] = n4;
                this.mConnAtom[n2][n] = this.mBondAtom[1 - n3][n5];
                this.mConnBond[n2][n] = n5;
                int n9 = n2;
                this.mAllConnAtoms[n9] = this.mAllConnAtoms[n9] + 1;
                int n10 = n2;
                this.mConnAtoms[n10] = this.mConnAtoms[n10] + 1;
                if (n2 >= this.mAtoms) continue;
                if (n4 > 1) {
                    int n11 = n2;
                    this.mPi[n11] = this.mPi[n11] + (n4 - 1);
                    continue;
                }
                if (this.mBondType[n5] != 64) continue;
                this.mPi[n2] = 1;
            }
        }
        for (n5 = this.mBonds; n5 < this.mAllBonds; ++n5) {
            n4 = this.getBondOrder(n5);
            if (n4 == 0) {
                n6 = 1;
                continue;
            }
            for (n3 = 0; n3 < 2; ++n3) {
                n2 = this.mBondAtom[n3][n5];
                n = this.mAllConnAtoms[n2];
                this.mConnBondOrder[n2][n] = n4;
                this.mConnAtom[n2][n] = this.mBondAtom[1 - n3][n5];
                this.mConnBond[n2][n] = n5;
                int n12 = n2;
                this.mAllConnAtoms[n12] = this.mAllConnAtoms[n12] + 1;
                if (this.mBondAtom[1 - n3][n5] >= this.mAtoms) continue;
                int n13 = n2;
                this.mConnAtoms[n13] = this.mConnAtoms[n13] + 1;
            }
        }
        if (n6 != 0) {
            int[] nArray2 = new int[this.mAllAtoms];
            for (n4 = 0; n4 < this.mAllAtoms; ++n4) {
                nArray2[n4] = this.mAllConnAtoms[n4];
            }
            for (n4 = 0; n4 < this.mAllBonds; ++n4) {
                n3 = this.getBondOrder(n4);
                if (n3 != 0) continue;
                for (n2 = 0; n2 < 2; ++n2) {
                    n = this.mBondAtom[n2][n4];
                    this.mConnBondOrder[n][nArray2[n]] = n3;
                    this.mConnAtom[n][nArray2[n]] = this.mBondAtom[1 - n2][n4];
                    this.mConnBond[n][nArray2[n]] = n4;
                    int n14 = n;
                    nArray2[n14] = nArray2[n14] + 1;
                }
            }
        }
    }

    private void findRings(int n) {
        int n2;
        this.mRingSet = new RingCollection(this, n);
        int[] nArray = new int[this.mAtoms];
        for (n2 = 0; n2 < this.mBonds; ++n2) {
            if (this.mRingSet.getBondRingSize(n2) == 0) continue;
            int n3 = n2;
            this.mBondFlags[n3] = this.mBondFlags[n3] | 0x40;
            int n4 = this.mBondAtom[0][n2];
            nArray[n4] = nArray[n4] + 1;
            int n5 = this.mBondAtom[1][n2];
            nArray[n5] = nArray[n5] + 1;
        }
        for (n2 = 0; n2 < this.mAtoms; ++n2) {
            if (nArray[n2] == 2) {
                int n6 = n2;
                this.mAtomFlags[n6] = this.mAtomFlags[n6] | 0x400;
                continue;
            }
            if (nArray[n2] == 3) {
                int n7 = n2;
                this.mAtomFlags[n7] = this.mAtomFlags[n7] | 0x800;
                continue;
            }
            if (nArray[n2] <= 3) continue;
            int n8 = n2;
            this.mAtomFlags[n8] = this.mAtomFlags[n8] | 0xC00;
        }
        for (n2 = 0; n2 < this.mRingSet.getSize(); ++n2) {
            int[] nArray2 = this.mRingSet.getRingAtoms(n2);
            int[] nArray3 = this.mRingSet.getRingBonds(n2);
            int n9 = nArray2.length;
            for (int i = 0; i < n9; ++i) {
                int n10 = nArray2[i];
                this.mAtomFlags[n10] = this.mAtomFlags[n10] | 8;
                int n11 = nArray3[i];
                this.mBondFlags[n11] = this.mBondFlags[n11] | 0x80;
                if (this.mBondType[nArray3[i]] != 386) continue;
                this.mBondType[nArray3[i]] = 2;
            }
        }
    }

    private boolean convertHydrogenToQueryFeatures() {
        int n;
        if (!this.mIsFragment) {
            return false;
        }
        for (n = 0; n < this.mAllAtoms; ++n) {
            if (this.getFreeValence(n) > 0 || this.mAtomCharge[n] == 0 && (this.mAtomicNo[n] == 5 || this.isNitrogenFamily(n) || this.isChalcogene(n))) continue;
            int n2 = n;
            this.mAtomQueryFeatures[n2] = this.mAtomQueryFeatures[n2] & 0xFFFFFFFFFFFFE7FFL;
        }
        n = 0;
        for (int i = 0; i < this.mAtoms; ++i) {
            int n3;
            int n4;
            int n5 = this.getExplicitHydrogens(i);
            if (this.mProtectHydrogen || n5 <= 0) continue;
            if ((this.mAtomQueryFeatures[i] & 0x800L) == 0L) {
                int n6;
                n4 = (this.mAtomQueryFeatures[i] & 0x780L) == 896L ? 3 : ((this.mAtomQueryFeatures[i] & 0x780L) == 384L ? 2 : ((this.mAtomQueryFeatures[i] & 0x80L) == 128L ? 1 : 0));
                n3 = this.getFreeValence(i);
                if (this.mAtomCharge[i] == 0 && (this.mAtomQueryFeatures[i] & 0xE000000L) == 0L && this.mAtomicNo[i] != 6) {
                    ++n3;
                }
                if ((n6 = n5) > 3 - n4) {
                    n6 = 3 - n4;
                }
                if (n6 > n3 + n5 - n4) {
                    n6 = n3 + n5 - n4;
                }
                if (n6 > 0) {
                    long l;
                    long l2 = l = n4 == 0 ? 0L : (this.mAtomQueryFeatures[i] & 0x780L) << n6;
                    int n7 = n6 == 3 ? 7 : (n5 == 2 ? 3 : 1);
                    int n8 = i;
                    this.mAtomQueryFeatures[n8] = this.mAtomQueryFeatures[n8] & 0xFFFFFFFFFFFFF87FL;
                    int n9 = i;
                    this.mAtomQueryFeatures[n9] = this.mAtomQueryFeatures[n9] | 0x780L & (l |= (long)(n7 << 7));
                }
            }
            for (n4 = this.mConnAtoms[i]; n4 < this.mAllConnAtoms[i]; ++n4) {
                n3 = this.mConnBond[i][n4];
                if (this.mBondType[n3] != 1) continue;
                this.mAtomicNo[this.mConnAtom[i][n4]] = -1;
                this.mBondType[n3] = 512;
                n = 1;
            }
        }
        if (n != 0) {
            this.compressMolTable();
        }
        return n != 0;
    }

    public void validateAtomQueryFeatures() {
        if (!this.mIsFragment) {
            return;
        }
        this.ensureHelperArrays(7);
        for (int i = 0; i < this.mAtoms; ++i) {
            if (this.isRingAtom(i)) {
                int n = i;
                this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFFFFEFFFFFFF7L;
            }
            if (this.isAromaticAtom(i)) {
                int n = i;
                this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFBFFFFFFFFFF9L;
            } else if ((this.mAtomQueryFeatures[i] & 2L) != 0L) {
                int n = i;
                this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFFFFFFFFFFFFBL;
            }
            if ((this.mAtomQueryFeatures[i] & 0x1C00000L) != 0L) {
                int n = i;
                this.mAtomQueryFeatures[n] = this.mAtomQueryFeatures[n] & 0xFFFFFFFFFFFFFFF7L;
            }
            if (this.mAtomCharge[i] == 0) continue;
            int n = i;
            this.mAtomFlags[n] = (int)((long)this.mAtomFlags[n] & 0xFFFFFFFFF1FFFFFFL);
        }
    }

    public void validateBondQueryFeatures() {
        if (!this.mIsFragment) {
            return;
        }
        this.ensureHelperArrays(7);
        for (int i = 0; i < this.mBonds; ++i) {
            int n;
            if (this.isDelocalizedBond(i)) {
                int n2 = i;
                this.mBondQueryFeatures[n2] = this.mBondQueryFeatures[n2] & 0xFFFFFFF7;
            }
            if ((n = this.mBondType[i] & 0x7F) == 1) {
                int n3 = i;
                this.mBondQueryFeatures[n3] = this.mBondQueryFeatures[n3] & 0xFFFFFFFE;
                continue;
            }
            if (n == 2) {
                int n4 = i;
                this.mBondQueryFeatures[n4] = this.mBondQueryFeatures[n4] & 0xFFFFFFFD;
                continue;
            }
            if (n == 4) {
                int n5 = i;
                this.mBondQueryFeatures[n5] = this.mBondQueryFeatures[n5] & 0xFFFFFFFB;
                continue;
            }
            if (n == 8) {
                int n6 = i;
                this.mBondQueryFeatures[n6] = this.mBondQueryFeatures[n6] & 0xFFFFFFDF;
                continue;
            }
            if (n == 16) {
                int n7 = i;
                this.mBondQueryFeatures[n7] = this.mBondQueryFeatures[n7] & 0xFFFFFFBF;
                continue;
            }
            if (n == 32) {
                int n8 = i;
                this.mBondQueryFeatures[n8] = this.mBondQueryFeatures[n8] & 0xFFFFFFEF;
                continue;
            }
            if (n != 64) continue;
            int n9 = i;
            this.mBondQueryFeatures[n9] = this.mBondQueryFeatures[n9] & 0xFFFFFFF7;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
    }

    public static final Coordinates getCenterGravity(ExtendedMolecule extendedMolecule) {
        int n = extendedMolecule.getAllAtoms();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return ExtendedMolecule.getCenterGravity(extendedMolecule, nArray);
    }

    public static final Coordinates getCenterGravity(ExtendedMolecule extendedMolecule, int[] nArray) {
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < nArray.length; ++i) {
            coordinates.x += extendedMolecule.getAtomX(nArray[i]);
            coordinates.y += extendedMolecule.getAtomY(nArray[i]);
            coordinates.z += extendedMolecule.getAtomZ(nArray[i]);
        }
        coordinates.x /= (double)nArray.length;
        coordinates.y /= (double)nArray.length;
        coordinates.z /= (double)nArray.length;
        return coordinates;
    }

    public int mpPreferredSide(int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[16];
        double[] dArray = new double[16];
        double[] dArray2 = new double[2];
        int n5 = 0;
        for (n4 = 0; n4 < 2; ++n4) {
            n3 = this.getBondAtom(n4, n);
            for (n2 = 0; n2 < this.getConnAtoms(n3); ++n2) {
                int n6;
                int n7 = this.getConnBond(n3, n2);
                if (n7 == n) continue;
                if (n5 == 4) {
                    return 0;
                }
                int n8 = this.getConnAtom(n3, n2);
                nArray[n5] = 16;
                if (this.getAtomPi(n8) != 0) {
                    int n9 = n5;
                    nArray[n9] = nArray[n9] + (this.isRingAtom(n8) ? 1 : 4);
                }
                if (this.isRingBond(n) && this.isRingBond(n7) && (n6 = this.getRingSet().getSharedRing(n, n7)) != -1) {
                    int n10 = n5;
                    nArray[n10] = nArray[n10] + (this.getRingSet().isAromatic(n6) ? 64 : 6);
                }
                dArray[n5++] = this.getBondAngle(n3, n8);
            }
        }
        dArray2[0] = this.getBondAngle(this.getBondAtom(0, n), this.getBondAtom(1, n));
        if (dArray2[0] < 0.0) {
            dArray2[1] = dArray2[0] + Math.PI;
            n4 = 0;
        } else {
            dArray2[1] = dArray2[0];
            dArray2[0] = dArray2[1] - Math.PI;
            n4 = 1;
        }
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            if (dArray[n2] > dArray2[0] && dArray[n2] < dArray2[1]) {
                n3 -= nArray[n2];
                continue;
            }
            n3 += nArray[n2];
        }
        return n4 != 0 ? -n3 : n3;
    }
}

