/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionArrow;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.Color;
import java.awt.Point;

public class ExtendedDepictor {
    public static final int TYPE_MOLECULES = 0;
    public static final int TYPE_REACTION = 1;
    public static final int TYPE_MARKUSH = 2;
    private StereoMolecule[] mMolecule;
    private StereoMolecule[] mCatalyst;
    private Reaction mReaction;
    private GenericDepictor[] mDepictor;
    private GenericDepictor[] mCatalystDepictor;
    private DrawingObjectList mDrawingObjectList;
    private int mDisplayMode;
    private int mReactantCount;
    private int mMarkushCoreCount;
    private int mChemistryType;
    private boolean mReactionLayoutNeeded;
    private DepictorTransformation mTransformation;
    private int mFragmentNoColor;
    private int mDefaultAVBL;

    public ExtendedDepictor(StereoMolecule stereoMolecule, DrawingObjectList drawingObjectList) {
        if (stereoMolecule != null) {
            this.mMolecule = new StereoMolecule[1];
            this.mMolecule[0] = stereoMolecule;
        }
        this.mChemistryType = 0;
        this.mDrawingObjectList = drawingObjectList;
        this.initialize();
    }

    public ExtendedDepictor(StereoMolecule[] stereoMoleculeArray, DrawingObjectList drawingObjectList) {
        this.mMolecule = stereoMoleculeArray;
        this.mChemistryType = 0;
        this.mDrawingObjectList = drawingObjectList;
        this.initialize();
    }

    public ExtendedDepictor(StereoMolecule[] stereoMoleculeArray, int n, DrawingObjectList drawingObjectList) {
        this.mMolecule = stereoMoleculeArray;
        this.mChemistryType = 2;
        this.mDrawingObjectList = drawingObjectList;
        this.mMarkushCoreCount = n;
        this.initialize();
    }

    public ExtendedDepictor(Reaction reaction, DrawingObjectList drawingObjectList, boolean bl) {
        this.mReaction = reaction;
        if (reaction != null) {
            int n;
            this.mMolecule = new StereoMolecule[reaction.getMolecules()];
            for (n = 0; n < reaction.getMolecules(); ++n) {
                this.mMolecule[n] = reaction.getMolecule(n);
            }
            this.mReactantCount = reaction.getReactants();
            this.mCatalyst = new StereoMolecule[reaction.getCatalysts()];
            for (n = 0; n < reaction.getCatalysts(); ++n) {
                this.mCatalyst[n] = reaction.getCatalyst(n);
            }
            this.mReactionLayoutNeeded = bl;
        }
        this.mChemistryType = 1;
        this.mDrawingObjectList = drawingObjectList;
        this.initialize();
    }

    public boolean isFragment() {
        if (this.mChemistryType == 1) {
            return this.mReaction == null ? false : this.mReaction.isFragment();
        }
        if (this.mMolecule == null) {
            return false;
        }
        for (StereoMolecule stereoMolecule : this.mMolecule) {
            if (!stereoMolecule.isFragment()) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        int n;
        this.mTransformation = new DepictorTransformation();
        if (this.mMolecule != null) {
            this.mDepictor = new GenericDepictor[this.mMolecule.length];
            for (n = 0; n < this.mMolecule.length; ++n) {
                this.mDepictor[n] = new GenericDepictor(this.mMolecule[n]);
            }
        }
        if (this.mCatalyst != null) {
            this.mCatalystDepictor = new GenericDepictor[this.mCatalyst.length];
            for (n = 0; n < this.mCatalyst.length; ++n) {
                this.mCatalystDepictor[n] = new GenericDepictor(this.mCatalyst[n]);
            }
        }
        this.mDefaultAVBL = 24;
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
    }

    public void setDefaultAVBL(int n) {
        this.mDefaultAVBL = n;
    }

    public void setFactorTextSize(double d) {
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictor : this.mDepictor) {
                genericDepictor.setFactorTextSize(d);
            }
        }
    }

    public void setFragmentNoColor(int n) {
        this.mFragmentNoColor = n;
    }

    public int getMoleculeCount() {
        return this.mMolecule == null ? 0 : this.mMolecule.length;
    }

    public StereoMolecule getMolecule(int n) {
        return this.mMolecule[n];
    }

    public Reaction getReaction() {
        return this.mReaction;
    }

    public AbstractDepictor getMoleculeDepictor(int n) {
        return this.mDepictor[n];
    }

    @Deprecated
    public void setForegroundColor(Color color, Color color2) {
        this.setForegroundColor(color.getRGB(), color2.getRGB());
    }

    public void setForegroundColor(int n, int n2) {
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictor : this.mDepictor) {
                genericDepictor.setForegroundColor(n, n2);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                genericDepictor.setForegroundColor(n, n2);
            }
        }
    }

    @Deprecated
    public void setOverruleColor(Color color, Color color2) {
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictor : this.mDepictor) {
                genericDepictor.setOverruleColor(color, color2);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                genericDepictor.setOverruleColor(color, color2);
            }
        }
    }

    public void setOverruleColor(int n, int n2) {
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictor : this.mDepictor) {
                genericDepictor.setOverruleColor(n, n2);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                genericDepictor.setOverruleColor(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GenericDrawContext genericDrawContext) {
        int n = genericDrawContext.getRGB();
        int n2 = genericDrawContext.getFontSize();
        try {
            this.paintFragmentNumbers(genericDrawContext);
            this.paintStructures(genericDrawContext);
            this.paintDrawingObjects(genericDrawContext);
        }
        finally {
            genericDrawContext.setRGB(n);
            genericDrawContext.setFont(n2, false, false);
        }
    }

    public void paintFragmentNumbers(GenericDrawContext genericDrawContext) {
        if (this.mFragmentNoColor != 0 && this.mMolecule != null) {
            double d = this.calculateAverageBondLength();
            genericDrawContext.setRGB(this.mFragmentNoColor);
            genericDrawContext.setFont((int)(1.6 * d), true, false);
            for (int i = 0; i < this.mMolecule.length; ++i) {
                if (this.mMolecule[i].getAllAtoms() == 0) continue;
                Point point = new Point();
                for (int j = 0; j < this.mMolecule[i].getAllAtoms(); ++j) {
                    point.x = (int)((double)point.x + this.mMolecule[i].getAtomX(j));
                    point.y = (int)((double)point.y + this.mMolecule[i].getAtomY(j));
                }
                point.x /= this.mMolecule[i].getAllAtoms();
                point.y /= this.mMolecule[i].getAllAtoms();
                point.x = (int)this.mDepictor[i].getTransformation().transformX(point.x);
                point.y = (int)this.mDepictor[i].getTransformation().transformY(point.y);
                String string = this.mChemistryType == 0 ? "" + (i + 1) : (this.mChemistryType == 2 ? (i < this.mMarkushCoreCount ? "" + (char)(65 + i) : "R" + (i + 1 - this.mMarkushCoreCount)) : (this.mChemistryType == 1 ? (i < this.mReactantCount ? "" + (char)(65 + i) : "P" + (i + 1 - this.mReactantCount)) : "?" + (i + 1)));
                genericDrawContext.drawCenteredString(point.x, point.y, string);
            }
        }
    }

    public void paintStructures(GenericDrawContext genericDrawContext) {
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictor : this.mDepictor) {
                genericDepictor.setDisplayMode(this.mDisplayMode);
                genericDepictor.paint(genericDrawContext);
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                genericDepictor.paint(genericDrawContext);
            }
        }
    }

    public void paintDrawingObjects(GenericDrawContext genericDrawContext) {
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                abstractDrawingObject.draw(genericDrawContext, this.mTransformation);
            }
        }
    }

    public DepictorTransformation updateCoords(GenericDrawContext genericDrawContext, GenericRectangle genericRectangle, int n) {
        this.validateView(genericDrawContext, genericRectangle, n);
        if (this.mTransformation.isVoidTransformation()) {
            return null;
        }
        if (this.mMolecule != null) {
            for (StereoMolecule object : this.mMolecule) {
                this.mTransformation.applyTo(object);
            }
        }
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                this.mTransformation.applyTo(abstractDrawingObject);
            }
        }
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictor : this.mDepictor) {
                genericDepictor.getTransformation().clear();
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                genericDepictor.getTransformation().clear();
            }
        }
        DepictorTransformation depictorTransformation = this.mTransformation;
        this.mTransformation = new DepictorTransformation();
        return depictorTransformation;
    }

    public DepictorTransformation validateView(GenericDrawContext genericDrawContext, GenericRectangle genericRectangle, int n) {
        if (this.mReactionLayoutNeeded) {
            this.layoutReaction(genericDrawContext);
        }
        GenericRectangle genericRectangle2 = null;
        if (this.mDepictor != null) {
            for (GenericDepictor genericDepictorArray : this.mDepictor) {
                genericDepictorArray.validateView(genericDrawContext, null, 0);
                genericRectangle2 = genericRectangle2 == null ? genericDepictorArray.getBoundingRect() : genericRectangle2.union(genericDepictorArray.getBoundingRect());
            }
        }
        if (this.mCatalystDepictor != null) {
            for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                genericDepictor.validateView(genericDrawContext, null, 0);
                genericRectangle2 = genericRectangle2 == null ? genericDepictor.getBoundingRect() : genericRectangle2.union(genericDepictor.getBoundingRect());
            }
        }
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                GenericRectangle genericRectangle3 = abstractDrawingObject.getBoundingRect(genericDrawContext);
                this.mTransformation.applyTo(genericRectangle3);
                genericRectangle2 = genericRectangle2 == null ? genericRectangle3 : genericRectangle2.union(genericRectangle3);
            }
        }
        if (genericRectangle2 == null) {
            return null;
        }
        double d = this.calculateAverageBondLength();
        DepictorTransformation depictorTransformation = new DepictorTransformation(genericRectangle2, genericRectangle, d, n);
        if (!depictorTransformation.isVoidTransformation()) {
            depictorTransformation.applyTo(this.mTransformation);
            if (this.mDepictor != null) {
                for (GenericDepictor genericDepictor : this.mDepictor) {
                    genericDepictor.applyTransformation(depictorTransformation);
                }
            }
            if (this.mCatalystDepictor != null) {
                for (GenericDepictor genericDepictor : this.mCatalystDepictor) {
                    genericDepictor.applyTransformation(depictorTransformation);
                }
            }
            return depictorTransformation;
        }
        return null;
    }

    private double calculateAverageBondLength() {
        float f = 0.0f;
        int n = 0;
        if (this.mMolecule != null) {
            for (int i = 0; i < this.mMolecule.length; ++i) {
                if (this.mMolecule[i].getAllAtoms() == 0) continue;
                if (this.mMolecule[i].getAllBonds() != 0) {
                    f = (float)((double)f + this.mDepictor[i].getTransformation().getScaling() * (double)this.mMolecule[i].getAllBonds() * this.mMolecule[i].getAverageBondLength());
                    n += this.mMolecule[i].getAllBonds();
                    continue;
                }
                f = (float)((double)f + this.mDepictor[i].getTransformation().getScaling() * this.mMolecule[i].getAverageBondLength());
                ++n;
            }
        }
        return n == 0 ? (double)this.mDefaultAVBL : this.mTransformation.getScaling() * (double)f / (double)n;
    }

    private void layoutReaction(GenericDrawContext genericDrawContext) {
        GenericRectangle[] genericRectangleArray = new GenericRectangle[this.mMolecule.length];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.mMolecule.length; ++i) {
            this.mDepictor[i].validateView(genericDrawContext, null, 65536);
            genericRectangleArray[i] = this.mDepictor[i].getBoundingRect();
            d += genericRectangleArray[i].width;
            d2 = Math.max(d2, genericRectangleArray[i].height);
        }
        double d3 = 12.0;
        GenericRectangle[] genericRectangleArray2 = new GenericRectangle[this.mCatalyst.length];
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < this.mCatalyst.length; ++i) {
            this.mCatalystDepictor[i].validateView(genericDrawContext, null, 65552);
            genericRectangleArray2[i] = this.mCatalystDepictor[i].getBoundingRect();
            d4 = Math.max(d4, genericRectangleArray2[i].width);
            d5 += genericRectangleArray2[i].height + d3;
        }
        double d6 = 36.0;
        double d7 = Math.max(48.0, d4 + 24.0);
        d2 = Math.max(d2, 24.0 + 2.0 * d5);
        int n = -1;
        if (this.mDrawingObjectList == null) {
            this.mDrawingObjectList = new DrawingObjectList();
            this.mDrawingObjectList.add(new ReactionArrow());
            n = 0;
        } else {
            for (int i = 0; i < this.mDrawingObjectList.size(); ++i) {
                if (!(this.mDrawingObjectList.get(i) instanceof ReactionArrow)) continue;
                n = i;
                break;
            }
            if (n == -1) {
                n = this.mDrawingObjectList.size();
                this.mDrawingObjectList.add(new ReactionArrow());
            }
        }
        double d8 = 0.5 * d6;
        for (int i = 0; i < this.mMolecule.length; ++i) {
            double d9;
            double d10;
            if (i == this.mReactantCount) {
                ((ReactionArrow)this.mDrawingObjectList.get(n)).setCoordinates(d8 - d6 / 2.0, d2 / 2.0, d8 - d6 / 2.0 + d7, d2 / 2.0);
                d10 = d8 + 0.5 * (24.0 - d6);
                d9 = 0.5 * (d2 - d3) - d5;
                for (int j = 0; j < this.mCatalyst.length; ++j) {
                    double d11 = d10 + 0.5 * (d4 - genericRectangleArray2[j].width) - genericRectangleArray2[j].x;
                    double d12 = d9 - genericRectangleArray2[j].y;
                    this.mCatalystDepictor[j].applyTransformation(new DepictorTransformation(1.0, d11, d12));
                    d9 += d3 + genericRectangleArray2[j].height;
                }
                d8 += d7;
            }
            d10 = d8 - genericRectangleArray[i].x;
            d9 = 0.5 * (d2 - genericRectangleArray[i].height) - genericRectangleArray[i].y;
            this.mDepictor[i].applyTransformation(new DepictorTransformation(1.0, d10, d9));
            d8 += d6 + genericRectangleArray[i].width;
        }
        this.mReactionLayoutNeeded = false;
    }
}

