/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPolygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class Depictor2D
extends AbstractDepictor<Graphics2D> {
    private static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private int mpTextSize;
    private double mCurrentStringWidth;
    private float mLineWidth;
    private ArrayList<Font> mFonts;
    private String mCurrentString;
    private Font mCurrentFont;
    private GlyphVector mCurrentGlyphVector;

    public Depictor2D(StereoMolecule stereoMolecule) {
        super(stereoMolecule);
    }

    public Depictor2D(StereoMolecule stereoMolecule, int n) {
        super(stereoMolecule, n);
    }

    @Override
    protected void init() {
        super.init();
        this.mFonts = new ArrayList();
        this.mLineWidth = 1.0f;
    }

    @Override
    protected void drawBlackLine(AbstractDepictor.DepictorLine depictorLine) {
        if (isMac) {
            ((Graphics2D)this.mContext).draw(new Line2D.Double(depictorLine.x1 - 0.5, depictorLine.y1 - 0.5, depictorLine.x2 - 0.5, depictorLine.y2 - 0.5));
        } else {
            ((Graphics2D)this.mContext).draw(new Line2D.Double(depictorLine.x1, depictorLine.y1, depictorLine.x2, depictorLine.y2));
        }
    }

    @Override
    protected void drawDottedLine(AbstractDepictor.DepictorLine depictorLine) {
        Stroke stroke = ((Graphics2D)this.mContext).getStroke();
        ((Graphics2D)this.mContext).setStroke(new BasicStroke(this.mLineWidth, 1, 1, this.mLineWidth, new float[]{3.0f * this.mLineWidth}, 0.0f));
        this.drawBlackLine(depictorLine);
        ((Graphics2D)this.mContext).setStroke(stroke);
    }

    @Override
    protected void drawString(String string, double d, double d2) {
        double d3 = this.getStringWidth(string);
        ((Graphics2D)this.mContext).drawGlyphVector(this.mCurrentGlyphVector, (float)(d - d3 / 2.0), (float)(d2 + (double)this.mpTextSize / 3.0));
    }

    @Override
    protected void drawPolygon(GenericPolygon genericPolygon) {
        int n;
        GeneralPath generalPath = new GeneralPath(1, genericPolygon.getSize());
        generalPath.moveTo(genericPolygon.getX(0), genericPolygon.getY(0));
        for (n = 1; n < genericPolygon.getSize(); ++n) {
            generalPath.lineTo(genericPolygon.getX(n), genericPolygon.getY(n));
        }
        generalPath.closePath();
        ((Graphics2D)this.mContext).fill(generalPath);
        if (isMac) {
            generalPath = new GeneralPath(1, genericPolygon.getSize());
            generalPath.moveTo(genericPolygon.getX(0) - 0.5, genericPolygon.getY(0) - 0.5);
            for (n = 1; n < genericPolygon.getSize(); ++n) {
                generalPath.lineTo(genericPolygon.getX(n) - 0.5, genericPolygon.getY(n) - 0.5);
            }
            generalPath.closePath();
        }
        ((Graphics2D)this.mContext).draw(generalPath);
    }

    @Override
    protected void fillCircle(double d, double d2, double d3) {
        if (isMac) {
            ((Graphics2D)this.mContext).fill(new Ellipse2D.Double(d - 0.5, d2 - 0.5, d3, d3));
        } else {
            ((Graphics2D)this.mContext).fill(new Ellipse2D.Double(d, d2, d3, d3));
        }
    }

    @Override
    protected double getStringWidth(String string) {
        if (!(this.mContext == null || string.equals(this.mCurrentString) && this.mCurrentFont == ((Graphics2D)this.mContext).getFont())) {
            this.mCurrentString = string;
            this.mCurrentFont = ((Graphics2D)this.mContext).getFont();
            double d = ((Graphics2D)this.mContext).getFontMetrics().stringWidth(string);
            this.mCurrentGlyphVector = ((Graphics2D)this.mContext).getFont().createGlyphVector(((Graphics2D)this.mContext).getFontRenderContext(), string);
            this.mCurrentStringWidth = this.mCurrentGlyphVector.getLogicalBounds().getWidth();
        }
        return this.mCurrentStringWidth;
    }

    @Override
    protected void setTextSize(int n) {
        this.mpTextSize = n;
        if (this.mContext != null && ((Graphics2D)this.mContext).getFont().getSize() != n) {
            for (int i = 0; i < this.mFonts.size(); ++i) {
                if (this.mFonts.get(i).getSize() != n) continue;
                ((Graphics2D)this.mContext).setFont(this.mFonts.get(i));
                return;
            }
            Font font = ((Graphics2D)this.mContext).getFont().deriveFont(0, n);
            this.mFonts.add(font);
            ((Graphics2D)this.mContext).setFont(font);
        }
    }

    @Override
    public int getTextSize() {
        return this.mpTextSize;
    }

    @Override
    protected double getLineWidth() {
        return this.mLineWidth;
    }

    @Override
    protected void setLineWidth(double d) {
        this.mLineWidth = (float)d;
        ((Graphics2D)this.mContext).setStroke(new BasicStroke((float)d, 1, 1));
    }

    @Override
    protected void setRGB(int n) {
        Color color = new Color(n);
        ((Graphics2D)this.mContext).setColor(color);
        ((Graphics2D)this.mContext).setPaint(color);
    }
}

